/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.NodeNameUtility;
import org.eclipse.edt.ide.core.internal.builder.SyntaxMarkerProblemRequestor;

public class MarkerSyntaxErrorRequestor
implements ISyntaxErrorRequestor {
    private SyntaxMarkerProblemRequestor problemRequestor;
    private String fileContents;

    public MarkerSyntaxErrorRequestor(SyntaxMarkerProblemRequestor problemRequestor, String fileContents) {
        this.problemRequestor = problemRequestor;
        this.fileContents = fileContents;
    }

    private void createErrorMarker(int type, int startOffset, int endOffset, String insert) {
        this.problemRequestor.acceptProblem(startOffset, endOffset, 2, type, new String[]{insert});
    }

    private void createErrorMarker(int type, int startOffset, int endOffset) {
        this.problemRequestor.acceptProblem(startOffset, endOffset, 2, type);
    }

    private void createWarningMarker(int type, int startOffset, int endOffset) {
        this.problemRequestor.acceptProblem(startOffset, endOffset, 1, type);
    }

    public void incorrectNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
        this.createErrorMarker(2101, startOffset, endOffset, NodeNameUtility.getNonterminalName((int)nonTerminalType));
    }

    public void incorrectPhrase(int nonTerminalType, int startOffset, int endOffset) {
        this.createErrorMarker(2112, startOffset, endOffset, NodeNameUtility.getNonterminalName((int)nonTerminalType));
    }

    public void incorrectPreviousNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
        this.createErrorMarker(2103, startOffset, endOffset, NodeNameUtility.getNonterminalName((int)nonTerminalType));
    }

    public void incorrectPreviousTerminal(int terminalType, int startOffset, int endOffset) {
        this.createErrorMarker(2108, startOffset, endOffset, NodeNameUtility.getTerminalName((int)terminalType));
    }

    public void incorrectTerminal(int terminalType, int startOffset, int endOffset) {
        this.createErrorMarker(2105, startOffset, endOffset, NodeNameUtility.getTerminalName((int)terminalType));
    }

    public void keywordAsName(int terminalType, int startOffset, int endOffset) {
        String insert;
        switch (terminalType) {
            case 125: 
            case 126: 
            case 127: 
            case 128: {
                insert = this.fileContents.substring(startOffset, endOffset).toUpperCase();
                break;
            }
            default: {
                insert = NodeNameUtility.getTerminalName((int)terminalType);
            }
        }
        this.createErrorMarker(3019, startOffset, endOffset, insert);
    }

    public void missingNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
        this.createErrorMarker(2100, startOffset, endOffset, NodeNameUtility.getNonterminalName((int)nonTerminalType));
    }

    public void missingPreviousNonTerminal(int nonTerminalType, int startOffset, int endOffset) {
        this.createErrorMarker(2102, startOffset, endOffset, NodeNameUtility.getNonterminalName((int)nonTerminalType));
    }

    public void missingPreviousTerminal(int terminalType, int startOffset, int endOffset) {
        this.createErrorMarker(2107, startOffset, endOffset, NodeNameUtility.getTerminalName((int)terminalType));
    }

    public void missingScopeCloser(int terminalType, int startOffset, int endOffset) {
        this.createErrorMarker(2110, startOffset, endOffset, NodeNameUtility.getTerminalName((int)terminalType));
    }

    public void missingTerminal(int terminalType, int startOffset, int endOffset) {
        this.createErrorMarker(2104, startOffset, endOffset, NodeNameUtility.getTerminalName((int)terminalType));
    }

    public void panicPhrase(int startOffset, int endOffset) {
        this.createErrorMarker(2113, startOffset, endOffset);
    }

    public void tooManyErrors() {
        this.createErrorMarker(2114, 0, 0);
    }

    public void unexpectedPhrase(int startOffset, int endOffset) {
        this.createErrorMarker(2111, startOffset, endOffset);
    }

    public void unexpectedPreviousTerminal(int startOffset, int endOffset) {
        this.createErrorMarker(2109, startOffset, endOffset);
    }

    public void unexpectedTerminal(int startOffset, int endOffset) {
        this.createErrorMarker(2106, startOffset, endOffset);
    }

    public void invalidEscapeSequence(int startOffset, int endOffset) {
        this.createErrorMarker(2205, startOffset, endOffset);
    }

    public void unclosedBlockComment(int startOffset, int endOffset) {
        this.createErrorMarker(2201, startOffset, endOffset);
    }

    public void unclosedDLI(int startOffset, int endOffset) {
        this.createErrorMarker(2204, startOffset, endOffset);
    }

    public void unclosedSQL(int startOffset, int endOffset) {
        this.createErrorMarker(2202, startOffset, endOffset);
    }

    public void unclosedSQLCondition(int startOffset, int endOffset) {
        this.createErrorMarker(2203, startOffset, endOffset);
    }

    public void unclosedString(int startOffset, int endOffset) {
        this.createErrorMarker(2200, startOffset, endOffset);
    }

    public void whitespaceInDLI(int startOffset, int endOffset) {
        this.createWarningMarker(2208, startOffset, endOffset);
    }

    public void whitespaceInSQL(int startOffset, int endOffset) {
        this.createWarningMarker(2206, startOffset, endOffset);
    }

    public void whitespaceInSQLCondition(int startOffset, int endOffset) {
        this.createWarningMarker(2207, startOffset, endOffset);
    }

    public void invalidCharacterInHexLiteral(int startOffset, int endOffset) {
        this.createErrorMarker(2209, startOffset, endOffset);
    }

    public void missingEndForPart(int startOffset, int endOffset) {
        this.createErrorMarker(2003, startOffset, endOffset);
    }
}

