/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.compiler.workingcopy;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java_cup.runtime.Scanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ErrorCorrectingParser;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Lexer;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IPartASTRequestor;
import org.eclipse.edt.ide.core.internal.lookup.AbstractASTManager;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IWorkingCopy;

public class WorkingCopyASTManager
extends AbstractASTManager {
    private static final WorkingCopyASTManager INSTANCE = new WorkingCopyASTManager();
    private HashMap fileCache = new HashMap();
    private IPartASTRequestor fileASTRequestor = null;

    private WorkingCopyASTManager() {
    }

    public static WorkingCopyASTManager getInstance() {
        return INSTANCE;
    }

    public void setPartASTRequestor(IPartASTRequestor fileASTRequestor) {
        this.fileASTRequestor = fileASTRequestor;
    }

    public void reportNestedFunctions(Node node, final IFile file) {
        if (this.fileASTRequestor != null) {
            node.accept((IASTVisitor)new AbstractASTVisitor(){

                public boolean visit(NestedFunction function) {
                    WorkingCopyASTManager.this.fileASTRequestor.addPartAST(file, (Node)function);
                    return false;
                }

                public boolean visit(NestedForm form) {
                    WorkingCopyASTManager.this.fileASTRequestor.addPartAST(file, (Node)form);
                    return false;
                }
            });
        }
    }

    @Override
    public File getFileAST(IFile file) {
        File cachedFile = (File)this.fileCache.get(file);
        if (cachedFile != null) {
            return cachedFile;
        }
        return super.getFileAST(file);
    }

    public File getFileAST(IWorkingCopy workingCopy) {
        try {
            String contents = ((IEGLFile)workingCopy).getBuffer().getContents();
            ErrorCorrectingParser parser = new ErrorCorrectingParser((Scanner)new Lexer((Reader)new BufferedReader(new StringReader(contents))));
            File cachedFile = (File)parser.parse().value;
            this.fileCache.put(((IEGLFile)workingCopy.getOriginalElement()).getResource(), cachedFile);
            return cachedFile;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    @Override
    protected void doGetPartAST(IFile declaringFile, Part result) {
        if (this.fileASTRequestor != null) {
            this.fileASTRequestor.addPartAST(declaringFile, (Node)result);
        }
    }

    @Override
    public void clear() {
        this.fileCache.clear();
        super.clear();
    }

    public void resetWorkingCopies() {
        this.fileCache.clear();
        this.fileASTRequestor = null;
    }
}

