/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.ISystemEnvironment;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.PackageBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.lookup.IBindingEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.IBuildPathEntry;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.mof2binding.Mof2Binding;
import org.eclipse.edt.ide.core.internal.compiler.SystemEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.AbstractProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.EglarBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPath;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectIREnvironment;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PartNotFoundException;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.edt.mof.serialization.ObjectStore;

public class ProjectEnvironment
extends AbstractProjectEnvironment
implements IBindingEnvironment {
    public static final String[] defaultPackage = InternUtil.intern((String[])new String[0]);
    private final IProject project;
    private IBuildPathEntry[] buildPathEntries;
    private ProjectBuildPathEntry declaringProjectBuildPathEntry;
    private PackageBinding rootPackageBinding = new PackageBinding(defaultPackage, null, (IEnvironment)this);
    private ProjectIREnvironment irEnvironment;
    private Mof2Binding converter;
    private boolean initialized;

    protected ProjectEnvironment(IProject project) {
        this.project = project;
        this.converter = new Mof2Binding((IBindingEnvironment)this);
    }

    public IBuildPathEntry[] getBuildPathEntries() {
        return this.buildPathEntries;
    }

    protected Mof2Binding getConverter() {
        return this.converter;
    }

    protected void setProjectBuildPathEntries(IBuildPathEntry[] projectBuildPathEntries) {
        this.buildPathEntries = projectBuildPathEntries;
        ArrayList<String> serializationSchemesSet = new ArrayList<String>();
        if (this.buildPathEntries != null) {
            int i = 0;
            while (i < this.buildPathEntries.length) {
                ObjectStore[] stores = this.buildPathEntries[i].getObjectStores();
                int j = 0;
                while (j < stores.length) {
                    this.irEnvironment.registerObjectStore(stores[j].getKeyScheme(), stores[j]);
                    if (this.buildPathEntries[i] instanceof ProjectBuildPathEntry && ((ProjectBuildPathEntry)this.buildPathEntries[i]).getProject() == this.project && !serializationSchemesSet.contains(stores[j].getKeyScheme())) {
                        this.irEnvironment.setDefaultSerializeStore(stores[j].getKeyScheme(), stores[j]);
                        serializationSchemesSet.add(stores[j].getKeyScheme());
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    protected void setDeclaringProjectBuildPathEntry(ProjectBuildPathEntry entry) {
        this.declaringProjectBuildPathEntry = entry;
    }

    public void setIREnvironment(ProjectIREnvironment environment) {
        this.irEnvironment = environment;
    }

    public ProjectIREnvironment getIREnvironment() {
        return this.irEnvironment;
    }

    public void initIREnvironments() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.irEnvironment.initSystemEnvironment(this.getSystemEnvironment());
        IBuildPathEntry[] iBuildPathEntryArray = this.buildPathEntries;
        int n = this.buildPathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvironment eglarEnvironment;
            IBuildPathEntry entry = iBuildPathEntryArray[n2];
            if (entry instanceof ProjectBuildPathEntry) {
                ((ProjectBuildPathEntry)entry).getDeclaringEnvironment().initIREnvironments();
            } else if (entry instanceof EglarBuildPathEntry && (eglarEnvironment = ((EglarBuildPathEntry)entry).getEnvironment()) instanceof ProjectEnvironment) {
                ((ProjectEnvironment)eglarEnvironment).initIREnvironments();
            }
            ++n2;
        }
    }

    public IPartBinding getPartBinding(String[] packageName, String partName) {
        IPartBinding result = null;
        int i = 0;
        while (i < this.buildPathEntries.length) {
            result = this.buildPathEntries[i].getPartBinding(packageName, partName);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return this.getSystemEnvironment().getPartBinding(packageName, partName);
    }

    public IPartBinding getCachedPartBinding(String[] packageName, String partName) {
        IPartBinding result = null;
        int i = 0;
        while (i < this.buildPathEntries.length) {
            result = this.buildPathEntries[i].getCachedPartBinding(packageName, partName);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return this.getSystemEnvironment().getCachedPartBinding(packageName, partName);
    }

    public IPartBinding getNewPartBinding(String[] packageName, String caseSensitiveInternedPartName, int kind) {
        return this.declaringProjectBuildPathEntry.getNewPartBinding(packageName, caseSensitiveInternedPartName, kind);
    }

    public boolean hasPackage(String[] packageName) {
        int i = 0;
        while (i < this.buildPathEntries.length) {
            if (this.buildPathEntries[i].hasPackage(packageName)) {
                return true;
            }
            ++i;
        }
        return this.getSystemEnvironment().hasPackage(packageName);
    }

    public void markPartBindingInvalid(String[] packageName, String partName) {
        this.declaringProjectBuildPathEntry.markPartBindingInvalid(packageName, partName);
    }

    public void removePartBinding(String[] packageName, String partName) {
        this.declaringProjectBuildPathEntry.removePartBindingInvalid(packageName, partName);
    }

    public IPackageBinding getRootPackage() {
        return this.rootPackageBinding;
    }

    public void clearRootPackage() {
        this.rootPackageBinding = new PackageBinding(defaultPackage, null, (IEnvironment)this);
    }

    public IProject getProject() {
        return this.project;
    }

    public void clear() {
        this.initialized = false;
        this.buildPathEntries = null;
        this.converter = new Mof2Binding((IBindingEnvironment)this);
        ProjectBuildPath projectBuildPath = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.project);
        this.setProjectBuildPathEntries(projectBuildPath.getBuildPathEntries());
    }

    public IPartBinding level01Compile(String[] packageName, String caseSensitiveInternedPartName) {
        String caseInsensitiveInternedPartName = InternUtil.intern((String)caseSensitiveInternedPartName);
        int i = 0;
        while (i < this.buildPathEntries.length) {
            int partType = this.buildPathEntries[i].hasPart(packageName, caseInsensitiveInternedPartName);
            if (partType != 1) {
                IPartBinding result = PartBinding.newPartBinding((int)partType, (String[])packageName, (String)caseSensitiveInternedPartName);
                result.setEnvironment(this.buildPathEntries[i].getRealizingEnvironment());
                return result;
            }
            ++i;
        }
        return this.getSystemEnvironment().getPartBinding(packageName, caseInsensitiveInternedPartName);
    }

    @Override
    public String getProjectName() {
        return this.getProject().getName();
    }

    public ProjectBuildPathEntry getDeclaringProjectBuildPathEntry() {
        return this.declaringProjectBuildPathEntry;
    }

    public ISystemEnvironment getSystemEnvironment() {
        return SystemEnvironmentManager.findSystemEnvironment(this.project, this.declaringProjectBuildPathEntry == null ? null : this.declaringProjectBuildPathEntry.getNotifier());
    }

    public ICompiler getCompiler() {
        return ProjectSettingsUtility.getCompiler(this.project);
    }

    public Part findPart(String[] packageName, String partName) throws PartNotFoundException {
        Part result = null;
        int i = 0;
        while (i < this.buildPathEntries.length) {
            result = this.buildPathEntries[i].findPart(packageName, partName);
            if (result != null) {
                return result;
            }
            ++i;
        }
        throw new PartNotFoundException(BuildException.getPartName((String[])packageName, (String)partName));
    }

    public void addPartBindingToCache(IPartBinding partBinding) {
        int i = 0;
        while (i < this.buildPathEntries.length) {
            if (this.buildPathEntries[i].hasPart(partBinding.getPackageName(), partBinding.getCaseSensitiveName()) != 1) {
                this.buildPathEntries[i].addPartBindingToCache(partBinding);
                break;
            }
            ++i;
        }
    }
}

