/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.ZipFileBindingBuildPathEntry;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.IZipFileBindingBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.IWorkingCopyBuildPathEntry;
import org.eclipse.edt.ide.core.internal.partinfo.IPartOrigin;
import org.eclipse.edt.ide.core.utils.BinaryReadOnlyFile;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PartNotFoundException;
import org.eclipse.edt.mof.serialization.ObjectStore;

public class WrapperedZipFileBuildPathEntry
implements IZipFileBindingBuildPathEntry,
IWorkingCopyBuildPathEntry {
    ZipFileBindingBuildPathEntry zipEntry;
    IProject project;

    public WrapperedZipFileBuildPathEntry(ZipFileBindingBuildPathEntry zipEntry, IProject project) {
        this.zipEntry = zipEntry;
        this.project = project;
    }

    @Override
    public IPartOrigin getPartOrigin(String[] packageName, String partName) {
        try {
            Part part = this.findPart(packageName, partName);
            if (part != null) {
                String sourceName = part.eGet("filename").toString();
                final BinaryReadOnlyFile brf = new BinaryReadOnlyFile(this.getID(), sourceName);
                brf.setProject(this.project);
                return new IPartOrigin(){

                    @Override
                    public boolean isOriginEGLFile() {
                        return true;
                    }

                    @Override
                    public IFile getEGLFile() {
                        return brf;
                    }

                    @Override
                    public boolean isSourceCodeAvailable() {
                        return brf.exists();
                    }
                };
            }
        }
        catch (PartNotFoundException partNotFoundException) {}
        return null;
    }

    public IPartBinding getPartBinding(String[] packageName, String partName) {
        return this.zipEntry.getPartBinding(packageName, partName);
    }

    public boolean hasPackage(String[] packageName) {
        return this.zipEntry.hasPackage(packageName);
    }

    public int hasPart(String[] packageName, String partName) {
        return this.zipEntry.hasPart(packageName, partName);
    }

    public IEnvironment getRealizingEnvironment() {
        return this.zipEntry.getRealizingEnvironment();
    }

    public IPartBinding getCachedPartBinding(String[] packageName, String partName) {
        return this.zipEntry.getCachedPartBinding(packageName, partName);
    }

    public void addPartBindingToCache(IPartBinding partBinding) {
        this.zipEntry.addPartBindingToCache(partBinding);
    }

    public ObjectStore[] getObjectStores() {
        return this.zipEntry.getObjectStores();
    }

    public Part findPart(String[] packageName, String name) throws PartNotFoundException {
        return this.zipEntry.findPart(packageName, name);
    }

    public boolean isZipFile() {
        return true;
    }

    public boolean isProject() {
        return false;
    }

    public String getID() {
        return this.zipEntry.getID();
    }

    public void clear() {
    }

    public boolean hasEntry(String entry) {
        return this.zipEntry.hasEntry(entry);
    }

    public List<String> getAllKeysFromPkg(String pkg, boolean includeSubPkgs) {
        return this.zipEntry.getAllKeysFromPkg(pkg, includeSubPkgs);
    }
}

