/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import com.ibm.icu.util.StringTokenizer;
import java.util.Map;
import java.util.Stack;
import org.eclipse.edt.ide.core.internal.model.AbstractSourceElementRequestor;
import org.eclipse.edt.ide.core.internal.model.Assert;
import org.eclipse.edt.ide.core.internal.model.BinaryField;
import org.eclipse.edt.ide.core.internal.model.BinaryFunction;
import org.eclipse.edt.ide.core.internal.model.BinaryProperty;
import org.eclipse.edt.ide.core.internal.model.BinaryPropertyBlock;
import org.eclipse.edt.ide.core.internal.model.ClassFile;
import org.eclipse.edt.ide.core.internal.model.ClassFileElementInfo;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.EGLElementInfo;
import org.eclipse.edt.ide.core.internal.model.ISourceElementRequestor;
import org.eclipse.edt.ide.core.internal.model.PackageDeclaration;
import org.eclipse.edt.ide.core.internal.model.SourceFieldElementInfo;
import org.eclipse.edt.ide.core.internal.model.SourceFunctionElementInfo;
import org.eclipse.edt.ide.core.internal.model.SourcePartElementInfo;
import org.eclipse.edt.ide.core.internal.model.SourcePropertyBlockElementInfo;
import org.eclipse.edt.ide.core.internal.model.SourcePropertyElementInfo;
import org.eclipse.edt.ide.core.internal.model.SourceRefElementInfo;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.IPropertyContainer;
import org.eclipse.edt.ide.core.model.Signature;

public class IRFileStructureRequestor
extends AbstractSourceElementRequestor
implements ISourceElementRequestor {
    protected IClassFile fUnit;
    protected ClassFileElementInfo fUnitInfo;
    protected EGLElementInfo fImportContainerInfo = null;
    protected Map fNewElements;
    protected Stack<EGLElementInfo> fInfoStack;
    protected Stack<Object> fHandleStack;
    protected char[] fSourceFileName = null;
    protected char[] fPackageName = null;
    protected static String[] fgEmptyStringArray = new String[0];
    protected static byte[] fgEmptyByte = new byte[0];
    protected static char[][] fgEmptyCharChar = new char[0][];
    protected static char[] fgEmptyChar = new char[0];

    public IRFileStructureRequestor(IClassFile unit, ClassFileElementInfo unitInfo, Map newElements) {
        this.fUnit = unit;
        this.fUnitInfo = unitInfo;
        this.fNewElements = newElements;
        this.fSourceFileName = unit.getElementName().toCharArray();
    }

    @Override
    public void acceptField(int declarationStart, int declarationEnd, int modifiers, char[] type, char[] name, int nameSourceStart, int nameSourceEnd) {
        SourcePartElementInfo parentInfo = (SourcePartElementInfo)this.fInfoStack.peek();
        EGLElement parentHandle = (EGLElement)this.fHandleStack.peek();
        BinaryField handle = null;
        if (parentHandle.getElementType() == 8) {
            handle = new BinaryField((IPart)((Object)parentHandle), new String(name));
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourceFieldElementInfo info = new SourceFieldElementInfo();
        info.setCharName(name);
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        info.setFlags(modifiers);
        info.setTypeName(type);
        parentInfo.addChild(handle);
        this.fNewElements.put(handle, info);
    }

    @Override
    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
        EGLElementInfo parentInfo = this.fInfoStack.peek();
        EGLElement parentHandle = (EGLElement)this.fHandleStack.peek();
        PackageDeclaration handle = null;
        this.fPackageName = name;
        if (parentHandle.getElementType() == 7) {
            handle = new PackageDeclaration((ClassFile)parentHandle, new String(name));
        }
        this.resolveDuplicates(handle);
        SourceRefElementInfo info = new SourceRefElementInfo();
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        parentInfo.addChild(handle);
        this.fNewElements.put(handle, info);
    }

    @Override
    public void acceptProperty(int declarationStart, int declarationEnd, char[] text) {
        SourcePropertyBlockElementInfo parentInfo = (SourcePropertyBlockElementInfo)this.fInfoStack.peek();
        EGLElement parentHandle = (EGLElement)this.fHandleStack.peek();
        BinaryProperty handle = null;
        StringTokenizer tokenizer = new StringTokenizer(new String(text), "=\t\f\n\r");
        String key = tokenizer.nextToken().trim();
        String value = null;
        int valueType = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("=")) continue;
            value = token.trim();
        }
        valueType = value == null || value.equals("yes") || value.equals("no") ? 0 : 2;
        if (parentHandle.getElementType() == 16) {
            handle = new BinaryProperty((IPropertyContainer)((Object)parentHandle), new String(key));
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourcePropertyElementInfo info = new SourcePropertyElementInfo();
        info.setSourceRangeStart(declarationStart);
        info.setSourceRangeEnd(declarationEnd);
        info.setCharName(key.toCharArray());
        if (value != null) {
            info.setValue(value.toCharArray());
            info.setValueType(valueType);
        }
        parentInfo.addChild(handle);
        this.fNewElements.put(handle, info);
    }

    @Override
    public void acceptPropertyLiteralName(int declarationStart, int declarationEnd, char[] name) {
    }

    @Override
    public void enterEGLFile() {
        this.fInfoStack = new Stack();
        this.fHandleStack = new Stack();
        this.fInfoStack.push(this.fUnitInfo);
        this.fHandleStack.push(this.fUnit);
    }

    @Override
    public void enterField(int declarationStart, int modifiers, char[] type, char[] typeDeclaredPackage, char[] name, int nameSourceStart, int nameSourceEnd, boolean hasOccurs, int declarationEnd) {
        EGLElementInfo parentObj = this.fInfoStack.peek();
        if (!(parentObj instanceof SourcePartElementInfo)) {
            this.exitField(declarationEnd);
        }
        SourcePartElementInfo parentInfo = (SourcePartElementInfo)this.fInfoStack.peek();
        EGLElement parentHandle = (EGLElement)this.fHandleStack.peek();
        BinaryField handle = null;
        if (parentHandle.getElementType() == 8 || parentHandle.getElementType() == 10) {
            handle = new BinaryField((IPart)((Object)parentHandle), new String(name));
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourceFieldElementInfo info = new SourceFieldElementInfo();
        info.setCharName(name);
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        info.setSourceRangeStart(declarationStart);
        info.setFlags(modifiers);
        info.setTypeName(type);
        info.setHasOccurs(hasOccurs);
        info.setTypeDeclaredPackage(typeDeclaredPackage);
        parentInfo.addChild(handle);
        this.fNewElements.put(handle, info);
        this.fInfoStack.push(info);
        this.fHandleStack.push(handle);
    }

    @Override
    public void enterFunction(int declarationStart, int modifiers, char[] returnType, char[] returnTypePackage, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] parameterUseTypes, boolean[] areNullable, char[][] parameterPackages) {
        SourcePartElementInfo parentInfo = (SourcePartElementInfo)this.fInfoStack.peek();
        EGLElement parentHandle = (EGLElement)this.fHandleStack.peek();
        BinaryFunction handle = null;
        if (parameterTypes == null) {
            parameterTypes = fgEmptyCharChar;
        }
        if (parameterNames == null) {
            parameterNames = fgEmptyCharChar;
        }
        String[] parameterTypeSigs = IRFileStructureRequestor.convertTypeNamesToSigs(parameterTypes);
        if (parentHandle.getElementType() != 8) {
            return;
        }
        handle = new BinaryFunction((IPart)((Object)parentHandle), new String(name), parameterTypeSigs);
        this.resolveDuplicates(handle);
        SourceFunctionElementInfo info = new SourceFunctionElementInfo();
        info.setSourceRangeStart(declarationStart);
        int flags = modifiers;
        info.setCharName(name);
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        info.setFlags(flags);
        info.setArgumentNames(parameterNames);
        info.setArgumentTypeNames(parameterTypes);
        info.setReturnType(returnType);
        info.setReturnTypePkg(returnTypePackage);
        info.setUseTypes(parameterUseTypes);
        info.setNullable(areNullable);
        info.setArgumentPackages(parameterPackages);
        parentInfo.addChild(handle);
        this.fNewElements.put(handle, info);
        this.fInfoStack.push(info);
        this.fHandleStack.push(handle);
    }

    @Override
    public void enterPart(int partType, char[] subType, int contentCode, int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] interfaces, char[][] parameterNames, char[][] parameterTypes, char[][] usagePartTypes, char[][] usagePartPackages, String eglFileName) {
        ClassFileElementInfo classFileInfo;
        char[] qualifiedName = null;
        EGLElementInfo parentInfo = this.fInfoStack.peek();
        EGLElement parentHandle = (EGLElement)this.fHandleStack.peek();
        IPart handle = null;
        String nameString = new String(name);
        if (parentHandle.getElementType() == 7) {
            handle = ((ClassFile)parentHandle).getPart(nameString);
            qualifiedName = this.fPackageName == null ? nameString.toCharArray() : (String.valueOf(new String(this.fPackageName)) + "." + nameString).toCharArray();
        } else if (parentHandle.getElementType() == 8) {
            handle = ((IPart)((Object)parentHandle)).getPart(nameString);
            ((SourcePartElementInfo)parentInfo).getCharName();
            qualifiedName = (String.valueOf(new String(((SourcePartElementInfo)parentInfo).getQualifiedName())) + "." + nameString).toCharArray();
        } else {
            Assert.isTrue(false);
        }
        this.resolveDuplicates(handle);
        SourcePartElementInfo info = new SourcePartElementInfo();
        info.setHandle(handle);
        info.setPartType(PartTypeConversion.getType(partType));
        info.setSubTypeName(subType);
        info.setContentHashCode(contentCode);
        info.setSourceRangeStart(declarationStart);
        info.setFlags(modifiers);
        info.setCharName(name);
        info.setNameSourceStart(nameSourceStart);
        info.setNameSourceEnd(nameSourceEnd);
        info.setInterfaceNames(interfaces);
        info.setSourceFileName(this.fSourceFileName);
        info.setPackageName(this.fPackageName);
        info.setQualifiedName(qualifiedName);
        info.setParameterNames(parameterNames);
        info.setParameterTypeNames(parameterTypes);
        info.setUsagePartTypes(usagePartTypes);
        info.setUsagePartPackages(usagePartPackages);
        parentInfo.addChild(handle);
        this.fNewElements.put(handle, info);
        if (parentInfo instanceof ClassFileElementInfo && (classFileInfo = (ClassFileElementInfo)parentInfo).getEglFileName() == null) {
            int index;
            String fileName = eglFileName;
            if (!fileName.contains("/")) {
                fileName.replace("\\", "/");
            }
            if ((index = fileName.lastIndexOf("/")) > -1) {
                eglFileName = eglFileName.substring(index + 1);
            }
            classFileInfo.setEglFileName(eglFileName);
            classFileInfo.setCaseSensitivePackageName(IRFileStructureRequestor.toStringArray(new String(this.fPackageName)));
        }
        this.fInfoStack.push(info);
        this.fHandleStack.push(handle);
    }

    public static String[] toStringArray(String str) {
        StringTokenizer parser = new StringTokenizer(str, ".");
        String[] names = new String[parser.countTokens()];
        int i = 0;
        while (i < names.length) {
            names[i] = parser.nextToken();
            ++i;
        }
        return names;
    }

    @Override
    public void enterPropertyBlock(int declarationStart, char[] name) {
        SourceRefElementInfo parentInfo = (SourceRefElementInfo)this.fInfoStack.peek();
        EGLElement parentHandle = (EGLElement)this.fHandleStack.peek();
        BinaryPropertyBlock handle = new BinaryPropertyBlock((IMember)((Object)parentHandle), new String(name));
        this.resolveDuplicates(handle);
        SourcePropertyBlockElementInfo info = new SourcePropertyBlockElementInfo();
        info.setCharName(name);
        info.setSourceRangeStart(declarationStart);
        parentInfo.addChild(handle);
        this.fNewElements.put(handle, info);
        this.fInfoStack.push(info);
        this.fHandleStack.push(handle);
    }

    @Override
    public void exitEGLFile(int declarationEnd) {
    }

    @Override
    public void exitField(int declarationEnd) {
        SourceFieldElementInfo info = (SourceFieldElementInfo)this.fInfoStack.pop();
        info.setSourceRangeEnd(declarationEnd);
        this.fHandleStack.pop();
    }

    @Override
    public void exitFunction(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    @Override
    public void exitPart(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    @Override
    public void exitPropertyBlock(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    @Override
    public void exitUse(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    protected void resolveDuplicates(IEGLElement handle) {
        while (this.fNewElements.containsKey(handle)) {
            EGLElement h = (EGLElement)handle;
            h.setOccurrenceCount(h.getOccurrenceCount() + 1);
        }
    }

    protected void exitMember(int declarationEnd) {
        SourceRefElementInfo info = (SourceRefElementInfo)this.fInfoStack.pop();
        info.setSourceRangeEnd(declarationEnd);
        this.fHandleStack.pop();
    }

    static String[] convertTypeNamesToSigs(char[][] typeNames) {
        if (typeNames == null) {
            return fgEmptyStringArray;
        }
        int n = typeNames.length;
        if (n == 0) {
            return fgEmptyStringArray;
        }
        String[] typeSigs = new String[n];
        int i = 0;
        while (i < n) {
            typeSigs[i] = Signature.createTypeSignature(typeNames[i], false);
            ++i;
        }
        return typeSigs;
    }

    @Override
    public void acceptUse(int declarationStart, int declarationEnd, char[] name) {
    }

    @Override
    public void acceptImport(int declarationStart, int declarationEnd, char[] name, boolean onDemand) {
    }

    @Override
    public void acceptLineSeparatorPositions(int[] positions) {
    }

    private static class PartTypeConversion {
        private PartTypeConversion() {
        }

        public static int getType(int irType) {
            int astType = -1;
            return astType;
        }
    }
}

