/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.core.internal.model.util.Util;

public class BinaryReadOnlyFile
implements IFile {
    private String pathString;
    private String fileString;
    private boolean isExternal;
    private IProject project;
    public static final String IR_EXTENSION = ".eglxml";
    public static final String EGLAR_IR_SEPARATOR = "|";

    public BinaryReadOnlyFile(String path, String file) {
        this.pathString = path;
        this.fileString = BinaryReadOnlyFile.resolveFileString(file);
        this.isExternal = false;
    }

    public BinaryReadOnlyFile(String path, String file, IProject project, boolean isExternal) {
        this.pathString = path;
        this.fileString = BinaryReadOnlyFile.resolveFileString(file);
        this.project = project;
        this.isExternal = isExternal;
    }

    public String getFullQualifiedName() {
        return this.fileString;
    }

    public InputStream getContents() throws CoreException {
        InputStream fs = null;
        try {
            JarFile jarFile = new JarFile(this.pathString);
            ZipEntry entry = jarFile.getEntry(this.fileString);
            fs = jarFile.getInputStream(entry);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fs;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getSource() {
        ZipFile zip = null;
        String out = "";
        try {
            Path eglarPath = new Path(this.getEGLARPath());
            zip = new ZipFile(eglarPath.toFile());
            ZipEntry ze = new ZipEntry(this.fileString);
            out = new String(Util.getZipEntryByteContent(ze, zip));
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out;
    }

    public String[] getPackageSegments() {
        String[] package1 = this.fileString.split("/");
        String[] package2 = new String[package1.length - 1];
        System.arraycopy(package1, 0, package2, 0, package2.length);
        return package2;
    }

    public IPath getFullPath() {
        String path = this.pathString;
        path = String.valueOf(path) + EGLAR_IR_SEPARATOR;
        path = String.valueOf(path) + this.fileString;
        return new Path(path);
    }

    public String getEGLARPath() {
        return this.pathString;
    }

    public String getPackage() {
        int index = this.fileString.lastIndexOf(".");
        if (index > -1) {
            return this.fileString.substring(0, index);
        }
        return "";
    }

    public String getName() {
        String irFileName = new Path(this.fileString).lastSegment();
        int index = irFileName.lastIndexOf(".");
        irFileName = index > -1 ? String.valueOf(irFileName.substring(0, index)) + IR_EXTENSION : String.valueOf(irFileName) + IR_EXTENSION;
        return irFileName;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    private static String resolveFileString(String file) {
        int index;
        String fileString = file;
        int n = index = fileString != null ? fileString.indexOf(":") : -1;
        if (index != -1) {
            fileString = fileString.substring(0, index);
        }
        return fileString;
    }

    public void accept(IResourceProxyVisitor visitor, int memberFlags) throws CoreException {
    }

    public void accept(IResourceVisitor visitor) throws CoreException {
    }

    public void accept(IResourceVisitor visitor, int depth, boolean includePhantoms) throws CoreException {
    }

    public void accept(IResourceVisitor visitor, int depth, int memberFlags) throws CoreException {
    }

    public void clearHistory(IProgressMonitor monitor) throws CoreException {
    }

    public void copy(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
    }

    public void copy(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public void copy(IProjectDescription description, boolean force, IProgressMonitor monitor) throws CoreException {
    }

    public void copy(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public IMarker createMarker(String type) throws CoreException {
        return null;
    }

    public IResourceProxy createProxy() {
        return null;
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
    }

    public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public void deleteMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
    }

    public boolean exists() {
        return false;
    }

    public IMarker findMarker(long id) throws CoreException {
        return null;
    }

    public IMarker[] findMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        return null;
    }

    public int findMaxProblemSeverity(String type, boolean includeSubtypes, int depth) throws CoreException {
        return 0;
    }

    public String getFileExtension() {
        return null;
    }

    public long getLocalTimeStamp() {
        return 0L;
    }

    public IPath getLocation() {
        return null;
    }

    public URI getLocationURI() {
        return null;
    }

    public IMarker getMarker(long id) {
        return null;
    }

    public long getModificationStamp() {
        return 0L;
    }

    public IPathVariableManager getPathVariableManager() {
        return null;
    }

    public IContainer getParent() {
        return null;
    }

    public Map<QualifiedName, String> getPersistentProperties() throws CoreException {
        return null;
    }

    public String getPersistentProperty(QualifiedName key) throws CoreException {
        return null;
    }

    public IPath getProjectRelativePath() {
        return new Path("");
    }

    public IPath getRawLocation() {
        return null;
    }

    public URI getRawLocationURI() {
        return null;
    }

    public ResourceAttributes getResourceAttributes() {
        return null;
    }

    public Map<QualifiedName, Object> getSessionProperties() throws CoreException {
        return null;
    }

    public Object getSessionProperty(QualifiedName key) throws CoreException {
        return null;
    }

    public int getType() {
        return 0;
    }

    public IWorkspace getWorkspace() {
        return null;
    }

    public boolean isAccessible() {
        return false;
    }

    public boolean isDerived() {
        return false;
    }

    public boolean isDerived(int options) {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isHidden(int options) {
        return false;
    }

    public boolean isLinked() {
        return false;
    }

    public boolean isVirtual() {
        return false;
    }

    public boolean isLinked(int options) {
        return false;
    }

    public boolean isLocal(int depth) {
        return false;
    }

    public boolean isPhantom() {
        return false;
    }

    public boolean isSynchronized(int depth) {
        return false;
    }

    public boolean isTeamPrivateMember() {
        return false;
    }

    public boolean isTeamPrivateMember(int options) {
        return false;
    }

    public void move(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
    }

    public void move(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public void move(IProjectDescription description, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
    }

    public void move(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public void refreshLocal(int depth, IProgressMonitor monitor) throws CoreException {
    }

    public void revertModificationStamp(long value) throws CoreException {
    }

    public void setDerived(boolean isDerived) throws CoreException {
    }

    public void setDerived(boolean isDerived, IProgressMonitor monitor) throws CoreException {
    }

    public void setHidden(boolean isHidden) throws CoreException {
    }

    public void setLocal(boolean flag, int depth, IProgressMonitor monitor) throws CoreException {
    }

    public long setLocalTimeStamp(long value) throws CoreException {
        return 0L;
    }

    public void setPersistentProperty(QualifiedName key, String value) throws CoreException {
    }

    public void setReadOnly(boolean readOnly) {
    }

    public void setResourceAttributes(ResourceAttributes attributes) throws CoreException {
    }

    public void setSessionProperty(QualifiedName key, Object value) throws CoreException {
    }

    public void setTeamPrivateMember(boolean isTeamPrivate) throws CoreException {
    }

    public void touch(IProgressMonitor monitor) throws CoreException {
    }

    public boolean contains(ISchedulingRule rule) {
        return false;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return false;
    }

    public void appendContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
    }

    public void appendContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public void create(InputStream source, boolean force, IProgressMonitor monitor) throws CoreException {
    }

    public void create(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public void createLink(IPath localLocation, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public void createLink(URI location, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public void delete(boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
    }

    public String getCharset() throws CoreException {
        return "UTF-8";
    }

    public String getCharset(boolean checkImplicit) throws CoreException {
        return null;
    }

    public String getCharsetFor(Reader reader) throws CoreException {
        return null;
    }

    public IContentDescription getContentDescription() throws CoreException {
        return null;
    }

    public InputStream getContents(boolean force) throws CoreException {
        return this.getContents();
    }

    public int getEncoding() throws CoreException {
        return 0;
    }

    public IFileState[] getHistory(IProgressMonitor monitor) throws CoreException {
        return null;
    }

    public void move(IPath destination, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
    }

    public void setCharset(String newCharset) throws CoreException {
    }

    public void setCharset(String newCharset, IProgressMonitor monitor) throws CoreException {
    }

    public void setContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
    }

    public void setContents(IFileState source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
    }

    public void setContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public void setContents(IFileState source, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }
}

