/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java;

import java.util.List;
import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.gen.GenerationException;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.javart.util.JavaAliaser;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.AsExpression;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.DataTable;
import org.eclipse.edt.mof.egl.Delegate;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.EnumerationEntry;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.ExternalType;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Form;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Library;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.MemberName;
import org.eclipse.edt.mof.egl.Name;
import org.eclipse.edt.mof.egl.NamedElement;
import org.eclipse.edt.mof.egl.NullLiteral;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.ProgramParameter;
import org.eclipse.edt.mof.egl.QualifiedFunctionInvocation;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.ThisExpression;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.TypeName;

public class CommonUtilities {
    public static String packageName(Part part) {
        return CommonUtilities.packageName(part.getPackageName());
    }

    public static String packageName(String pkg) {
        if (pkg != null && pkg.length() > 0) {
            return JavaAliaser.packageNameAlias((String)pkg);
        }
        return pkg;
    }

    public static String fullClassAlias(Part part) {
        String alias = JavaAliaser.getAlias((String)part.getName());
        String pkg = part.getPackageName();
        if (pkg.length() > 0) {
            pkg = CommonUtilities.packageName(pkg);
            return String.valueOf(pkg) + '.' + alias;
        }
        return alias;
    }

    public static String classAlias(Part part) {
        return JavaAliaser.getAlias((String)part.getName());
    }

    public static boolean isJavaExternalType(Type type) {
        return CommonUtilities.getJavaExternalType(type) != null;
    }

    public static ExternalType getJavaExternalType(Type type) {
        if (type instanceof ExternalType) {
            if (type.getAnnotation("eglx.java.JavaObject") != null || type.getAnnotation("eglx.java.RootJavaObject") != null || type.getAnnotation("eglx.lang.NativeType") != null) {
                return (ExternalType)type;
            }
            return null;
        }
        if (type instanceof Part) {
            Part member = (Part)type;
            if (member instanceof ExternalType) {
                if (member.getAnnotation("eglx.java.JavaObject") != null || member.getAnnotation("eglx.java.RootJavaObject") != null || member.getAnnotation("eglx.lang.NativeType") != null) {
                    return (ExternalType)member;
                }
                return null;
            }
        } else if (type instanceof ArrayType) {
            while (type instanceof ArrayType) {
                type = ((ArrayType)type).getElementType();
            }
            return CommonUtilities.getJavaExternalType(type);
        }
        return null;
    }

    public static boolean isSerializable(ExternalType et) {
        List extndsAry;
        if (et == null) {
            return false;
        }
        Annotation annot = et.getAnnotation("eglx.java.JavaObject");
        if (annot != null) {
            String name = et.getName();
            if (annot.getValue("externalName") != null && ((String)annot.getValue("externalName")).length() > 0) {
                name = (String)annot.getValue("externalName");
            }
            if ("Serializable".equals(name)) {
                String pkg = et.getPackageName();
                if (((String)annot.getValue("packageName")).length() > 0) {
                    pkg = (String)annot.getValue("packageName");
                }
                if ("java.io".equals(pkg)) {
                    return true;
                }
            }
        } else {
            annot = et.getAnnotation("eglx.java.RootJavaObject");
            if (annot != null && "Serializable".equals(et.getName())) {
                String pkg = et.getPackageName();
                if (((String)annot.getValue("packageName")).length() > 0) {
                    pkg = (String)annot.getValue("packageName");
                }
                if ("java.io".equals(pkg)) {
                    return true;
                }
            }
        }
        if ((extndsAry = et.getSuperTypes()) != null) {
            for (StructPart part : extndsAry) {
                if (!(part instanceof ExternalType) || !CommonUtilities.isSerializable((ExternalType)part)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getNativeRuntimeOperationName(BinaryExpression expr) throws GenerationException {
        if (expr.getOperation() == null || expr.getOperation().getName() == null) {
            throw new GenerationException();
        }
        String op = expr.getOperator();
        if (op.equals("+")) {
            return "plus";
        }
        if (op.equals("-")) {
            return "minus";
        }
        if (op.equals("/")) {
            return "divide";
        }
        if (op.equals("*")) {
            return "multiply";
        }
        if (op.equals("%")) {
            return "remainder";
        }
        if (op.equals("==")) {
            return "equals";
        }
        if (op.equals("!=")) {
            return "notEquals";
        }
        if (op.equals("<")) {
            return "compareTo";
        }
        if (op.equals(">")) {
            return "compareTo";
        }
        if (op.equals("<=")) {
            return "compareTo";
        }
        if (op.equals(">=")) {
            return "compareTo";
        }
        if (op.equals("&&")) {
            return "and";
        }
        if (op.equals("||")) {
            return "or";
        }
        if (op.equals("xor")) {
            return "xor";
        }
        if (op.equals("::")) {
            return "concat";
        }
        if (op.equals("?:")) {
            return "concatNull";
        }
        if (op.equals("&")) {
            return "bitand";
        }
        if (op.equals("|")) {
            return "bitor";
        }
        if (op.equals("<<")) {
            return "leftShift";
        }
        if (op.equals(">>")) {
            return "rightShiftArithmetic";
        }
        if (op.equals(">>>")) {
            return "rightShiftLogical";
        }
        if (op.equals("**")) {
            return "power";
        }
        if (op.equals("in")) {
            return "in";
        }
        if (op.equals("matches")) {
            return "matches";
        }
        if (op.equals("like")) {
            return "like";
        }
        return "UnknownOp";
    }

    public static String getNativeRuntimeComparisionOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("<")) {
            return " < 0";
        }
        if (op.equals(">")) {
            return " > 0";
        }
        if (op.equals("<=")) {
            return " <= 0";
        }
        if (op.equals(">=")) {
            return " >= 0";
        }
        return "";
    }

    public static String getNativeJavaOperation(BinaryExpression expr, Context ctx) {
        String op = expr.getOperator();
        if (expr.isNullable() || ((Boolean)ctx.getParameter("checkOverflow")).booleanValue()) {
            if (op.equals("<")) {
                return " < ";
            }
            if (op.equals(">")) {
                return " > ";
            }
            if (op.equals("<=")) {
                return " <= ";
            }
            if (op.equals(">=")) {
                return " >= ";
            }
            if (op.equals("&&")) {
                return " && ";
            }
            if (op.equals("||")) {
                return " || ";
            }
            if (op.equals("xor")) {
                return " ^ ";
            }
            if (op.equals("::")) {
                return " + ";
            }
            if (op.equals("&")) {
                return " & ";
            }
            if (op.equals("|")) {
                return " | ";
            }
            if (op.equals("<<")) {
                return " << ";
            }
            if (op.equals(">>")) {
                return " >> ";
            }
            if (op.equals(">>>")) {
                return " >>> ";
            }
            return "";
        }
        if (op.equals("+")) {
            return " + ";
        }
        if (op.equals("-")) {
            return " - ";
        }
        if (op.equals("*")) {
            return " * ";
        }
        if (op.equals("%")) {
            return " % ";
        }
        if (op.equals("<")) {
            return " < ";
        }
        if (op.equals(">")) {
            return " > ";
        }
        if (op.equals("<=")) {
            return " <= ";
        }
        if (op.equals(">=")) {
            return " >= ";
        }
        if (op.equals("&&")) {
            return " && ";
        }
        if (op.equals("||")) {
            return " || ";
        }
        if (op.equals("xor")) {
            return " ^ ";
        }
        if (op.equals("::")) {
            return " + ";
        }
        if (op.equals("&")) {
            return " & ";
        }
        if (op.equals("|")) {
            return " | ";
        }
        if (op.equals("<<")) {
            return " << ";
        }
        if (op.equals(">>")) {
            return " >> ";
        }
        if (op.equals(">>>")) {
            return " >>> ";
        }
        return "";
    }

    public static String getNativeNullTypeJavaOperation(BinaryExpression expr, Context ctx) {
        String op = expr.getOperator();
        if (op.equals("==")) {
            return " == ";
        }
        if (op.equals("!=")) {
            return " != ";
        }
        return "";
    }

    public static String getNativeJavaAssignment(String op) {
        if (op.equals("xor=")) {
            return "^=";
        }
        if (op.equals("::=")) {
            return "+=";
        }
        return op;
    }

    public static boolean isHandledByJavaWithoutCast(Expression src, AsExpression tgt, Context ctx) {
        if (src.isNullable() || tgt.isNullable()) {
            return false;
        }
        if (!ctx.mapsToPrimitiveType(src.getType()) || !ctx.mapsToPrimitiveType(tgt.getType())) {
            return false;
        }
        String srcString = ctx.getPrimitiveMapping(src.getType());
        String tgtString = ctx.getPrimitiveMapping(tgt.getType());
        int srcIndex = CommonUtilities.getJavaAllowedType(srcString);
        int tgtIndex = CommonUtilities.getJavaAllowedType(tgtString);
        return srcIndex >= 0 && tgtIndex >= 0 && CommonUtilities.isAcceptibleImplicitCast(srcIndex, tgtIndex);
    }

    public static boolean isHandledByJavaWithCast(Expression src, AsExpression tgt, Context ctx) {
        if (src.isNullable() || tgt.isNullable()) {
            return false;
        }
        if (!ctx.mapsToPrimitiveType(src.getType()) || !ctx.mapsToPrimitiveType(tgt.getType())) {
            return false;
        }
        String srcString = ctx.getPrimitiveMapping(src.getType());
        String tgtString = ctx.getPrimitiveMapping(tgt.getType());
        int srcIndex = CommonUtilities.getJavaAllowedType(srcString);
        int tgtIndex = CommonUtilities.getJavaAllowedType(tgtString);
        if (srcIndex >= 0 && tgtIndex >= 0 && srcIndex != tgtIndex) {
            return !CommonUtilities.isBoxedOutputTemp(src, ctx);
        }
        return false;
    }

    private static boolean isAcceptibleImplicitCast(int src, int tgt) {
        if (src == tgt) {
            return true;
        }
        if (src == 1 && (tgt == 2 || tgt == 3)) {
            return true;
        }
        return src == 2 && tgt == 3;
    }

    private static int getJavaAllowedType(String value) {
        if (value.equals("boolean")) {
            return 0;
        }
        if (value.equals("short")) {
            return 1;
        }
        if (value.equals("int")) {
            return 2;
        }
        if (value.equals("long")) {
            return 3;
        }
        if (value.equals("float")) {
            return 4;
        }
        if (value.equals("double")) {
            return 5;
        }
        return -1;
    }

    public static void genEzeCopyTo(Expression expr, Context ctx, TabbedWriter out) {
        out.print("org.eclipse.edt.runtime.java.eglx.lang.AnyValue.ezeCopyTo(");
        if (expr instanceof NullLiteral) {
            out.print("(eglx.lang.AnyValue) ");
        }
    }

    public static boolean isBoxedOutputTemp(Expression expr, Context ctx) {
        return expr instanceof MemberName && CommonUtilities.isBoxedOutputTemp(((MemberName)expr).getMember(), ctx);
    }

    public static boolean isBoxedOutputTemp(Member member, Context ctx) {
        return ctx.getAttribute(member, "functionArgumentTemporaryVariable") != null && ctx.getAttribute(member, "functionArgumentTemporaryVariable") != ParameterKind.PARM_IN;
    }

    public static void processImport(String qualifiedName, Context ctx) {
        if (qualifiedName == null || qualifiedName.indexOf(46) < 0) {
            return;
        }
        List typesImported = (List)ctx.getAttribute(((Object)((Object)ctx)).getClass(), "partTypesImported");
        for (String imported : typesImported) {
            if (!qualifiedName.equalsIgnoreCase(imported)) continue;
            return;
        }
        Part partBeingGenerated = (Part)ctx.getAttribute(((Object)((Object)ctx)).getClass(), "partBeingGenerated");
        if (partBeingGenerated.getFullyQualifiedName().equalsIgnoreCase(qualifiedName)) {
            return;
        }
        String unqualifiedName = qualifiedName;
        if (unqualifiedName.indexOf(46) >= 0) {
            unqualifiedName = unqualifiedName.substring(unqualifiedName.lastIndexOf(46) + 1);
        }
        if (unqualifiedName.equalsIgnoreCase(partBeingGenerated.getName())) {
            return;
        }
        for (String imported : typesImported) {
            int dotIndex = imported.lastIndexOf(46);
            if (dotIndex >= 0) {
                imported = imported.substring(dotIndex + 1);
            }
            if (!unqualifiedName.equalsIgnoreCase(imported)) continue;
            return;
        }
        typesImported.add(qualifiedName);
    }

    public static void generateSmapExtension(Member field, Context ctx) {
        Annotation annotation;
        if (!field.getName().startsWith("eze") && (annotation = field.getAnnotation("EGL_Location")) != null && annotation.getValue("line") != null) {
            ctx.getSmapExtension().append("" + (Integer)annotation.getValue("line"));
            if (ctx.getCurrentFile() != null) {
                if (ctx.getSmapFiles().indexOf(ctx.getCurrentFile()) < 0) {
                    ctx.getSmapFiles().add(ctx.getCurrentFile());
                }
                ctx.getSmapExtension().append("#" + (ctx.getSmapFiles().indexOf(ctx.getCurrentFile()) + 1) + ";");
            } else {
                ctx.getSmapExtension().append("#1;");
            }
            ctx.getSmapExtension().append(String.valueOf(field.getName()) + ";");
            ctx.getSmapExtension().append(String.valueOf(JavaAliaser.getAlias((String)field.getName())) + ";");
            ctx.getSmapExtension().append(String.valueOf(field.getType().getTypeSignature()) + "\n");
        }
    }

    public static void generateSmapExtension(Function function, Context ctx) {
        Annotation annotation = function.getAnnotation("EGL_Location");
        if (annotation != null && annotation.getValue("line") != null) {
            ctx.getSmapExtension().append("" + (Integer)annotation.getValue("line"));
            if (ctx.getCurrentFile() != null) {
                if (ctx.getSmapFiles().indexOf(ctx.getCurrentFile()) < 0) {
                    ctx.getSmapFiles().add(ctx.getCurrentFile());
                }
                ctx.getSmapExtension().append("#" + (ctx.getSmapFiles().indexOf(ctx.getCurrentFile()) + 1) + ";");
            } else {
                ctx.getSmapExtension().append("#1;");
            }
            ctx.getSmapExtension().append("F:" + function.getName() + ";" + JavaAliaser.getAlias((String)function.getName()) + ";(");
            int i = 0;
            while (i < function.getParameters().size()) {
                FunctionParameter decl = (FunctionParameter)function.getParameters().get(i);
                if (org.eclipse.edt.gen.CommonUtilities.isBoxedParameterType((FunctionParameter)decl, (EglContext)ctx) && !decl.isConst().booleanValue()) {
                    ctx.getSmapExtension().append("Lorg/eclipse/edt/javart/AnyBoxedObject;");
                } else if (decl.getType() instanceof Delegate) {
                    ctx.getSmapExtension().append("Lorg/eclipse/edt/javart/Delegate;");
                } else {
                    ctx.getSmapExtension().append(CommonUtilities.generateJavaTypeSignature(((FunctionParameter)function.getParameters().get(i)).getType(), ctx, ((FunctionParameter)function.getParameters().get(i)).isNullable()));
                }
                ++i;
            }
            ctx.getSmapExtension().append(")" + CommonUtilities.generateJavaTypeSignature(function.getReturnType(), ctx, function.isNullable()) + "\n");
        }
    }

    public static void generateSmapExtension(DataTable dataTable, Context ctx) {
    }

    public static void generateSmapExtension(Form form, Context ctx) {
    }

    public static void generateSmapExtension(Library library, Context ctx) {
        if (ctx.mapsToNativeType((Type)library)) {
            ctx.getSmapExtension().append("*S;" + library.getFullyQualifiedName() + ";" + "eze_Lib_" + library.getFullyQualifiedName().replace('.', '_') + "\n");
        } else {
            ctx.getSmapExtension().append("*L;" + library.getFullyQualifiedName() + ";" + "eze_Lib_" + library.getFullyQualifiedName().replace('.', '_') + "\n");
        }
    }

    public static void generateSmapExtension(ProgramParameter programParameter, Context ctx) {
        ctx.getSmapExtension().append("*P;" + programParameter.getName() + ";" + JavaAliaser.getAlias((String)programParameter.getName()) + ";");
        ctx.getSmapExtension().append(String.valueOf(programParameter.getType().getTypeSignature()) + "\n");
    }

    private static String generateJavaTypeSignature(Type type, Context ctx, boolean isNullable) {
        String signature = "";
        if (type instanceof ArrayType) {
            signature = String.valueOf(signature) + "Ljava/util/List;";
        } else if (type instanceof ExternalType && ctx.mapsToNativeType((Type)type.getClassifier())) {
            signature = String.valueOf(signature) + "L" + ctx.getRawNativeImplementationMapping((Type)type.getClassifier()) + ";";
        } else if (type == null) {
            signature = String.valueOf(signature) + "V";
        } else if (ctx.mapsToPrimitiveType((Type)type.getClassifier())) {
            String value = ctx.getRawPrimitiveMapping((Type)type.getClassifier());
            signature = isNullable ? (value.equals("boolean") ? String.valueOf(signature) + "Ljava/lang/Boolean;" : (value.equals("byte") ? String.valueOf(signature) + "Ljava/lang/Byte;" : (value.equals("double") ? String.valueOf(signature) + "Ljava/lang/Double;" : (value.equals("float") ? String.valueOf(signature) + "Ljava/lang/Float;" : (value.equals("int") ? String.valueOf(signature) + "Ljava/lang/Integer;" : (value.equals("long") ? String.valueOf(signature) + "Ljava/lang/Long;" : (value.equals("short") ? String.valueOf(signature) + "Ljava/lang/Short;" : String.valueOf(signature) + "L" + value.replaceAll("\\.", "/") + ";"))))))) : (value.equals("boolean") ? String.valueOf(signature) + "Z" : (value.equals("byte") ? String.valueOf(signature) + "B" : (value.equals("double") ? String.valueOf(signature) + "D" : (value.equals("float") ? String.valueOf(signature) + "F" : (value.equals("int") ? String.valueOf(signature) + "I" : (value.equals("long") ? String.valueOf(signature) + "J" : (value.equals("short") ? String.valueOf(signature) + "S" : String.valueOf(signature) + "L" + value.replaceAll("\\.", "/") + ";")))))));
        } else {
            signature = String.valueOf(signature) + "L" + type.getClassifier().getTypeSignature().replaceAll("\\.", "/") + ";";
        }
        return signature;
    }

    public static String getPropertyFunction(NamedElement field, boolean setter, Context context) {
        String result = null;
        boolean isEGLProperty = true;
        Annotation annotation = field.getAnnotation("eglx.lang.EGLProperty");
        if (annotation == null) {
            annotation = field.getAnnotation("eglx.lang.Property");
            isEGLProperty = false;
        }
        if (annotation != null) {
            boolean bothUnspecified;
            String propertyFunction = setter ? "setMethod" : "getMethod";
            String otherPropertyFunction = setter ? "getMethod" : "setMethod";
            Object propFn = annotation.getValue(propertyFunction);
            Object otherPropFn = annotation.getValue(otherPropertyFunction);
            boolean bl = bothUnspecified = (propFn == null || propFn instanceof String && ((String)propFn).length() == 0) && (otherPropFn == null || otherPropFn instanceof String && ((String)otherPropFn).length() == 0);
            if (bothUnspecified) {
                String fieldName = field.getName();
                result = String.valueOf(setter ? "set" : "get") + fieldName.substring(0, 1).toUpperCase();
                if (fieldName.length() > 1) {
                    result = String.valueOf(result) + fieldName.substring(1);
                }
                if (isEGLProperty) {
                    QualifiedFunctionInvocation qfi = context.getFactory().createQualifiedFunctionInvocation();
                    qfi.setId(result);
                    qfi.setQualifier(CommonUtilities.expressionForContainer(((Field)field).getContainer(), context));
                    if (setter) {
                        MemberName argName = context.getFactory().createMemberName();
                        argName.setId(field.getName());
                        argName.setMember((Member)field);
                        qfi.getArguments().add(argName);
                    }
                    result = qfi.getTarget().getName();
                }
            } else {
                result = propFn instanceof Name ? ((Name)propFn).getId() : (String)propFn;
            }
        }
        return result;
    }

    private static Expression expressionForContainer(Container container, Context ctx) {
        ThisExpression result = null;
        Object pbg = ctx.getAttribute(((Object)((Object)ctx)).getClass(), "partBeingGenerated");
        if (container instanceof Function || container instanceof Part && pbg instanceof Part && ((Part)container).getFullyQualifiedName().equalsIgnoreCase(((Part)pbg).getFullyQualifiedName())) {
            ThisExpression thisExpr = ctx.getFactory().createThisExpression();
            thisExpr.setThisObject((Element)container);
            result = thisExpr;
        } else {
            TypeName typeExpr = ctx.getFactory().createTypeName();
            typeExpr.setType((Type)container);
            result = typeExpr;
        }
        return result;
    }

    public static String getEnumerationName(Object enm) {
        if (enm instanceof EnumerationEntry) {
            return ((EnumerationEntry)enm).getName();
        }
        return "";
    }
}

