/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.generator.java;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.eclipse.edt.compiler.internal.util.IGenerationResultsMessage;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.CommonUtilities;
import org.eclipse.edt.gen.EGLMessages.EGLMessage;
import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.gen.Generator;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.JavaCoreGenerator;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Part;

public class EGL2Java
extends AbstractGeneratorCommand {
    public static void main(String[] args) {
        EGL2Java genPart = new EGL2Java();
        genPart.generate(args, (Generator)new JavaCoreGenerator((AbstractGeneratorCommand)genPart), null, null);
    }

    protected void writeAuxiliaryFiles(Part part, Generator generator) throws Exception {
        super.writeAuxiliaryFiles(part, generator);
        if (!generator.getContext().getMessageRequestor().isError() && generator.getContext() instanceof Context) {
            boolean writeSMAP;
            Context context = (Context)generator.getContext();
            boolean bl = writeSMAP = generator.getResult() != null && generator.getResult().toString().length() != 0;
            if (!writeSMAP) {
                Boolean forceSMAP = (Boolean)context.getAttribute(context.getClass(), "forceWriteSMAP");
                boolean bl2 = writeSMAP = forceSMAP != null && forceSMAP != false;
            }
            if (writeSMAP) {
                try {
                    this.writeSMAPFile(context.getSmapData().toString().getBytes("UTF-8"), part, generator);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    String[] details = new String[]{"UTF-8"};
                    EGLMessage message = EGLMessage.createEGLMessage((Map)context.getMessageMapping(), (int)1, (String)"9971", null, (String[])details, (Annotation)CommonUtilities.includeEndOffset((Annotation)context.getLastStatementLocation(), (EglContext)context));
                    context.getMessageRequestor().addMessage((IGenerationResultsMessage)message);
                }
                catch (Exception exception) {
                    String name = generator.getRelativeFileName(part);
                    name = String.valueOf(name.substring(0, name.length() - generator.getFileExtension().length())) + ".eglsmap";
                    String[] details = new String[]{name};
                    EGLMessage message = EGLMessage.createEGLMessage((Map)context.getMessageMapping(), (int)1, (String)"9970", null, (String[])details, (Annotation)CommonUtilities.includeEndOffset((Annotation)context.getLastStatementLocation(), (EglContext)context));
                    context.getMessageRequestor().addMessage((IGenerationResultsMessage)message);
                    return;
                }
            }
        }
    }

    protected void writeSMAPFile(byte[] data, Part part, Generator generator) throws Exception {
        String fileName = ((String)this.getParameter("output").getValue()).replaceAll("\\\\", "/");
        if (!fileName.endsWith("/")) {
            fileName = String.valueOf(fileName) + "/";
        }
        fileName = String.valueOf(fileName) + generator.getRelativeFileName(part);
        File outSmapFile = new File(String.valueOf(fileName.substring(0, fileName.length() - generator.getFileExtension().length())) + ".eglsmap");
        int offset = fileName.lastIndexOf("/");
        if (offset > 0) {
            new File(fileName.substring(0, offset)).mkdirs();
        }
        FileOutputStream outStream = new FileOutputStream(outSmapFile);
        try {
            outStream.write(data, 0, data.length);
        }
        catch (IOException ioe) {
            try {
                outStream.close();
            }
            catch (IOException iOException) {}
            throw ioe;
        }
        outStream.close();
    }
}

