/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.deployment.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLElementImageDescriptor;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.deployment.Binding;
import org.eclipse.edt.ide.ui.internal.deployment.Bindings;
import org.eclipse.edt.ide.ui.internal.deployment.Deployment;
import org.eclipse.edt.ide.ui.internal.deployment.DeploymentFactory;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDBaseBlock;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDBaseFormPage;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDBindingDetailPageProvider;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDBindingFormPage;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDeploymentDescriptorEditor;
import org.eclipse.edt.ide.ui.internal.deployment.ui.SOAMessages;
import org.eclipse.edt.ide.ui.internal.viewsupport.ImageDescriptorRegistry;
import org.eclipse.edt.ide.ui.internal.wizards.EGLDDBindingWizard;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class EGLDDBindingBlock
extends EGLDDBaseBlock {
    private static final int COLINDEX_NAME = 0;
    private static final int COLINDEX_TYPE = 1;
    protected Button fBtnRemove;
    protected ISelection fCurrentSelection;
    protected Button fBtnAdd;

    public EGLDDBindingBlock(FormPage page) {
        this.fPage = page;
    }

    public void createContent(IManagedForm managedForm) {
        super.createContent(managedForm);
    }

    protected void createMasterPart(final IManagedForm managedForm, Composite parent) {
        FormToolkit toolkit = managedForm.getToolkit();
        Composite client1 = toolkit.createComposite(parent, 64);
        GridData gd = new GridData(1808);
        client1.setLayoutData((Object)gd);
        this.createAliasLayout(toolkit, client1);
        Section section = toolkit.createSection(client1, 384);
        section.setText(this.getMasterSectionTitle());
        section.setDescription(this.getMasterSectionDescription());
        section.marginWidth = 10;
        section.marginHeight = 5;
        gd = new GridData(1840);
        gd.horizontalSpan = 2;
        section.setLayoutData((Object)gd);
        Composite seprator = toolkit.createCompositeSeparator((Composite)section);
        gd = new GridData(1808);
        gd.heightHint = 3;
        seprator.setLayoutData((Object)gd);
        Composite client2 = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client2.setLayout((Layout)layout);
        Table t = EGLDDBindingBlock.createTableControl(toolkit, client2);
        Composite btnComposite = toolkit.createComposite(client2);
        GridLayout g1 = new GridLayout(1, true);
        gd = new GridData(2);
        btnComposite.setLayout((Layout)g1);
        btnComposite.setLayoutData((Object)gd);
        this.fBtnAdd = toolkit.createButton(btnComposite, SOAMessages.AddLabel, 8);
        gd = new GridData(832);
        this.fBtnAdd.setLayoutData((Object)gd);
        this.fBtnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EGLDDBindingBlock.this.HandleAddBtnPressed();
            }
        });
        this.fBtnRemove = toolkit.createButton(btnComposite, SOAMessages.RemoveLabel, 8);
        gd = new GridData(832);
        this.fBtnRemove.setLayoutData((Object)gd);
        this.fBtnRemove.setEnabled(false);
        this.fBtnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EGLDDBindingBlock.this.HandleRemoveBtnPressed();
            }
        });
        section.setClient((Control)client2);
        final SectionPart spart = new SectionPart(section);
        managedForm.addPart((IFormPart)spart);
        this.fTableViewer = new TableViewer(t);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EGLDDBindingBlock.this.fCurrentSelection = event.getSelection();
                managedForm.fireSelectionChanged((IFormPart)spart, EGLDDBindingBlock.this.fCurrentSelection);
                EGLDDBindingBlock.this.HandleTableViewerSelectionChanged();
            }
        });
        this.fTableViewer.setColumnProperties(new String[]{"COL_BINDNAME", "COL_PROTOCOL"});
        this.fTableViewer.setSorter(new ViewerSorter());
        this.setTableViewerProviders(this.fTableViewer);
        EGLDeploymentRoot serviceBindingRoot = this.getEGLDeploymentRootInput();
        if (serviceBindingRoot != null) {
            this.fTableViewer.setInput((Object)serviceBindingRoot);
        } else {
            this.fTableViewer.setInput((Object)this.fPage.getEditor().getEditorInput());
        }
    }

    private void createAliasLayout(FormToolkit toolkit, Composite client) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        client.setLayoutData((Object)gd);
    }

    public static Table createTableControl(FormToolkit toolkit, Composite client) {
        Table t = toolkit.createTable(client, 66308);
        t.setHeaderVisible(true);
        t.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        GridData gd = new GridData(1808);
        gd.heightHint = 20;
        gd.widthHint = 100;
        t.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
        int maxWidth = 70;
        TableColumn col = new TableColumn(t, 16384, 0);
        col.setText(SOAMessages.TableColName);
        col.pack();
        int tableColWidth = Math.max(70, col.getWidth());
        maxWidth = Math.max(maxWidth, tableColWidth);
        ColumnWeightData colData = new ColumnWeightData(tableColWidth, tableColWidth, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        col = new TableColumn(t, 16384, 1);
        col.setText(SOAMessages.TableColType);
        col.pack();
        tableColWidth = Math.max(70, col.getWidth());
        maxWidth = Math.max(maxWidth, tableColWidth);
        colData = new ColumnWeightData(tableColWidth, tableColWidth, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        t.setLayout((Layout)tableLayout);
        return t;
    }

    protected IFile getServiceBindingFile() {
        IFile fileInput = null;
        FormEditor formEditor = this.fPage.getEditor();
        IEditorInput input = formEditor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            fileInput = ((IFileEditorInput)input).getFile();
        }
        return fileInput;
    }

    protected void HandleTableViewerSelectionChanged() {
        this.fBtnRemove.setEnabled(true);
    }

    protected void HandleAddBtnPressed() {
        EGLDDBindingWizard wizard = new EGLDDBindingWizard();
        IWorkbench workbench = this.fPage.getSite().getWorkbenchWindow().getWorkbench();
        IProject proj = ((EGLDeploymentDescriptorEditor)this.fPage.getEditor()).getProject();
        EGLDDBindingFormPage formPage = (EGLDDBindingFormPage)this.fPage;
        wizard.init(workbench, proj, this.getEGLDeploymentRootInput());
        formPage.openWizard((IWizard)wizard);
        Object newBinding = wizard.getNewBinding();
        if (newBinding != null) {
            EGLDDBaseFormPage.updateTableViewerAfterAdd(this.fTableViewer, newBinding);
        }
    }

    protected void HandleRemoveBtnPressed() {
        IStructuredSelection ssel = (IStructuredSelection)this.fTableViewer.getSelection();
        if (ssel.size() == 1) {
            Object obj = ssel.getFirstElement();
            Deployment deployment = this.getEGLDeploymentRootInput().getDeployment();
            Bindings bindings = deployment.getBindings();
            if (bindings == null) {
                bindings = DeploymentFactory.eINSTANCE.createBindings();
                deployment.setBindings(bindings);
            }
            int selectionIndex = this.fTableViewer.getTable().getSelectionIndex();
            boolean removeSuccesful = false;
            if (obj instanceof Binding) {
                removeSuccesful = bindings.getBinding().remove(obj);
            }
            if (removeSuccesful) {
                EGLDDBaseFormPage.updateTableViewerAfterRemove(selectionIndex, this.fTableViewer, this.fBtnRemove);
            }
        }
    }

    protected String getMasterSectionDescription() {
        return SOAMessages.BindingMainSectionDescription;
    }

    protected String getMasterSectionTitle() {
        return SOAMessages.BindingMainSectionTitle;
    }

    protected void setTableViewerProviders(TableViewer tviewer) {
        tviewer.setContentProvider((IContentProvider)new ServiceBindingContentProvider());
        tviewer.setLabelProvider((IBaseLabelProvider)new ServiceBindingLabelProvider());
    }

    protected void createToolBarActions(IManagedForm managedForm) {
    }

    protected void registerPages(DetailsPart detailsPart) {
        detailsPart.setPageProvider((IDetailsPageProvider)new EGLDDBindingDetailPageProvider());
    }

    public static class ServiceBindingContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            EGLDeploymentRoot servicebindingRoot;
            Deployment deployment;
            Bindings bindings;
            ArrayList children = new ArrayList();
            if (inputElement instanceof EGLDeploymentRoot && (bindings = (deployment = (servicebindingRoot = (EGLDeploymentRoot)inputElement).getDeployment()).getBindings()) != null) {
                children.addAll(bindings.getBinding());
            }
            return children.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static class ServiceBindingLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                EGLElementImageDescriptor overlayedDescriptor = null;
                ImageDescriptorRegistry registry = EDTUIPlugin.getImageDescriptorRegistry();
                int overlayFlag = 0;
                overlayedDescriptor = new EGLElementImageDescriptor(PluginImages.DESC_OBJS_EXTERNALSERVICE, overlayFlag, EGLDeploymentDescriptorEditor.SMALL_SIZE);
                if (overlayedDescriptor != null) {
                    return registry.get((ImageDescriptor)overlayedDescriptor);
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Binding) {
                if (columnIndex == 0) {
                    return ((Binding)element).getName();
                }
                if (columnIndex == 1) {
                    String type = ((Binding)element).getType();
                    if (org.eclipse.edt.javart.resources.egldd.Binding.BINDING_SERVICE_REST.equals(type)) {
                        return "REST";
                    }
                    if (org.eclipse.edt.javart.resources.egldd.Binding.BINDING_DB_SQL.equals(type)) {
                        return "SQL";
                    }
                    return type.substring(type.lastIndexOf(".") + 1).toUpperCase();
                }
            }
            return "";
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }
}

