/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor.sql;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.ClassFieldBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.internal.sql.util.SQLUtility;
import org.eclipse.edt.ide.core.internal.model.BinaryPart;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.internal.search.PartDeclarationInfo;
import org.eclipse.edt.ide.core.internal.search.PartInfo;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.dialogs.RecordPartSelectionDialog;
import org.eclipse.edt.ide.ui.internal.editor.EditorUtility;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.TextEditor;

public class SQLEditorUtility
extends EditorUtility {
    public static boolean isRetrieveSQLValid(TextEditor editor) {
        Record record = SQLEditorUtility.getSQLRecord(editor);
        return record != null;
    }

    public static ClassFieldBinding createRecordBinding(Record record) {
        ITypeBinding typeBinding;
        if (record != null && (typeBinding = (ITypeBinding)record.getName().resolveBinding()) != null && typeBinding != IBinding.NOT_FOUND_BINDING) {
            return new ClassFieldBinding(typeBinding.getCaseSensitiveName(), null, typeBinding);
        }
        return null;
    }

    public static Record getSQLRecord(TextEditor editor) {
        Record record;
        Node node = SQLEditorUtility.getCurrentNode(editor);
        while (node != null && !(node instanceof Record)) {
            node = node.getParent();
        }
        if (node != null && node instanceof Record && SQLUtility.isSQLRecordPart((Record)(record = (Record)node))) {
            return record;
        }
        return null;
    }

    public static List getSQLRecords(TextEditor editor, String name, int matchMode, IEGLSearchScope scope) {
        ArrayList<PartDeclarationInfo> sqlParts = new ArrayList<PartDeclarationInfo>();
        if (editor != null && scope != null && name != null) {
            List parts = SQLEditorUtility.getRecordParts(editor, name, matchMode, scope);
            for (PartDeclarationInfo partInfo : parts) {
                IPart part = SQLEditorUtility.resolvePart((PartInfo)partInfo, scope);
                if (part != null && part instanceof SourcePart && ((SourcePart)part).isSQLRecord()) {
                    sqlParts.add(partInfo);
                    continue;
                }
                if (part == null || !(part instanceof BinaryPart) || !((BinaryPart)part).isSQLRecord()) continue;
                sqlParts.add(partInfo);
            }
        }
        return sqlParts;
    }

    public static boolean isPrepareStatementAllowed(TextEditor editor) {
        if (SQLEditorUtility.isWithinFunction(editor)) {
            Node node = SQLEditorUtility.getCurrentNode(editor);
            while (node != null) {
                Statement statementNode;
                if (node instanceof Statement && !(statementNode = (Statement)node).canIncludeOtherStatements()) {
                    return false;
                }
                node = node.getParent();
            }
            if (node == null) {
                return true;
            }
        }
        return false;
    }

    public static IPart getSQLRecordPartFromSelectionDialog(TextEditor editor, IEGLSearchScope scope) {
        Object[] parts;
        if (editor == null) {
            return null;
        }
        IPart part = null;
        Shell parent = EDTUIPlugin.getActiveWorkbenchShell();
        RecordPartSelectionDialog dialog = new RecordPartSelectionDialog(parent, (IRunnableContext)new ProgressMonitorDialog(parent), 8, scope, SQLEditorUtility.getSQLRecords(editor, "", 1, scope));
        dialog.setMatchEmptyString(true);
        dialog.setTitle(UINlsStrings.SQLRecordPartDialogTitle);
        dialog.setMessage(String.valueOf(UINlsStrings.SQLRecordPartDialogMessagePart1) + "\r\n" + "\r\n" + UINlsStrings.SQLRecordPartDialogMessagePart2);
        int result = dialog.open();
        if (result == 0 && (parts = dialog.getResult()) != null && parts.length > 0) {
            part = (IPart)parts[0];
        }
        return part;
    }

    public static boolean isCreateDataItemValid(IStructuredSelection selection) {
        int i = 0;
        String recordName = "";
        boolean validSelection = false;
        Record record = null;
        for (Object selectedElement : selection) {
            if (selectedElement != null && selectedElement instanceof StructureItem) {
                StructureItem structureItem = (StructureItem)selectedElement;
                if (structureItem.getParent() instanceof Record) {
                    record = (Record)structureItem.getParent();
                    if (i == 0) {
                        if (SQLUtility.isSQLRecordPart((Record)record)) {
                            recordName = record.getName().getCanonicalName();
                            ++i;
                        } else {
                            return false;
                        }
                    }
                    if (record.getName().getCanonicalName().equals(recordName)) {
                        if (structureItem.getType().isPrimitiveType()) {
                            validSelection = true;
                            continue;
                        }
                        if (!structureItem.getType().isArrayType() || !((ArrayType)structureItem.getType()).getBaseType().isPrimitiveType()) continue;
                        validSelection = true;
                        continue;
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return validSelection;
    }
}

