/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.ISystemEnvironment;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.ide.core.internal.compiler.SystemEnvironmentManager;
import org.eclipse.edt.ide.core.internal.model.BinaryPart;
import org.eclipse.edt.ide.core.internal.model.ClassFile;
import org.eclipse.edt.ide.core.internal.model.util.EGLModelUtil;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.edt.ide.core.model.ISourceRange;
import org.eclipse.edt.ide.core.model.IWorkingCopy;
import org.eclipse.edt.ide.core.utils.BinaryReadOnlyFile;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.editor.BinaryEditorInput;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.editor.IEvEditor;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;
import org.eclipse.jface.action.Action;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class EditorUtility {
    public static boolean isEditorInput(Object element, IEditorPart editor) {
        if (editor != null) {
            try {
                return editor.getEditorInput().equals(EditorUtility.getEditorInput(element));
            }
            catch (EGLModelException x) {
                EDTUIPlugin.log(x.getStatus());
            }
        }
        return false;
    }

    public static IEditorPart isOpenInEditor(Object inputElement) {
        IWorkbenchPage p;
        IEditorInput input = null;
        try {
            input = EditorUtility.getEditorInput(inputElement);
        }
        catch (EGLModelException x) {
            EDTUIPlugin.log(x.getStatus());
        }
        if (input != null && (p = EDTUIPlugin.getActivePage()) != null) {
            return p.findEditor(input);
        }
        return null;
    }

    public static IEditorPart openInEditor(Object inputElement) throws EGLModelException, PartInitException {
        return EditorUtility.openInEditor(inputElement, true);
    }

    public static IEditorPart openInEditor(Object inputElement, boolean activate) throws EGLModelException, PartInitException {
        BinaryEditorInput fileInput;
        IClassFile classFile;
        if (inputElement instanceof IFile) {
            return EditorUtility.openInEditor((IFile)inputElement, activate);
        }
        IEditorInput input = EditorUtility.getEditorInput(inputElement);
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput2 = (IFileEditorInput)input;
            return EditorUtility.openInEditor(fileInput2.getFile(), activate);
        }
        if (input instanceof BinaryEditorInput && (classFile = (fileInput = (BinaryEditorInput)input).getClassFile()) instanceof ClassFile) {
            return EditorUtility.openClassFile((ClassFile)classFile, "org.eclipse.edt.ide.ui.BinaryFileEditor");
        }
        if (input != null) {
            return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, inputElement), activate);
        }
        return null;
    }

    public static void revealInEditor(IEditorPart part, Node node) {
        if (node != null && (part instanceof EGLEditor || part instanceof IEvEditor)) {
            int start = node.getOffset();
            int length = node.getLength();
            if (part instanceof EGLEditor) {
                ((EGLEditor)part).selectAndReveal(start, length);
            } else if (part instanceof IEvEditor) {
                ((IEvEditor)part).selectAndReveal(start, length);
            }
        }
    }

    public static void revealInEditor(IEditorPart part, Match match) {
        if (match != null && (part instanceof EGLEditor || part instanceof IEvEditor)) {
            int start = match.getOffset();
            int length = match.getLength();
            if (part instanceof EGLEditor) {
                ((EGLEditor)part).selectAndReveal(start, length);
            } else if (part instanceof IEvEditor) {
                ((IEvEditor)part).selectAndReveal(start, length);
            }
        }
    }

    public static void revealInEditor(IEditorPart part, IEGLElement element) {
        if (element != null && (part instanceof EGLEditor || part instanceof IEvEditor)) {
            try {
                if (element instanceof IMember) {
                    ISourceRange range = ((IMember)element).getNameRange();
                    int start = range.getOffset();
                    int length = range.getLength() - 1;
                    if (part instanceof EGLEditor) {
                        ((EGLEditor)part).selectAndReveal(start, length);
                    } else if (part instanceof IEvEditor) {
                        ((IEvEditor)part).selectAndReveal(start, length);
                    }
                }
            }
            catch (EGLModelException eGLModelException) {}
        }
    }

    private static IEditorPart openInEditor(IFile file, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (file != null && (p = EDTUIPlugin.getActivePage()) != null) {
            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)activate);
            return editorPart;
        }
        return null;
    }

    private static IEditorPart openInEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (input != null && (p = EDTUIPlugin.getActivePage()) != null) {
            IEditorPart editorPart = p.openEditor(input, editorID, activate);
            return editorPart;
        }
        return null;
    }

    public static String getEditorID(IEditorInput input, Object inputObject) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(input.getName());
        if (descriptor != null) {
            return descriptor.getId();
        }
        return null;
    }

    private static IEditorInput getEditorInput(IEGLElement element) throws EGLModelException {
        IEGLElement root = element;
        while (element != null) {
            if (element instanceof IWorkingCopy && ((IWorkingCopy)element).isWorkingCopy()) {
                element = ((IWorkingCopy)element).getOriginalElement();
            }
            if (element instanceof IEGLFile) {
                IEGLFile unit = (IEGLFile)element;
                IResource resource = unit.getResource();
                if (resource instanceof IFile) {
                    return new FileEditorInput((IFile)resource);
                }
            } else if (element instanceof IClassFile && root instanceof BinaryPart) {
                BinaryPart part = (BinaryPart)root;
                String irFullQualifiedFile = part.getFullyQualifiedName();
                IProject project = part.getEGLProject().getProject();
                String eglarFilePath = Util.findPartFilePath((String)irFullQualifiedFile, (IEGLProject)EGLCore.create((IProject)project));
                BinaryReadOnlyFile storage = EditorUtility.getBinaryReadonlyFile(project, eglarFilePath, irFullQualifiedFile);
                BinaryEditorInput input = new BinaryEditorInput(storage);
                input.setClassFile((IClassFile)element);
                return input;
            }
            element = element.getParent();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object input) throws EGLModelException {
        if (input instanceof IEGLElement) {
            return EditorUtility.getEditorInput((IEGLElement)input);
        }
        if (input instanceof IFile) {
            return new FileEditorInput((IFile)input);
        }
        return null;
    }

    public static IEGLElement getActiveEditorEGLInput() {
        IEditorInput editorInput;
        IEditorPart part;
        IWorkbenchPage page = EDTUIPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) != null && (editorInput = part.getEditorInput()) != null) {
            return (IEGLElement)editorInput.getAdapter(IEGLElement.class);
        }
        return null;
    }

    public static IEGLFile getWorkingCopy(IEGLFile cu) {
        if (cu == null) {
            return null;
        }
        if (cu.isWorkingCopy()) {
            return cu;
        }
        return (IEGLFile)cu.findSharedWorkingCopy(EGLUI.getBufferFactory());
    }

    public static IMember getWorkingCopy(IMember member) throws EGLModelException {
        IEGLFile workingCopy;
        IEGLFile cu = member.getEGLFile();
        if (cu != null && (workingCopy = EditorUtility.getWorkingCopy(cu)) != null) {
            return EGLModelUtil.findMemberInEGLFile((IEGLFile)workingCopy, (IMember)member);
        }
        return null;
    }

    private static IEGLFile getEGLFile(IEGLElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof IMember) {
            return ((IMember)element).getEGLFile();
        }
        int type = element.getElementType();
        if (6 == type) {
            return (IEGLFile)element;
        }
        if (7 == type) {
            return null;
        }
        return EditorUtility.getEGLFile(element.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IEGLElement getWorkingCopy(IEGLElement element, boolean reconcile) throws EGLModelException {
        IEGLFile unit = EditorUtility.getEGLFile(element);
        if (unit == null) {
            return null;
        }
        if (unit.isWorkingCopy()) {
            return element;
        }
        IEGLFile workingCopy = EditorUtility.getWorkingCopy(unit);
        if (workingCopy != null) {
            if (reconcile) {
                IEGLFile iEGLFile = workingCopy;
                synchronized (iEGLFile) {
                    workingCopy.reconcile();
                    return EGLModelUtil.findInEGLFile((IEGLFile)workingCopy, (IEGLElement)element);
                }
            }
            return EGLModelUtil.findInEGLFile((IEGLFile)workingCopy, (IEGLElement)element);
        }
        return null;
    }

    public static int findLocalizedModifier(String token) {
        if (token == null) {
            return 0;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    public static IEditorPart openClassFile(String eglarFilePath, String irFullQualifiedFile, String editorId) {
        return EditorUtility.openClassFile(null, eglarFilePath, irFullQualifiedFile, editorId);
    }

    private static BinaryEditorInput getClassfileEditor(IProject proj, String eglarFilePath, String irFullQualifiedFile, String editorId) {
        IEditorPart editorPart;
        IWorkbenchPage p;
        BinaryReadOnlyFile storage = EditorUtility.getBinaryReadonlyFile(proj, eglarFilePath, irFullQualifiedFile);
        BinaryEditorInput input = new BinaryEditorInput(storage);
        if (input != null && (p = EDTUIPlugin.getActivePage()) != null && (editorPart = p.findEditor((IEditorInput)input)) != null) {
            p.bringToTop((IWorkbenchPart)editorPart);
            return null;
        }
        return input;
    }

    private static BinaryEditorInput getClassfileSourceEditor(IProject proj, String eglarFilePath, String irFullQualifiedFile, String editorId, ClassFile classFile) {
        IEditorPart editorPart;
        IWorkbenchPage p;
        BinaryReadOnlyFile storage = EditorUtility.getBinaryReadonlyFile(proj, eglarFilePath, irFullQualifiedFile);
        BinaryEditorInput input = new BinaryEditorInput(storage, (IClassFile)classFile);
        if (input != null && (p = EDTUIPlugin.getActivePage()) != null && (editorPart = p.findEditor((IEditorInput)input)) != null) {
            p.bringToTop((IWorkbenchPart)editorPart);
            return null;
        }
        return input;
    }

    public static BinaryReadOnlyFile getBinaryReadonlyFile(IProject proj, String eglarFilePath, String irFullQualifiedFile) {
        if (proj.getWorkspace().getRoot().findMember((IPath)new Path(eglarFilePath)) == null) {
            return new BinaryReadOnlyFile(eglarFilePath, irFullQualifiedFile, proj, true);
        }
        return new BinaryReadOnlyFile(eglarFilePath, irFullQualifiedFile, proj, false);
    }

    public static IEditorPart openClassFile(IProject proj, String eglarFilePath, String irFullQualifiedFile, String editorId) {
        BinaryEditorInput input = EditorUtility.getClassfileEditor(proj, eglarFilePath, irFullQualifiedFile, editorId);
        if (input == null) {
            return null;
        }
        IClassFile classFile = input.getClassFile();
        if (classFile instanceof ClassFile) {
            return EditorUtility.openClassFile((ClassFile)classFile, editorId);
        }
        return null;
    }

    private static String getClassFileSource(ClassFile classFile, IProject proj) {
        String sourceName = null;
        ISystemEnvironment sysEnv = SystemEnvironmentManager.findSystemEnvironment((IProject)proj, null);
        IEnvironment sysIREnv = sysEnv.getIREnvironment();
        String mofSignature = String.valueOf(IRUtils.concatWithSeparator((String[])classFile.getPackageName(), (String)".")) + "." + classFile.getTypeName();
        String eglSignature = "egl:" + mofSignature;
        EObject irPart = null;
        try {
            irPart = sysIREnv.find(eglSignature);
            sourceName = irPart.eGet("filename").toString();
        }
        catch (MofObjectNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (DeserializationException e1) {
            e1.printStackTrace();
        }
        return sourceName;
    }

    private static String getClassFilePartSignature(ClassFile classFile, IProject proj) {
        ISystemEnvironment sysEnv = SystemEnvironmentManager.findSystemEnvironment((IProject)proj, null);
        sysEnv.getIREnvironment();
        return String.valueOf(IRUtils.concatWithSeparator((String[])classFile.getPackageName(), (String)".")) + "." + classFile.getTypeName();
    }

    public static IEditorPart openClassFile(ClassFile classFile, String editorId) {
        if (classFile != null) {
            IProject proj = classFile.getEGLProject().getProject();
            if (org.eclipse.edt.ide.core.internal.model.util.Util.isBinaryProject((IProject)proj)) {
                IFile eglFile = classFile.getFileInSourceFolder();
                classFile.setSourceFileSearchRequired(false);
                if (eglFile != null) {
                    try {
                        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)EDTUIPlugin.getActiveWorkbenchWindow().getActivePage(), (IFile)eglFile);
                        classFile.setSourceFileSearchRequired(true);
                        return editorPart;
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }
            String eglarPath = classFile.getPath().toString();
            String sourceFileName = EditorUtility.getClassFileSource(classFile, proj);
            if (sourceFileName != null && "" != sourceFileName) {
                return EditorUtility.openSourceFromEglarInBinaryEditor(classFile, proj, eglarPath, sourceFileName, editorId);
            }
            String fullyqualifiedPartName = EditorUtility.getClassFilePartSignature(classFile, proj);
            return EditorUtility.openClassFileInBinaryEditor(classFile, proj, eglarPath, fullyqualifiedPartName, editorId);
        }
        return null;
    }

    public static IEditorPart openClassFileInBinaryEditor(ClassFile classFile, IProject proj, String eglarFilePath, String irFullQualifiedFile, String editorId) {
        IWorkbenchWindow ww = EDTUIPlugin.getActiveWorkbenchWindow();
        BinaryEditorInput input = EditorUtility.getClassfileEditor(proj, eglarFilePath, irFullQualifiedFile, editorId);
        input.setClassFile((IClassFile)classFile);
        if (input == null) {
            return null;
        }
        try {
            return ww.getActivePage().openEditor((IEditorInput)input, editorId, true);
        }
        catch (PartInitException e) {
            EDTUIPlugin.log(e);
            return null;
        }
    }

    public static IEditorPart openSourceFromEglarInBinaryEditor(ClassFile classFile, IProject proj, String eglarFilePath, String irFullQualifiedFile, String editorId) {
        IWorkbenchWindow ww = EDTUIPlugin.getActiveWorkbenchWindow();
        BinaryEditorInput input = EditorUtility.getClassfileSourceEditor(proj, eglarFilePath, irFullQualifiedFile, editorId, classFile);
        if (input == null) {
            return null;
        }
        try {
            return ww.getActivePage().openEditor((IEditorInput)input, editorId, true);
        }
        catch (PartInitException e) {
            EDTUIPlugin.log(e);
            return null;
        }
    }
}

