/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IDebugEventFilter;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.edt.debug.core.EDTDebugCorePlugin;
import org.eclipse.edt.debug.core.IEGLDebugTarget;
import org.eclipse.edt.debug.core.PreferenceUtil;
import org.eclipse.edt.debug.core.breakpoints.EGLLineBreakpoint;
import org.eclipse.edt.debug.core.java.IEGLJavaDebugTarget;
import org.eclipse.edt.debug.core.java.IEGLJavaThread;
import org.eclipse.edt.debug.core.java.SMAPFileCache;
import org.eclipse.edt.debug.core.java.SMAPLineInfo;
import org.eclipse.edt.debug.core.java.SMAPUtil;
import org.eclipse.edt.debug.core.java.filters.ITypeFilter;
import org.eclipse.edt.debug.core.java.filters.TypeFilterUtil;
import org.eclipse.edt.debug.internal.core.java.EGLJavaDebugElement;
import org.eclipse.edt.debug.internal.core.java.EGLJavaThread;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageDeclaration;
import org.eclipse.edt.javart.util.JavaAliaser;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.breakpoints.ValidBreakpointLocationLocator;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;

public class EGLJavaDebugTarget
extends EGLJavaDebugElement
implements IEGLJavaDebugTarget,
IDebugEventFilter,
IBreakpointManagerListener,
IEclipsePreferences.IPreferenceChangeListener,
IResourceChangeListener {
    private final IJavaDebugTarget javaTarget;
    private final Map<IJavaThread, EGLJavaThread> threads;
    private final List<IEGLJavaThread> eglThreads;
    private final Map<EGLLineBreakpoint, IJavaBreakpoint> breakpoints;
    private boolean filterRuntimes;
    private final boolean supportsSourceDebugExtension;
    private final SMAPFileCache smapFileCache;
    private Map<String, SMAPLineInfo> smapLineCache;
    private static Integer JLS_VERSION;

    public EGLJavaDebugTarget(IJavaDebugTarget target) {
        super(null);
        this.javaTarget = target;
        this.threads = new HashMap<IJavaThread, EGLJavaThread>();
        this.eglThreads = new ArrayList<IEGLJavaThread>();
        this.breakpoints = new HashMap<EGLLineBreakpoint, IJavaBreakpoint>();
        this.smapFileCache = new SMAPFileCache();
        this.initFilters();
        boolean bl = this.supportsSourceDebugExtension = target instanceof JDIDebugTarget ? ((JDIDebugTarget)target).getVM().canGetSourceDebugExtension() : true;
        if (!this.supportsSourceDebugExtension) {
            this.smapLineCache = new HashMap<String, SMAPLineInfo>();
        }
        try {
            IThread[] threads = this.javaTarget.getThreads();
            int i = 0;
            while (i < threads.length) {
                if (threads[i] instanceof IJavaThread) {
                    this.getThread((IJavaThread)threads[i]);
                }
                ++i;
            }
        }
        catch (DebugException e) {
            EDTDebugCorePlugin.log(e);
        }
        PreferenceUtil.addPreferenceChangeListener(this);
        DebugPlugin.getDefault().addDebugEventFilter((IDebugEventFilter)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.initializeBreakpoints();
    }

    protected void initFilters() {
        this.filterRuntimes = PreferenceUtil.getBoolean("org.eclipse.edt.debug.core.typeFiltersEnabled", true);
        if (this.filterRuntimes) {
            ITypeFilter[] iTypeFilterArray = TypeFilterUtil.INSTANCE.getActiveFilters();
            int n = iTypeFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeFilter filter = iTypeFilterArray[n2];
                filter.initialize(this);
                ++n2;
            }
        }
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.javaTarget.getLaunch();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IDebugTarget.class || adapter == EGLJavaDebugTarget.class || adapter == IEGLDebugTarget.class || adapter == IEGLJavaDebugTarget.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public SMAPFileCache getSMAPFileCache() {
        return this.smapFileCache;
    }

    public Map<String, SMAPLineInfo> getSMAPLineCache() {
        return this.smapLineCache;
    }

    public boolean filterRuntimes() {
        return this.filterRuntimes;
    }

    public boolean canTerminate() {
        return this.javaTarget.canTerminate();
    }

    public boolean isTerminated() {
        return this.javaTarget.isTerminated();
    }

    public void terminate() throws DebugException {
        this.javaTarget.terminate();
    }

    public boolean canResume() {
        return this.javaTarget.canResume();
    }

    public boolean canSuspend() {
        return this.javaTarget.canSuspend();
    }

    public boolean isSuspended() {
        return this.javaTarget.isSuspended();
    }

    public void resume() throws DebugException {
        this.javaTarget.resume();
    }

    public void suspend() throws DebugException {
        this.javaTarget.suspend();
    }

    private void initializeBreakpoints() {
        IBreakpoint[] bps;
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        manager.addBreakpointListener((IBreakpointListener)this);
        manager.addBreakpointManagerListener((IBreakpointManagerListener)this);
        IBreakpoint[] iBreakpointArray = bps = manager.getBreakpoints("org.eclipse.edt.debug.ui.presentation.java");
        int n = bps.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp = iBreakpointArray[n2];
            if (bp instanceof EGLLineBreakpoint) {
                this.breakpointAdded(bp);
            }
            ++n2;
        }
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return this.javaTarget.supportsBreakpoint(breakpoint) || breakpoint instanceof EGLLineBreakpoint;
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (breakpoint instanceof EGLLineBreakpoint) {
            EGLLineBreakpoint eglBP = (EGLLineBreakpoint)breakpoint;
            if (!this.breakpoints.containsKey((Object)eglBP)) {
                try {
                    IJavaBreakpoint javaBP = this.createStratumBreakpoint(eglBP);
                    if (javaBP != null) {
                        javaBP.setEnabled(eglBP.isEnabled());
                        this.breakpoints.put(eglBP, javaBP);
                        if (DebugPlugin.getDefault().getBreakpointManager().isEnabled() || !eglBP.isRegistered()) {
                            this.javaTarget.breakpointAdded((IBreakpoint)javaBP);
                        }
                    }
                }
                catch (CoreException e) {
                    EDTDebugCorePlugin.log(e);
                }
            }
        } else if (this.notifyJavaTarget(breakpoint)) {
            this.javaTarget.breakpointAdded(breakpoint);
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (breakpoint instanceof EGLLineBreakpoint) {
            IJavaBreakpoint javaBP = this.breakpoints.remove(breakpoint);
            if (javaBP != null) {
                this.javaTarget.breakpointRemoved((IBreakpoint)javaBP, delta);
                try {
                    javaBP.delete();
                }
                catch (CoreException e) {
                    EDTDebugCorePlugin.log(e);
                }
            }
            try {
                if (!breakpoint.isRegistered()) {
                    breakpoint.delete();
                }
            }
            catch (CoreException e) {
                EDTDebugCorePlugin.log(e);
            }
        } else if (this.notifyJavaTarget(breakpoint)) {
            this.javaTarget.breakpointRemoved(breakpoint, delta);
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        block12: {
            if (breakpoint instanceof EGLLineBreakpoint) {
                EGLLineBreakpoint eglBP = (EGLLineBreakpoint)breakpoint;
                IJavaBreakpoint javaBP = this.breakpoints.get((Object)eglBP);
                if (javaBP != null) {
                    IMarker marker = eglBP.getMarker();
                    if (this.lineNumberChanged(marker, delta)) {
                        try {
                            javaBP.delete();
                            javaBP = this.createStratumBreakpoint(eglBP);
                            if (javaBP != null) {
                                javaBP.setEnabled(breakpoint.isEnabled());
                                this.breakpoints.put(eglBP, javaBP);
                                this.javaTarget.breakpointAdded((IBreakpoint)javaBP);
                                break block12;
                            }
                            this.breakpoints.remove((Object)eglBP);
                        }
                        catch (CoreException e) {
                            EDTDebugCorePlugin.log(e);
                        }
                    } else if (this.enablementChanged(marker, delta)) {
                        try {
                            javaBP.setEnabled(eglBP.isEnabled());
                        }
                        catch (CoreException e) {
                            EDTDebugCorePlugin.log(e);
                        }
                    }
                }
            } else if (this.notifyJavaTarget(breakpoint)) {
                this.javaTarget.breakpointChanged(breakpoint, delta);
            }
        }
    }

    private boolean notifyJavaTarget(IBreakpoint bp) {
        try {
            return !bp.isRegistered() || bp instanceof IJavaLineBreakpoint && BreakpointUtils.isRunToLineBreakpoint((IJavaLineBreakpoint)((IJavaLineBreakpoint)bp));
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        for (Map.Entry<EGLLineBreakpoint, IJavaBreakpoint> entry : this.breakpoints.entrySet()) {
            if (enabled) {
                this.javaTarget.breakpointAdded((IBreakpoint)entry.getValue());
                continue;
            }
            try {
                if (!entry.getKey().isRegistered()) continue;
                this.javaTarget.breakpointRemoved((IBreakpoint)entry.getValue(), null);
            }
            catch (CoreException e) {
                EDTDebugCorePlugin.log(e);
            }
        }
    }

    public EGLLineBreakpoint findCorrespondingBreakpoint(IJavaLineBreakpoint breakpoint) {
        for (Map.Entry<EGLLineBreakpoint, IJavaBreakpoint> entry : this.breakpoints.entrySet()) {
            if (entry.getValue() != breakpoint) continue;
            return entry.getKey();
        }
        return null;
    }

    private boolean lineNumberChanged(IMarker marker, IMarkerDelta delta) {
        if (delta != null) {
            return delta.getAttribute("lineNumber", -1) != marker.getAttribute("lineNumber", -1);
        }
        return true;
    }

    private boolean enablementChanged(IMarker marker, IMarkerDelta delta) {
        if (delta != null) {
            return delta.getAttribute("org.eclipse.debug.core.enabled", true) ^ marker.getAttribute("org.eclipse.debug.core.enabled", true);
        }
        return true;
    }

    private IJavaBreakpoint createStratumBreakpoint(EGLLineBreakpoint bp) throws CoreException {
        IMarker marker = bp.getMarker();
        if (marker != null && marker.exists()) {
            IResource resource = null;
            if (bp.isRunToLine()) {
                String path = marker.getAttribute("org.eclipse.edt.debug.core.runToLinePath", null);
                if (path != null) {
                    resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                }
            } else {
                resource = marker.getResource();
            }
            if (resource == null) {
                return null;
            }
            String qualifiedName = this.getGeneratedClassName(resource);
            if (qualifiedName != null) {
                List<Integer> javaLines;
                int hitcount = 0;
                HashMap attributes = null;
                if (bp.isRunToLine()) {
                    hitcount = 1;
                    attributes = new HashMap(2);
                    BreakpointUtils.addRunToLineAttributes(attributes);
                }
                if (this.supportsSourceDebugExtension) {
                    return JDIDebugModel.createStratumBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), (String)"egl", (String)resource.getName(), null, (String)qualifiedName, (int)bp.getLineNumber(), (int)bp.getCharStart(), (int)bp.getCharEnd(), (int)hitcount, (boolean)false, attributes);
                }
                SMAPLineInfo lineInfo = SMAPUtil.getSMAPLineInfo(SMAPUtil.getSMAP((IEGLJavaDebugTarget)this, qualifiedName), this.smapLineCache);
                if (lineInfo != null && (javaLines = lineInfo.getJavaLines(bp.getLineNumber())) != null && javaLines.size() > 0) {
                    IFile javaFile;
                    IFile iFile = javaFile = javaLines.size() == 1 ? null : this.findJavaFile(qualifiedName);
                    if (javaFile == null) {
                        return JDIDebugModel.createLineBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), (String)qualifiedName, (int)javaLines.get(0), (int)-1, (int)-1, (int)hitcount, (boolean)false, null);
                    }
                    for (int javaLine : javaLines) {
                        IJavaLineBreakpoint javaBP = JDIDebugModel.createLineBreakpoint((IResource)javaFile, (String)qualifiedName, (int)javaLine, (int)-1, (int)-1, (int)hitcount, (boolean)false, null);
                        if (!this.verifyLineBreakpoint(javaFile, javaBP)) continue;
                        int line = javaBP.getLineNumber();
                        javaBP.delete();
                        return JDIDebugModel.createLineBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), (String)qualifiedName, (int)line, (int)-1, (int)-1, (int)hitcount, (boolean)false, null);
                    }
                }
            }
        }
        return null;
    }

    protected IFile findJavaFile(String className) {
        ISourceLocator locator = this.getLaunch().getSourceLocator();
        if (locator instanceof ISourceLookupDirector) {
            Object src;
            IResource resource = null;
            int inner = className.indexOf(36);
            if (inner != -1) {
                className = className.substring(0, inner);
            }
            if ((src = ((ISourceLookupDirector)locator).getSourceElement((Object)(String.valueOf(className.replace('.', '/')) + ".java"))) instanceof IJavaElement) {
                resource = ((IJavaElement)src).getResource();
            } else if (src instanceof IStorage) {
                resource = ResourcesPlugin.getWorkspace().getRoot().findMember(((IStorage)src).getFullPath());
            }
            if (resource != null && resource.getType() == 1 && resource.exists()) {
                return (IFile)resource;
            }
        }
        return null;
    }

    protected boolean verifyLineBreakpoint(IFile file, IJavaLineBreakpoint bp) {
        ICompilationUnit cunit = JavaCore.createCompilationUnitFrom((IFile)file);
        if (cunit != null) {
            if (JLS_VERSION == null) {
                try {
                    JLS_VERSION = (Integer)AST.class.getField("JLS4").get(null);
                }
                catch (Exception exception) {
                    JLS_VERSION = 3;
                }
            }
            ASTParser parser = ASTParser.newParser((int)JLS_VERSION);
            parser.setSource(cunit);
            parser.setResolveBindings(true);
            CompilationUnit unit = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
            if (unit != null) {
                try {
                    int line = bp.getLineNumber();
                    ValidBreakpointLocationLocator locator = new ValidBreakpointLocationLocator(unit, line, true, true);
                    unit.accept((ASTVisitor)locator);
                    if (locator.getLocationType() == 1) {
                        if (locator.getLineLocation() != line) {
                            bp.getMarker().setAttribute("lineNumber", locator.getLineLocation());
                        }
                        return true;
                    }
                    return false;
                }
                catch (CoreException coreException) {}
            }
        }
        return true;
    }

    private String getGeneratedClassName(IResource resource) {
        IEGLFile eglFile = (IEGLFile)EGLCore.create((IResource)resource);
        if (eglFile != null && eglFile.exists()) {
            try {
                String name;
                int idx;
                StringBuilder buf = new StringBuilder(50);
                IPackageDeclaration[] pkg = eglFile.getPackageDeclarations();
                if (pkg != null && pkg.length > 0) {
                    buf.append(JavaAliaser.packageNameAlias((String)pkg[0].getElementName()));
                    buf.append('.');
                }
                if ((idx = (name = eglFile.getElementName()).lastIndexOf(46)) != -1) {
                    name = name.substring(0, idx);
                }
                buf.append(JavaAliaser.getAlias((String)name));
                return buf.toString();
            }
            catch (EGLModelException eGLModelException) {}
        }
        return null;
    }

    public boolean canDisconnect() {
        return this.javaTarget.canDisconnect();
    }

    public void disconnect() throws DebugException {
        this.javaTarget.disconnect();
    }

    public boolean isDisconnected() {
        return this.javaTarget.isDisconnected();
    }

    public boolean supportsStorageRetrieval() {
        return this.javaTarget.supportsStorageRetrieval();
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return this.javaTarget.getMemoryBlock(startAddress, length);
    }

    public IProcess getProcess() {
        return this.javaTarget.getProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IThread[] getThreads() throws DebugException {
        List<IEGLJavaThread> list = this.eglThreads;
        synchronized (list) {
            return this.eglThreads.toArray(new EGLJavaThread[this.eglThreads.size()]);
        }
    }

    public boolean hasThreads() throws DebugException {
        return this.eglThreads.size() > 0;
    }

    public String getName() throws DebugException {
        return this.javaTarget.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EGLJavaThread getThread(IJavaThread javaThread) {
        EGLJavaThread eglThread;
        Object object = this.threads;
        synchronized (object) {
            eglThread = this.threads.get(javaThread);
        }
        if (eglThread == null) {
            eglThread = new EGLJavaThread(this, javaThread);
            object = this.threads;
            synchronized (object) {
                this.threads.put(javaThread, eglThread);
            }
            object = this.eglThreads;
            synchronized (object) {
                this.eglThreads.add(eglThread);
            }
        }
        return eglThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EGLJavaThread removeThread(IJavaThread javaThread) {
        EGLJavaThread eglThread;
        Object object = this.threads;
        synchronized (object) {
            eglThread = this.threads.remove(javaThread);
        }
        if (eglThread != null) {
            object = this.eglThreads;
            synchronized (object) {
                this.eglThreads.remove(eglThread);
            }
            return eglThread;
        }
        return null;
    }

    public DebugEvent[] filterDebugEvents(DebugEvent[] events) {
        if (events == null || events.length < 1) {
            return events;
        }
        Object src = events[0].getSource();
        if (!(src instanceof IDebugElement)) {
            return events;
        }
        if (((IDebugElement)src).getDebugTarget() != this.javaTarget) {
            return events;
        }
        ArrayList unfiltered = new ArrayList(events.length);
        HashMap<Object, List<DebugEvent>> groupedEvents = this.groupBySource(events);
        for (Map.Entry entry : groupedEvents.entrySet()) {
            EGLJavaThread eglThread;
            IJavaThread javaThread;
            src = entry.getKey();
            List srcEvents = (List)entry.getValue();
            if (src instanceof IDebugTarget) {
                this.handleDebugEvents(srcEvents.toArray(new DebugEvent[srcEvents.size()]));
                continue;
            }
            if (src instanceof IThread) {
                javaThread = (IJavaThread)((IThread)src).getAdapter(IJavaThread.class);
                if (javaThread != null) {
                    eglThread = this.getThread(javaThread);
                    eglThread.handleDebugEvents(srcEvents.toArray(new DebugEvent[srcEvents.size()]));
                    continue;
                }
                unfiltered.addAll(srcEvents);
                continue;
            }
            if (src instanceof IStackFrame) {
                javaThread = (IJavaThread)((IStackFrame)src).getThread().getAdapter(IJavaThread.class);
                if (javaThread != null) {
                    eglThread = this.getThread(javaThread);
                    eglThread.handleDebugEvents(srcEvents.toArray(new DebugEvent[srcEvents.size()]));
                    continue;
                }
                unfiltered.addAll(srcEvents);
                continue;
            }
            unfiltered.addAll(srcEvents);
        }
        return unfiltered.toArray(new DebugEvent[unfiltered.size()]);
    }

    @Override
    public void handleDebugEvents(DebugEvent[] events) {
        if (events == null || events.length == 0) {
            return;
        }
        if (events[0].getSource() == this.javaTarget) {
            if (events[0].getKind() == 8) {
                this.cleanup();
            }
            super.handleDebugEvents(events);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        plugin.getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)this);
        plugin.removeDebugEventFilter((IDebugEventFilter)this);
        PreferenceUtil.removePreferenceChangeListener(this);
        for (IJavaBreakpoint object : this.breakpoints.values()) {
            try {
                object.delete();
            }
            catch (CoreException coreException) {}
        }
        for (EGLLineBreakpoint eGLLineBreakpoint : this.breakpoints.keySet()) {
            try {
                if (eGLLineBreakpoint.isPersisted()) continue;
                eGLLineBreakpoint.delete();
            }
            catch (CoreException coreException) {}
        }
        this.breakpoints.clear();
        ITypeFilter[] iTypeFilterArray = TypeFilterUtil.INSTANCE.getAllFilters();
        int n = iTypeFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeFilter iTypeFilter = iTypeFilterArray[n2];
            iTypeFilter.dispose(this);
            ++n2;
        }
        this.smapFileCache.clear();
        if (this.smapLineCache != null) {
            this.smapLineCache = null;
        }
        Map<IJavaThread, EGLJavaThread> map = this.threads;
        synchronized (map) {
            this.threads.clear();
        }
        List<IEGLJavaThread> list = this.eglThreads;
        synchronized (list) {
            this.eglThreads.clear();
        }
    }

    @Override
    public IJavaDebugTarget getJavaDebugTarget() {
        return this.javaTarget;
    }

    @Override
    public Object getJavaDebugElement() {
        return this.getJavaDebugTarget();
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        boolean refreshFrames = false;
        String key = event.getKey();
        if ("org.eclipse.edt.debug.core.typeFiltersEnabled".equals(key)) {
            this.initFilters();
            refreshFrames = true;
        } else if ("org.eclipse.edt.debug.core.typeFilterEnablement".equals(key)) {
            refreshFrames = true;
        }
        if (refreshFrames) {
            this.refreshAllFrames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAllFrames() {
        List<IEGLJavaThread> list = this.eglThreads;
        synchronized (list) {
            for (IEGLJavaThread thread : this.eglThreads) {
                try {
                    if (!thread.hasStackFrames() || !(thread instanceof EGLJavaThread)) continue;
                    ((EGLJavaThread)thread).disposeStackFrames();
                    this.fireEvent(new DebugEvent((Object)thread, 16, 512));
                }
                catch (DebugException debugException) {}
            }
        }
    }

    public boolean supportsStepFilters() {
        return this.javaTarget.supportsStepFilters();
    }

    public boolean isStepFiltersEnabled() {
        return this.javaTarget.isStepFiltersEnabled();
    }

    public void setStepFiltersEnabled(boolean enabled) {
        this.javaTarget.setStepFiltersEnabled(enabled);
    }

    @Override
    public boolean supportsSourceDebugExtension() {
        return this.supportsSourceDebugExtension;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getDelta() != null) {
            try {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        String removed;
                        if (delta == null) {
                            return false;
                        }
                        if ((delta.getKind() == 2 || delta.getKind() == 4 && ((delta.getFlags() & 0x100) != 0 || (delta.getFlags() & 0x100000) != 0) && "eglsmap".equals(delta.getFullPath().getFileExtension())) && (removed = EGLJavaDebugTarget.this.smapFileCache.removeEntry(delta.getFullPath().toString(), null)) != null && EGLJavaDebugTarget.this.smapLineCache != null) {
                            EGLJavaDebugTarget.this.smapLineCache.remove(removed);
                        }
                        return true;
                    }
                });
            }
            catch (CoreException ce) {
                EDTDebugCorePlugin.log(ce);
            }
        }
    }
}

