/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.rui.internal.nls.ILocalesListViewer;
import org.eclipse.edt.ide.rui.internal.nls.Locale;
import org.eclipse.edt.ide.rui.internal.nls.LocaleUtility;
import org.eclipse.edt.ide.rui.internal.nls.LocalesList;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvHelp;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.edt.ide.rui.visualeditor.internal.preferences.IEvPreferencePage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class EvPreferencePageLanguage
extends Composite
implements IEvPreferencePage,
ILocalesListViewer {
    protected Combo _handlerLocaleCombo = null;
    protected LocalesList _localesList = LocalesList.getLocalesList();
    protected Combo _runtimeMessageLocaleCombo = null;
    IPreferenceStore _baseEGLStore = EDTCoreIDEPlugin.getPlugin().getPreferenceStore();
    HashMap _handlerLocaleDisplayToCode = new HashMap();

    public EvPreferencePageLanguage(Composite parent, int style) {
        super(parent, style);
        LocalesList.getLocalesList().addChangeListener((ILocalesListViewer)this);
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        this.createRuntimeMessagesNLSGroup(parent);
        this.createHandlerNLSGoup(parent);
        Dialog.applyDialogFont((Control)parent);
        EvHelp.setHelp((Control)this, EvHelp.PREFERENCES_LANGUAGE);
    }

    protected void createHandlerNLSGoup(Composite parent) {
        Group runtimeGroup = new Group((Composite)this, 0);
        runtimeGroup.setText(Messages.NL_Rich_UI_handler_locale);
        GridData layoutData = new GridData(768);
        runtimeGroup.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout();
        runtimeGroup.setLayout((Layout)layout);
        this._handlerLocaleCombo = new Combo((Composite)runtimeGroup, 8);
        layoutData = new GridData(768);
        this._handlerLocaleCombo.setLayoutData((Object)layoutData);
        this.populateCombo();
        String localeCode = this._baseEGLStore.getString("org.eclipse.edt.ide.rui.HandlerLocale");
        if (localeCode == null || localeCode.length() == 0) {
            localeCode = LocaleUtility.getDefaultHandlerLocale().getCode();
        }
        String displayString = "";
        Iterator iterator = this._localesList.getLocales().iterator();
        while (iterator.hasNext() && displayString.equals("")) {
            Locale locale = (Locale)iterator.next();
            if (!locale.getCode().equals(localeCode)) continue;
            displayString = this.buildHandlerLocaleDisplayString(locale);
        }
        this._handlerLocaleCombo.setText(displayString);
    }

    private void populateCombo() {
        ArrayList<String> descriptions = new ArrayList<String>();
        for (Locale locale : this._localesList.getLocales()) {
            String displayString = this.buildHandlerLocaleDisplayString(locale);
            descriptions.add(displayString);
            this._handlerLocaleDisplayToCode.put(displayString, locale.getCode());
        }
        Object[] listArray = descriptions.toArray(new String[descriptions.size()]);
        Arrays.sort(listArray);
        this._handlerLocaleCombo.setItems((String[])listArray);
    }

    private String buildHandlerLocaleDisplayString(Locale locale) {
        return String.valueOf(locale.getDescription()) + " (" + locale.getCode() + ")";
    }

    protected void createRuntimeMessagesNLSGroup(Composite parent) {
        Group runtimeGroup = new Group((Composite)this, 0);
        runtimeGroup.setText(Messages.NL_Runtime_messages_locale);
        GridData layoutData = new GridData(768);
        runtimeGroup.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout();
        runtimeGroup.setLayout((Layout)layout);
        this._runtimeMessageLocaleCombo = new Combo((Composite)runtimeGroup, 8);
        layoutData = new GridData(768);
        this._runtimeMessageLocaleCombo.setLayoutData((Object)layoutData);
        this._runtimeMessageLocaleCombo.setItems(LocaleUtility.getRuntimeDescriptionsArray());
        String runtimeLocale = this._baseEGLStore.getString("org.eclipse.edt.ide.rui.RuntimeLocale");
        if (runtimeLocale == null || runtimeLocale.length() == 0) {
            runtimeLocale = LocaleUtility.getDefaultRuntimeLocale().getCode();
        }
        this._runtimeMessageLocaleCombo.setText(LocaleUtility.getRuntimeDescriptionForCode((String)runtimeLocale));
    }

    @Override
    public String getHelpID() {
        return EvHelp.PREFERENCES_LANGUAGE;
    }

    @Override
    public void performDefaults() {
        String defaultRuntimeLocaleCode = LocaleUtility.getDefaultRuntimeLocale().getCode();
        String defaultRuntimeLocaleDescription = LocaleUtility.getRuntimeDescriptionForCode((String)defaultRuntimeLocaleCode);
        this._runtimeMessageLocaleCombo.setText(defaultRuntimeLocaleDescription);
        String defaultHandlerLocaleCode = LocaleUtility.getDefaultHandlerLocale().getCode();
        String defaultHandlerLocaleDescription = LocaleUtility.getHandlerDescriptionForCode((String)defaultHandlerLocaleCode);
        Locale dummy = new Locale(defaultHandlerLocaleCode, defaultHandlerLocaleDescription, "");
        this._handlerLocaleCombo.setText(this.buildHandlerLocaleDisplayString(dummy));
    }

    public void performOK() {
        String displayString;
        String code;
        String runtimeLocaleCode = LocaleUtility.getRuntimeCodeForDescription((String)this._runtimeMessageLocaleCombo.getText());
        if (runtimeLocaleCode != null) {
            this._baseEGLStore.setValue("org.eclipse.edt.ide.rui.RuntimeLocale", runtimeLocaleCode);
        }
        if ((code = (String)this._handlerLocaleDisplayToCode.get(displayString = this._handlerLocaleCombo.getText())) == null) {
            code = "";
        }
        this._baseEGLStore.setValue("org.eclipse.edt.ide.rui.HandlerLocale", code);
    }

    public void dispose() {
        LocalesList.getLocalesList().removeChangeListener((ILocalesListViewer)this);
        super.dispose();
    }

    public void addLocale(Locale locale) {
        this.refreshHandlerLocaleCombo();
    }

    private void refreshHandlerLocaleCombo() {
        if (!this._handlerLocaleCombo.isDisposed()) {
            String currentSelection = this._handlerLocaleCombo.getText();
            this.populateCombo();
            this._handlerLocaleCombo.setText(currentSelection);
        }
    }

    public void removeLocale(Locale locale) {
        this.refreshHandlerLocaleCombo();
    }

    public void updateLocale(Locale locale) {
        this.refreshHandlerLocaleCombo();
    }

    public void clear() {
    }
}

