/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.util;

import eglx.java.JavaObjectException;
import eglx.lang.AnyException;
import eglx.lang.InvalidIndexException;
import eglx.lang.NullValueException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.edt.javart.ControlFlow;
import org.eclipse.edt.javart.FatalProblem;
import org.eclipse.edt.javart.RunUnit;
import org.eclipse.edt.javart.Runtime;
import org.eclipse.edt.runtime.java.eglx.lang.EAny;

public class JavartUtil {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static GregorianCalendar gregorianCalendar;
    private static ExecutorService threadPool;

    private JavartUtil() {
    }

    public static GregorianCalendar getCalendar() {
        if (gregorianCalendar == null) {
            gregorianCalendar = new GregorianCalendar();
        }
        return gregorianCalendar;
    }

    public static String getCurrentTime() {
        GregorianCalendar calendar = JavartUtil.getCalendar();
        calendar.setTime(new Date());
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        StringBuilder time = new StringBuilder(8);
        if (hour < 10) {
            time.append('0');
        }
        time.append(hour);
        time.append(':');
        if (minute < 10) {
            time.append('0');
        }
        time.append(minute);
        time.append(':');
        if (second < 10) {
            time.append('0');
        }
        time.append(second);
        return time.toString();
    }

    public static String getEglType(Object object) {
        if (object instanceof EAny) {
            return ((EAny)object).ezeTypeSignature();
        }
        return object.getClass().getName();
    }

    public static String removePackageName(String fullName) {
        int index = fullName.lastIndexOf(46);
        if (index == -1) {
            return fullName;
        }
        return fullName.substring(index + 1);
    }

    public static void checkSubstringIndices(int startIndex, int endIndex, int maxlen) throws AnyException {
        if (startIndex < 1 || startIndex > maxlen) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = startIndex;
            throw ex.fillInMessage("EGL0012E", startIndex, endIndex);
        }
        if (endIndex < startIndex || endIndex < 1 || endIndex > maxlen) {
            InvalidIndexException ex = new InvalidIndexException();
            ex.index = endIndex;
            throw ex.fillInMessage("EGL0012E", startIndex, endIndex);
        }
    }

    public static String errorMessage(String id) {
        RunUnit ru = Runtime.getRunUnit();
        String message = ru.getLocalizedText().getMessage(id);
        if (ru.getTrace().traceIsOn()) {
            ru.getTrace().put(message);
        }
        return message;
    }

    public static String errorMessage(String id, Object ... inserts) {
        RunUnit ru = Runtime.getRunUnit();
        String message = ru.getLocalizedText().getMessage(id, inserts);
        if (ru.getTrace().traceIsOn()) {
            ru.getTrace().put(message);
        }
        return message;
    }

    public static void checkHandleable(Exception caught) throws RuntimeException {
        if (caught instanceof FatalProblem || caught instanceof ControlFlow) {
            throw (RuntimeException)caught;
        }
    }

    public static <T> T checkNullable(T o) throws NullValueException {
        if (o == null) {
            NullValueException nvx = new NullValueException();
            throw nvx.fillInMessage("EGL0016E", new Object[0]);
        }
        return o;
    }

    public static int checkIndex(int index, List<?> list) throws InvalidIndexException {
        if (list == null) {
            NullValueException nvx = new NullValueException();
            throw nvx.fillInMessage("EGL0016E", new Object[0]);
        }
        if (index < 0 || index >= list.size()) {
            InvalidIndexException iix = new InvalidIndexException();
            iix.index = index;
            throw iix.fillInMessage("EGL0010E", index, list.size());
        }
        return index;
    }

    public static AnyException makeEglException(Throwable ex) {
        if (ex instanceof AnyException) {
            return (AnyException)ex;
        }
        String msg = ex.getMessage();
        String className = ex.getClass().getName();
        if (msg == null || msg.length() == 0) {
            msg = className;
        }
        if (ex instanceof NullPointerException) {
            NullValueException nvx = new NullValueException();
            nvx.initCause(ex);
            return nvx.fillInMessage("EGL0016E", msg);
        }
        JavaObjectException jox = new JavaObjectException();
        jox.exceptionType = className;
        jox.initCause(ex);
        return jox.fillInMessage("EGL0008E", msg);
    }

    public static boolean isJavaObjectException(Exception ex) {
        return ex instanceof JavaObjectException || !(ex instanceof AnyException) && !(ex instanceof NullPointerException);
    }

    public static synchronized ExecutorService getThreadPool() {
        if (threadPool == null) {
            threadPool = Executors.newCachedThreadPool(new EGLThreadFactory());
        }
        return threadPool;
    }

    private static class EGLThreadFactory
    implements ThreadFactory {
        private EGLThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    }
}

