/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.eglx.lang;

import eglx.lang.AnyException;
import eglx.lang.TypeCastException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.util.DateTimeUtil;
import org.eclipse.edt.javart.util.TimestampIntervalMask;
import org.eclipse.edt.runtime.java.eglx.lang.EAny;
import org.eclipse.edt.runtime.java.eglx.lang.EString;
import org.eclipse.edt.runtime.java.eglx.lang.ETimestamp;

public class EDate
extends AnyBoxedObject<Calendar> {
    private static final long serialVersionUID = 10L;

    public EDate() {
        this(DateTimeUtil.getNewCalendar());
    }

    public EDate(Calendar value) {
        super(value);
    }

    public static EDate ezeBox(Calendar value) {
        Calendar clone = null;
        if (value != null) {
            clone = (Calendar)value.clone();
        }
        return new EDate(clone);
    }

    public static Object ezeCast(Object value, Object[] constraints) throws AnyException {
        Integer[] args = new Integer[constraints.length];
        System.arraycopy(constraints, 0, args, 0, args.length);
        return EDate.ezeCast(value, args);
    }

    public static Calendar ezeCast(Object value, Integer ... args) throws AnyException {
        return (Calendar)EAny.ezeCast(value, "asDate", EDate.class, null, null);
    }

    public static boolean ezeIsa(Object value, Integer ... args) {
        return value instanceof EDate || value instanceof Calendar;
    }

    public String toString() {
        return EString.asString(EString.asStringDate((Calendar)this.object), new Integer[0]);
    }

    public static Calendar defaultValue() {
        long now = System.currentTimeMillis();
        Calendar cal = DateTimeUtil.getBaseCalendar();
        cal.setTimeInMillis(now);
        return cal;
    }

    public static Calendar asDate(EString date) throws TypeCastException {
        return EDate.asDate((String)date.ezeUnbox());
    }

    public static Calendar asDate(String date) throws TypeCastException {
        return EDate.convert(date);
    }

    public static Calendar asDate(EDate date) throws AnyException {
        if (date == null) {
            return null;
        }
        return EDate.asDate((Calendar)date.ezeUnbox());
    }

    public static Calendar asDate(ETimestamp date) throws AnyException {
        if (date == null) {
            return null;
        }
        return EDate.asDate((Calendar)date.ezeUnbox(), date.getStartCode(), date.getEndCode());
    }

    public static Calendar asDate(GregorianCalendar date) throws AnyException {
        if (date == null) {
            return null;
        }
        return EDate.asDate((Calendar)date);
    }

    public static Calendar asDate(Calendar date) throws AnyException {
        if (date == null) {
            return null;
        }
        return EDate.asDate(date, 0, 2);
    }

    public static Calendar asDate(Calendar original, int startCode, int endCode) {
        if (original == null) {
            return null;
        }
        if (startCode > 0 || endCode < 2) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "timestamp";
            tcx.castToName = "date";
            throw tcx.fillInMessage("EGL0007E", original, tcx.actualTypeName, tcx.castToName);
        }
        Calendar cal = (Calendar)original.clone();
        Calendar result = DateTimeUtil.getBaseCalendar();
        result.set(1, cal.get(1));
        result.set(2, cal.get(2));
        result.set(5, cal.get(5));
        try {
            result.setTimeInMillis(result.getTimeInMillis());
        }
        catch (Exception ex) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "timestamp";
            tcx.castToName = "date";
            tcx.initCause(ex);
            throw tcx.fillInMessage("EGL0007E", original, tcx.actualTypeName, tcx.castToName);
        }
        return result;
    }

    public static Calendar convert(String date) {
        int years;
        int days;
        int months;
        boolean invalidSeparator;
        block13: {
            int i;
            int length;
            block18: {
                char ch;
                block16: {
                    block17: {
                        block14: {
                            block15: {
                                if (date == null) {
                                    return null;
                                }
                                length = date.length();
                                if (length < 5 || length > 10) {
                                    TypeCastException tcx = new TypeCastException();
                                    tcx.actualTypeName = "string";
                                    tcx.castToName = "date";
                                    throw tcx.fillInMessage("EGL0007E", date, tcx.actualTypeName, tcx.castToName);
                                }
                                invalidSeparator = false;
                                months = -1;
                                days = -1;
                                years = -1;
                                if (length <= 0) break block13;
                                i = 0;
                                if ((ch = date.charAt(i++)) < '0' || ch > '9') break block13;
                                if (i > length) break block14;
                                months = ch - 48;
                                if (i >= length) break block13;
                                if ('0' > (ch = date.charAt(i++)) || ch > '9') break block15;
                                months = months * 10 + ch - 48;
                                if (i >= length) break block13;
                                ch = date.charAt(i++);
                            }
                            if (i >= length || ch >= '0' && ch <= '9') {
                                invalidSeparator = true;
                            }
                        }
                        while (i < length && ('0' > ch || ch > '9')) {
                            if ((ch = date.charAt(i++)) >= '0' && ch <= '9') continue;
                            invalidSeparator = true;
                        }
                        if (i > length) break block16;
                        days = ch - 48;
                        if (i >= length) break block13;
                        if ('0' > (ch = date.charAt(i++)) || ch > '9') break block17;
                        days = days * 10 + ch - 48;
                        if (i >= length) break block13;
                        ch = date.charAt(i++);
                    }
                    if (i >= length || ch >= '0' && ch <= '9') {
                        invalidSeparator = true;
                    }
                }
                while (i < length && ('0' > ch || ch > '9')) {
                    if ((ch = date.charAt(i++)) >= '0' && ch <= '9') continue;
                    invalidSeparator = true;
                }
                if (i > length) break block13;
                years = ch - 48;
                if (i >= length) break block13;
                if ('0' > (ch = date.charAt(i++)) || ch > '9') break block18;
                years = years * 10 + ch - 48;
                if (i >= length) break block13;
                if ('0' > (ch = date.charAt(i++)) || ch > '9') break block18;
                years = years * 10 + ch - 48;
                if (i >= length) break block13;
                if ('0' > (ch = date.charAt(i++)) || ch > '9') break block18;
                years = years * 10 + ch - 48;
                if (i >= length) break block13;
                ch = date.charAt(i++);
            }
            if (i < length) {
                invalidSeparator = true;
            }
        }
        if (invalidSeparator || months == -1 || days == -1 || years == -1) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "string";
            tcx.castToName = "date";
            throw tcx.fillInMessage("EGL0007E", date, tcx.actualTypeName, tcx.castToName);
        }
        Calendar cal = DateTimeUtil.getBaseCalendar();
        cal.set(1, years);
        cal.set(2, months - 1);
        cal.set(5, days);
        try {
            cal.setTimeInMillis(cal.getTimeInMillis());
        }
        catch (Exception ex) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "string";
            tcx.castToName = "date";
            tcx.initCause(ex);
            throw tcx.fillInMessage("EGL0007E", date, tcx.actualTypeName, tcx.castToName);
        }
        return cal;
    }

    public static int compareTo(Calendar op1, Calendar op2) throws AnyException {
        if (op1 == null && op2 == null) {
            return 0;
        }
        return op1.compareTo(op2);
    }

    public static boolean equals(Calendar op1, Calendar op2) {
        if (op1 == null && op2 == null) {
            return true;
        }
        if (op1 == null || op2 == null) {
            return false;
        }
        return op1.get(1) == op2.get(1) && op1.get(2) == op2.get(2) && op1.get(5) == op2.get(5);
    }

    public static boolean notEquals(Calendar op1, Calendar op2) {
        return !EDate.equals(op1, op2);
    }

    public static int daysDifferent(EDate aDate, EDate bDate) throws AnyException {
        ((Calendar)aDate.ezeUnbox()).setTimeInMillis(((Calendar)aDate.ezeUnbox()).getTimeInMillis());
        ((Calendar)bDate.ezeUnbox()).setTimeInMillis(((Calendar)bDate.ezeUnbox()).getTimeInMillis());
        return (int)((((Calendar)aDate.ezeUnbox()).getTimeInMillis() - ((Calendar)bDate.ezeUnbox()).getTimeInMillis()) / 86400000L);
    }

    public static Calendar addDays(EDate original, int amount) throws AnyException {
        Calendar aDate = (Calendar)((Calendar)original.ezeUnbox()).clone();
        aDate.setLenient(true);
        aDate.add(5, amount);
        try {
            aDate.setTimeInMillis(aDate.getTimeInMillis());
        }
        catch (Exception exception) {}
        return (Calendar)new EDate(aDate).ezeUnbox();
    }

    public static Calendar extend(EDate aDate, String timeSpanPattern) throws AnyException {
        int startCode = 0;
        int endCode = 5;
        TimestampIntervalMask mask = new TimestampIntervalMask(timeSpanPattern);
        if (mask.getStartCode() != -1 && mask.getStartCode() <= mask.getEndCode()) {
            startCode = mask.getStartCode();
            endCode = mask.getEndCode();
        }
        return ETimestamp.asTimestamp(aDate, startCode, endCode);
    }
}

