/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.eglx.lang;

import eglx.lang.AnyException;
import eglx.lang.TypeCastException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.util.DateTimeUtil;
import org.eclipse.edt.javart.util.TimestampIntervalMask;
import org.eclipse.edt.runtime.java.eglx.lang.EAny;
import org.eclipse.edt.runtime.java.eglx.lang.EString;
import org.eclipse.edt.runtime.java.eglx.lang.ETimestamp;

public class ETime
extends AnyBoxedObject<Calendar> {
    private static final long serialVersionUID = 10L;

    public ETime() {
        this(DateTimeUtil.getNewCalendar());
    }

    public ETime(Calendar value) {
        super(value);
    }

    public static ETime ezeBox(Calendar value) {
        Calendar clone = null;
        if (value != null) {
            clone = (Calendar)value.clone();
        }
        return new ETime(clone);
    }

    public static Object ezeCast(Object value, Object[] constraints) throws AnyException {
        Integer[] args = new Integer[constraints.length];
        System.arraycopy(constraints, 0, args, 0, args.length);
        return ETime.ezeCast(value, args);
    }

    public static Calendar ezeCast(Object value, Integer ... args) throws AnyException {
        return (Calendar)EAny.ezeCast(value, "asTime", ETime.class, null, null);
    }

    public static boolean ezeIsa(Object value, Integer ... args) {
        return value instanceof ETime || value instanceof Calendar;
    }

    public String toString() {
        return EString.asString(EString.asStringTime((Calendar)this.object), new Integer[0]);
    }

    public static Calendar defaultValue() {
        long now = System.currentTimeMillis();
        Calendar cal = DateTimeUtil.getBaseCalendar();
        cal.setTimeInMillis(now);
        return cal;
    }

    public static Calendar asTime(EString time) throws TypeCastException {
        return ETime.asTime((String)time.ezeUnbox());
    }

    public static Calendar asTime(String time) throws TypeCastException {
        return ETime.convert(time);
    }

    public static Calendar asTime(ETime time) throws AnyException {
        if (time == null) {
            return null;
        }
        return ETime.asTime((Calendar)time.ezeUnbox());
    }

    public static Calendar asTime(ETimestamp time) throws AnyException {
        if (time == null) {
            return null;
        }
        return ETime.asTime((Calendar)time.ezeUnbox(), time.getStartCode(), time.getEndCode());
    }

    public static Calendar asTime(GregorianCalendar time) throws AnyException {
        if (time == null) {
            return null;
        }
        return ETime.asTime((Calendar)time);
    }

    public static Calendar asTime(Calendar time) throws AnyException {
        if (time == null) {
            return null;
        }
        return ETime.asTime(time, 3, 5);
    }

    public static Calendar asTime(Calendar original, int startCode, int endCode) {
        if (original == null) {
            return null;
        }
        if (startCode > 3 || endCode < 5) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "timestamp";
            tcx.castToName = "time";
            throw tcx.fillInMessage("EGL0007E", original, tcx.actualTypeName, tcx.castToName);
        }
        Calendar cal = (Calendar)original.clone();
        Calendar result = DateTimeUtil.getBaseCalendar();
        result.set(11, cal.get(11));
        result.set(12, cal.get(12));
        result.set(13, cal.get(13));
        try {
            result.setTimeInMillis(result.getTimeInMillis());
        }
        catch (Exception ex) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "timestamp";
            tcx.castToName = "time";
            tcx.initCause(ex);
            throw tcx.fillInMessage("EGL0007E", original, tcx.actualTypeName, tcx.castToName);
        }
        return result;
    }

    public static Calendar convert(String time) {
        int seconds;
        int minutes;
        int hours;
        boolean invalidSeparator;
        block13: {
            int i;
            int length;
            block18: {
                char ch;
                block16: {
                    block17: {
                        block14: {
                            block15: {
                                if (time == null) {
                                    return null;
                                }
                                length = time.length();
                                if (length < 5 || length > 8) {
                                    TypeCastException tcx = new TypeCastException();
                                    tcx.actualTypeName = "string";
                                    tcx.castToName = "time";
                                    throw tcx.fillInMessage("EGL0007E", time, tcx.actualTypeName, tcx.castToName);
                                }
                                invalidSeparator = false;
                                hours = -1;
                                minutes = -1;
                                seconds = -1;
                                if (length <= 0) break block13;
                                i = 0;
                                if ((ch = time.charAt(i++)) < '0' || ch > '9') break block13;
                                if (i > length) break block14;
                                hours = ch - 48;
                                if (i >= length) break block13;
                                if ('0' > (ch = time.charAt(i++)) || ch > '9') break block15;
                                hours = hours * 10 + ch - 48;
                                if (i >= length) break block13;
                                ch = time.charAt(i++);
                            }
                            if (i >= length || ch != ':') {
                                invalidSeparator = true;
                            }
                        }
                        while (i < length && ('0' > ch || ch > '9')) {
                            if ((ch = time.charAt(i++)) >= '0' && ch <= '9') continue;
                            invalidSeparator = true;
                        }
                        if (i > length) break block16;
                        minutes = ch - 48;
                        if (i >= length) break block13;
                        if ('0' > (ch = time.charAt(i++)) || ch > '9') break block17;
                        minutes = minutes * 10 + ch - 48;
                        if (i >= length) break block13;
                        ch = time.charAt(i++);
                    }
                    if (i >= length || ch != ':') {
                        invalidSeparator = true;
                    }
                }
                while (i < length && ('0' > ch || ch > '9')) {
                    if ((ch = time.charAt(i++)) >= '0' && ch <= '9') continue;
                    invalidSeparator = true;
                }
                if (i > length) break block13;
                seconds = ch - 48;
                if (i >= length) break block13;
                if ('0' > (ch = time.charAt(i++)) || ch > '9') break block18;
                seconds = seconds * 10 + ch - 48;
                if (i >= length) break block13;
                ch = time.charAt(i++);
            }
            if (i < length) {
                invalidSeparator = true;
            }
        }
        if (invalidSeparator || hours == -1 || minutes == -1 || seconds == -1) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "string";
            tcx.castToName = "time";
            throw tcx.fillInMessage("EGL0007E", time, tcx.actualTypeName, tcx.castToName);
        }
        Calendar cal = DateTimeUtil.getBaseCalendar();
        cal.set(1, cal.get(1));
        cal.set(2, cal.get(2));
        cal.set(5, cal.get(5));
        cal.set(11, hours);
        cal.set(12, minutes);
        cal.set(13, seconds);
        try {
            cal.setTimeInMillis(cal.getTimeInMillis());
        }
        catch (Exception ex) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "string";
            tcx.castToName = "time";
            tcx.initCause(ex);
            throw tcx.fillInMessage("EGL0007E", time, tcx.actualTypeName, tcx.castToName);
        }
        return cal;
    }

    public static int compareTo(Calendar op1, Calendar op2) throws AnyException {
        if (op1 == null && op2 == null) {
            return 0;
        }
        return op1.compareTo(op2);
    }

    public static boolean equals(Calendar op1, Calendar op2) {
        if (op1 == null && op2 == null) {
            return true;
        }
        if (op1 == null || op2 == null) {
            return false;
        }
        return op1.get(11) == op2.get(11) && op1.get(12) == op2.get(12) && op1.get(13) == op2.get(13);
    }

    public static boolean notEquals(Calendar op1, Calendar op2) {
        return !ETime.equals(op1, op2);
    }

    public static Calendar extend(ETime aTime, String timeSpanPattern) throws AnyException {
        int startCode = 0;
        int endCode = 5;
        TimestampIntervalMask mask = new TimestampIntervalMask(timeSpanPattern);
        if (mask.getStartCode() != -1 && mask.getStartCode() <= mask.getEndCode()) {
            startCode = mask.getStartCode();
            endCode = mask.getEndCode();
        }
        return ETimestamp.asTimestamp(aTime, startCode, endCode);
    }
}

