/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.eglx.lang;

import eglx.lang.AnyException;
import eglx.lang.InvalidArgumentException;
import eglx.lang.TypeCastException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.javart.util.DateTimeUtil;
import org.eclipse.edt.javart.util.JavartDateFormat;
import org.eclipse.edt.javart.util.TimestampIntervalMask;
import org.eclipse.edt.runtime.java.eglx.lang.EAny;
import org.eclipse.edt.runtime.java.eglx.lang.EDate;
import org.eclipse.edt.runtime.java.eglx.lang.EString;
import org.eclipse.edt.runtime.java.eglx.lang.ETime;

public class ETimestamp
extends AnyBoxedObject<Calendar> {
    private static final long serialVersionUID = 10L;
    public static final String DefaultPattern = "yyyyMMddHHmmss";
    public static final String DefaultFormatPattern = "yyyy-MM-dd HH:mm:ss.SSSSSS";
    public static final int YEAR_CODE = 0;
    public static final int MONTH_CODE = 1;
    public static final int DAY_CODE = 2;
    public static final int HOUR_CODE = 3;
    public static final int MINUTE_CODE = 4;
    public static final int SECOND_CODE = 5;
    public static final int FRACTION1_CODE = 6;
    public static final int FRACTION2_CODE = 7;
    public static final int FRACTION3_CODE = 8;
    public static final int FRACTION4_CODE = 9;
    public static final int FRACTION5_CODE = 10;
    public static final int FRACTION6_CODE = 11;
    private int startCode;
    private int endCode;

    public ETimestamp() {
        this(DateTimeUtil.getNewCalendar(), 0, 5);
    }

    public ETimestamp(Calendar value, int startCode, int endCode) {
        super(value);
        this.startCode = startCode;
        this.endCode = endCode;
    }

    public int getStartCode() {
        return this.startCode;
    }

    public int getEndCode() {
        return this.endCode;
    }

    public static ETimestamp ezeBox(Calendar value, int startCode, int endCode) {
        Calendar clone = null;
        if (value != null) {
            clone = (Calendar)value.clone();
        }
        return new ETimestamp(clone, startCode, endCode);
    }

    public static ETimestamp ezeBox(Calendar value) {
        return ETimestamp.ezeBox(value, 0, 5);
    }

    public static Object ezeCast(Object value, Object[] constraints) throws AnyException {
        Integer[] args = new Integer[constraints.length];
        System.arraycopy(constraints, 0, args, 0, args.length);
        return ETimestamp.ezeCast(value, args);
    }

    public static Calendar ezeCast(Object value, Integer ... args) throws AnyException {
        return (Calendar)EAny.ezeCast(value, "asTimestamp", ETimestamp.class, new Class[]{Integer[].class}, args);
    }

    public static boolean ezeIsa(Object value, Integer ... args) {
        boolean isa = value instanceof ETimestamp;
        if (isa) {
            if (args.length == 2) {
                isa = ((ETimestamp)value).startCode == args[0] && ((ETimestamp)value).endCode == args[1];
            }
        } else {
            isa = value instanceof Calendar;
        }
        return isa;
    }

    public String toString() {
        return EString.asString(EString.asStringTimestamp((Calendar)this.object, this.startCode, this.endCode), new Integer[0]);
    }

    public static Calendar asTimestamp(EDate timestamp) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp.ezeUnbox());
    }

    public static Calendar asTimestamp(ETime timestamp) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp.ezeUnbox());
    }

    public static Calendar asTimestamp(ETimestamp timestamp) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp.ezeUnbox());
    }

    public static Calendar asTimestamp(GregorianCalendar timestamp) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp);
    }

    public static Calendar asTimestamp(Calendar timestamp) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp(timestamp, DefaultPattern);
    }

    public static Calendar asTimestamp(EDate timestamp, String timespanMask) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp.ezeUnbox(), timespanMask);
    }

    public static Calendar asTimestamp(ETime timestamp, String timespanMask) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp.ezeUnbox(), timespanMask);
    }

    public static Calendar asTimestamp(ETimestamp timestamp, String timespanMask) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp.ezeUnbox(), timespanMask);
    }

    public static Calendar asTimestamp(GregorianCalendar timestamp, String timespanMask) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp, timespanMask);
    }

    public static Calendar asTimestamp(Calendar original, String timespanMask) throws AnyException {
        if (original == null) {
            return null;
        }
        Calendar timestamp = (Calendar)original.clone();
        if (timespanMask == null || timespanMask.length() == 0) {
            timespanMask = DefaultPattern;
        }
        int startCode = 0;
        int endCode = 5;
        TimestampIntervalMask mask = new TimestampIntervalMask(timespanMask);
        if (mask.getStartCode() != -1 && mask.getStartCode() <= mask.getEndCode()) {
            startCode = mask.getStartCode();
            endCode = mask.getEndCode();
        }
        return ETimestamp.asTimestamp(timestamp, startCode, endCode);
    }

    public static Calendar asTimestamp(EString timestamp, Integer ... args) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((String)timestamp.ezeUnbox(), args);
    }

    public static Calendar asTimestamp(String timestamp, Integer ... args) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        if (args != null && args.length == 2) {
            return ETimestamp.convert(timestamp, args[0], args[1]);
        }
        return ETimestamp.asTimestamp(timestamp, DefaultPattern);
    }

    public static Calendar asTimestamp(EString timestamp, String timespanMask) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((String)timestamp.ezeUnbox(), timespanMask);
    }

    public static Calendar asTimestamp(String timestamp, String timespanMask) throws AnyException {
        if (timestamp == null || timespanMask == null) {
            return null;
        }
        int startCode = 0;
        int endCode = 5;
        TimestampIntervalMask mask = new TimestampIntervalMask(timespanMask);
        if (mask.getStartCode() != -1 && mask.getStartCode() <= mask.getEndCode()) {
            startCode = mask.getStartCode();
            endCode = mask.getEndCode();
        }
        return ETimestamp.convert(timestamp, startCode, endCode);
    }

    public static Calendar asTimestamp(EDate timestamp, Integer ... args) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp.ezeUnbox(), args);
    }

    public static Calendar asTimestamp(ETime timestamp, Integer ... args) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp.ezeUnbox(), args);
    }

    public static Calendar asTimestamp(ETimestamp timestamp, Integer ... args) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp.ezeUnbox(), args);
    }

    public static Calendar asTimestamp(GregorianCalendar timestamp, Integer ... args) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp, args);
    }

    public static Calendar asTimestamp(Calendar date, Integer ... args) {
        if (date == null) {
            return null;
        }
        if (args == null) {
            return ETimestamp.asTimestamp(date, 0, 5);
        }
        return ETimestamp.asTimestamp(date, (int)args[0], (int)args[1]);
    }

    public static Calendar asTimestamp(EDate timestamp, int startCode, int endCode) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp.ezeUnbox(), startCode, endCode);
    }

    public static Calendar asTimestamp(ETime timestamp, int startCode, int endCode) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp.ezeUnbox(), startCode, endCode);
    }

    public static Calendar asTimestamp(ETimestamp timestamp, int startCode, int endCode) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp.ezeUnbox(), startCode, endCode);
    }

    public static Calendar asTimestamp(GregorianCalendar timestamp, int startCode, int endCode) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((Calendar)timestamp, startCode, endCode);
    }

    public static Calendar asTimestamp(Calendar original, int startCode, int endCode) {
        if (original == null) {
            return null;
        }
        Calendar cal = (Calendar)original.clone();
        cal.setLenient(true);
        Calendar result = DateTimeUtil.getBaseCalendar();
        if (startCode <= 0 && endCode >= 0) {
            result.set(1, cal.get(1));
        }
        if (startCode <= 1 && endCode >= 1) {
            result.set(2, cal.get(2));
        }
        if (startCode <= 2 && endCode >= 2) {
            result.set(5, cal.get(5));
        }
        if (startCode <= 3 && endCode >= 3) {
            result.set(11, cal.get(11));
        }
        if (startCode <= 4 && endCode >= 4) {
            result.set(12, cal.get(12));
        }
        if (startCode <= 5 && endCode >= 5) {
            result.set(13, cal.get(13));
        }
        if (startCode <= 11 && endCode >= 6) {
            result.set(14, cal.get(14));
        }
        return result;
    }

    public static Calendar asTimestamp(EString timestamp, String format, int startCode, int endCode) throws AnyException {
        if (timestamp == null) {
            return null;
        }
        return ETimestamp.asTimestamp((String)timestamp.ezeUnbox(), format, startCode, endCode);
    }

    public static Calendar asTimestamp(String timestamp, String format, int startCode, int endCode) throws AnyException {
        Calendar result;
        if (timestamp == null) {
            return null;
        }
        timestamp = timestamp.trim();
        try {
            result = ETimestamp.convert(timestamp, format);
        }
        catch (ParseException parseException) {
            result = ETimestamp.convert(timestamp, startCode, endCode);
        }
        return result;
    }

    public static int compareTo(Calendar op1, Calendar op2) throws AnyException {
        if (op1 == null && op2 == null) {
            return 0;
        }
        return op1.compareTo(op2);
    }

    public static boolean equals(Calendar op1, Calendar op2) {
        if (op1 == null && op2 == null) {
            return true;
        }
        if (op1 == null || op2 == null) {
            return false;
        }
        return op1.equals(op2);
    }

    public static boolean notEquals(Calendar op1, Calendar op2) {
        return !ETimestamp.equals(op1, op2);
    }

    public static Calendar convert(String timestamp, int startCode, int endCode) {
        int microseconds;
        int seconds;
        int minutes;
        int hours;
        int days;
        int months;
        int years;
        boolean invalidSeparator;
        block39: {
            char ch;
            int i;
            int length;
            block48: {
                block49: {
                    block46: {
                        block47: {
                            block44: {
                                block45: {
                                    block42: {
                                        block43: {
                                            block40: {
                                                block41: {
                                                    invalidSeparator = false;
                                                    years = -1;
                                                    months = -1;
                                                    days = -1;
                                                    hours = -1;
                                                    minutes = -1;
                                                    seconds = -1;
                                                    microseconds = -1;
                                                    length = timestamp.length();
                                                    if (length <= 0) break block39;
                                                    i = 0;
                                                    do {
                                                        ch = timestamp.charAt(i++);
                                                    } while (i < length && ('0' > ch || ch > '9'));
                                                    if (i <= length && startCode == 0) {
                                                        years = 0;
                                                        int j = 0;
                                                        while ('0' <= ch && ch <= '9' && j < 4) {
                                                            years = years * 10 + ch - 48;
                                                            if (i >= length) {
                                                                if (i != 4) {
                                                                    years = -1;
                                                                }
                                                                break block39;
                                                            }
                                                            ch = timestamp.charAt(i++);
                                                            ++j;
                                                        }
                                                        if (i != 5) {
                                                            years = -1;
                                                        }
                                                        if (i >= length || '0' <= ch && ch <= '9') {
                                                            invalidSeparator = true;
                                                        }
                                                    }
                                                    while (i < length && ('0' > ch || ch > '9')) {
                                                        if ((ch = timestamp.charAt(i++)) >= '0' && ch <= '9') continue;
                                                        invalidSeparator = true;
                                                    }
                                                    if (i > length || startCode > 1 || endCode < 1) break block40;
                                                    months = ch - 48;
                                                    if (i >= length) break block39;
                                                    if ('0' > (ch = timestamp.charAt(i++)) || ch > '9') break block41;
                                                    months = months * 10 + ch - 48;
                                                    if (i >= length) break block39;
                                                    ch = timestamp.charAt(i++);
                                                }
                                                if (i >= length || '0' <= ch && ch <= '9') {
                                                    invalidSeparator = true;
                                                }
                                            }
                                            while (i < length && ('0' > ch || ch > '9')) {
                                                if ((ch = timestamp.charAt(i++)) >= '0' && ch <= '9') continue;
                                                invalidSeparator = true;
                                            }
                                            if (i > length || startCode > 2 || endCode < 2) break block42;
                                            days = ch - 48;
                                            if (i >= length) break block39;
                                            if ('0' > (ch = timestamp.charAt(i++)) || ch > '9') break block43;
                                            days = days * 10 + ch - 48;
                                            if (i >= length) break block39;
                                            ch = timestamp.charAt(i++);
                                        }
                                        if (i >= length || '0' <= ch && ch <= '9') {
                                            invalidSeparator = true;
                                        }
                                    }
                                    while (i < length && ('0' > ch || ch > '9')) {
                                        if ((ch = timestamp.charAt(i++)) >= '0' && ch <= '9') continue;
                                        invalidSeparator = true;
                                    }
                                    if (i > length || startCode > 3 || endCode < 3) break block44;
                                    hours = ch - 48;
                                    if (i >= length) break block39;
                                    if ('0' > (ch = timestamp.charAt(i++)) || ch > '9') break block45;
                                    hours = hours * 10 + ch - 48;
                                    if (i >= length) break block39;
                                    ch = timestamp.charAt(i++);
                                }
                                if (i >= length || '0' <= ch && ch <= '9') {
                                    invalidSeparator = true;
                                }
                            }
                            while (i < length && ('0' > ch || ch > '9')) {
                                if ((ch = timestamp.charAt(i++)) >= '0' && ch <= '9') continue;
                                invalidSeparator = true;
                            }
                            if (i > length || startCode > 4 || endCode < 4) break block46;
                            minutes = ch - 48;
                            if (i >= length) break block39;
                            if ('0' > (ch = timestamp.charAt(i++)) || ch > '9') break block47;
                            minutes = minutes * 10 + ch - 48;
                            if (i >= length) break block39;
                            ch = timestamp.charAt(i++);
                        }
                        if (i >= length || '0' <= ch && ch <= '9') {
                            invalidSeparator = true;
                        }
                    }
                    while (i < length && ('0' > ch || ch > '9')) {
                        if ((ch = timestamp.charAt(i++)) >= '0' && ch <= '9') continue;
                        invalidSeparator = true;
                    }
                    if (i > length || startCode > 5 || endCode < 5) break block48;
                    seconds = ch - 48;
                    if (i >= length) break block39;
                    if ('0' > (ch = timestamp.charAt(i++)) || ch > '9') break block49;
                    seconds = seconds * 10 + ch - 48;
                    if (i >= length) break block39;
                    ch = timestamp.charAt(i++);
                }
                if (i >= length || '0' <= ch && ch <= '9') {
                    invalidSeparator = true;
                }
            }
            while (i < length && ('0' > ch || ch > '9')) {
                if ((ch = timestamp.charAt(i++)) >= '0' && ch <= '9') continue;
                invalidSeparator = true;
            }
            if (i <= length && endCode >= 6) {
                microseconds = 0;
                int microsecondsFound = 0;
                int fractionDigits = endCode - 6 + 1;
                while (microsecondsFound < fractionDigits && '0' <= ch && ch <= '9') {
                    microseconds *= 10;
                    microseconds += ch - 48;
                    ++microsecondsFound;
                    if (i >= length) break;
                    ch = timestamp.charAt(i++);
                }
                if (microsecondsFound < 6) {
                    int j = microsecondsFound;
                    while (j < 6) {
                        microseconds *= 10;
                        ++j;
                    }
                }
                if (i < length) {
                    invalidSeparator = true;
                }
            }
        }
        if (invalidSeparator || years == -1 && startCode == 0 || months == -1 && startCode <= 1 && endCode >= 1 || days == -1 && startCode <= 2 && endCode >= 2 || hours == -1 && startCode <= 3 && endCode >= 3 || minutes == -1 && startCode <= 4 && endCode >= 4 || seconds == -1 && startCode <= 5 && endCode >= 5 || microseconds == -1 && endCode >= 6) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "string";
            tcx.castToName = "timestamp";
            throw tcx.fillInMessage("EGL0007E", timestamp, tcx.actualTypeName, tcx.castToName);
        }
        Calendar cal = DateTimeUtil.getBaseCalendar();
        if (years != -1) {
            cal.set(1, years);
        }
        if (months != -1) {
            cal.set(2, months - 1);
        }
        if (days != -1) {
            cal.set(5, days);
        }
        if (hours != -1) {
            cal.set(11, hours);
        }
        if (minutes != -1) {
            cal.set(12, minutes);
        }
        if (seconds != -1) {
            cal.set(13, seconds);
        }
        if (microseconds != -1) {
            cal.set(14, microseconds / 1000);
        }
        try {
            if (years != -1 && months != -1 && days != -1) {
                cal.setTimeInMillis(cal.getTimeInMillis());
            }
        }
        catch (Exception ex) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "string";
            tcx.castToName = "timestamp";
            tcx.initCause(ex);
            throw tcx.fillInMessage("EGL0007E", timestamp, tcx.actualTypeName, tcx.castToName);
        }
        return cal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Calendar convert(String timestamp, String format) throws ParseException {
        byte[] byArray = DateTimeUtil.LOCK;
        synchronized (DateTimeUtil.LOCK) {
            JavartDateFormat formatter = DateTimeUtil.getDateFormat(format);
            formatter.setMicrosecond(0);
            Date date = formatter.parse(timestamp);
            Calendar cal = DateTimeUtil.getBaseCalendar();
            cal.setTime(date);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return cal;
        }
    }

    public static String createPattern(int startCode, int endCode) {
        if (startCode > endCode) {
            return null;
        }
        String[] code = new String[]{"yyyy", "MM", "dd", "HH", "mm", "ss", "SSSSSS"};
        String[] delimiters = new String[]{"-", "-", " ", ":", ":", "."};
        int sindex = startCode > 6 ? 6 : startCode;
        int eindex = endCode > 6 ? 6 : endCode;
        StringBuilder patternString = new StringBuilder(26);
        int i = sindex;
        int j = 0;
        while (i <= eindex) {
            if (j > 0) {
                patternString.append(delimiters[i - 1]);
            }
            patternString.append(code[i]);
            ++i;
            ++j;
        }
        return patternString.toString();
    }

    public static Calendar defaultValue() {
        long now = System.currentTimeMillis();
        Calendar cal = DateTimeUtil.getBaseCalendar();
        cal.setTimeInMillis(now);
        return cal;
    }

    public static Calendar defaultValue(int startCode, int endCode) {
        long now = System.currentTimeMillis();
        Calendar cal = DateTimeUtil.getBaseCalendar();
        cal.setTimeInMillis(now);
        int year = cal.get(1);
        int month = cal.get(2);
        int date = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int fraction = cal.get(14);
        cal.clear();
        if (startCode <= 0 && endCode >= 0) {
            cal.set(1, year);
        }
        if (startCode <= 1 && endCode >= 1) {
            cal.set(2, month);
        }
        if (startCode <= 2 && endCode >= 2) {
            cal.set(5, date);
        }
        if (startCode <= 3 && endCode >= 3) {
            cal.set(11, hour);
        }
        if (startCode <= 4 && endCode >= 4) {
            cal.set(12, minute);
        }
        if (startCode <= 5 && endCode >= 5) {
            cal.set(13, second);
        }
        if (startCode <= 11 && endCode >= 6) {
            cal.set(14, fraction);
        }
        try {
            cal.setTimeInMillis(cal.getTimeInMillis());
        }
        catch (Exception exception) {}
        return ETimestamp.asTimestamp(cal, startCode, endCode);
    }

    public static int dayOf(ETimestamp original) throws AnyException {
        if (original.getStartCode() > 2 || original.getEndCode() < 2) {
            InvalidArgumentException ex = new InvalidArgumentException();
            throw ex.fillInMessage("EGL0017E", "dayOf", "dd");
        }
        Calendar aTimestamp = (Calendar)((Calendar)original.ezeUnbox()).clone();
        return aTimestamp.get(5);
    }

    public static int monthOf(ETimestamp original) throws AnyException {
        if (original.getStartCode() > 1 || original.getEndCode() < 1) {
            InvalidArgumentException ex = new InvalidArgumentException();
            throw ex.fillInMessage("EGL0017E", "monthOf", "MM");
        }
        Calendar aTimestamp = (Calendar)((Calendar)original.ezeUnbox()).clone();
        return aTimestamp.get(2) + 1;
    }

    public static int yearOf(ETimestamp original) throws AnyException {
        if (original.getStartCode() > 0 || original.getEndCode() < 0) {
            InvalidArgumentException ex = new InvalidArgumentException();
            throw ex.fillInMessage("EGL0017E", "yearOf", "yyyy");
        }
        Calendar aTimestamp = (Calendar)((Calendar)original.ezeUnbox()).clone();
        return aTimestamp.get(1);
    }

    public static int weekdayOf(ETimestamp original) throws AnyException {
        if (original.getStartCode() > 0 || original.getEndCode() < 2) {
            InvalidArgumentException ex = new InvalidArgumentException();
            throw ex.fillInMessage("EGL0017E", "weekdayOf", "dd");
        }
        Calendar aTimestamp = (Calendar)((Calendar)original.ezeUnbox()).clone();
        return aTimestamp.get(7) - 1;
    }

    public static Calendar dateOf(ETimestamp aTimestamp) throws AnyException {
        if (aTimestamp.getStartCode() > 0 || aTimestamp.getEndCode() < 2) {
            InvalidArgumentException ex = new InvalidArgumentException();
            throw ex.fillInMessage("EGL0017E", "dateOf", "yyyyMMdd");
        }
        return ETimestamp.asTimestamp(aTimestamp, 0, 2);
    }

    public static Calendar timeOf(ETimestamp aTimestamp) throws AnyException {
        if (aTimestamp.getStartCode() > 3 || aTimestamp.getEndCode() < 5) {
            InvalidArgumentException ex = new InvalidArgumentException();
            throw ex.fillInMessage("EGL0017E", "timeOf", "HHmmss");
        }
        return ETimestamp.asTimestamp(aTimestamp, 3, 5);
    }

    public static Calendar extend(ETimestamp aTimestamp, String timeSpanPattern) throws AnyException {
        int startCode = 0;
        int endCode = 5;
        TimestampIntervalMask mask = new TimestampIntervalMask(timeSpanPattern);
        if (mask.getStartCode() != -1 && mask.getStartCode() <= mask.getEndCode()) {
            startCode = mask.getStartCode();
            endCode = mask.getEndCode();
        }
        return ETimestamp.asTimestamp(aTimestamp, startCode, endCode);
    }
}

