/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.utilities;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.internal.util.EGLMessage;
import org.eclipse.edt.compiler.internal.util.IGenerationResultsMessage;
import org.eclipse.edt.ide.core.internal.generation.GenerationResultsMessage;
import org.eclipse.edt.ide.core.internal.model.BinaryPart;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.internal.search.AllPartsCache;
import org.eclipse.edt.ide.core.internal.search.PartInfo;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.Signature;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.core.utils.EclipseUtilities;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.ide.deployment.core.model.DeploymentProject;
import org.eclipse.edt.ide.deployment.core.model.DeploymentTarget;
import org.eclipse.edt.ide.deployment.results.IDeploymentResultsCollector;
import org.eclipse.edt.ide.deployment.solution.DeploymentContext;
import org.eclipse.edt.ide.deployment.utilities.IDEDeploymentDescFileLocator;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DeploymentUtilities {
    private static final String RUIHANDLER = InternUtil.intern((String)"RUIHandler");

    public static String createExceptionMessage(Throwable t) {
        while (t.getCause() != null && !t.getCause().equals(t)) {
            t = t.getCause();
        }
        if (t.getMessage() != null && t.getMessage().length() > 0) {
            return String.valueOf(t.getClass().getName()) + ":" + t.getMessage();
        }
        if (t.toString() != null) {
            return t.toString();
        }
        return "";
    }

    public static IStatus createErrorStatus(String message) {
        return DeploymentUtilities.createErrorStatus(message, null);
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        return new Status(4, "org.eclipse.edt.ide.deployment", -1, message, exception);
    }

    public static IStatus createDeployMessage(int severity, String message) {
        return new Status(severity, "Deployment", message);
    }

    public static String deriveHTMLFilePath(String targetDirectory, String fileName, String localeCode, boolean filenameWithLocale, String fileExtension) throws CoreException {
        String filename = DeploymentUtilities.buildFileNameWithLocale(fileName, localeCode, filenameWithLocale, fileExtension);
        return String.valueOf(targetDirectory) + "/" + filename;
    }

    public static String buildFileNameWithLocale(String fileName, String localeCode, boolean filenameWithLocale, String fileExtension) {
        return String.valueOf(fileName) + (filenameWithLocale ? "-" + localeCode : "") + "." + fileExtension;
    }

    public static String generateTargetDirectory(IFolder sourceFolder, String targetDirectory, String targetDirectoryType) throws CoreException {
        String rootPath;
        String result = "";
        String sourceDirectory = sourceFolder.getFullPath().toString();
        ArrayList results = new ArrayList();
        if (results.size() > 0 && sourceDirectory.startsWith(rootPath = ((IResource)results.get(0)).getFullPath().toString())) {
            result = String.valueOf(targetDirectory) + sourceDirectory.substring(rootPath.length());
        }
        return result;
    }

    public static void copyFile(IFile file, String fullTargetPath) throws CoreException {
        DeploymentUtilities.copyFile(file.getRawLocation().toOSString(), fullTargetPath);
    }

    public static void copyFile(File file, String fullTargetPath) throws CoreException {
        DeploymentUtilities.copyFile(file.getAbsolutePath(), fullTargetPath);
    }

    private static void copyFile(String filePath, String fullTargetPath) throws CoreException {
        try {
            BufferedInputStream reader = new BufferedInputStream(new FileInputStream(filePath));
            DeploymentUtilities.copyFile(reader, fullTargetPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            Status status = new Status(4, "org.eclipse.edt.ide.deployment", -1, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    public static void copyFile(InputStream is, String fullTargetPath) throws CoreException {
        try {
            BufferedOutputStream writer = new BufferedOutputStream(new FileOutputStream(fullTargetPath));
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = is.read(buf)) != -1) {
                ((OutputStream)writer).write(buf, 0, i);
            }
            is.close();
            ((OutputStream)writer).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            Status status = new Status(4, "org.eclipse.edt.ide.deployment", -1, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (IOException e) {
            e.printStackTrace();
            Status status = new Status(4, "org.eclipse.edt.ide.deployment", -1, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    public static String getDeploymentTargetId(DeploymentTarget target, String resultsCollectorsSubName, String resultsCollectorName) {
        if (target instanceof DeploymentProject) {
            return ((DeploymentProject)target).getName();
        }
        return null;
    }

    public static String getDeploymentTargetType(DeploymentTarget target) {
        if (target != null) {
            switch (target.getTargetType()) {
                case 3: {
                    return "j2ee";
                }
            }
        }
        return "";
    }

    public static void finalize(IDeploymentResultsCollector collector, boolean displayErrorDialog, String modelName) {
        try {
            if (collector.hasError()) {
                PlatformUI.isWorkbenchRunning();
            }
        }
        finally {
            collector.done();
        }
    }

    public static String[] convertPackage(String pkg) {
        StringTokenizer toks = new StringTokenizer(pkg, ".");
        ArrayList<String> pkgAry = new ArrayList<String>();
        while (toks.hasMoreElements()) {
            pkgAry.add(toks.nextToken());
        }
        return pkgAry.toArray(new String[pkgAry.size()]);
    }

    public static IStatus convert(IGenerationResultsMessage message) {
        int statusint = 1;
        switch (message.getSeverity()) {
            case 1: {
                statusint = 4;
                break;
            }
            case 3: {
                statusint = 1;
                break;
            }
            case 2: {
                statusint = 2;
                break;
            }
            default: {
                statusint = 8;
            }
        }
        return DeploymentUtilities.createStatus(statusint, message.getBuiltMessage());
    }

    public static IStatus createStatus(int severity, String message) {
        return new Status(severity, "org.eclipse.edt.ide.deployment", message);
    }

    public static final Shell getShell() {
        IWorkbenchWindow workbenchWindow;
        Shell shell = null;
        Display display = DeploymentUtilities.getDisplay();
        if (display != null) {
            shell = display.getActiveShell();
        }
        if (shell == null && (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            shell = workbenchWindow.getShell();
        }
        return shell;
    }

    public static final Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static List<DeploymentDesc> getDependentModels(IProject project, DeploymentDesc mainModel) throws Exception {
        List egldds = EclipseUtilities.getDependentDescriptors((IProject)project);
        ArrayList<DeploymentDesc> models = new ArrayList<DeploymentDesc>();
        new IDEDeploymentDescFileLocator();
        for (String eglddFile : egldds) {
            IFile eglddResource = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(eglddFile);
            String ddName = eglddResource.getName();
            if ((ddName = ddName.substring(0, ddName.indexOf(eglddResource.getFileExtension()) - 1)).equalsIgnoreCase(mainModel.getName())) continue;
            DeploymentDesc model = DeploymentDesc.createDeploymentDescriptor((String)ddName, (InputStream)eglddResource.getContents());
            models.add(model);
        }
        return models;
    }

    public static List getAllEglddsName(DeploymentContext context) {
        ArrayList<String> egldds = new ArrayList<String>();
        egldds.add(context.getDeploymentDesc().getName());
        for (DeploymentDesc egldd : context.getDependentModels()) {
            egldds.add(egldd.getName());
        }
        return egldds;
    }

    public static Map getAllRUIHandlersInProject(IEGLProject project) throws EGLModelException {
        return DeploymentUtilities.getAllRUIHandlersInProject(project, false);
    }

    public static Map getAllRUIHandlersInProject(IEGLProject project, boolean searchReferencedProjects) throws EGLModelException {
        ArrayList handlerList = new ArrayList();
        IEGLSearchScope projSearchScope = SearchEngine.createEGLSearchScope((IEGLElement[])new IEGLElement[]{project}, (boolean)searchReferencedProjects);
        AllPartsCache.getParts((IEGLSearchScope)projSearchScope, (int)512, (IProgressMonitor)new NullProgressMonitor(), handlerList);
        HashMap<String, String> ruiMap = new HashMap<String, String>();
        for (PartInfo partinfo : handlerList) {
            BinaryPart binaryPart;
            int idx;
            String htmlDefault;
            String impl;
            IPart part = partinfo.resolvePart(projSearchScope);
            if (part instanceof SourcePart) {
                SourcePart sourcePart = (SourcePart)partinfo.resolvePart(projSearchScope);
                if (!sourcePart.isHandler() || sourcePart.getSubTypeSignature() == null || RUIHANDLER != InternUtil.intern((String)Signature.toString((String)sourcePart.getSubTypeSignature()))) continue;
                impl = partinfo.getFullyQualifiedName();
                htmlDefault = impl;
                idx = htmlDefault.lastIndexOf(46);
                if (idx != -1) {
                    htmlDefault = htmlDefault.substring(idx + 1);
                }
                ruiMap.put(impl, htmlDefault);
                continue;
            }
            if (!(part instanceof BinaryPart) || !(binaryPart = (BinaryPart)partinfo.resolvePart(projSearchScope)).isHandler() || binaryPart.getSubTypeSignature() == null || RUIHANDLER != InternUtil.intern((String)Signature.toString((String)binaryPart.getSubTypeSignature()))) continue;
            impl = partinfo.getFullyQualifiedName();
            htmlDefault = impl;
            idx = htmlDefault.lastIndexOf(46);
            if (idx != -1) {
                htmlDefault = htmlDefault.substring(idx + 1);
            }
            ruiMap.put(impl, htmlDefault);
        }
        return ruiMap;
    }

    public static IGenerationResultsMessage createEGLDeploymentErrorMessage(String messageID, Object messageContributor, String[] inserts) {
        return new GenerationResultsMessage(new EGLMessage(DeploymentUtilities.getValidationResourceBundleName(), 1, messageID, "Validation", messageContributor, inserts, -1, -1, -1, -1));
    }

    public static IGenerationResultsMessage createEGLDeploymentInformationalMessage(String messageID, Object messageContributor, String[] inserts) {
        return new GenerationResultsMessage(new EGLMessage(DeploymentUtilities.getValidationResourceBundleName(), 3, messageID, "Deployment", messageContributor, inserts, -1, -1, -1, -1));
    }

    public static String getValidationResourceBundleName() {
        return "org.eclipse.edt.compiler.internal.core.builder.EGLValidationResources";
    }
}

