/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates;

import java.util.List;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.egl.ExceptionBlock;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.TryStatement;

public class TryStatementTemplate
extends JavaTemplate {
    public void genStatementBody(TryStatement stmt, Context ctx, TabbedWriter out) {
        out.print("try ");
        ctx.invoke("genStatement", (Statement)stmt.getTryBlock(), (TemplateContext)ctx, out);
        ctx.writeSmapLine();
        List blocks = stmt.getExceptionBlocks();
        if (blocks.isEmpty()) {
            String exTemp = ctx.nextTempName();
            out.println("catch ( java.lang.Exception " + exTemp + " ) {");
            out.println("org.eclipse.edt.javart.util.JavartUtil.checkHandleable( " + exTemp + " );");
            out.println('}');
        } else {
            ExceptionBlock anyExBlock = null;
            ExceptionBlock nullValueExBlock = null;
            ExceptionBlock javaOjbectExBlock = null;
            int specialBlocksCount = 0;
            for (ExceptionBlock exceptionBlock : blocks) {
                String sig = exceptionBlock.getException().getType().getTypeSignature();
                if (sig.equals("eglx.lang.AnyException")) {
                    anyExBlock = exceptionBlock;
                    ++specialBlocksCount;
                    continue;
                }
                if (sig.equals("eglx.lang.NullValueException")) {
                    nullValueExBlock = exceptionBlock;
                    ++specialBlocksCount;
                    continue;
                }
                if (sig.equals("eglx.java.JavaObjectException")) {
                    javaOjbectExBlock = exceptionBlock;
                    ++specialBlocksCount;
                    continue;
                }
                ctx.invoke("genOnException", (Statement)exceptionBlock, (TemplateContext)ctx, out);
            }
            if (specialBlocksCount == 1) {
                ExceptionBlock block = anyExBlock != null ? anyExBlock : (nullValueExBlock != null ? nullValueExBlock : javaOjbectExBlock);
                ctx.invoke("genOneSpecialOnException", block, (TemplateContext)ctx, out);
            } else if (specialBlocksCount > 1) {
                ctx.invoke("genSpecialOnExceptions", (EObject)anyExBlock, new Object[]{nullValueExBlock, javaOjbectExBlock, ctx, out});
            }
        }
    }

    public void genStatementEnd(TryStatement stmt, Context ctx, TabbedWriter out) {
    }
}

