/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.services.internal.testserver;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.compiler.tools.IRUtils;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.utils.DefaultDeploymentDescriptorUtility;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.ide.deployment.core.model.Service;
import org.eclipse.edt.ide.testserver.ClasspathUtil;
import org.eclipse.edt.ide.testserver.TestServerPlugin;
import org.eclipse.edt.javart.resources.egldd.Binding;

public class DeploymentDescriptorFinder {
    private DeploymentDescriptorFinder() {
    }

    public static String toArgumentString(Collection<DDFile> ddFiles) {
        if (ddFiles.size() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        boolean needSeparator = false;
        for (DDFile file : ddFiles) {
            if (needSeparator) {
                buf.append(File.pathSeparatorChar);
            } else {
                needSeparator = true;
            }
            buf.append(file.toString());
        }
        return buf.toString();
    }

    public static String toOrderedArgumentString(Collection<DDFile> ddFiles) {
        if (ddFiles.size() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        boolean needSeparator = false;
        for (DDFile file : ddFiles) {
            if (needSeparator) {
                buf.append(File.pathSeparatorChar);
            } else {
                needSeparator = true;
            }
            try {
                buf.append(URLEncoder.encode(file.name, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                buf.append(file.name);
            }
        }
        return buf.toString();
    }

    public static String getDefaultDDName(IProject project) {
        IResource member;
        String path = DefaultDeploymentDescriptorUtility.getDefaultDeploymentDescriptor((IResource)project).getPartPath();
        if (path != null && (member = ResourcesPlugin.getWorkspace().getRoot().findMember(path)) != null && member.getType() == 1) {
            try {
                DeploymentDesc dd = DeploymentDesc.createDeploymentDescriptor((String)member.getLocation().toOSString());
                return dd.getName().toLowerCase();
            }
            catch (Exception e) {
                TestServerPlugin.getDefault().log(e.getMessage(), e);
            }
        }
        return "";
    }

    public static List<DDFile> findDeploymentDescriptors(IProject project) {
        ArrayList<DDFile> ddFiles = new ArrayList<DDFile>();
        DeploymentDescriptorFinder.addDDFiles(project, new HashSet<IProject>(), new HashSet<IResource>(), ddFiles);
        return ddFiles;
    }

    private static void addDDFiles(IProject project, Set<IProject> seenProjects, final Set<IResource> seenDDs, final List<DDFile> ddFiles) {
        if (seenProjects.contains(project)) {
            return;
        }
        seenProjects.add(project);
        try {
            IWorkspaceRoot root;
            if (!project.hasNature("org.eclipse.edt.ide.core.eglnature")) {
                return;
            }
            IEGLProject eglProject = EGLCore.create((IProject)project);
            if (eglProject == null) {
                return;
            }
            IPackageFragmentRoot[] iPackageFragmentRootArray = eglProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                root = iPackageFragmentRootArray[n2];
                if (root.getResource() != null) {
                    root.getResource().accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) throws CoreException {
                            if (proxy.getType() == 1) {
                                if (IRUtils.matchesFileName((String)proxy.getName(), (char[])ClasspathUtil.SUFFIX_egldd, (char[])ClasspathUtil.SUFFIX_EGLDD)) {
                                    DeploymentDescriptorFinder.parseDD(proxy.requestResource(), seenDDs, ddFiles);
                                }
                                return false;
                            }
                            return true;
                        }
                    }, 0);
                }
                ++n2;
            }
            root = ResourcesPlugin.getWorkspace().getRoot();
            IEGLPathEntry[] iEGLPathEntryArray = eglProject.getResolvedEGLPath(true);
            int n3 = iEGLPathEntryArray.length;
            n = 0;
            while (n < n3) {
                IResource resource;
                IEGLPathEntry entry = iEGLPathEntryArray[n];
                if (entry.getEntryKind() == 2 && (resource = root.findMember(entry.getPath())) != null && resource.getType() == 4 && resource.isAccessible()) {
                    DeploymentDescriptorFinder.addDDFiles((IProject)resource, seenProjects, seenDDs, ddFiles);
                }
                ++n;
            }
        }
        catch (CoreException e) {
            TestServerPlugin.getDefault().log(e.getMessage(), (Exception)((Object)e));
        }
    }

    private static void parseDD(IResource file, Set<IResource> seenDDs, List<DDFile> resolvedFiles) {
        if (seenDDs.contains(file)) {
            return;
        }
        seenDDs.add(file);
        try {
            String absPath = file.getLocation().toOSString();
            DeploymentDesc dd = DeploymentDesc.createDeploymentDescriptor((String)absPath);
            boolean found = false;
            int i = 0;
            while (i < resolvedFiles.size()) {
                if (dd.getName().equals(resolvedFiles.get((int)i).name)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                resolvedFiles.add(new DDFile(dd.getName().toLowerCase(), absPath, dd.getBindings(), dd.getServices()));
            }
        }
        catch (Exception e) {
            TestServerPlugin.getDefault().log(e.getMessage(), e);
        }
    }

    public static class DDFile {
        String name;
        String path;
        List<Binding> bindings;
        List<Service> services;

        DDFile(String name, String path, List<Binding> bindings, List<Service> services) {
            this.name = name;
            this.path = path;
            this.bindings = bindings;
            this.services = services;
        }

        public List<Binding> getBindings() {
            return this.bindings;
        }

        public List<Service> getServices() {
            return this.services;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof DDFile) {
                DDFile file = (DDFile)o;
                if (this.name.equals(file.name) && this.path.equals(file.path) && this.bindings.size() == file.bindings.size() && this.services.size() == file.services.size()) {
                    for (Binding b : this.bindings) {
                        if (file.bindings.contains(b)) continue;
                        return false;
                    }
                    for (Service s : this.services) {
                        if (file.services.contains(s)) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            try {
                return String.valueOf(URLEncoder.encode(this.name, "UTF-8")) + File.pathSeparatorChar + URLEncoder.encode(this.path, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return String.valueOf(this.name) + File.pathSeparatorChar + this.path;
            }
        }
    }
}

