/*******************************************************************************
 * Copyright © 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
/* The following code was generated by JFlex 1.4.3 on 5/4/12 11:31 AM */

package org.eclipse.edt.compiler.core.ast;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

import java_cup.runtime.Symbol;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 5/4/12 11:31 AM from the specification file
 * <tt>egl.flex</tt>
 */
public class Lexer implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 128;

  /** lexical states */
  public static final int DLI = 14;
  public static final int DLI_QUOTED_ID = 16;
  public static final int SQLDELIMITEDID = 10;
  public static final int STRING = 2;
  public static final int DLI_DBL_QUOTED_ID = 18;
  public static final int SQL = 8;
  public static final int YYINITIAL = 0;
  public static final int HEXSTRING = 4;
  public static final int BLOCK_COMMENT = 6;
  public static final int SQLSTRING = 12;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9, 9
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\5\1\3\1\1\1\0\1\3\1\2\16\5\4\0\1\3\1\55"+
    "\1\23\1\31\1\4\1\67\1\62\1\76\1\53\1\54\1\30\1\13"+
    "\1\56\1\22\1\11\1\21\1\16\5\6\1\52\3\6\1\60\1\57"+
    "\1\64\1\61\1\65\1\66\1\73\1\41\1\20\1\24\1\25\1\12"+
    "\1\14\1\46\1\47\1\7\1\4\1\51\1\34\1\26\1\37\1\36"+
    "\1\43\1\33\1\44\1\32\1\40\1\27\1\45\1\50\1\17\1\42"+
    "\1\4\1\70\1\75\1\71\1\0\1\4\1\0\1\41\1\77\1\24"+
    "\1\25\1\12\1\15\1\46\1\47\1\10\1\4\1\51\1\34\1\26"+
    "\1\100\1\36\1\43\1\33\1\101\1\32\1\102\1\27\1\45\1\50"+
    "\1\17\1\42\1\4\1\35\1\63\1\72\1\74\41\5\2\0\4\4"+
    "\4\0\1\4\2\0\1\5\7\0\1\4\4\0\1\4\5\0\27\4"+
    "\1\0\37\4\1\0\u013f\4\31\0\162\4\4\0\14\4\16\0\5\4"+
    "\11\0\1\4\21\0\130\5\5\0\23\5\12\0\1\4\13\0\1\4"+
    "\1\0\3\4\1\0\1\4\1\0\24\4\1\0\54\4\1\0\46\4"+
    "\1\0\5\4\4\0\202\4\1\0\4\5\3\0\105\4\1\0\46\4"+
    "\2\0\2\4\6\0\20\4\41\0\46\4\2\0\1\4\7\0\47\4"+
    "\11\0\21\5\1\0\27\5\1\0\3\5\1\0\1\5\1\0\2\5"+
    "\1\0\1\5\13\0\33\4\5\0\3\4\15\0\4\5\14\0\6\5"+
    "\13\0\32\4\5\0\13\4\16\5\7\0\12\5\4\0\2\4\1\5"+
    "\143\4\1\0\1\4\10\5\1\0\6\5\2\4\2\5\1\0\4\5"+
    "\2\4\12\5\3\4\2\0\1\4\17\0\1\5\1\4\1\5\36\4"+
    "\33\5\2\0\3\4\60\0\46\4\13\5\1\4\u014f\0\3\5\66\4"+
    "\2\0\1\5\1\4\20\5\2\0\1\4\4\5\3\0\12\4\2\5"+
    "\2\0\12\5\21\0\3\5\1\0\10\4\2\0\2\4\2\0\26\4"+
    "\1\0\7\4\1\0\1\4\3\0\4\4\2\0\1\5\1\4\7\5"+
    "\2\0\2\5\2\0\3\5\11\0\1\5\4\0\2\4\1\0\3\4"+
    "\2\5\2\0\12\5\4\4\15\0\3\5\1\0\6\4\4\0\2\4"+
    "\2\0\26\4\1\0\7\4\1\0\2\4\1\0\2\4\1\0\2\4"+
    "\2\0\1\5\1\0\5\5\4\0\2\5\2\0\3\5\13\0\4\4"+
    "\1\0\1\4\7\0\14\5\3\4\14\0\3\5\1\0\11\4\1\0"+
    "\3\4\1\0\26\4\1\0\7\4\1\0\2\4\1\0\5\4\2\0"+
    "\1\5\1\4\10\5\1\0\3\5\1\0\3\5\2\0\1\4\17\0"+
    "\2\4\2\5\2\0\12\5\1\0\1\4\17\0\3\5\1\0\10\4"+
    "\2\0\2\4\2\0\26\4\1\0\7\4\1\0\2\4\1\0\5\4"+
    "\2\0\1\5\1\4\6\5\3\0\2\5\2\0\3\5\10\0\2\5"+
    "\4\0\2\4\1\0\3\4\4\0\12\5\1\0\1\4\20\0\1\5"+
    "\1\4\1\0\6\4\3\0\3\4\1\0\4\4\3\0\2\4\1\0"+
    "\1\4\1\0\2\4\3\0\2\4\3\0\3\4\3\0\10\4\1\0"+
    "\3\4\4\0\5\5\3\0\3\5\1\0\4\5\11\0\1\5\17\0"+
    "\11\5\11\0\1\4\7\0\3\5\1\0\10\4\1\0\3\4\1\0"+
    "\27\4\1\0\12\4\1\0\5\4\4\0\7\5\1\0\3\5\1\0"+
    "\4\5\7\0\2\5\11\0\2\4\4\0\12\5\22\0\2\5\1\0"+
    "\10\4\1\0\3\4\1\0\27\4\1\0\12\4\1\0\5\4\2\0"+
    "\1\5\1\4\7\5\1\0\3\5\1\0\4\5\7\0\2\5\7\0"+
    "\1\4\1\0\2\4\4\0\12\5\22\0\2\5\1\0\10\4\1\0"+
    "\3\4\1\0\27\4\1\0\20\4\4\0\6\5\2\0\3\5\1\0"+
    "\4\5\11\0\1\5\10\0\2\4\4\0\12\5\22\0\2\5\1\0"+
    "\22\4\3\0\30\4\1\0\11\4\1\0\1\4\2\0\7\4\3\0"+
    "\1\5\4\0\6\5\1\0\1\5\1\0\10\5\22\0\2\5\15\0"+
    "\60\4\1\5\2\4\7\5\4\0\10\4\10\5\1\0\12\5\47\0"+
    "\2\4\1\0\1\4\2\0\2\4\1\0\1\4\2\0\1\4\6\0"+
    "\4\4\1\0\7\4\1\0\3\4\1\0\1\4\1\0\1\4\2\0"+
    "\2\4\1\0\4\4\1\5\2\4\6\5\1\0\2\5\1\4\2\0"+
    "\5\4\1\0\1\4\1\0\6\5\2\0\12\5\2\0\2\4\42\0"+
    "\1\4\27\0\2\5\6\0\12\5\13\0\1\5\1\0\1\5\1\0"+
    "\1\5\4\0\2\5\10\4\1\0\42\4\6\0\24\5\1\0\2\5"+
    "\4\4\4\0\10\5\1\0\44\5\11\0\1\5\71\0\42\4\1\0"+
    "\5\4\1\0\2\4\1\0\7\5\3\0\4\5\6\0\12\5\6\0"+
    "\6\4\4\5\106\0\46\4\12\0\51\4\7\0\132\4\5\0\104\4"+
    "\5\0\122\4\6\0\7\4\1\0\77\4\1\0\1\4\1\0\4\4"+
    "\2\0\7\4\1\0\1\4\1\0\4\4\2\0\47\4\1\0\1\4"+
    "\1\0\4\4\2\0\37\4\1\0\1\4\1\0\4\4\2\0\7\4"+
    "\1\0\1\4\1\0\4\4\2\0\7\4\1\0\7\4\1\0\27\4"+
    "\1\0\37\4\1\0\1\4\1\0\4\4\2\0\7\4\1\0\47\4"+
    "\1\0\23\4\16\0\11\5\56\0\125\4\14\0\u026c\4\2\0\10\4"+
    "\12\0\32\4\5\0\113\4\3\0\3\4\17\0\15\4\1\0\4\4"+
    "\3\5\13\0\22\4\3\5\13\0\22\4\2\5\14\0\15\4\1\0"+
    "\3\4\1\0\2\5\14\0\64\4\40\5\3\0\1\4\3\0\2\4"+
    "\1\5\2\0\12\5\41\0\3\5\2\0\12\5\6\0\130\4\10\0"+
    "\51\4\1\5\126\0\35\4\3\0\14\5\4\0\14\5\12\0\12\5"+
    "\36\4\2\0\5\4\u038b\0\154\4\224\0\234\4\4\0\132\4\6\0"+
    "\26\4\2\0\6\4\2\0\46\4\2\0\6\4\2\0\10\4\1\0"+
    "\1\4\1\0\1\4\1\0\1\4\1\0\37\4\2\0\65\4\1\0"+
    "\7\4\1\0\1\4\3\0\3\4\1\0\7\4\3\0\4\4\2\0"+
    "\6\4\4\0\15\4\5\0\3\4\1\0\7\4\17\0\4\5\32\0"+
    "\5\5\20\0\2\4\23\0\1\4\13\0\4\5\6\0\6\5\1\0"+
    "\1\4\15\0\1\4\40\0\22\4\36\0\15\5\4\0\1\5\3\0"+
    "\6\5\27\0\1\4\4\0\1\4\2\0\12\4\1\0\1\4\3\0"+
    "\5\4\6\0\1\4\1\0\1\4\1\0\1\4\1\0\4\4\1\0"+
    "\3\4\1\0\7\4\3\0\3\4\5\0\5\4\26\0\44\4\u0e81\0"+
    "\3\4\31\0\11\4\6\5\1\0\5\4\2\0\5\4\4\0\126\4"+
    "\2\0\2\5\2\0\3\4\1\0\137\4\5\0\50\4\4\0\136\4"+
    "\21\0\30\4\70\0\20\4\u0200\0\u19b6\4\112\0\u51a6\4\132\0\u048d\4"+
    "\u0773\0\u2ba4\4\u215c\0\u012e\4\2\0\73\4\225\0\7\4\14\0\5\4"+
    "\5\0\1\4\1\5\12\4\1\0\15\4\1\0\5\4\1\0\1\4"+
    "\1\0\2\4\1\0\2\4\1\0\154\4\41\0\u016b\4\22\0\100\4"+
    "\2\0\66\4\50\0\15\4\3\0\20\5\20\0\4\5\17\0\2\4"+
    "\30\0\3\4\31\0\1\4\6\0\5\4\1\0\207\4\2\0\1\5"+
    "\4\0\1\4\13\0\12\5\7\0\32\4\4\0\1\4\1\0\32\4"+
    "\12\0\132\4\3\0\6\4\2\0\6\4\2\0\6\4\2\0\3\4"+
    "\3\0\2\4\3\0\2\4\22\0\3\5\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\4\0\1\1\2\0\1\1\2\0\1\2\1\3\1\4"+
    "\1\5\1\6\1\5\1\7\1\5\1\10\1\5\1\6"+
    "\2\5\1\11\1\12\1\13\4\5\1\14\1\2\2\5"+
    "\1\15\12\5\1\16\1\17\1\20\1\21\1\22\1\23"+
    "\1\24\1\25\1\26\1\27\1\30\1\31\1\32\1\33"+
    "\1\34\1\35\1\36\1\37\1\40\2\41\1\42\1\43"+
    "\2\44\1\40\2\4\4\1\1\45\1\46\1\47\1\1"+
    "\2\50\1\51\1\1\1\52\1\53\1\54\1\55\2\56"+
    "\1\57\1\60\1\0\1\61\1\62\1\63\1\0\1\64"+
    "\1\65\1\66\1\5\1\67\1\70\5\5\1\71\6\5"+
    "\1\0\3\5\1\72\1\73\1\74\1\75\1\76\1\5"+
    "\1\77\7\5\1\100\3\5\1\101\5\5\1\102\1\103"+
    "\2\0\12\5\1\104\4\5\1\105\2\5\1\106\1\5"+
    "\1\107\5\5\1\110\17\5\1\111\1\112\1\113\1\114"+
    "\1\115\1\116\1\105\1\117\1\120\1\121\1\122\1\123"+
    "\1\124\1\125\1\126\1\127\1\130\1\131\1\132\1\133"+
    "\1\134\1\135\1\1\1\136\1\137\1\64\1\0\1\5"+
    "\1\140\2\5\1\141\7\5\1\142\5\5\1\143\3\5"+
    "\1\144\1\145\6\5\2\73\1\146\10\5\1\147\2\5"+
    "\1\150\1\5\1\151\1\5\1\152\1\5\1\153\1\154"+
    "\2\0\1\5\1\155\14\5\1\156\4\5\1\157\3\5"+
    "\1\160\4\5\1\161\3\5\1\162\1\163\1\115\1\164"+
    "\1\165\5\5\1\166\5\5\1\167\10\5\1\170\1\171"+
    "\1\172\1\173\1\174\1\1\5\5\1\175\1\5\1\176"+
    "\4\5\1\177\6\5\1\200\4\5\1\201\1\202\1\203"+
    "\12\5\1\204\1\205\5\5\1\206\1\5\1\207\2\5"+
    "\2\0\11\5\1\210\2\5\1\211\4\5\1\212\1\213"+
    "\1\5\1\214\1\5\1\215\1\216\1\5\1\217\16\5"+
    "\1\220\1\5\1\221\1\5\1\222\1\223\1\5\1\224"+
    "\1\5\1\225\3\5\1\226\5\5\1\227\2\5\1\230"+
    "\1\231\1\5\1\232\4\5\1\106\4\5\1\233\2\5"+
    "\1\234\1\235\12\5\1\236\1\5\1\237\2\0\1\240"+
    "\4\5\1\241\1\5\1\242\3\5\1\243\11\5\1\244"+
    "\3\5\1\245\11\5\1\246\2\5\1\247\1\250\1\5"+
    "\1\251\1\252\5\5\1\253\7\5\1\254\1\5\1\255"+
    "\10\5\1\256\6\5\1\257\1\0\2\5\1\260\3\5"+
    "\1\261\1\262\5\5\1\263\1\264\13\5\1\265\1\5"+
    "\1\266\7\5\1\267\1\270\3\5\1\271\2\5\1\272"+
    "\1\273\1\274\1\5\1\275\3\5\1\276\1\277\2\5"+
    "\1\300\4\5\1\0\1\5\1\301\3\5\1\302\2\5"+
    "\1\303\6\5\1\304\1\305\1\306\1\307\1\5\1\310"+
    "\2\5\1\311\1\312\1\313\1\314\3\5\1\315\2\5"+
    "\1\316\4\5\1\317\1\320\1\5\1\321\1\322\1\5"+
    "\1\323\1\5\1\0\1\5\1\324\5\5\1\325\1\5"+
    "\1\326\1\5\1\327\1\330\1\331\3\5\1\332\2\5"+
    "\1\333\1\334\2\5\1\335\1\336\1\337\1\0\1\340"+
    "\4\5\1\341\1\342\1\5\1\343\1\5\1\344\2\5"+
    "\1\345\1\5\1\0\1\346\6\5\1\347\1\350\1\0"+
    "\1\351\1\5\1\352\1\353\1\5\1\354\1\0\2\5"+
    "\1\0\1\5\1\355\1\356\1\357";

  private static int [] zzUnpackAction() {
    int [] result = new int[733];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\103\0\206\0\311\0\u010c\0\u014f\0\u0192\0\u01d5"+
    "\0\u0218\0\u025b\0\u029e\0\u02e1\0\u0324\0\u0367\0\u03aa\0\u03ed"+
    "\0\u0430\0\u0473\0\u04b6\0\u04f9\0\u053c\0\u057f\0\u05c2\0\u0605"+
    "\0\u0648\0\u029e\0\u068b\0\u06ce\0\u0711\0\u0754\0\u0797\0\u07da"+
    "\0\u081d\0\u0860\0\u029e\0\u08a3\0\u08e6\0\u0929\0\u096c\0\u09af"+
    "\0\u09f2\0\u0a35\0\u0a78\0\u0abb\0\u0afe\0\u029e\0\u029e\0\u0b41"+
    "\0\u029e\0\u029e\0\u0b84\0\u0bc7\0\u0c0a\0\u0c4d\0\u0c90\0\u0cd3"+
    "\0\u0d16\0\u0d59\0\u029e\0\u029e\0\u029e\0\u029e\0\u029e\0\u0d9c"+
    "\0\u029e\0\u0ddf\0\u029e\0\u0e22\0\u029e\0\u0ddf\0\u0e65\0\u029e"+
    "\0\u0ea8\0\u029e\0\u0eeb\0\u0f2e\0\u0f71\0\u029e\0\u029e\0\u029e"+
    "\0\u0fb4\0\u029e\0\u0ff7\0\u103a\0\u107d\0\u10c0\0\u029e\0\u029e"+
    "\0\u029e\0\u029e\0\u1103\0\u10c0\0\u103a\0\u02e1\0\u029e\0\u029e"+
    "\0\u1146\0\u1189\0\u029e\0\u029e\0\u0367\0\u11cc\0\u120f\0\u1252"+
    "\0\u1295\0\u12d8\0\u131b\0\u135e\0\u13a1\0\u029e\0\u13e4\0\u1427"+
    "\0\u146a\0\u14ad\0\u14f0\0\u1533\0\u1576\0\u15b9\0\u15fc\0\u163f"+
    "\0\u1682\0\u16c5\0\u029e\0\u029e\0\u029e\0\u1708\0\u029e\0\u174b"+
    "\0\u178e\0\u17d1\0\u1814\0\u1857\0\u189a\0\u18dd\0\u029e\0\u1920"+
    "\0\u1963\0\u19a6\0\u029e\0\u19e9\0\u1a2c\0\u1a6f\0\u1ab2\0\u1af5"+
    "\0\u1b38\0\u029e\0\u1b7b\0\u1bbe\0\u1c01\0\u1c44\0\u1c87\0\u1cca"+
    "\0\u1d0d\0\u1d50\0\u1d93\0\u1dd6\0\u1e19\0\u1e5c\0\u0367\0\u1e9f"+
    "\0\u1ee2\0\u1f25\0\u1f68\0\u0367\0\u1fab\0\u1fee\0\u2031\0\u2074"+
    "\0\u0367\0\u20b7\0\u20fa\0\u213d\0\u2180\0\u21c3\0\u0367\0\u2206"+
    "\0\u2249\0\u228c\0\u22cf\0\u2312\0\u2355\0\u2398\0\u23db\0\u241e"+
    "\0\u2461\0\u24a4\0\u24e7\0\u252a\0\u256d\0\u25b0\0\u029e\0\u25f3"+
    "\0\u029e\0\u029e\0\u029e\0\u029e\0\u029e\0\u029e\0\u2636\0\u029e"+
    "\0\u2679\0\u26bc\0\u029e\0\u029e\0\u029e\0\u029e\0\u029e\0\u029e"+
    "\0\u029e\0\u029e\0\u029e\0\u029e\0\u26ff\0\u029e\0\u029e\0\u2742"+
    "\0\u2742\0\u2785\0\u0367\0\u27c8\0\u280b\0\u284e\0\u2891\0\u28d4"+
    "\0\u2917\0\u295a\0\u299d\0\u29e0\0\u2a23\0\u0367\0\u2a66\0\u2aa9"+
    "\0\u2aec\0\u2b2f\0\u2b72\0\u2bb5\0\u2bf8\0\u2c3b\0\u2c7e\0\u1576"+
    "\0\u2cc1\0\u2d04\0\u2d47\0\u2d8a\0\u2dcd\0\u2e10\0\u2e53\0\u029e"+
    "\0\u2e96\0\u029e\0\u2ed9\0\u2f1c\0\u2f5f\0\u2fa2\0\u2fe5\0\u3028"+
    "\0\u306b\0\u30ae\0\u029e\0\u30f1\0\u3134\0\u029e\0\u3177\0\u029e"+
    "\0\u31ba\0\u0367\0\u31fd\0\u0367\0\u029e\0\u3240\0\u3283\0\u32c6"+
    "\0\u0367\0\u3309\0\u334c\0\u338f\0\u33d2\0\u3415\0\u3458\0\u349b"+
    "\0\u34de\0\u3521\0\u3564\0\u35a7\0\u35ea\0\u0367\0\u362d\0\u3670"+
    "\0\u36b3\0\u36f6\0\u0367\0\u3739\0\u377c\0\u37bf\0\u0367\0\u3802"+
    "\0\u3845\0\u3888\0\u38cb\0\u0367\0\u390e\0\u3951\0\u3994\0\u0367"+
    "\0\u0367\0\u0367\0\u0367\0\u0367\0\u39d7\0\u3a1a\0\u3a5d\0\u3aa0"+
    "\0\u3ae3\0\u0367\0\u3b26\0\u3b69\0\u3bac\0\u3bef\0\u3c32\0\u0367"+
    "\0\u3c75\0\u3cb8\0\u3cfb\0\u3d3e\0\u3d81\0\u3dc4\0\u3e07\0\u3e4a"+
    "\0\u029e\0\u029e\0\u029e\0\u3e8d\0\u029e\0\u3ed0\0\u3f13\0\u3f56"+
    "\0\u3f99\0\u3fdc\0\u401f\0\u0367\0\u4062\0\u0367\0\u40a5\0\u40e8"+
    "\0\u412b\0\u416e\0\u0367\0\u41b1\0\u41f4\0\u4237\0\u427a\0\u42bd"+
    "\0\u4300\0\u4343\0\u4386\0\u43c9\0\u440c\0\u444f\0\u0367\0\u029e"+
    "\0\u0367\0\u4492\0\u44d5\0\u4518\0\u455b\0\u459e\0\u45e1\0\u4624"+
    "\0\u4667\0\u46aa\0\u46ed\0\u0367\0\u0367\0\u4730\0\u4773\0\u47b6"+
    "\0\u47f9\0\u483c\0\u0367\0\u487f\0\u0367\0\u48c2\0\u4905\0\u4948"+
    "\0\u498b\0\u49ce\0\u4a11\0\u4a54\0\u4a97\0\u4ada\0\u4b1d\0\u4b60"+
    "\0\u4ba3\0\u4be6\0\u0367\0\u4c29\0\u4c6c\0\u0367\0\u4caf\0\u4cf2"+
    "\0\u4d35\0\u4d78\0\u4dbb\0\u0367\0\u4dfe\0\u0367\0\u4e41\0\u4e84"+
    "\0\u0367\0\u4ec7\0\u0367\0\u4f0a\0\u4f4d\0\u4f90\0\u4fd3\0\u5016"+
    "\0\u5059\0\u509c\0\u50df\0\u5122\0\u5165\0\u51a8\0\u51eb\0\u522e"+
    "\0\u5271\0\u0367\0\u52b4\0\u0367\0\u52f7\0\u533a\0\u0367\0\u537d"+
    "\0\u0367\0\u53c0\0\u029e\0\u5403\0\u5446\0\u5489\0\u0367\0\u54cc"+
    "\0\u550f\0\u5552\0\u5595\0\u55d8\0\u0367\0\u561b\0\u565e\0\u0367"+
    "\0\u0367\0\u56a1\0\u0367\0\u56e4\0\u5727\0\u576a\0\u57ad\0\u0367"+
    "\0\u57f0\0\u5833\0\u5876\0\u58b9\0\u0367\0\u58fc\0\u593f\0\u0367"+
    "\0\u5982\0\u59c5\0\u5a08\0\u5a4b\0\u5a8e\0\u5ad1\0\u5b14\0\u5b57"+
    "\0\u5b9a\0\u5bdd\0\u5c20\0\u5c63\0\u5ca6\0\u029e\0\u5ce9\0\u5d2c"+
    "\0\u029e\0\u5d6f\0\u5db2\0\u5df5\0\u5e38\0\u0367\0\u5e7b\0\u0367"+
    "\0\u5ebe\0\u5f01\0\u5f44\0\u0367\0\u5f87\0\u5fca\0\u600d\0\u6050"+
    "\0\u6093\0\u60d6\0\u6119\0\u615c\0\u619f\0\u0367\0\u61e2\0\u6225"+
    "\0\u6268\0\u0367\0\u62ab\0\u62ee\0\u6331\0\u6374\0\u63b7\0\u63fa"+
    "\0\u643d\0\u6480\0\u64c3\0\u0367\0\u6506\0\u6549\0\u0367\0\u0367"+
    "\0\u658c\0\u0367\0\u0367\0\u65cf\0\u6612\0\u6655\0\u6698\0\u66db"+
    "\0\u0367\0\u671e\0\u6761\0\u67a4\0\u67e7\0\u682a\0\u686d\0\u68b0"+
    "\0\u0367\0\u68f3\0\u0367\0\u6936\0\u6979\0\u69bc\0\u69ff\0\u6a42"+
    "\0\u6a85\0\u6ac8\0\u6b0b\0\u0367\0\u6b4e\0\u6b91\0\u6bd4\0\u6c17"+
    "\0\u6c5a\0\u6c9d\0\u0367\0\u6ce0\0\u6d23\0\u6d66\0\u0367\0\u6da9"+
    "\0\u6dec\0\u6e2f\0\u0367\0\u0367\0\u6e72\0\u6eb5\0\u6ef8\0\u6f3b"+
    "\0\u6f7e\0\u0367\0\u0367\0\u6fc1\0\u7004\0\u7047\0\u708a\0\u70cd"+
    "\0\u7110\0\u7153\0\u7196\0\u71d9\0\u721c\0\u725f\0\u0367\0\u72a2"+
    "\0\u72e5\0\u7328\0\u736b\0\u73ae\0\u73f1\0\u7434\0\u7477\0\u74ba"+
    "\0\u0367\0\u0367\0\u74fd\0\u7540\0\u7583\0\u0367\0\u75c6\0\u7609"+
    "\0\u0367\0\u0367\0\u0367\0\u764c\0\u0367\0\u768f\0\u76d2\0\u7715"+
    "\0\u0367\0\u0367\0\u7758\0\u779b\0\u0367\0\u77de\0\u7821\0\u7864"+
    "\0\u78a7\0\u78ea\0\u792d\0\u0367\0\u7970\0\u79b3\0\u79f6\0\u0367"+
    "\0\u7a39\0\u7a7c\0\u0367\0\u7abf\0\u7b02\0\u7b45\0\u7b88\0\u7bcb"+
    "\0\u7c0e\0\u0367\0\u0367\0\u0367\0\u0367\0\u7c51\0\u0367\0\u7c94"+
    "\0\u7cd7\0\u0367\0\u0367\0\u0367\0\u0367\0\u7d1a\0\u7d5d\0\u7da0"+
    "\0\u0367\0\u7de3\0\u7e26\0\u0367\0\u7e69\0\u7eac\0\u7eef\0\u7f32"+
    "\0\u0367\0\u0367\0\u7f75\0\u0367\0\u0367\0\u7fb8\0\u0367\0\u7ffb"+
    "\0\u803e\0\u8081\0\u0367\0\u80c4\0\u8107\0\u814a\0\u818d\0\u81d0"+
    "\0\u0367\0\u8213\0\u0367\0\u8256\0\u0367\0\u0367\0\u0367\0\u8299"+
    "\0\u82dc\0\u831f\0\u0367\0\u8362\0\u83a5\0\u0367\0\u0367\0\u83e8"+
    "\0\u842b\0\u0367\0\u0367\0\u0367\0\u846e\0\u0367\0\u84b1\0\u84f4"+
    "\0\u8537\0\u857a\0\u0367\0\u0367\0\u85bd\0\u0367\0\u8600\0\u0367"+
    "\0\u8643\0\u8686\0\u0367\0\u86c9\0\u870c\0\u0367\0\u874f\0\u8792"+
    "\0\u87d5\0\u8818\0\u885b\0\u889e\0\u0367\0\u0367\0\u88e1\0\u0367"+
    "\0\u8924\0\u0367\0\u0367\0\u8967\0\u0367\0\u89aa\0\u89ed\0\u8a30"+
    "\0\u8a73\0\u8ab6\0\u0367\0\u029e\0\u0367";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[733];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\13\2\14\1\15\1\16\1\13\1\17\2\20\1\21"+
    "\1\22\1\23\2\24\1\25\1\26\1\27\1\30\1\31"+
    "\1\32\1\33\1\34\1\35\1\36\1\37\1\40\1\41"+
    "\1\16\1\42\1\43\1\44\1\45\1\46\1\47\1\50"+
    "\1\51\1\52\1\16\1\53\1\54\1\55\1\16\1\17"+
    "\1\56\1\57\1\60\1\61\1\62\1\63\1\64\1\65"+
    "\1\66\1\67\1\70\1\71\1\72\1\73\1\74\1\75"+
    "\1\76\1\77\2\13\1\27\1\45\1\52\1\46\1\100"+
    "\1\101\1\102\20\100\1\103\51\100\1\104\5\100\2\105"+
    "\1\106\3\105\1\107\3\105\1\107\1\105\3\107\1\105"+
    "\1\107\2\105\1\103\2\107\13\105\1\107\10\105\1\107"+
    "\24\105\1\107\3\105\30\110\1\111\52\110\1\112\3\113"+
    "\1\114\2\112\2\114\1\112\1\114\1\112\2\114\1\112"+
    "\2\114\1\112\1\115\1\116\4\114\2\112\3\114\1\112"+
    "\14\114\20\112\1\117\3\112\1\120\4\114\1\121\1\122"+
    "\1\123\20\121\1\124\57\121\1\125\1\122\1\123\73\125"+
    "\1\126\4\125\1\112\3\113\1\114\2\112\2\114\1\112"+
    "\1\114\1\112\2\114\1\112\2\114\2\112\1\127\4\114"+
    "\2\112\3\114\1\112\14\114\20\112\1\130\3\112\1\131"+
    "\4\114\1\125\1\132\1\133\73\125\1\134\4\125\1\121"+
    "\1\132\1\133\20\121\1\135\57\121\104\0\2\14\1\136"+
    "\102\0\1\15\103\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\15\16\24\0\4\16"+
    "\6\0\1\17\1\137\1\140\1\141\1\142\1\0\1\143"+
    "\1\144\1\17\33\0\1\17\34\0\5\16\1\0\1\16"+
    "\1\0\2\145\3\16\3\0\2\16\1\146\1\16\2\0"+
    "\1\147\2\16\1\0\1\16\1\150\13\16\24\0\1\16"+
    "\1\150\2\16\6\0\1\141\7\0\1\141\33\0\1\141"+
    "\34\0\5\16\1\0\1\16\1\0\3\16\1\151\1\16"+
    "\3\0\2\16\1\152\1\16\2\0\1\153\1\16\1\154"+
    "\1\0\1\16\1\155\13\16\24\0\1\16\1\155\2\16"+
    "\61\0\1\156\25\0\3\16\2\157\1\0\1\16\1\0"+
    "\5\16\3\0\3\16\1\160\2\0\2\16\1\161\1\0"+
    "\1\162\2\16\1\163\2\16\1\164\6\16\24\0\2\16"+
    "\1\164\1\16\6\0\1\17\1\137\1\140\1\141\1\142"+
    "\1\0\1\143\1\144\1\17\1\165\32\0\1\17\34\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\1\166\14\16\24\0\4\16\4\0\3\16"+
    "\2\167\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\1\170\3\16\1\171\10\16\24\0\4\16"+
    "\21\0\1\172\6\0\1\173\30\0\1\174\102\0\1\175"+
    "\25\0\5\16\1\0\1\16\1\0\3\16\1\176\1\16"+
    "\2\0\1\177\3\16\1\200\2\0\2\16\1\201\1\0"+
    "\1\202\2\16\1\203\11\16\24\0\4\16\4\0\3\16"+
    "\2\204\1\0\1\205\1\0\3\16\1\206\1\16\2\0"+
    "\1\207\4\16\2\0\2\16\1\210\1\0\3\16\1\211"+
    "\11\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\3\16\1\212\1\16\2\0\1\213\4\16\2\0\3\16"+
    "\1\0\1\214\14\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\3\16\1\215\1\16\3\0\4\16\2\0"+
    "\1\216\2\16\1\0\5\16\1\217\1\220\6\16\24\0"+
    "\2\16\1\220\1\16\30\0\1\221\30\0\1\222\46\0"+
    "\1\223\4\0\1\224\54\0\3\16\2\225\1\0\1\226"+
    "\1\0\5\16\3\0\1\227\1\16\1\230\1\231\2\0"+
    "\1\16\1\232\1\16\1\0\2\16\1\233\6\16\1\234"+
    "\3\16\24\0\3\16\1\233\4\0\3\16\2\235\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\3\16\1\236\11\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\2\237\3\16\3\0\3\16\1\240\2\0"+
    "\3\16\1\0\1\16\1\241\1\242\2\16\1\243\1\244"+
    "\6\16\24\0\1\16\1\241\1\244\1\242\4\0\5\16"+
    "\1\0\1\245\1\0\5\16\3\0\3\16\1\246\2\0"+
    "\3\16\1\0\1\247\14\16\24\0\4\16\4\0\3\16"+
    "\2\250\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\1\251\3\16\1\252\1\16\1\253\2\16"+
    "\1\254\3\16\24\0\2\16\1\253\1\16\4\0\5\16"+
    "\1\0\1\16\1\0\4\16\1\255\3\0\1\16\1\256"+
    "\2\16\2\0\1\257\1\16\1\260\1\0\1\16\1\261"+
    "\13\16\24\0\1\255\1\261\2\16\4\0\5\16\1\0"+
    "\1\262\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\3\16\1\263"+
    "\2\16\1\264\6\16\24\0\2\16\1\264\1\16\4\0"+
    "\5\16\1\0\1\265\1\0\5\16\3\0\3\16\1\266"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\267\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\1\270\5\16\1\271\6\16\24\0\2\16\1\271"+
    "\1\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\1\272\2\16\1\273\11\16"+
    "\24\0\4\16\4\0\3\16\2\274\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\6\16\1\275"+
    "\2\16\1\276\3\16\24\0\2\16\1\275\1\16\61\0"+
    "\1\277\101\0\1\300\103\0\1\301\102\0\1\302\1\303"+
    "\101\0\1\304\1\0\1\305\100\0\1\306\2\0\1\307"+
    "\77\0\1\310\3\0\1\311\75\0\1\312\103\0\1\313"+
    "\21\0\1\100\2\0\20\100\1\0\51\100\1\0\5\100"+
    "\1\0\1\101\116\0\1\314\5\0\1\315\51\0\1\316"+
    "\1\317\1\320\1\321\1\322\1\323\6\0\1\107\3\0"+
    "\1\107\1\0\3\107\1\0\1\107\3\0\2\107\13\0"+
    "\1\107\10\0\1\107\24\0\1\107\24\0\1\324\62\0"+
    "\3\113\103\0\5\114\1\0\1\114\1\0\5\114\3\0"+
    "\4\114\2\0\3\114\1\0\15\114\24\0\4\114\22\0"+
    "\1\325\60\0\1\121\2\0\20\121\1\0\57\121\1\0"+
    "\1\122\124\0\1\326\57\0\1\125\2\0\73\125\1\0"+
    "\4\125\76\0\1\327\5\0\1\132\107\0\1\141\3\0"+
    "\1\142\1\0\1\143\1\144\1\141\33\0\1\141\36\0"+
    "\1\330\4\0\1\331\2\0\1\330\3\0\1\331\27\0"+
    "\1\330\34\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\5\16\1\332\7\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\3\16\1\333\11\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\1\334\2\16\1\0\1\335\1\16\1\336"+
    "\2\16\1\337\7\16\24\0\3\16\1\336\4\0\3\16"+
    "\2\340\1\0\1\341\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\2\16\1\342\12\16\24\0\3\16\1\342"+
    "\4\0\5\16\1\0\1\16\1\0\4\16\1\343\3\0"+
    "\4\16\2\0\3\16\1\0\15\16\24\0\1\343\3\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\1\344"+
    "\3\16\2\0\3\16\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\1\345\2\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\1\16\1\346\1\16"+
    "\1\347\2\0\3\16\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\350\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\6\16\1\351\6\16\24\0\2\16\1\351"+
    "\1\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\1\16\1\352\13\16\24\0"+
    "\1\16\1\352\2\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\1\353\14\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\6\16\1\354\6\16"+
    "\24\0\2\16\1\354\1\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\2\16\1\355\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\356\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\1\357\14\16"+
    "\24\0\4\16\6\0\1\360\3\0\1\360\1\0\3\360"+
    "\1\0\1\360\3\0\2\360\13\0\1\360\10\0\1\360"+
    "\24\0\1\360\7\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\6\16\1\361\6\16"+
    "\24\0\2\16\1\361\1\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\1\16"+
    "\1\362\6\16\1\363\4\16\24\0\1\16\1\362\2\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\1\364\14\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\1\16\1\365\1\366\2\16\1\367\7\16"+
    "\24\0\1\16\1\365\1\16\1\366\1\172\1\370\1\371"+
    "\100\172\4\0\5\16\1\0\1\16\1\0\5\16\2\0"+
    "\1\372\4\16\2\0\3\16\1\0\15\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\6\16\1\373\6\16\24\0\2\16"+
    "\1\373\1\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\1\374\14\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\1\16\1\375\13\16\24\0"+
    "\1\16\1\375\2\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\1\376\1\16\1\377\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\1\u0100\2\16\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\1\u0101\3\16\2\0\2\16\1\u0102\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\2\0\1\u0103\4\16\2\0\3\16\1\0\15\16\24\0"+
    "\4\16\4\0\3\16\2\u0104\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\15\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\2\16\1\u0105\12\16\24\0\3\16"+
    "\1\u0105\4\0\5\16\1\0\1\16\1\0\5\16\2\0"+
    "\1\u0106\4\16\2\0\3\16\1\0\15\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\7\16\1\u0107\5\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\2\0\1\u0108"+
    "\4\16\2\0\3\16\1\0\15\16\24\0\4\16\4\0"+
    "\3\16\2\u0109\1\0\1\u010a\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\1\16\1\u010b\2\16"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\2\16"+
    "\1\u010c\1\0\15\16\24\0\4\16\61\0\1\u010d\55\0"+
    "\1\u010e\101\0\1\u010f\53\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\1\16\1\u0110"+
    "\13\16\24\0\1\16\1\u0110\2\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\2\16\1\u0111\3\16\1\u0112\6\16\24\0\2\16\1\u0112"+
    "\1\u0111\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\6\16\1\u0113\6\16\24\0"+
    "\2\16\1\u0113\1\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\3\16\1\u0114"+
    "\11\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\5\16\1\u0115"+
    "\7\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\2\16\1\u0116\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\3\16\1\u0117\2\16"+
    "\1\u0118\6\16\24\0\2\16\1\u0118\1\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\1\u0119\14\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\4\16\1\u011a\3\0\4\16\2\0\3\16"+
    "\1\0\15\16\24\0\1\u011a\3\16\4\0\5\16\1\0"+
    "\1\16\1\0\4\16\1\u011b\3\0\4\16\2\0\1\u011c"+
    "\2\16\1\0\1\16\1\u011d\13\16\24\0\1\u011b\1\u011d"+
    "\2\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\2\16\1\u011e\12\16\24\0"+
    "\3\16\1\u011e\4\0\5\16\1\0\1\u011f\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\15\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\11\16\1\u0120\3\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\u0121\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\3\16\1\u0122\1\16\3\0\4\16"+
    "\2\0\3\16\1\0\12\16\1\u0123\2\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\2\16"+
    "\1\u0124\1\16\2\0\2\16\1\u0125\1\0\15\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\1\u0126\3\16\2\0\3\16\1\0\2\16\1\u0127\12\16"+
    "\24\0\3\16\1\u0127\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\2\16\1\u0128\1\16\2\0\3\16\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\5\16\1\u0129"+
    "\7\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\3\16\1\u012a\2\0\3\16\1\0\3\16"+
    "\1\u012b\1\u012c\10\16\24\0\4\16\4\0\3\16\2\u012d"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\6\16\1\u012e\6\16\24\0\2\16\1\u012e\1\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\1\u012f\2\16\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\1\16\1\u0130"+
    "\2\16\2\0\3\16\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\2\16\1\u0131\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\1\16\1\u0132\2\16"+
    "\2\0\3\16\1\0\4\16\1\u0133\10\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\1\u0134\2\16\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\1\u0135\3\16"+
    "\2\0\1\u0136\2\16\1\0\15\16\24\0\4\16\4\0"+
    "\3\16\2\u0137\1\0\1\u0138\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\1\u0139\14\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\2\u013a\3\16\3\0\1\u013b"+
    "\3\16\2\0\2\16\1\u013c\1\0\2\16\1\u013d\2\16"+
    "\1\u013e\7\16\24\0\3\16\1\u013d\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\1\16\1\u013f\13\16\24\0\1\16\1\u013f\2\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\2\16\1\u0140\12\16\24\0\3\16\1\u0140"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\2\16\1\u0141\12\16\24\0\3\16"+
    "\1\u0141\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\1\u0142\14\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\2\16\1\u0143\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\1\16\1\u0144\13\16\24\0\1\16\1\u0144"+
    "\2\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\2\16\1\u0145\12\16\24\0"+
    "\3\16\1\u0145\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\3\16\1\u0146\11\16"+
    "\24\0\4\16\4\0\3\16\2\u0147\1\0\1\u0148\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\15\16\24\0"+
    "\4\16\61\0\1\u0149\102\0\1\u014a\102\0\1\u014b\3\0"+
    "\1\u014c\76\0\1\u014d\21\0\1\325\1\112\1\u014e\100\325"+
    "\6\0\1\330\7\0\1\330\33\0\1\330\34\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\2\16"+
    "\1\u014f\1\0\1\u0150\14\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\u0151\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\3\16\1\u0152\2\0\3\16\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\u0153\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\1\u0154\14\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\3\16\1\u0155\11\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\2\16\1\u0156\12\16"+
    "\24\0\3\16\1\u0156\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\1\u0157\3\16\2\0\3\16\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\u0158\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\15\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\u0159\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\3\16\1\u015a\11\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\u015b\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\2\16\1\u015c\1\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\2\16\1\u015d\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\1\u015e\2\16\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\1\u015f\3\16\2\0\3\16\1\0\15\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\3\16\1\u0160\11\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\u0161\1\0\5\16\3\0"+
    "\2\16\1\u0162\1\u0163\2\0\3\16\1\0\12\16\1\u0164"+
    "\2\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\1\u0165\2\16\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\u0166\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\15\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\2\16"+
    "\1\u0167\1\16\2\0\3\16\1\0\15\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\15\16\6\0\1\u0168\15\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\1\16"+
    "\1\u0169\2\16\2\0\3\16\1\0\15\16\24\0\4\16"+
    "\4\0\3\16\2\u016a\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\2\16\1\u016b\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\3\16\1\u016c\11\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\u016d\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\1\u016e"+
    "\14\16\24\0\4\16\1\0\1\370\105\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\6\16\1\u016f\6\16\24\0\2\16\1\u016f\1\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\1\u0170\2\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\1\u0171"+
    "\2\16\1\0\2\16\1\u0172\4\16\1\u0173\5\16\24\0"+
    "\3\16\1\u0172\4\0\5\16\1\0\1\u0174\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\15\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\2\16\1\u0175\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\5\16\1\u0176\7\16\24\0\4\16\4\0"+
    "\3\16\2\u0177\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\6\16\1\u0178\6\16\24\0\2\16"+
    "\1\u0178\1\16\4\0\5\16\1\0\1\u0179\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\15\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\1\u017a"+
    "\3\16\2\0\3\16\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\u017b\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\3\16\1\u017c\11\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\u017d\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\15\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\1\16\1\u017e\13\16\24\0\1\16\1\u017e\2\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\3\16\1\u017f\11\16\24\0\4\16\7\0"+
    "\2\u0180\126\0\1\u0181\52\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\10\16\1\u0182"+
    "\4\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\7\16\1\u0183"+
    "\5\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\1\u0184\14\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\2\16\1\u0185\1\0\15\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\u0186\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\1\16\1\u0187\13\16\24\0\1\16\1\u0187"+
    "\2\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\1\u0188\3\16\2\0\3\16\1\0\2\16\1\u0189\12\16"+
    "\24\0\3\16\1\u0189\4\0\3\16\2\u018a\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\12\16\1\u018b\2\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\6\16\1\u018c\6\16"+
    "\24\0\2\16\1\u018c\1\16\4\0\5\16\1\0\1\u018d"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\2\16\1\u018e\12\16"+
    "\24\0\3\16\1\u018e\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\10\16\1\u018f"+
    "\4\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\3\16\1\u0190\1\16\3\0\4\16\2\0\3\16\1\0"+
    "\7\16\1\u0191\5\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\u0192\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\1\16\1\u0193"+
    "\13\16\24\0\1\16\1\u0193\2\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\2\16\1\u0194\12\16\24\0\3\16\1\u0194\4\0\5\16"+
    "\1\0\1\16\1\0\4\16\1\u0195\3\0\4\16\2\0"+
    "\3\16\1\0\15\16\24\0\1\u0195\3\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\2\16"+
    "\1\u0196\1\0\15\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\3\16\1\u0197\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\u0198"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\u0199\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\15\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\u0134\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\1\16\1\u019a\13\16\24\0\1\16\1\u019a\2\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\1\u019b\2\16\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\1\u019c\14\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\1\u019d\14\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\13\16\1\u019e\1\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\1\u019f\2\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\1\16"+
    "\1\u01a0\5\16\1\u01a1\5\16\24\0\1\16\1\u01a0\2\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\5\16\1\u01a2\1\16\1\u01a3\5\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\10\16\1\u01a4\4\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\1\u01a5\14\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\3\16\1\u01a6\11\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\3\16\1\u01a7\2\0\3\16\1\0\15\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\2\16\1\u01a8\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\3\16\1\u01a9"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\1\u01aa\14\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\3\16\1\u01ab\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\1\16\1\u01ac\2\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\1\16\1\u01ad\2\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\11\16"+
    "\1\u01ae\3\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\5\16"+
    "\1\u01af\7\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\2\16\1\u01b0\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\1\16\1\u01b1"+
    "\4\16\1\u01b2\6\16\24\0\1\16\1\u01b1\1\u01b2\1\16"+
    "\61\0\1\u01b3\22\0\1\112\105\0\5\16\1\0\1\u01b4"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\6\16\1\u01b5\6\16"+
    "\24\0\2\16\1\u01b5\1\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\6\16"+
    "\1\u01b6\6\16\24\0\2\16\1\u01b6\1\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\2\16\1\u01b7\12\16\24\0\3\16\1\u01b7\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\6\16\1\u01b8\6\16\24\0\2\16\1\u01b8"+
    "\1\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\6\16\1\u01b9\6\16\24\0"+
    "\2\16\1\u01b9\1\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\3\16\1\u01ba\2\0\3\16\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\1\16\1\u01bb\4\16"+
    "\1\u01bc\6\16\24\0\1\16\1\u01bb\1\u01bc\1\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\1\16\1\u01bd"+
    "\2\16\2\0\3\16\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\5\16\1\u01be\7\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\u01bf\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\15\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\1\16\1\u01c0\2\16\2\0"+
    "\3\16\1\0\15\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\2\16\1\u01c1\12\16\24\0\3\16\1\u01c1\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\2\16\1\u01c2\12\16\24\0\3\16\1\u01c2\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\2\16\1\u01c3\12\16\24\0\3\16\1\u01c3"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\3\16\1\u01c4\11\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\10\16\1\u01c5\4\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\5\16\1\u01c6\7\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\3\16\1\u01c7\11\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\u01c8\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\1\u01c9"+
    "\2\16\1\0\15\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\1\16\1\u01ca\13\16\24\0\1\16\1\u01ca\2\16\4\0"+
    "\5\16\1\0\1\u01cb\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\15\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\2\16\1\u01cc\1\16\2\0"+
    "\3\16\1\0\15\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\1\u01cd\2\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\1\u01ce\2\16\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\u01cf\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\15\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\u01d0\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\2\16\1\u01d1\12\16\24\0\3\16\1\u01d1"+
    "\4\0\3\16\2\u01d2\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\u01d3\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\15\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\2\16\1\u01d4"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\2\16\1\u01d5\1\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\u01d6"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\2\16\1\u01d7\5\16"+
    "\1\u01d8\4\16\24\0\3\16\1\u01d7\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\3\16\1\u01d9\11\16\24\0\4\16\4\0\3\16\2\u01da"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\2\16\1\u01db\12\16\24\0\3\16\1\u01db\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\10\16\1\u01dc\4\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\2\16\1\u01dd\12\16\24\0\3\16\1\u01dd"+
    "\1\0\3\u0180\31\0\1\u01de\46\0\3\u01df\20\0\1\u01e0"+
    "\10\0\1\u01e1\51\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\2\16\1\u01e2\1\0\15\16\24\0"+
    "\4\16\4\0\3\16\2\u01e3\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\15\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\2\16\1\u01e4\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\2\16\1\u01e5\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\6\16\1\u01e6\6\16\24\0\2\16\1\u01e6\1\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\3\16"+
    "\1\u01e7\2\0\3\16\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\13\16\1\u01e8\1\16\24\0\4\16\4\0"+
    "\3\16\2\u01e9\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\1\16\1\u01ea\13\16\24\0\1\16\1\u01ea\2\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\3\16\1\u01eb\11\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\2\16\1\u01ec\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\3\16\1\u01ed"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\1\u01ee\3\16\2\0"+
    "\3\16\1\0\15\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\u01ef\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\6\16\1\u01f0"+
    "\6\16\24\0\2\16\1\u01f0\1\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\3\16\1\u01f1\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\u01f2"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\6\16\1\u01f3\6\16"+
    "\24\0\2\16\1\u01f3\1\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\1\u01f4\2\16\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\1\u01f5\2\16\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\12\16\1\u01f6\2\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\2\16\1\u01f7\1\0\15\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\3\16\1\u01f8\11\16\24\0"+
    "\4\16\4\0\3\16\2\u01f9\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\15\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\2\16\1\u01fa\12\16\24\0\3\16"+
    "\1\u01fa\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\3\16\1\u01fb\11\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\3\16\1\u01fc\11\16\24\0"+
    "\4\16\4\0\3\16\2\u01fd\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\15\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\6\16\1\u01fe\6\16\24\0\2\16"+
    "\1\u01fe\1\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\6\16\1\u01ff\6\16"+
    "\24\0\2\16\1\u01ff\1\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\2\16"+
    "\1\u0200\12\16\24\0\3\16\1\u0200\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\6\16\1\u0201\6\16\24\0\2\16\1\u0201\1\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\3\16\1\u0202\11\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\1\16\1\u0203\13\16\24\0\1\16\1\u0203"+
    "\2\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\5\16\1\u0204\7\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\2\16\1\u0205\1\0\15\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\7\16\1\u0206\5\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\u0207\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\u0208\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\2\16\1\u0209\1\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\2\16"+
    "\1\u020a\12\16\24\0\3\16\1\u020a\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\2\16\1\u020b\12\16\24\0\3\16\1\u020b\4\0\5\16"+
    "\1\0\1\16\1\0\2\u020c\3\16\3\0\4\16\2\0"+
    "\3\16\1\0\15\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\u020d\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\2\16\1\u020e"+
    "\12\16\24\0\3\16\1\u020e\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\1\16\1\u020f\2\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\1\16"+
    "\1\u0210\13\16\24\0\1\16\1\u0210\2\16\4\0\5\16"+
    "\1\0\1\u0211\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\6\16"+
    "\1\u0212\6\16\24\0\2\16\1\u0212\1\16\4\0\3\16"+
    "\2\u0213\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\15\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\1\u0214\3\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\6\16"+
    "\1\u0215\6\16\24\0\2\16\1\u0215\1\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\1\16\1\u0216\2\16"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\6\16\1\u0217\6\16\24\0\2\16\1\u0217\1\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\1\16\1\u0218\1\16\1\0\15\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\2\16\1\u0219\12\16\24\0\3\16"+
    "\1\u0219\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\3\16\1\u021a\11\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\u021b\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\15\16\24\0\4\16\4\0"+
    "\3\16\2\u021c\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\1\16\1\u021d\13\16\24\0\1\16\1\u021d\2\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\6\16\1\u021e\6\16\24\0\2\16"+
    "\1\u021e\1\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\1\16\1\u021f\13\16"+
    "\24\0\1\16\1\u021f\2\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\6\16"+
    "\1\u0220\6\16\24\0\2\16\1\u0220\1\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\3\16\1\u0221\11\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\3\16\1\u0222\11\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\2\16\1\u0223\1\16"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\u0224\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\3\16"+
    "\1\u0225\11\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\2\16\1\u0226\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\2\16\1\u0227"+
    "\12\16\24\0\3\16\1\u0227\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\3\16"+
    "\1\u0228\11\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\5\16"+
    "\1\u0229\5\16\1\u022a\1\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\u022b\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\1\0\3\u01df\31\0\1\u01e1"+
    "\103\0\1\u022c\50\0\5\16\1\0\1\u022d\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\15\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\1\u022e"+
    "\3\16\2\0\3\16\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\2\16\1\u022f\1\0\15\16\24\0\4\16\4\0\3\16"+
    "\2\u0230\1\0\1\16\1\0\2\u0231\3\16\3\0\4\16"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\2\16"+
    "\1\u0232\1\0\15\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\1\u0233\3\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\10\16"+
    "\1\u0234\4\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\6\16"+
    "\1\u0235\6\16\24\0\2\16\1\u0235\1\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\3\16\1\u0236\11\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\u0237\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\1\16"+
    "\1\u0238\13\16\24\0\1\16\1\u0238\2\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\12\16\1\u0239\2\16\24\0\4\16\4\0\3\16"+
    "\2\u023a\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\15\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\6\16\1\u023b\6\16\24\0\2\16\1\u023b\1\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\1\u023c\2\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\2\16\1\u023d\12\16\24\0\3\16\1\u023d\4\0"+
    "\5\16\1\0\1\16\1\0\2\u023e\3\16\3\0\4\16"+
    "\2\0\3\16\1\0\3\16\1\u023f\11\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\3\16"+
    "\1\u0240\2\0\3\16\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\10\16\1\u0241\4\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\1\16\1\u0242\13\16\24\0\1\16\1\u0242"+
    "\2\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\2\16\1\u0243\12\16\24\0"+
    "\3\16\1\u0243\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\6\16\1\u0244\6\16"+
    "\24\0\2\16\1\u0244\1\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\1\u0245"+
    "\14\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\3\16\1\u0246"+
    "\11\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\1\16\1\u0247\2\16\2\0\3\16\1\0"+
    "\15\16\24\0\4\16\4\0\3\16\2\u0248\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\1\16\1\u0249\13\16"+
    "\24\0\1\16\1\u0249\2\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\1\u024a\3\16\2\0\3\16\1\0"+
    "\15\16\24\0\4\16\4\0\3\16\2\u024b\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\u024c\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\15\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\14\16\1\u024d\24\0\4\16\4\0"+
    "\5\16\1\0\1\u024e\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\15\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\3\16\1\u024f\11\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\1\16\1\u0250\13\16\24\0\1\16\1\u0250\2\16\4\0"+
    "\5\16\1\0\1\u0251\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\15\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\1\u0252\2\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\3\16"+
    "\1\u0253\11\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\3\16"+
    "\1\u0254\11\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\1\u0255"+
    "\14\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\11\16\1\u0256"+
    "\3\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\1\u0257\14\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\3\16\1\u0258\11\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\1\16\1\u0259\2\16\2\0\3\16\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\2\16\1\u025a\1\0\15\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\1\16\1\u025b\13\16\24\0"+
    "\1\16\1\u025b\2\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\2\16\1\u025c"+
    "\12\16\24\0\3\16\1\u025c\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\2\16"+
    "\1\u025d\12\16\24\0\3\16\1\u025d\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\3\16\1\u025e\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\3\16\1\u025f\2\0\3\16\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\1\u0260\2\16\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\4\16\1\u0261\10\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\2\16\1\u0262\1\0\15\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\u0263\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\2\16\1\u0264\12\16\24\0\3\16\1\u0264"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\2\16\1\u0265\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\u0266\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\15\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\4\16\1\u0267\3\0\4\16\2\0\3\16"+
    "\1\0\15\16\24\0\1\u0267\3\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\1\u0268\3\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\u0269"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\15\16"+
    "\24\0\4\16\37\0\1\u026a\40\0\1\u026a\6\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\6\16\1\u026b\6\16\24\0\2\16\1\u026b\1\16"+
    "\4\0\5\16\1\0\1\u026c\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\1\16\1\u026d\13\16\24\0\1\16\1\u026d\2\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\2\16\1\u026e\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\2\16\1\u026f\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\4\16\1\u0270\10\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\10\16\1\u0271\4\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\5\16\1\u0272\7\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\2\16\1\u0273\12\16\24\0\3\16\1\u0273\4\0"+
    "\3\16\2\u0274\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\1\u0275\14\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\3\16\1\u0276\11\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\u0277\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\1\u0278\3\16\2\0\3\16\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\2\16\1\u0279\12\16"+
    "\24\0\3\16\1\u0279\4\0\5\16\1\0\1\u027a\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\15\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\10\16\1\u027b\4\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\u027c\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\u027d\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\15\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\3\16\1\u027e\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\2\16\1\u027f\1\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\7\16"+
    "\1\u0280\5\16\24\0\4\16\4\0\3\16\2\u0281\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\1\u0282\2\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\u0283"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\2\16\1\u0284\12\16"+
    "\24\0\3\16\1\u0284\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\6\16\1\u0285"+
    "\6\16\24\0\2\16\1\u0285\1\16\4\0\5\16\1\0"+
    "\1\16\1\0\2\16\1\u0286\2\16\3\0\4\16\2\0"+
    "\3\16\1\0\15\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\1\16\1\u0287\13\16\24\0\1\16\1\u0287\2\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\1\u0288\3\16"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\2\16\1\u0289\12\16\24\0\3\16\1\u0289\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\2\16\1\u028a\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\2\16\1\u028b\12\16\24\0\3\16\1\u028b\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\1\16\1\u028c\13\16\24\0\1\16\1\u028c"+
    "\2\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\3\16\1\u028d\2\0\3\16\1\0\15\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\2\16\1\u028e\12\16\24\0\3\16"+
    "\1\u028e\4\0\3\16\2\u028f\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\15\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\1\u0290"+
    "\3\16\2\0\3\16\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\u0291\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\15\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\u0292\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\1\16\1\u0293"+
    "\13\16\24\0\1\16\1\u0293\2\16\4\0\5\16\1\0"+
    "\1\u0294\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\2\16\1\u0295\1\16\2\0\3\16\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\2\16\1\u0296\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\4\16"+
    "\1\u0297\3\0\4\16\2\0\3\16\1\0\15\16\24\0"+
    "\1\u0297\3\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\4\16\1\u0298\10\16"+
    "\24\0\4\16\25\0\1\u0299\61\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\1\u029a"+
    "\14\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\2\16\1\u029b"+
    "\12\16\24\0\3\16\1\u029b\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\1\u029c"+
    "\14\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\3\16\1\u029d"+
    "\11\16\24\0\4\16\4\0\5\16\1\0\1\u029e\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\15\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\2\16\1\u029f\12\16\24\0"+
    "\3\16\1\u029f\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\1\u02a0\2\16\1\0\15\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\6\16\1\u02a1\6\16\24\0"+
    "\2\16\1\u02a1\1\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\2\16\1\u02a2\1\16\2\0\3\16\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\6\16\1\u02a3"+
    "\6\16\24\0\2\16\1\u02a3\1\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\2\16\1\u02a4\12\16\24\0\3\16\1\u02a4\4\0\5\16"+
    "\1\0\1\u02a5\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\1\u02a6\2\16\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\u02a7\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\15\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\1\16\1\u02a8\13\16\24\0"+
    "\1\16\1\u02a8\2\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\1\u02a9\3\16\2\0\3\16\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\2\16\1\u02aa\12\16"+
    "\24\0\3\16\1\u02aa\4\0\5\16\1\0\1\u02ab\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\15\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\2\16\1\u02ac\12\16\24\0"+
    "\3\16\1\u02ac\4\0\3\16\2\u02ad\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\15\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\5\16\1\u02ae\7\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\u02af\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\1\u02b0\14\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\2\16\1\u02b1\12\16\24\0\3\16\1\u02b1\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\2\16\1\u02b2\12\16\24\0\3\16\1\u02b2"+
    "\4\0\5\16\1\0\1\u02b3\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\1\u02b4"+
    "\2\16\1\0\15\16\24\0\4\16\7\0\2\u02b5\76\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\12\16\1\u02b6\2\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\3\16\1\u02b7\11\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\4\16\1\u02b8\3\0\4\16"+
    "\2\0\3\16\1\0\15\16\24\0\1\u02b8\3\16\4\0"+
    "\5\16\1\0\1\16\1\0\4\16\1\u02b9\3\0\4\16"+
    "\2\0\3\16\1\0\15\16\24\0\1\u02b9\3\16\4\0"+
    "\3\16\2\u02ba\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\u02bb\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\5\16"+
    "\1\u02bc\7\16\24\0\4\16\4\0\3\16\2\u02bd\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\15\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\10\16\1\u02be"+
    "\4\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\1\u02bf\14\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\1\u02c0\2\16\1\0\15\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\4\16\1\u02c1\10\16\24\0"+
    "\4\16\4\0\5\16\1\0\1\16\1\0\5\16\3\0"+
    "\4\16\2\0\3\16\1\0\1\u02c2\14\16\24\0\4\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\1\16\1\u02c3\13\16\24\0\1\16"+
    "\1\u02c3\2\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\1\u02c4\14\16\24\0"+
    "\4\16\40\0\1\u02c5\41\0\1\u02c5\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\4\16\2\0\3\16\1\0"+
    "\2\16\1\u02c6\12\16\24\0\3\16\1\u02c6\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\2\16"+
    "\1\u02c7\1\0\15\16\24\0\4\16\4\0\5\16\1\0"+
    "\1\16\1\0\5\16\3\0\3\16\1\u02c8\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\1\u02c9"+
    "\14\16\24\0\4\16\4\0\5\16\1\0\1\16\1\0"+
    "\5\16\3\0\4\16\2\0\3\16\1\0\1\u02ca\14\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\2\16\1\u02cb\1\16\2\0\3\16\1\0\15\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\5\16\1\u02cc\7\16"+
    "\24\0\4\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\1\16\1\u02cd\13\16"+
    "\24\0\1\16\1\u02cd\2\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\6\16"+
    "\1\u02ce\6\16\24\0\2\16\1\u02ce\1\16\7\0\2\u02cf"+
    "\76\0\5\16\1\0\1\u02d0\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\15\16\24\0\4\16\4\0\5\16"+
    "\1\0\1\16\1\0\5\16\3\0\4\16\2\0\3\16"+
    "\1\0\1\16\1\u02d1\13\16\24\0\1\16\1\u02d1\2\16"+
    "\4\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\3\16\1\0\1\16\1\u02d2\13\16\24\0\1\16"+
    "\1\u02d2\2\16\4\0\5\16\1\0\1\16\1\0\5\16"+
    "\3\0\4\16\2\0\3\16\1\0\1\16\1\u02d3\13\16"+
    "\24\0\1\16\1\u02d3\2\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\5\16"+
    "\1\u02d4\7\16\24\0\4\16\4\0\5\16\1\0\1\u02d5"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\15\16"+
    "\24\0\4\16\36\0\1\u02d6\50\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\1\16\1\u02d7\2\16\2\0\3\16"+
    "\1\0\15\16\24\0\4\16\4\0\5\16\1\0\1\16"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\3\16"+
    "\1\u02d8\11\16\24\0\4\16\37\0\1\u02d9\40\0\1\u02d9"+
    "\6\0\5\16\1\0\1\16\1\0\5\16\3\0\4\16"+
    "\2\0\2\16\1\u02da\1\0\15\16\24\0\4\16\4\0"+
    "\5\16\1\0\1\16\1\0\5\16\3\0\4\16\2\0"+
    "\3\16\1\0\2\16\1\u02db\12\16\24\0\3\16\1\u02db"+
    "\1\0\3\u02d9\31\0\1\u02dc\51\0\5\16\1\0\1\u02dd"+
    "\1\0\5\16\3\0\4\16\2\0\3\16\1\0\15\16"+
    "\24\0\4\16";

  private static int [] zzUnpackTrans() {
    int [] result = new int[35577];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\4\0\1\1\2\0\1\1\2\0\1\11\16\1\1\11"+
    "\10\1\1\11\12\1\2\11\1\1\2\11\10\1\5\11"+
    "\1\1\1\11\1\1\1\11\1\1\1\11\2\1\1\11"+
    "\1\1\1\11\3\1\3\11\1\1\1\11\4\1\4\11"+
    "\3\1\1\0\2\11\1\1\1\0\2\11\11\1\1\11"+
    "\6\1\1\0\5\1\3\11\1\1\1\11\7\1\1\11"+
    "\3\1\1\11\6\1\1\11\2\0\52\1\1\11\1\1"+
    "\6\11\1\1\1\11\2\1\12\11\1\1\2\11\1\1"+
    "\1\0\36\1\1\11\1\1\1\11\10\1\1\11\2\1"+
    "\1\11\1\1\1\11\4\1\1\11\2\0\71\1\3\11"+
    "\1\1\1\11\32\1\1\11\27\1\2\0\61\1\1\11"+
    "\52\1\1\11\2\0\1\11\112\1\1\0\75\1\1\0"+
    "\56\1\1\0\33\1\1\0\17\1\1\0\11\1\1\0"+
    "\6\1\1\0\2\1\1\0\2\1\1\11\1\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[733];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
	private Symbol symbol(int type) {
		return new Symbol(type, yychar, yychar + yylength());
	}
	
	private Symbol symbol(int type, int offset, int length) {
		return new Symbol(type, offset, offset + length);
	}	

	private Symbol symbol(int type, Object value) {
		return new Symbol(type, yychar, yychar + yylength(), value);
	}
	
	private Symbol symbol(int type, Object value, int offset, int length) {
		return new Symbol(type, offset, offset + length, value);
	}
	
	private Symbol sqlStatement() {
		rawString.append("}");
		if(openingBraceOffset != "#sql{".length()) {
			lexerErrors.add(new SyntaxError(2206, startOffset + "#sql".length(), startOffset + openingBraceOffset - 1, SyntaxError.WARNING)); 
		}
		return symbol(NodeTypes.SQLSTMTLIT, new InlineSQLStatement(rawString.toString(), openingBraceOffset, startOffset, startOffset+rawString.length()), startOffset, rawString.length());
	}
	
	private Symbol sqlCondition() {
		rawString.append("}");
		if(openingBraceOffset != "#sqlcondition{".length()) {
			lexerErrors.add(new SyntaxError(2207, startOffset + "#sqlcondition".length(), startOffset + openingBraceOffset - 1, SyntaxError.WARNING)); 
		}
		return symbol(NodeTypes.SQLCONDITION, new InlineSQLStatement(rawString.toString(), openingBraceOffset, startOffset, startOffset+rawString.length()), startOffset, rawString.length());
	}
	
	private Symbol dli() {
		rawString.append("}");
		if(openingBraceOffset != "#dli{".length()) {
			lexerErrors.add(new SyntaxError(2208, startOffset + "#dli".length(), startOffset + openingBraceOffset - 1, SyntaxError.WARNING)); 
		}
		return symbol(NodeTypes.INLINE_DLI, new InlineDLIStatement(rawString.toString(), openingBraceOffset, startOffset, startOffset+rawString.length()), startOffset, rawString.length());
	}
	
	private Symbol byteslit() {
		String text = yytext();
		return symbol(NodeTypes.BYTESLIT, new BytesLiteral(text, text.substring(2), yychar, yychar + yylength()), yychar, yylength());
	}
	
	private Symbol bigintlit() {
		String text = yytext();
		return symbol(NodeTypes.BIGINTLIT, new IntegerLiteral(LiteralExpression.BIGINT_LITERAL, text.substring(0, text.length() - 1), yychar, yychar + yylength()), yychar, yylength());
	}
	
	private Symbol smallintlit() {
		String text = yytext();
		return symbol(NodeTypes.SMALLINTLIT, new IntegerLiteral(LiteralExpression.SMALLINT_LITERAL, text.substring(0, text.length() - 1), yychar, yychar + yylength()), yychar, yylength());
	}
	
	private Symbol floatlit() {
		String text = yytext();
		if (text.endsWith("F")) {
			return symbol(NodeTypes.FLOATLIT, new FloatLiteral(LiteralExpression.FLOAT_LITERAL, text.substring(0, text.length() - 1), yychar, yychar + yylength()), yychar, yylength());
		}
		return symbol(NodeTypes.FLOATLIT, new FloatLiteral(LiteralExpression.FLOAT_LITERAL, text, yychar, yychar + yylength()), yychar, yylength());
	}
	
	private Symbol smallfloatlit() {
		String text = yytext();
		return symbol(NodeTypes.SMALLFLOATLIT, new FloatLiteral(LiteralExpression.SMALLFLOAT_LITERAL, text.substring(0, text.length() - 1), yychar, yychar + yylength()), yychar, yylength());
	}
	
	private static final int LITERALTYPE_STRING		= 0;
	private static final int LITERALTYPE_HEX		= 1;
	private static final int LITERALTYPE_CHAR		= 2;
	private static final int LITERALTYPE_DBCHAR		= 3;
	private static final int LITERALTYPE_MBCHAR		= 4;
	private static final int LITERALTYPE_CHARHEX	= 5;
	private static final int LITERALTYPE_DBCHARHEX	= 6;
	private static final int LITERALTYPE_MBCHARHEX	= 7;
	private static final int LITERALTYPE_UNICODEHEX	= 8;
	
	private Symbol string() {
		switch(stringLiteralType) {
			case LITERALTYPE_STRING:	return symbol(NodeTypes.STRING, new StringLiteral(rawString.toString(), stringValue.toString(), false, startOffset, startOffset+rawString.length()), startOffset, rawString.length());
			case LITERALTYPE_HEX:		return symbol(NodeTypes.HEXLIT, new HexLiteral(rawString.toString(), stringValue.toString(), startOffset, startOffset+rawString.length()+1), startOffset, rawString.length()+1);
			case LITERALTYPE_CHAR:		return symbol(NodeTypes.CHARLIT, new CharLiteral(rawString.toString(), stringValue.toString(), false, startOffset, startOffset+rawString.length()+1), startOffset, rawString.length()+1);
			case LITERALTYPE_DBCHAR:	return symbol(NodeTypes.DBCHARLIT, new DBCharLiteral(rawString.toString(), stringValue.toString(), false, startOffset, startOffset+rawString.length()+1), startOffset, rawString.length()+1);
			case LITERALTYPE_MBCHAR:	return symbol(NodeTypes.MBCHARLIT, new MBCharLiteral(rawString.toString(), stringValue.toString(), false, startOffset, startOffset+rawString.length()+1), startOffset, rawString.length()+1);
			case LITERALTYPE_CHARHEX:	return symbol(NodeTypes.CHARLIT, new CharLiteral(rawString.toString(), stringValue.toString(), true, startOffset, startOffset+rawString.length()+2), startOffset, rawString.length()+2);
			case LITERALTYPE_DBCHARHEX:	return symbol(NodeTypes.DBCHARLIT, new DBCharLiteral(rawString.toString(), stringValue.toString(), true, startOffset, startOffset+rawString.length()+2), startOffset, rawString.length()+2);
			case LITERALTYPE_MBCHARHEX:	return symbol(NodeTypes.MBCHARLIT, new MBCharLiteral(rawString.toString(), stringValue.toString(), true, startOffset, startOffset+rawString.length()+2), startOffset, rawString.length()+2);
			case LITERALTYPE_UNICODEHEX:	return symbol(NodeTypes.STRING, new StringLiteral(rawString.toString(), stringValue.toString(), true, startOffset, startOffset+rawString.length()+2), startOffset, rawString.length()+2);
			default: throw new RuntimeException("Should not happen.");
		}
	}
	
	public List getLexerErrors() {
		return lexerErrors;
	}
	
	public void reset(Reader reader) {
		lexerErrors = new ArrayList();
		yyreset(reader);
	}
	protected int stringLiteralType;
	protected StringBuffer rawString = new StringBuffer();		// The raw string of delimited tokens (i.e. for string literals, including the ")
	protected StringBuffer stringValue = new StringBuffer();	// The canonical string of delimiated tokens (i.e. for string literals, excluding the ")
	protected int startOffset;									// The start offset of delimited tokens
	protected int openingBraceOffset;							// The offset of the opening brace for inline SQL and inline SQL Condition tokens
	
	protected boolean isSQLCondition;
	
	protected List lexerErrors = new ArrayList();
	
	protected boolean returnLineBreaks;
	protected boolean returnLineComments;
	protected boolean returnBlockComments;
	
	protected List lineBreaks = new ArrayList();
	protected List lineComments = new ArrayList();
	protected List blockComments = new ArrayList();


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public Lexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public Lexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1814) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 200: 
          { return symbol(NodeTypes.PROGRAM);
          }
        case 240: break;
        case 117: 
          { return symbol(NodeTypes.BOOLEANLIT, org.eclipse.edt.compiler.core.Boolean.YES);
          }
        case 241: break;
        case 1: 
          { rawString.append(yytext());
          }
        case 242: break;
        case 81: 
          { return symbol(NodeTypes.GE);
          }
        case 243: break;
        case 66: 
          { return symbol(NodeTypes.TIMESTIMES);
          }
        case 244: break;
        case 70: 
          { return symbol(NodeTypes.BOOLEANLIT, org.eclipse.edt.compiler.core.Boolean.NO);
          }
        case 245: break;
        case 123: 
          { return symbol(NodeTypes.RIGHTSHIFTLOGICAL);
          }
        case 246: break;
        case 234: 
          { return symbol(NodeTypes.ONEXCEPTION);
          }
        case 247: break;
        case 57: 
          { return symbol(NodeTypes.PLUSEQ);
          }
        case 248: break;
        case 215: 
          { return symbol(NodeTypes.ABSOLUTE);
          }
        case 249: break;
        case 10: 
          { return symbol(NodeTypes.MINUS);
          }
        case 250: break;
        case 121: 
          { return symbol(NodeTypes.LEFTSHIFTEQ);
          }
        case 251: break;
        case 144: 
          { return symbol(NodeTypes.GOTO);
          }
        case 252: break;
        case 185: 
          { return symbol(NodeTypes.FOREACH);
          }
        case 253: break;
        case 192: 
          { return symbol(NodeTypes.DLICALL);
          }
        case 254: break;
        case 126: 
          { return symbol(NodeTypes.EXIT);
          }
        case 255: break;
        case 30: 
          { return symbol(NodeTypes.AT);
          }
        case 256: break;
        case 53: 
          { return smallfloatlit();
          }
        case 257: break;
        case 169: 
          { return symbol(NodeTypes.IMPORT);
          }
        case 258: break;
        case 79: 
          { return symbol(NodeTypes.LE);
          }
        case 259: break;
        case 52: 
          { return floatlit();
          }
        case 260: break;
        case 138: 
          { return symbol(NodeTypes.OPEN);
          }
        case 261: break;
        case 199: 
          { return symbol(NodeTypes.PREPARE);
          }
        case 262: break;
        case 107: 
          { return symbol(NodeTypes.URL);
          }
        case 263: break;
        case 235: 
          { return symbol(NodeTypes.TRANSACTION);
          }
        case 264: break;
        case 225: 
          { return symbol(NodeTypes.OTHERWISE);
          }
        case 265: break;
        case 191: 
          { return symbol(NodeTypes.NUMERICPRIMITIVE, Primitive.DECIMAL);
          }
        case 266: break;
        case 122: 
          { return symbol(NodeTypes.RIGHTSHIFTARITHMETICEQ);
          }
        case 267: break;
        case 69: 
          { return symbol(NodeTypes.OR);
          }
        case 268: break;
        case 153: 
          { return symbol(NodeTypes.FIRST);
          }
        case 269: break;
        case 135: 
          { return symbol(NodeTypes.MOVE);
          }
        case 270: break;
        case 227: 
          { return symbol(NodeTypes.RETURNING);
          }
        case 271: break;
        case 164: 
          { return symbol(NodeTypes.THROW);
          }
        case 272: break;
        case 97: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.INT);
          }
        case 273: break;
        case 85: 
          { rawString.append("\\f");		stringValue.append('\f');
          }
        case 274: break;
        case 167: 
          { return symbol(NodeTypes.WHILE);
          }
        case 275: break;
        case 119: 
          { return symbol(NodeTypes.GET);
          }
        case 276: break;
        case 84: 
          { return symbol(NodeTypes.MODULOEQ);
          }
        case 277: break;
        case 60: 
          { yybegin(BLOCK_COMMENT); startOffset = yychar;
          }
        case 278: break;
        case 7: 
          { return symbol(NodeTypes.DOT);
          }
        case 279: break;
        case 221: 
          { return symbol(NodeTypes.DECREMENT);
          }
        case 280: break;
        case 187: 
          { return symbol(NodeTypes.FREESQL);
          }
        case 281: break;
        case 145: 
          { return symbol(NodeTypes.HOLD);
          }
        case 282: break;
        case 118: 
          { return symbol(NodeTypes.REF);
          }
        case 283: break;
        case 105: 
          { yybegin(HEXSTRING); stringLiteralType = LITERALTYPE_UNICODEHEX; rawString.setLength(0); rawString.append('\"'); stringValue.setLength(0); startOffset = yychar;
          }
        case 284: break;
        case 15: 
          { return symbol(NodeTypes.RPAREN);
          }
        case 285: break;
        case 206: 
          { return symbol(NodeTypes.FUNCTION);
          }
        case 286: break;
        case 68: 
          { return symbol(NodeTypes.OF);
          }
        case 287: break;
        case 59: 
          { Symbol symbol = symbol(NodeTypes.LINE_COMMENT); if(returnLineComments) lineComments.add(symbol); return symbol;
          }
        case 288: break;
        case 190: 
          { return symbol(NodeTypes.DISPLAY);
          }
        case 289: break;
        case 237: 
          { return symbol(NodeTypes.WITHV60COMPAT);
          }
        case 290: break;
        case 207: 
          { return symbol(NodeTypes.CONTINUE);
          }
        case 291: break;
        case 127: 
          { return symbol(NodeTypes.ELSE);
          }
        case 292: break;
        case 3: 
          { Symbol symbol = symbol(NodeTypes.LINEBREAKS); if(returnLineBreaks) lineBreaks.add(symbol); return symbol;
          }
        case 293: break;
        case 205: 
          { return symbol(NodeTypes.INPARENT);
          }
        case 294: break;
        case 46: 
          { yybegin(DLI); rawString.append(yytext());
          }
        case 295: break;
        case 40: 
          { yybegin(SQL); rawString.append(yytext());
          }
        case 296: break;
        case 89: 
          { rawString.append("\\b");		stringValue.append('\b');
          }
        case 297: break;
        case 25: 
          { return symbol(NodeTypes.QUESTION);
          }
        case 298: break;
        case 5: 
          { return symbol(NodeTypes.ID, yytext());
          }
        case 299: break;
        case 93: 
          { yybegin(YYINITIAL); Symbol symbol = symbol(NodeTypes.BLOCK_COMMENT, startOffset, yychar + 2 - startOffset); if(returnBlockComments) blockComments.add(symbol); return symbol;
          }
        case 300: break;
        case 120: 
          { return symbol(NodeTypes.CONCATEQ);
          }
        case 301: break;
        case 96: 
          { return symbol(NodeTypes.ISA);
          }
        case 302: break;
        case 197: 
          { return symbol(NodeTypes.PASSING);
          }
        case 303: break;
        case 21: 
          { return symbol(NodeTypes.BITAND);
          }
        case 304: break;
        case 44: 
          { yybegin(YYINITIAL); return dli();
          }
        case 305: break;
        case 55: 
          { return symbol(NodeTypes.IS);
          }
        case 306: break;
        case 86: 
          { rawString.append("\\\"");		stringValue.append('\"');
          }
        case 307: break;
        case 102: 
          { yybegin(HEXSTRING); stringLiteralType = LITERALTYPE_CHARHEX; rawString.setLength(0); rawString.append('\"'); stringValue.setLength(0); startOffset = yychar;
          }
        case 308: break;
        case 38: 
          { yybegin(YYINITIAL); return isSQLCondition ? sqlCondition() : sqlStatement();
          }
        case 309: break;
        case 28: 
          { return symbol(NodeTypes.RBRACKET);
          }
        case 310: break;
        case 202: 
          { return symbol(NodeTypes.REPLACE);
          }
        case 311: break;
        case 189: 
          { return symbol(NodeTypes.CURRENT);
          }
        case 312: break;
        case 184: 
          { return symbol(NodeTypes.EXTENDS);
          }
        case 313: break;
        case 216: 
          { return symbol(NodeTypes.PREVIOUS);
          }
        case 314: break;
        case 112: 
          { return symbol(NodeTypes.NOT);
          }
        case 315: break;
        case 43: 
          { yybegin(DLI_DBL_QUOTED_ID); rawString.append('\"');
          }
        case 316: break;
        case 177: 
          { return symbol(NodeTypes.STATIC);
          }
        case 317: break;
        case 178: 
          { return symbol(NodeTypes.CHARPRIMITIVE, Primitive.STRING);
          }
        case 318: break;
        case 108: 
          { return symbol(NodeTypes.TIMESTIMESEQ);
          }
        case 319: break;
        case 110: 
          { return symbol(NodeTypes.OUT);
          }
        case 320: break;
        case 134: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.DATE);
          }
        case 321: break;
        case 94: 
          { rawString.append("\"\"");
          }
        case 322: break;
        case 182: 
          { return symbol(NodeTypes.RETURN);
          }
        case 323: break;
        case 24: 
          { return symbol(NodeTypes.GT);
          }
        case 324: break;
        case 128: 
          { return symbol(NodeTypes.FORM);
          }
        case 325: break;
        case 196: 
          { return symbol(NodeTypes.PACKAGE);
          }
        case 326: break;
        case 64: 
          { yybegin(STRING); stringLiteralType = LITERALTYPE_DBCHAR; rawString.setLength(0); rawString.append('\"'); stringValue.setLength(0); startOffset = yychar;
          }
        case 327: break;
        case 48: 
          { yybegin(DLI); rawString.append('\"');
          }
        case 328: break;
        case 218: 
          { return symbol(NodeTypes.INTERFACE);
          }
        case 329: break;
        case 8: 
          { return symbol(NodeTypes.PLUS);
          }
        case 330: break;
        case 14: 
          { return symbol(NodeTypes.LPAREN);
          }
        case 331: break;
        case 74: 
          { return symbol(NodeTypes.CONCAT);
          }
        case 332: break;
        case 239: 
          { return symbol(NodeTypes.LANGUAGEBUNDLE);
          }
        case 333: break;
        case 148: 
          { return symbol(NodeTypes.WHEN);
          }
        case 334: break;
        case 152: 
          { return symbol(NodeTypes.FIELD);
          }
        case 335: break;
        case 161: 
          { return symbol(NodeTypes.SUPER);
          }
        case 336: break;
        case 156: 
          { return symbol(NodeTypes.CLOSE);
          }
        case 337: break;
        case 180: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.NUMBER);
          }
        case 338: break;
        case 115: 
          { return symbol(NodeTypes.ALL);
          }
        case 339: break;
        case 146: 
          { return symbol(NodeTypes.WITH);
          }
        case 340: break;
        case 31: 
          { return symbol(NodeTypes.NEGATE);
          }
        case 341: break;
        case 32: 
          { rawString.append(yytext());	stringValue.append(yytext());
          }
        case 342: break;
        case 23: 
          { return symbol(NodeTypes.LT);
          }
        case 343: break;
        case 158: 
          { return symbol(NodeTypes.USING);
          }
        case 344: break;
        case 228: 
          { return symbol(NodeTypes.IMPLEMENTS);
          }
        case 345: break;
        case 75: 
          { return symbol(NodeTypes.EQ);
          }
        case 346: break;
        case 194: 
          { return symbol(NodeTypes.LIBRARY);
          }
        case 347: break;
        case 159: 
          { yybegin(DLI); rawString.setLength(0); rawString.append(yytext()); startOffset = yychar; openingBraceOffset = yylength();
          }
        case 348: break;
        case 47: 
          { yybegin(DLI); rawString.append('\'');
          }
        case 349: break;
        case 16: 
          { return symbol(NodeTypes.BANG);
          }
        case 350: break;
        case 41: 
          { yybegin(SQL); rawString.append('\"');
          }
        case 351: break;
        case 65: 
          { yybegin(STRING); stringLiteralType = LITERALTYPE_MBCHAR; rawString.setLength(0); rawString.append('\"'); stringValue.setLength(0); startOffset = yychar;
          }
        case 352: break;
        case 62: 
          { return symbol(NodeTypes.MINUSEQ);
          }
        case 353: break;
        case 236: 
          { return symbol(NodeTypes.EXTERNALTYPE);
          }
        case 354: break;
        case 17: 
          { return symbol(NodeTypes.COMMA);
          }
        case 355: break;
        case 6: 
          { return symbol(NodeTypes.INTEGER, yytext());
          }
        case 356: break;
        case 18: 
          { return symbol(NodeTypes.SEMI);
          }
        case 357: break;
        case 163: 
          { return symbol(NodeTypes.LABEL);
          }
        case 358: break;
        case 179: 
          { return symbol(NodeTypes.OPENUI);
          }
        case 359: break;
        case 73: 
          { return symbol(NodeTypes.NE);
          }
        case 360: break;
        case 230: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.SMALLFLOAT);
          }
        case 361: break;
        case 203: 
          { return symbol(NodeTypes.RUNUNIT);
          }
        case 362: break;
        case 172: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.BIGINT);
          }
        case 363: break;
        case 137: 
          { return symbol(NodeTypes.LAST);
          }
        case 364: break;
        case 195: 
          { return symbol(NodeTypes.ONEVENT);
          }
        case 365: break;
        case 175: 
          { return symbol(NodeTypes.UPDATE);
          }
        case 366: break;
        case 101: 
          { return symbol(NodeTypes.XOR);
          }
        case 367: break;
        case 29: 
          { return symbol(NodeTypes.RCURLY);
          }
        case 368: break;
        case 61: 
          { return symbol(NodeTypes.DIVEQ);
          }
        case 369: break;
        case 211: 
          { return symbol(NodeTypes.USINGPCB);
          }
        case 370: break;
        case 171: 
          { return symbol(NodeTypes.ESCAPE);
          }
        case 371: break;
        case 51: 
          { return symbol(NodeTypes.DECIMALLIT, yytext());
          }
        case 372: break;
        case 42: 
          { yybegin(SQL); rawString.append('\'');
          }
        case 373: break;
        case 78: 
          { return symbol(NodeTypes.BITOREQ);
          }
        case 374: break;
        case 168: 
          { return symbol(NodeTypes.WHERE);
          }
        case 375: break;
        case 11: 
          { yybegin(STRING); stringLiteralType = LITERALTYPE_STRING; rawString.setLength(0); rawString.append('\"'); stringValue.setLength(0); startOffset = yychar;
          }
        case 376: break;
        case 72: 
          { return symbol(NodeTypes.AS);
          }
        case 377: break;
        case 174: 
          { return symbol(NodeTypes.DELETE);
          }
        case 378: break;
        case 204: 
          { return symbol(NodeTypes.HANDLER);
          }
        case 379: break;
        case 208: 
          { return symbol(NodeTypes.CONVERSE);
          }
        case 380: break;
        case 19: 
          { return symbol(NodeTypes.COLON);
          }
        case 381: break;
        case 176: 
          { return symbol(NodeTypes.SCROLL);
          }
        case 382: break;
        case 170: 
          { return symbol(NodeTypes.INSERT);
          }
        case 383: break;
        case 162: 
          { return symbol(NodeTypes.STACK);
          }
        case 384: break;
        case 229: 
          { return symbol(NodeTypes.BYPOSITION);
          }
        case 385: break;
        case 155: 
          { return symbol(NodeTypes.CHARPRIMITIVE, Primitive.BYTES);
          }
        case 386: break;
        case 99: 
          { return symbol(NodeTypes.FOR);
          }
        case 387: break;
        case 173: 
          { return symbol(NodeTypes.BYNAME);
          }
        case 388: break;
        case 37: 
          { yybegin(SQLDELIMITEDID); rawString.append('\"');
          }
        case 389: break;
        case 150: 
          { return symbol(NodeTypes.INOUT);
          }
        case 390: break;
        case 111: 
          { return symbol(NodeTypes.NEW);
          }
        case 391: break;
        case 95: 
          { rawString.append("\'\'");
          }
        case 392: break;
        case 160: 
          { yybegin(SQL); isSQLCondition = false; rawString.setLength(0); rawString.append(yytext()); startOffset = yychar; openingBraceOffset = yylength();
          }
        case 393: break;
        case 220: 
          { return symbol(NodeTypes.FORUPDATE);
          }
        case 394: break;
        case 88: 
          { rawString.append("\\\'");		stringValue.append('\'');
          }
        case 395: break;
        case 12: 
          { return symbol(NodeTypes.TIMES);
          }
        case 396: break;
        case 20: 
          { return symbol(NodeTypes.ASSIGN);
          }
        case 397: break;
        case 165: 
          { return symbol(NodeTypes.PRINT);
          }
        case 398: break;
        case 166: 
          { return symbol(NodeTypes.GROUP);
          }
        case 399: break;
        case 26: 
          { return symbol(NodeTypes.MODULO);
          }
        case 400: break;
        case 34: 
          { yybegin(YYINITIAL); rawString.append('\"'); return string();
          }
        case 401: break;
        case 147: 
          { return symbol(NodeTypes.WRAP);
          }
        case 402: break;
        case 67: 
          { return symbol(NodeTypes.TIMESEQ);
          }
        case 403: break;
        case 141: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.TIME);
          }
        case 404: break;
        case 219: 
          { return symbol(NodeTypes.FORMGROUP);
          }
        case 405: break;
        case 71: 
          { return symbol(NodeTypes.TO);
          }
        case 406: break;
        case 217: 
          { return symbol(NodeTypes.RELATIVE);
          }
        case 407: break;
        case 58: 
          { return symbol(NodeTypes.BY);
          }
        case 408: break;
        case 131: 
          { return symbol(NodeTypes.BIND);
          }
        case 409: break;
        case 13: 
          { return symbol(NodeTypes.LCURLY);
          }
        case 410: break;
        case 83: 
          { return symbol(NodeTypes.NULLCONCAT);
          }
        case 411: break;
        case 133: 
          { return symbol(NodeTypes.CALL);
          }
        case 412: break;
        case 181: 
          { return symbol(NodeTypes.RECORD);
          }
        case 413: break;
        case 113: 
          { return symbol(NodeTypes.TRY);
          }
        case 414: break;
        case 183: 
          { return symbol(NodeTypes.EXECUTE);
          }
        case 415: break;
        case 35: 
          { rawString.append("\\");		stringValue.append('\\'); lexerErrors.add(new SyntaxError(2205, yychar, yychar+2));
          }
        case 416: break;
        case 210: 
          { return symbol(NodeTypes.DATAITEM);
          }
        case 417: break;
        case 232: 
          { return symbol(NodeTypes.CONSTRUCTOR);
          }
        case 418: break;
        case 151: 
          { return symbol(NodeTypes.EMBED);
          }
        case 419: break;
        case 109: 
          { return symbol(NodeTypes.SET);
          }
        case 420: break;
        case 87: 
          { rawString.append("\\\\");		stringValue.append('\\');
          }
        case 421: break;
        case 27: 
          { return symbol(NodeTypes.LBRACKET);
          }
        case 422: break;
        case 114: 
          { return symbol(NodeTypes.ADD);
          }
        case 423: break;
        case 2: 
          { return symbol(NodeTypes.error);
          }
        case 424: break;
        case 188: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.BOOLEAN);
          }
        case 425: break;
        case 103: 
          { yybegin(HEXSTRING); stringLiteralType = LITERALTYPE_DBCHARHEX; rawString.setLength(0); rawString.append('\"'); stringValue.setLength(0); startOffset = yychar;
          }
        case 426: break;
        case 130: 
          { return symbol(NodeTypes.XOREQ);
          }
        case 427: break;
        case 209: 
          { return symbol(NodeTypes.DELEGATE);
          }
        case 428: break;
        case 92: 
          { rawString.append("\\t");		stringValue.append('\t');
          }
        case 429: break;
        case 154: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.FLOAT);
          }
        case 430: break;
        case 124: 
          { return symbol(NodeTypes.NULLCONCATEQ);
          }
        case 431: break;
        case 98: 
          { return symbol(NodeTypes.END);
          }
        case 432: break;
        case 142: 
          { return symbol(NodeTypes.TYPE);
          }
        case 433: break;
        case 50: 
          { return smallintlit();
          }
        case 434: break;
        case 22: 
          { return symbol(NodeTypes.BITOR);
          }
        case 435: break;
        case 238: 
          { yybegin(SQL); isSQLCondition = true;  rawString.setLength(0); rawString.append(yytext()); startOffset = yychar; openingBraceOffset = yylength();
          }
        case 436: break;
        case 132: 
          { return symbol(NodeTypes.CASE);
          }
        case 437: break;
        case 222: 
          { return symbol(NodeTypes.DATATABLE);
          }
        case 438: break;
        case 116: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.ANY);
          }
        case 439: break;
        case 125: 
          { return symbol(NodeTypes.INTO);
          }
        case 440: break;
        case 9: 
          { return symbol(NodeTypes.DIV);
          }
        case 441: break;
        case 157: 
          { return symbol(NodeTypes.CONST);
          }
        case 442: break;
        case 63: 
          { yybegin(STRING); stringLiteralType = LITERALTYPE_CHAR; rawString.setLength(0); rawString.append('\"'); stringValue.setLength(0); startOffset = yychar;
          }
        case 443: break;
        case 56: 
          { return symbol(NodeTypes.IN);
          }
        case 444: break;
        case 45: 
          { yybegin(DLI_QUOTED_ID); rawString.append('\'');
          }
        case 445: break;
        case 82: 
          { return symbol(NodeTypes.RIGHTSHIFTARITHMETIC);
          }
        case 446: break;
        case 224: 
          { return symbol(NodeTypes.SINGLEROW);
          }
        case 447: break;
        case 106: 
          { return symbol(NodeTypes.USE);
          }
        case 448: break;
        case 129: 
          { return symbol(NodeTypes.FROM);
          }
        case 449: break;
        case 33: 
          { yybegin(YYINITIAL); rawString.append(yytext()); lexerErrors.add(new SyntaxError(2200, startOffset, yychar)); return string();
          }
        case 450: break;
        case 226: 
          { return symbol(NodeTypes.TIMESTAMPINTERVALPRIMITIVE, Primitive.TIMESTAMP);
          }
        case 451: break;
        case 214: 
          { return symbol(NodeTypes.TRANSFER);
          }
        case 452: break;
        case 49: 
          { return bigintlit();
          }
        case 453: break;
        case 100: 
          { return byteslit();
          }
        case 454: break;
        case 91: 
          { rawString.append("\\r");		stringValue.append('\r');
          }
        case 455: break;
        case 80: 
          { return symbol(NodeTypes.LEFTSHIFT);
          }
        case 456: break;
        case 212: 
          { return symbol(NodeTypes.PRIMITIVE, Primitive.SMALLINT);
          }
        case 457: break;
        case 36: 
          { lexerErrors.add(new SyntaxError(2209, yychar, yychar+1));
          }
        case 458: break;
        case 54: 
          { return symbol(NodeTypes.IF);
          }
        case 459: break;
        case 193: 
          { return symbol(NodeTypes.SERVICE);
          }
        case 460: break;
        case 77: 
          { return symbol(NodeTypes.AND);
          }
        case 461: break;
        case 104: 
          { yybegin(HEXSTRING); stringLiteralType = LITERALTYPE_MBCHARHEX; rawString.setLength(0); rawString.append('\"'); stringValue.setLength(0); startOffset = yychar;
          }
        case 462: break;
        case 223: 
          { return symbol(NodeTypes.USINGKEYS);
          }
        case 463: break;
        case 198: 
          { return symbol(NodeTypes.PRIVATE);
          }
        case 464: break;
        case 90: 
          { rawString.append("\\n");		stringValue.append('\n');
          }
        case 465: break;
        case 140: 
          { return symbol(NodeTypes.NULL);
          }
        case 466: break;
        case 213: 
          { return symbol(NodeTypes.NOCURSOR);
          }
        case 467: break;
        case 143: 
          { return symbol(NodeTypes.THIS);
          }
        case 468: break;
        case 149: 
          { return symbol(NodeTypes.RIGHTSHIFTLOGICALEQ);
          }
        case 469: break;
        case 136: 
          { return symbol(NodeTypes.SHOW);
          }
        case 470: break;
        case 39: 
          { yybegin(SQLSTRING); rawString.append('\'');
          }
        case 471: break;
        case 76: 
          { return symbol(NodeTypes.BITANDEQ);
          }
        case 472: break;
        case 186: 
          { return symbol(NodeTypes.FORWARD);
          }
        case 473: break;
        case 233: 
          { return symbol(NodeTypes.SQLNULLABLE);
          }
        case 474: break;
        case 231: 
          { return symbol(NodeTypes.ENUMERATION);
          }
        case 475: break;
        case 201: 
          { return symbol(NodeTypes.RETURNS);
          }
        case 476: break;
        case 4: 
          { 
          }
        case 477: break;
        case 139: 
          { return symbol(NodeTypes.NEXT);
          }
        case 478: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
            switch (zzLexicalState) {
            case DLI: {
              yybegin(YYINITIAL); lexerErrors.add(new SyntaxError(2204, startOffset, startOffset + openingBraceOffset)); return dli();
            }
            case 734: break;
            case DLI_QUOTED_ID: {
              yybegin(DLI);
            }
            case 735: break;
            case SQLDELIMITEDID: {
              yybegin(SQL);
            }
            case 736: break;
            case STRING: {
              yybegin(YYINITIAL); lexerErrors.add(new SyntaxError(2200, startOffset, yychar)); return string();
            }
            case 737: break;
            case DLI_DBL_QUOTED_ID: {
              yybegin(DLI);
            }
            case 738: break;
            case SQL: {
              yybegin(YYINITIAL); lexerErrors.add(new SyntaxError(isSQLCondition ? 2203 : 2202, startOffset, startOffset + openingBraceOffset)); return isSQLCondition ? sqlCondition() : sqlStatement();
            }
            case 739: break;
            case HEXSTRING: {
              yybegin(YYINITIAL); lexerErrors.add(new SyntaxError(2200, startOffset, yychar)); return string();
            }
            case 740: break;
            case BLOCK_COMMENT: {
              yybegin(YYINITIAL); lexerErrors.add(new SyntaxError(2201, startOffset, startOffset + 2)); Symbol symbol = symbol(NodeTypes.BLOCK_COMMENT, startOffset, yychar);  if(returnBlockComments) blockComments.add(symbol); return symbol;
            }
            case 741: break;
            case SQLSTRING: {
              yybegin(SQL);
            }
            case 742: break;
            default:
              { return new java_cup.runtime.Symbol(NodeTypes.EOF, yychar, yychar);
 }
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
