/*******************************************************************************
 * Copyright © 2000, 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.ide.core.internal.model;

import org.eclipse.edt.ide.core.internal.model.util.LRUCache;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IOpenable;


/**
 * An LRU cache of <code>EGLElements</code>.
 */
public class ElementCache extends OverflowingLRUCache {
/**
 * Constructs a new element cache of the given size.
 */
public ElementCache(int size) {
	super(size);
}
/**
 * Constructs a new element cache of the given size.
 */
public ElementCache(int size, int overflow) {
	super(size, overflow);
}
/**
 * Returns true if the element is successfully closed and
 * removed from the cache, otherwise false.
 *
 * <p>NOTE: this triggers an external removal of this element
 * by closing the element.
 */
protected boolean close(LRUCacheEntry entry) {
	IOpenable element = (IOpenable) entry._fKey;
	try {
		if (element.hasUnsavedChanges()) {
			return false;
		} else {
			// TODO handle zip/jar later
			/*
			// We must close an entire JarPackageFragmentRoot at once.
			if (element instanceof JarPackageFragment) {
				JarPackageFragment packageFragment= (JarPackageFragment) element;
				JarPackageFragmentRoot root = (JarPackageFragmentRoot) packageFragment.getParent();
				root.close();
			} else {
				element.close();
			}
			*/
			element.close();
			return true;
		}
	} catch (EGLModelException npe) {
		return false;
	}
}
	/**
	 * Returns a new instance of the reciever.
	 */
	protected LRUCache newInstance(int size, int overflow) {
		return new ElementCache(size, overflow);
	}
}
