/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.dialogs.OpenPartSelectionDialog;
import org.eclipse.edt.ide.ui.internal.util.EditorUtility;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class OpenPartAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public OpenPartAction() {
        this.setText(UINlsStrings.OpenPartLabel);
        this.setDescription(UINlsStrings.OpenPartDescription);
        this.setToolTipText(UINlsStrings.OpenPartTooltip);
        this.setImageDescriptor(PluginImages.DESC_TOOL_OPENPART);
    }

    public void run() {
        IPart type = this.openPartSelectionDialog();
        if (type != null) {
            this.openInEditor(type);
        }
    }

    private boolean openInEditor(IPart type) {
        boolean beep = false;
        try {
            EditorUtility.openInEditor(type, true);
        }
        catch (CoreException coreException) {
            beep = true;
            EGLLogger.log((Object)this, UINlsStrings.OpenPartErrorMessage);
        }
        return beep;
    }

    private IPart openPartSelectionDialog() {
        Object[] types;
        IPart type = null;
        Shell parent = EDTUIPlugin.getActiveWorkbenchShell();
        OpenPartSelectionDialog dialog = new OpenPartSelectionDialog(parent, (IRunnableContext)new ProgressMonitorDialog(parent), Short.MAX_VALUE, SearchEngine.createWorkspaceScope());
        dialog.setMatchEmptyString(true);
        dialog.setTitle(UINlsStrings.OpenPartDialogTitle);
        dialog.setMessage(UINlsStrings.OpenPartDialogMessage);
        int result = dialog.open();
        if (result == 0 && (types = dialog.getResult()) != null && types.length > 0) {
            type = (IPart)types[0];
        }
        return type;
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

