/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.internal.EGLBasePlugin;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLDataTypeUtility;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.jface.text.ITextViewer;

public class EGLPredefinedDataTypeProposalHandler
extends EGLAbstractProposalHandler {
    private ITypeBinding partBinding;

    public EGLPredefinedDataTypeProposalHandler(ITextViewer viewer, int documentOffset, String prefix, Node boundNode) {
        super(viewer, documentOffset, prefix);
        while (!(boundNode instanceof File)) {
            if (boundNode instanceof Part) {
                this.partBinding = (ITypeBinding)((Part)boundNode).getName().resolveBinding();
            }
            boundNode = boundNode.getParent();
        }
    }

    public List getProposals() {
        String[] predefinedStrings = EGLPredefinedDataTypeProposalHandler.getFilteredPredefinedTypesByCapability(this.getPredefinedTypes());
        ArrayList<EGLCompletionProposal> proposals = new ArrayList<EGLCompletionProposal>();
        int i = 0;
        while (i < predefinedStrings.length) {
            if (predefinedStrings[i].toUpperCase().startsWith(this.getPrefix().toUpperCase())) {
                String predefinedString = predefinedStrings[i];
                proposals.add(new EGLCompletionProposal(this.viewer, null, predefinedString, UINlsStrings.CAProposal_PredefinedDataType, this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), predefinedString.length(), 60, ""));
            }
            ++i;
        }
        return proposals;
    }

    private String[] getPredefinedTypes() {
        if (this.partBinding != null) {
            switch (this.partBinding.getKind()) {
                case 6: 
                case 7: {
                    if (7 == this.partBinding.getKind()) {
                        return EGLDataTypeUtility.PREDEFINED_DATA_TYPE_STRINGS;
                    }
                    return new String[0];
                }
                case 11: {
                    if (this.partBinding.getAnnotation(EGLLANG, "NativeLibrary") == null) break;
                    return EGLDataTypeUtility.PREDEFINED_NATIVE_LIBRARY_TYPE_STRINGS;
                }
                case 14: 
                case 15: {
                    return EGLDataTypeUtility.PREDEFINED_SERVICE_FUNCTION_TYPE_STRINGS;
                }
            }
            if (this.isNewExpression()) {
                return EGLDataTypeUtility.PREDEFINED_NEWABLE_TYPE_STRINGS;
            }
        }
        return EGLDataTypeUtility.All_PREDEFINED_TYPE_STRINGS;
    }

    public static String[] getFilteredPredefinedTypesByCapability(String[] types) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < types.length) {
            if (!(!EGLBasePlugin.isReports() && EGLDataTypeUtility.JASPER_REPORT_TYPE_STRINGS.contains(types[i]) || !EGLBasePlugin.isBIRT() && EGLDataTypeUtility.BIRT_REPORT_TYPE_STRINGS.contains(types[i]) || !EGLBasePlugin.isCUI() && EGLDataTypeUtility.CONSOLE_UI_TYPE_STRINGS.contains(types[i]) || !EGLBasePlugin.isDLI() && EGLDataTypeUtility.DLI_TYPE_STRINGS.contains(types[i]))) {
                result.add(types[i]);
            }
            ++i;
        }
        return result.toArray(new String[0]);
    }
}

