/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.handlers;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.LocalVariableBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTPartVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Constructor;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.ForStatement;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OnExceptionBlock;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.ProgramParameter;
import org.eclipse.edt.compiler.core.ast.ServiceReference;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.StringLiteral;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.VariableFormField;
import org.eclipse.edt.compiler.internal.io.IRFileNameUtility;
import org.eclipse.edt.ide.core.internal.utils.BoundNodeLocationUtility;
import org.eclipse.edt.ide.core.internal.utils.IBoundNodeAddress;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.core.utils.BinaryReadOnlyFile;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.editor.BinaryEditorInput;
import org.eclipse.edt.ide.ui.internal.editor.BinaryFileEditor;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.editor.IEvEditor;
import org.eclipse.edt.ide.ui.internal.editor.util.BoundNodeModelUtility;
import org.eclipse.edt.ide.ui.internal.editor.util.IBoundNodeRequestor;
import org.eclipse.edt.ide.ui.internal.handlers.EGLHandler;
import org.eclipse.edt.ide.ui.internal.util.EditorUtility;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class OpenOnSelectionHandler
extends EGLHandler {
    private boolean beep;
    private IBinding targetBinding;

    @Override
    public void run() {
        Node boundNode;
        this.beep = true;
        ISelection selection = this.fEditor.getSelectionProvider().getSelection();
        Object currentFile = this.fEditor instanceof BinaryFileEditor ? (BinaryReadOnlyFile)((BinaryEditorInput)this.fEditor.getEditorInput()).getStorage() : ((FileEditorInput)this.fEditor.getEditorInput()).getFile();
        final IProject currentProject = currentFile.getProject();
        int currentPosition = ((ITextSelection)selection).getOffset();
        IEGLDocument document = (IEGLDocument)this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
        final int[][] localVariableDefinition = new int[1][];
        final IBoundNodeAddress[] address = new IBoundNodeAddress[1];
        final String[] selectedNodeName = new String[1];
        BoundNodeModelUtility.getBoundNodeAtOffset(currentFile, currentPosition, new IBoundNodeRequestor(){

            @Override
            public void acceptNode(final Node boundPart, Node selectedNode) {
                if (!(selectedNode instanceof Part) && !(selectedNode instanceof Statement)) {
                    selectedNode.accept((IASTVisitor)new AbstractASTExpressionVisitor(){

                        public boolean visit(File file) {
                            return false;
                        }

                        public boolean visitName(Name name) {
                            IBinding binding = name.resolveBinding();
                            if (binding != null && binding != IBinding.NOT_FOUND_BINDING) {
                                if (binding.isDataBinding() && 2 == ((IDataBinding)binding).getKind()) {
                                    localVariableDefinition[0] = this.findLocalVariableDeclaration((LocalVariableBinding)binding, boundPart);
                                } else {
                                    address[0] = BoundNodeLocationUtility.getInstance().createBoundNodeAddress(binding);
                                    IFile boundFile = null;
                                    if (address[0] != null) {
                                        boundFile = address[0].getDeclaringFile();
                                    }
                                    if (boundFile != null && boundFile.getProject() == null && boundFile instanceof BinaryReadOnlyFile) {
                                        ((BinaryReadOnlyFile)address[0].getDeclaringFile()).setProject(currentProject);
                                    }
                                }
                                selectedNodeName[0] = name.getIdentifier();
                            }
                            return false;
                        }

                        public boolean visit(FieldAccess fieldAccess) {
                            IDataBinding binding = fieldAccess.resolveDataBinding();
                            if (Binding.isValidBinding((IBinding)binding)) {
                                binding.getType();
                                if (2 == binding.getKind()) {
                                    localVariableDefinition[0] = this.findLocalVariableDeclaration((LocalVariableBinding)binding, boundPart);
                                } else {
                                    address[0] = BoundNodeLocationUtility.getInstance().createBoundNodeAddress((IBinding)binding);
                                }
                                selectedNodeName[0] = fieldAccess.getID();
                            }
                            return false;
                        }

                        public boolean visit(StringLiteral stringLiteral) {
                            ITypeBinding typeBinding = stringLiteral.resolveTypeBinding();
                            if (Binding.isValidBinding((IBinding)typeBinding) && typeBinding.isPartBinding()) {
                                address[0] = BoundNodeLocationUtility.getInstance().createBoundNodeAddress((IBinding)((IPartBinding)typeBinding));
                            }
                            return false;
                        }

                        public boolean visit(NestedFunction nestedFunction) {
                            return false;
                        }

                        public boolean visit(Constructor constructor) {
                            return false;
                        }

                        private int[] findLocalVariableDeclaration(LocalVariableBinding binding, Node boundPart2) {
                            int[][] result = new int[1][];
                            LocalVariableDeclarationFinder finder = new LocalVariableDeclarationFinder(binding);
                            boundPart2.accept((IASTVisitor)finder);
                            if (finder.localVariableDeclarationName != null) {
                                result[0] = new int[]{finder.localVariableDeclarationName.getOffset(), finder.localVariableDeclarationName.getLength()};
                            }
                            return result[0];
                        }
                    });
                }
            }
        });
        if (localVariableDefinition[0] != null) {
            this.fEditor.selectAndReveal(localVariableDefinition[0][0], localVariableDefinition[0][1]);
            this.beep = false;
        } else if (address[0] != null && (boundNode = BoundNodeLocationUtility.getInstance().getASTNodeForAddress(address[0], EGLUI.getSharedWorkingCopies())) != null) {
            NodeFinderASTPartVisitor nodeFinder = new NodeFinderASTPartVisitor(selectedNodeName, document, address, (IFile)currentFile);
            boundNode.accept((IASTVisitor)nodeFinder);
        }
        if (this.beep) {
            this.fEditor.getSite().getShell().getDisplay().beep();
        }
    }

    private IEditorPart openInEditor(IFile file) {
        try {
            return EditorUtility.openInEditor((Object)file, true);
        }
        catch (CoreException coreException) {
            EGLLogger.log((Object)this, UINlsStrings.OpenPartErrorMessage);
            return null;
        }
    }

    public IBinding getTargetBinding() {
        return this.targetBinding;
    }

    private static class LocalVariableDeclarationFinder
    extends AbstractASTVisitor {
        Name localVariableDeclarationName;
        LocalVariableBinding referenceBinding;

        public LocalVariableDeclarationFinder(LocalVariableBinding binding) {
            this.referenceBinding = binding;
        }

        private void handleName(Name name) {
            if (this.referenceBinding == name.resolveDataBinding()) {
                this.localVariableDeclarationName = name;
            }
        }

        public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
            Iterator iter = functionDataDeclaration.getNames().iterator();
            while (iter.hasNext()) {
                this.handleName((Name)iter.next());
            }
            return false;
        }

        public boolean visit(ForStatement forStatement) {
            if (forStatement.hasVariableDeclaration()) {
                this.handleName(forStatement.getVariableDeclarationName());
            }
            return true;
        }

        public boolean visit(OnExceptionBlock onExceptionBlock) {
            if (onExceptionBlock.hasExceptionDeclaration()) {
                this.handleName(onExceptionBlock.getExceptionName());
            }
            return true;
        }
    }

    class NavigationASTExpressionVisitor
    extends AbstractASTExpressionVisitor {
        final String[] selectedNodeName;
        final IBoundNodeAddress[] address;
        final int[][] localVariableDefinition;
        Node boundPart;

        public NavigationASTExpressionVisitor(String[] selectedNodeName, IBoundNodeAddress[] address, int[][] localVariableDefinition, Node boundPart) {
            this.selectedNodeName = selectedNodeName;
            this.address = address;
            this.localVariableDefinition = localVariableDefinition;
            this.boundPart = boundPart;
        }

        public boolean visit(File file) {
            return false;
        }

        public boolean visitName(Name name) {
            IBinding binding = name.resolveBinding();
            if (binding != null && binding != IBinding.NOT_FOUND_BINDING) {
                if (binding.isDataBinding() && 2 == ((IDataBinding)binding).getKind()) {
                    this.localVariableDefinition[0] = this.findLocalVariableDeclaration((LocalVariableBinding)binding, this.boundPart);
                } else {
                    this.address[0] = BoundNodeLocationUtility.getInstance().createBoundNodeAddress(binding);
                }
                this.selectedNodeName[0] = name.getIdentifier();
            }
            return false;
        }

        public boolean visit(FieldAccess fieldAccess) {
            IDataBinding binding = fieldAccess.resolveDataBinding();
            if (Binding.isValidBinding((IBinding)binding)) {
                binding.getType();
                if (2 == binding.getKind()) {
                    this.localVariableDefinition[0] = this.findLocalVariableDeclaration((LocalVariableBinding)binding, this.boundPart);
                } else {
                    this.address[0] = BoundNodeLocationUtility.getInstance().createBoundNodeAddress((IBinding)binding);
                }
                this.selectedNodeName[0] = fieldAccess.getID();
            }
            return false;
        }

        public boolean visit(StringLiteral stringLiteral) {
            ITypeBinding typeBinding = stringLiteral.resolveTypeBinding();
            if (Binding.isValidBinding((IBinding)typeBinding) && typeBinding.isPartBinding()) {
                this.address[0] = BoundNodeLocationUtility.getInstance().createBoundNodeAddress((IBinding)((IPartBinding)typeBinding));
            }
            return false;
        }

        public boolean visit(NestedFunction nestedFunction) {
            return false;
        }

        public boolean visit(Constructor constructor) {
            return false;
        }

        private int[] findLocalVariableDeclaration(LocalVariableBinding binding, Node boundPart) {
            int[][] result = new int[1][];
            LocalVariableDeclarationFinder finder = new LocalVariableDeclarationFinder(binding);
            boundPart.accept((IASTVisitor)finder);
            if (finder.localVariableDeclarationName != null) {
                result[0] = new int[]{finder.localVariableDeclarationName.getOffset(), finder.localVariableDeclarationName.getLength()};
            }
            return result[0];
        }
    }

    class NodeFinderASTPartVisitor
    extends AbstractASTPartVisitor {
        final String[] selectedNodeName;
        final IEGLDocument document;
        final IBoundNodeAddress[] address;
        final IFile currentFile;

        public NodeFinderASTPartVisitor(String[] selectedNodeName, IEGLDocument document, IBoundNodeAddress[] address, IFile currentFile) {
            this.selectedNodeName = selectedNodeName;
            this.document = document;
            this.address = address;
            this.currentFile = currentFile;
        }

        public boolean visit(ClassDataDeclaration classDataDeclaration) {
            for (Name name : classDataDeclaration.getNames()) {
                if (name.getIdentifier() != this.selectedNodeName[0]) continue;
                this.selectAndReveal(name);
            }
            return true;
        }

        public boolean visit(FunctionParameter functionParameter) {
            this.selectAndReveal(functionParameter.getName());
            return false;
        }

        public boolean visit(NestedFunction nestedFunction) {
            this.selectAndReveal(nestedFunction.getName());
            return false;
        }

        public boolean visit(VariableFormField field) {
            this.selectAndReveal(field.getName());
            return false;
        }

        public boolean visit(NestedForm nestedForm) {
            this.selectAndReveal(nestedForm.getName());
            return false;
        }

        public boolean visit(ProgramParameter programParameter) {
            this.selectAndReveal(programParameter.getName());
            return false;
        }

        public boolean visit(StructureItem structureItem) {
            this.selectAndReveal(structureItem.getName());
            return false;
        }

        public boolean visit(ServiceReference serviceReference) {
            this.selectAndReveal(serviceReference.getName());
            return false;
        }

        public void visitPart(Part part) {
            this.selectAndReveal(part.getName());
        }

        private void selectAndReveal(Name name) {
            IFile file = this.address[0].getDeclaringFile();
            if (file.equals((Object)this.currentFile)) {
                this.document.reconcile();
                EditorUtility.revealInEditor((IEditorPart)OpenOnSelectionHandler.this.fEditor, (Node)name);
            } else if (file.isReadOnly()) {
                String irName = file instanceof BinaryReadOnlyFile ? ((BinaryReadOnlyFile)file).getIrName() : IRFileNameUtility.toIRFileName((String)name.getIdentifier());
                IEditorPart part = EditorUtility.openSourceFromEglarInBinaryEditor(file.getProject(), file.getFullPath().toString(), file.getProjectRelativePath().toString(), irName, "org.eclipse.edt.ide.ui.BinaryFileEditor");
                int start = name.getOffset();
                int length = name.getLength();
                if (part instanceof EGLEditor) {
                    ((EGLEditor)part).selectAndReveal(start, length);
                } else if (part instanceof IEvEditor) {
                    ((IEvEditor)part).selectAndReveal(start, length);
                }
            } else {
                EditorUtility.revealInEditor(OpenOnSelectionHandler.this.openInEditor(file), (Node)name);
            }
            OpenOnSelectionHandler.this.beep = false;
        }
    }
}

