/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.rename;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.edt.compiler.internal.core.builder.DefaultProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultCompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameValidator;
import org.eclipse.edt.ide.core.internal.model.SourcePart;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.refactoring.Checks;
import org.eclipse.edt.ide.ui.internal.refactoring.changes.RenameResourceChange;
import org.eclipse.edt.ide.ui.internal.refactoring.rename.RenamePartProcessor;
import org.eclipse.edt.ide.ui.internal.refactoring.rename.RenameProcessor;
import org.eclipse.edt.ide.ui.internal.refactoring.tagging.IReferenceUpdating;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class RenameEGLFileProcessor
extends RenameProcessor
implements IReferenceUpdating {
    private boolean fUpdateReferences;
    private IEGLFile eglFile;
    private Boolean willRenameGeneratablePart;
    private RenamePartProcessor renameGeneratablePartProcessor;
    private CompositeChange compositeChange;

    public RenameEGLFileProcessor(IEGLFile eglFile) {
        this.eglFile = eglFile;
        this.compositeChange = new CompositeChange(this.getProcessorName());
    }

    @Override
    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        if (this.willRenameGeneratablePart() && this.fUpdateReferences) {
            return this.renameGeneratablePartProcessor.doCheckFinalConditions(pm, context);
        }
        this.compositeChange = new CompositeChange(this.getProcessorName());
        RefactoringStatus result = new RefactoringStatus();
        try {
            pm.beginTask("", 1);
            pm.setTaskName(UINlsStrings.RefactoringProcessor_precondition_checking);
            result.merge(Checks.checkFileNewName(this.eglFile, this.getNewElementName()));
            pm.worked(1);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.createChanges((IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        finally {
            pm.done();
        }
        return result;
    }

    private void createChanges(IProgressMonitor pm) throws CoreException {
        if (this.willRenameGeneratablePart() && this.fUpdateReferences) {
            this.renameGeneratablePartProcessor.createChange(pm);
            return;
        }
        try {
            String filename = this.eglFile.getElementName();
            String ext = null;
            int lastIndexOfDot = filename.lastIndexOf(46);
            if (lastIndexOfDot != -1) {
                ext = filename.substring(lastIndexOfDot + 1);
                filename = filename.substring(0, lastIndexOfDot);
            }
            StringBuffer newFilename = new StringBuffer(this.getNewElementName());
            if (ext != null) {
                newFilename.append('.');
                newFilename.append(ext);
            }
            this.compositeChange.add((Change)new RenameResourceChange(null, this.eglFile.getResource(), newFilename.toString(), null));
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.willRenameGeneratablePart()) {
            return this.renameGeneratablePartProcessor.checkInitialConditions(pm);
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.willRenameGeneratablePart() && this.fUpdateReferences) {
            return this.renameGeneratablePartProcessor.createChange(pm);
        }
        return this.compositeChange;
    }

    public String getProcessorName() {
        return UINlsStrings.RenameEGLFileRefactoring_name;
    }

    public boolean isApplicable() throws CoreException {
        return false;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        if (this.willRenameGeneratablePart()) {
            return this.renameGeneratablePartProcessor.loadParticipants(status, sharedParticipants);
        }
        return new RefactoringParticipant[0];
    }

    @Override
    public boolean canEnableUpdateReferences() {
        if (this.willRenameGeneratablePart()) {
            return this.renameGeneratablePartProcessor.canEnableUpdateReferences();
        }
        return false;
    }

    @Override
    public boolean getUpdateReferences() {
        if (this.willRenameGeneratablePart()) {
            return this.renameGeneratablePartProcessor.getUpdateReferences();
        }
        return this.fUpdateReferences;
    }

    @Override
    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
        if (this.willRenameGeneratablePart()) {
            this.renameGeneratablePartProcessor.setUpdateReferences(update);
            return;
        }
    }

    @Override
    protected String[] getAffectedProjectNatures() throws CoreException {
        return null;
    }

    @Override
    protected IFile[] getChangedFiles() throws CoreException {
        return null;
    }

    public Object[] getElements() {
        return null;
    }

    public String getIdentifier() {
        return null;
    }

    public RenamePartProcessor getRenamePartProcessor() {
        return this.willRenameGeneratablePart() ? this.renameGeneratablePartProcessor : null;
    }

    @Override
    public void setNewElementName(String newName) {
        super.setNewElementName(newName);
        if (this.willRenameGeneratablePart()) {
            this.renameGeneratablePartProcessor.setNewElementName(newName);
        }
    }

    @Override
    public String getCurrentElementName() {
        return this.getSimpleEGLFileName();
    }

    private String getSimpleEGLFileName() {
        return RenameEGLFileProcessor.removeFileNameExtension(this.eglFile.getElementName());
    }

    private static String removeFileNameExtension(String fileName) {
        if (fileName.lastIndexOf(".") == -1) {
            return fileName;
        }
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    @Override
    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        if (this.willRenameGeneratablePart() && this.fUpdateReferences) {
            return this.renameGeneratablePartProcessor.checkNewElementName(newName);
        }
        final RefactoringStatus[] result = new RefactoringStatus[]{new RefactoringStatus()};
        EGLNameValidator.validate((String)newName, (int)31, (IProblemRequestor)new DefaultProblemRequestor(){

            public void acceptProblem(int startOffset, int endOffset, int severity, int problemKind, String[] inserts) {
                if (result[0].isOK()) {
                    result[0] = RefactoringStatus.createFatalErrorStatus((String)1.getMessageFromBundle((int)problemKind, (String[])inserts));
                }
            }
        }, (ICompilerOptions)DefaultCompilerOptions.getInstance());
        return result[0];
    }

    private boolean willRenameGeneratablePart() {
        if (this.willRenameGeneratablePart == null) {
            try {
                IPart generatablePartWithSameName = this.getGeneratablePartWithSameName();
                if (generatablePartWithSameName == null) {
                    this.willRenameGeneratablePart = Boolean.FALSE;
                } else {
                    this.willRenameGeneratablePart = Boolean.TRUE;
                    this.renameGeneratablePartProcessor = new RenamePartProcessor(generatablePartWithSameName);
                }
            }
            catch (EGLModelException e) {
                EDTUIPlugin.log(e);
                this.willRenameGeneratablePart = Boolean.FALSE;
            }
        }
        return this.willRenameGeneratablePart;
    }

    private IPart getGeneratablePartWithSameName() throws EGLModelException {
        IPart[] parts = this.eglFile.getParts();
        String filename = this.eglFile.getElementName();
        int lastIndexOfDot = filename.lastIndexOf(46);
        if (lastIndexOfDot != -1) {
            filename = filename.substring(0, lastIndexOfDot);
        }
        int i = 0;
        while (i < parts.length) {
            if (filename.equals(parts[i].getElementName()) && parts[i] instanceof SourcePart && ((SourcePart)parts[i]).isGeneratable()) {
                return parts[i];
            }
            ++i;
        }
        return null;
    }
}

