/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.builder;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.ide.core.internal.builder.Util;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.serialization.AbstractObjectStore;
import org.eclipse.edt.mof.serialization.CachingObjectStore;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.Deserializer;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.SerializationException;

public class IFileSystemObjectStore
extends AbstractObjectStore
implements CachingObjectStore {
    private static final boolean DEBUG = false;
    private Map<String, EObject> cache;
    IPath root;
    String fileExtension;

    public IFileSystemObjectStore(IPath root, IEnvironment env) {
        super(env);
        this.root = root;
        this.cache = new HashMap<String, EObject>();
    }

    public IFileSystemObjectStore(IPath root, IEnvironment env, String storageFormat) {
        this(root, env, storageFormat, "XML".equals(storageFormat) ? ".mofxml" : ".mofbin");
    }

    public IFileSystemObjectStore(IPath root, IEnvironment env, String storageFormat, String fileExtension) {
        super(env, storageFormat, ".eglxml".equals(fileExtension) ? "egl" : "mof");
        this.root = root;
        this.fileExtension = fileExtension;
        this.cache = new HashMap<String, EObject>();
    }

    public Deserializer createDeserializer(String typeSignature) {
        try {
            IPath path = this.root.append(String.valueOf(typeSignature.toUpperCase().toLowerCase().replace('.', '/')) + this.getFileExtension());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            if (file.exists()) {
                try {
                    BufferedInputStream inputStream = new BufferedInputStream(file.getContents());
                    return this.factory.createDeserializer((Object)inputStream, this.env);
                }
                catch (CoreException e) {
                    throw new BuildException("CoreException", (Throwable)e);
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public void primRemove(String key) {
        String normKey = key.toUpperCase().toLowerCase();
        this.cache.remove(normKey);
    }

    public void put(String key, EObject obj) throws SerializationException {
        super.put(key, obj);
        if (obj != null) {
            String normKey = this.removeSchemeFromKey(key).toUpperCase().toLowerCase();
            this.cache.put(normKey, obj);
        }
    }

    public void store(String typeSignature, Object obj) {
        if (!(obj instanceof byte[])) {
            throw new IllegalArgumentException("Object not of type: byte[]");
        }
        byte[] entry = (byte[])obj;
        BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(entry));
        try {
            try {
                IFile file = this.getOutputFileForWrite(typeSignature);
                if (file.exists()) {
                    if (entry.length > 0) {
                        file.setContents((InputStream)inputStream, true, false, null);
                        if (!file.isDerived()) {
                            file.setDerived(true, null);
                        }
                    } else {
                        file.delete(true, null);
                    }
                } else if (entry.length > 0) {
                    file.create((InputStream)inputStream, 1, null);
                    file.setDerived(true, null);
                }
            }
            catch (CoreException e) {
                throw new SerializationException((Throwable)e);
            }
        }
        finally {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {
                throw new SerializationException((Throwable)e);
            }
        }
    }

    private IFile getOutputFileForWrite(String typeSignature) throws CoreException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String relativeFilePath = String.valueOf(typeSignature.replace('.', '/')) + this.getFileExtension();
        int lastSlash = relativeFilePath.lastIndexOf(47);
        if (lastSlash != -1) {
            Util.createFolder((IPath)new Path(relativeFilePath.substring(0, lastSlash)), (IContainer)workspaceRoot.getFolder(this.root));
        }
        return workspaceRoot.getFile(this.root.append(relativeFilePath));
    }

    public boolean containsKey(String key) {
        key = this.removeSchemeFromKey(key);
        IPath path = this.root.append(String.valueOf(key.replace('.', '/')) + this.getFileExtension());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        return file.exists();
    }

    public long lastModified(String key) {
        key = this.removeSchemeFromKey(key);
        IPath path = this.root.append(String.valueOf(key.replace('.', '/')) + this.getFileExtension());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        return file.getModificationStamp();
    }

    public String getFileExtension() {
        if (this.fileExtension == null) {
            this.fileExtension = "BINARY".equals(this.storageFormat) ? ".mofbin" : ".mofxml";
        }
        return this.fileExtension;
    }

    public EObject get(String key) throws DeserializationException {
        String normKey = this.removeSchemeFromKey(key).toUpperCase().toLowerCase();
        EObject value = this.cache.get(normKey);
        if (value == null && (value = super.get(key)) != null) {
            this.cache.put(normKey, value);
        }
        return value;
    }

    public EObject getFromCache(String key) {
        String normKey = this.removeSchemeFromKey(key).toUpperCase().toLowerCase();
        return this.cache.get(normKey);
    }

    public void addToCache(String key, EObject object) {
        String normKey = this.removeSchemeFromKey(key).toUpperCase().toLowerCase();
        this.cache.put(normKey, object);
    }

    public void clearCache() {
        this.cache.clear();
    }

    public List<String> getAllKeysFromPkg(String pkg, boolean includeSubPkgs) {
        if (!this.containsPkg(pkg)) {
            return new ArrayList<String>();
        }
        IPath path = this.root.append(pkg.replace('.', '/'));
        IFolder pkgDir = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        return this.getAllKeysFromPkg(pkgDir, pkg, includeSubPkgs);
    }

    private List<String> getAllKeysFromPkg(final IFolder pkgDir, final String pkg, final boolean includeSubPkgs) {
        final ArrayList<String> list = new ArrayList<String>();
        try {
            pkgDir.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.equals((Object)pkgDir)) {
                        return true;
                    }
                    if (resource.getType() == 2) {
                        if (includeSubPkgs) {
                            String subPkgName = pkg.length() > 0 ? String.valueOf(pkg) + "." + resource.getName() : resource.getName();
                            list.addAll(IFileSystemObjectStore.this.getAllKeysFromPkg((IFolder)resource, subPkgName, includeSubPkgs));
                        }
                    } else if (resource.getType() == 1 && IFileSystemObjectStore.this.getFileExtension().equals(IFileSystemObjectStore.this.getFileExtension((IFile)resource))) {
                        if (pkg.length() > 0) {
                            list.add(String.valueOf(IFileSystemObjectStore.this.getScheme()) + pkg + "." + IFileSystemObjectStore.this.getFileName((IResource)((IFile)resource)));
                        } else {
                            list.add(String.valueOf(IFileSystemObjectStore.this.getScheme()) + IFileSystemObjectStore.this.getFileName((IResource)((IFile)resource)));
                        }
                    }
                    return false;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return list;
    }

    private String getFileExtension(IFile file) {
        String name = file.getName();
        int index = name.lastIndexOf(".");
        if (index < 0) {
            return null;
        }
        return name.substring(index);
    }

    private String getFileName(IResource file) {
        String name = file.getName();
        int index = name.lastIndexOf(".");
        if (index < 0) {
            return name;
        }
        return name.substring(0, index);
    }

    private boolean containsPkg(String pkg) {
        IPath path = this.root.append(pkg.replace('.', '/'));
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        return folder.exists();
    }

    private String getScheme() {
        if (this.getFileExtension().equals(".mofbin") || this.getFileExtension().equals(".mofxml")) {
            return "";
        }
        return "egl:";
    }

    public String toString() {
        return "IFileSystemObjectStore root=" + this.root;
    }
}

