/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.ZipFileBindingBuildPathEntry;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.IZipFileBindingBuildPathEntry;
import org.eclipse.edt.compiler.internal.io.IRFileNameUtility;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.IWorkingCopyBuildPathEntry;
import org.eclipse.edt.ide.core.internal.partinfo.IPartOrigin;
import org.eclipse.edt.ide.core.utils.BinaryReadOnlyFile;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PartNotFoundException;
import org.eclipse.edt.mof.serialization.ObjectStore;

public class WrapperedZipFileBuildPathEntry
implements IZipFileBindingBuildPathEntry,
IWorkingCopyBuildPathEntry {
    ZipFileBindingBuildPathEntry zipEntry;
    IProject project;
    private HashMap<String, IPartOrigin> partOriginByPart = new HashMap(32);

    public WrapperedZipFileBuildPathEntry(ZipFileBindingBuildPathEntry zipEntry, IProject project) {
        this.zipEntry = zipEntry;
        this.project = project;
    }

    @Override
    public IPartOrigin getPartOrigin(String[] packageName, String partName) {
        IPartOrigin partOrigin = null;
        try {
            Part part = this.findPart(packageName, partName);
            String sourceName = null;
            String irName = "";
            if (part != null) {
                sourceName = part.eGet("filename").toString();
                irName = IRFileNameUtility.toIRFileName((String)part.getName());
            } else {
                ZipFile zipFile = null;
                try {
                    ZipEntry ze;
                    zipFile = new ZipFile(this.getID());
                    if (partName != null && (ze = zipFile.getEntry(partName)) != null) {
                        sourceName = partName;
                    }
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            if (sourceName != null) {
                StringBuffer key = new StringBuffer(new Path(this.getID()).toString());
                key.append("|");
                key.append(sourceName);
                partOrigin = this.partOriginByPart.get(key.toString());
                if (partOrigin == null) {
                    final BinaryReadOnlyFile brf = new BinaryReadOnlyFile(this.getID(), sourceName, irName);
                    brf.setProject(this.project);
                    partOrigin = new IPartOrigin(){

                        @Override
                        public boolean isOriginEGLFile() {
                            return true;
                        }

                        @Override
                        public IFile getEGLFile() {
                            return brf;
                        }

                        @Override
                        public boolean isSourceCodeAvailable() {
                            return brf.exists();
                        }
                    };
                    this.partOriginByPart.put(brf.getIrFullPathString(), partOrigin);
                }
            }
        }
        catch (PartNotFoundException partNotFoundException) {}
        return partOrigin;
    }

    public IPartBinding getPartBinding(String[] packageName, String partName) {
        return this.zipEntry.getPartBinding(packageName, partName);
    }

    public boolean hasPackage(String[] packageName) {
        return this.zipEntry.hasPackage(packageName);
    }

    public int hasPart(String[] packageName, String partName) {
        int typeBindingKind = this.zipEntry.hasPart(packageName, partName);
        if (1 == typeBindingKind) {
            ZipFile zipFile = null;
            try {
                ZipEntry ze;
                zipFile = new ZipFile(this.getID());
                if (partName != null && (ze = zipFile.getEntry(partName)) != null) {
                    typeBindingKind = 16;
                }
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        return typeBindingKind;
    }

    public IEnvironment getRealizingEnvironment() {
        return this.zipEntry.getRealizingEnvironment();
    }

    public IPartBinding getCachedPartBinding(String[] packageName, String partName) {
        return this.zipEntry.getCachedPartBinding(packageName, partName);
    }

    public void addPartBindingToCache(IPartBinding partBinding) {
        this.zipEntry.addPartBindingToCache(partBinding);
    }

    public ObjectStore[] getObjectStores() {
        return this.zipEntry.getObjectStores();
    }

    public Part findPart(String[] packageName, String name) throws PartNotFoundException {
        return this.zipEntry.findPart(packageName, name);
    }

    public boolean isZipFile() {
        return true;
    }

    public boolean isProject() {
        return false;
    }

    public String getID() {
        return this.zipEntry.getID();
    }

    public void clear() {
    }

    public boolean hasEntry(String entry) {
        return this.zipEntry.hasEntry(entry);
    }

    public List<String> getAllKeysFromPkg(String pkg, boolean includeSubPkgs) {
        return this.zipEntry.getAllKeysFromPkg(pkg, includeSubPkgs);
    }
}

