/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.edt.compiler.ISystemPackageBuildPathEntry;
import org.eclipse.edt.compiler.SystemEnvironment;
import org.eclipse.edt.compiler.SystemPackageMOFPathEntry;
import org.eclipse.edt.compiler.binding.AnnotationFieldBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.FixedStructureBinding;
import org.eclipse.edt.compiler.binding.FormBinding;
import org.eclipse.edt.compiler.binding.FormDataBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeBindingImpl;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.FormGroup;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.ProgramParameter;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.TopLevelForm;
import org.eclipse.edt.compiler.core.ast.VariableFormField;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.io.IRFileNameUtility;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IWorkingCopyCompileRequestor;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompilationResult;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompiler;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectEnvironment;
import org.eclipse.edt.ide.core.internal.model.EGLFile;
import org.eclipse.edt.ide.core.internal.partinfo.IPartOrigin;
import org.eclipse.edt.ide.core.internal.utils.IBoundNodeAddress;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IWorkingCopy;
import org.eclipse.edt.ide.core.utils.BinaryReadOnlyFile;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;

public class BoundNodeLocationUtility {
    private static final BoundNodeLocationUtility INSTANCE = new BoundNodeLocationUtility();

    private BoundNodeLocationUtility() {
    }

    public static BoundNodeLocationUtility getInstance() {
        return INSTANCE;
    }

    private IBoundNodeAddress getAddressOfForm(FormDataBinding form) {
        if (form == null) {
            return null;
        }
        return this.getAddressOfForm((FormBinding)form.getType());
    }

    private IBoundNodeAddress getAddressOfForm(FormBinding form) {
        if (form == null) {
            return null;
        }
        if (form.getEnclosingFormGroup() == null) {
            return new BoundPartAddress(this.getFileForNode((IPartBinding)form), form.getName());
        }
        return new BoundFormBindingAddress(this.getFileForNode((IPartBinding)form.getEnclosingFormGroup()), form.getEnclosingFormGroup().getName(), form.getName());
    }

    public IBoundNodeAddress createBoundNodeAddress(IBinding selectedNodeBinding) {
        IBoundNodeAddress address = null;
        if (selectedNodeBinding.isTypeBinding()) {
            if (((ITypeBinding)selectedNodeBinding).isPartBinding()) {
                if (((ITypeBinding)selectedNodeBinding).getKind() == 8) {
                    return this.getAddressOfForm((FormBinding)selectedNodeBinding);
                }
                IFile file = this.getFileForNode((IPartBinding)selectedNodeBinding);
                address = new BoundPartAddress(file, ((IPartBinding)selectedNodeBinding).getName());
            }
        } else if (selectedNodeBinding.isDataBinding()) {
            IDataBinding dataBinding = (IDataBinding)selectedNodeBinding;
            if (dataBinding.getKind() == 8) {
                address = this.getAddressOfForm((FormDataBinding)dataBinding);
            } else {
                IPartBinding declaringPart = dataBinding.getDeclaringPart();
                switch (dataBinding.getKind()) {
                    case 13: {
                        IAnnotationTypeBinding encl;
                        if (dataBinding.getType() instanceof AnnotationTypeBindingImpl) {
                            address = new BoundPartAddress(this.getFileForNode((IPartBinding)((AnnotationTypeBindingImpl)dataBinding.getType()).getAnnotationRecord()), dataBinding.getName());
                            break;
                        }
                        if (!(dataBinding instanceof AnnotationFieldBinding) || !((encl = ((AnnotationFieldBinding)dataBinding).getEnclosingAnnotationType()) instanceof AnnotationTypeBindingImpl)) break;
                        address = new BoundDataBindingAddress(this.getFileForNode((IPartBinding)((AnnotationTypeBindingImpl)encl).getAnnotationRecord()), encl.getName(), 14, dataBinding.getName());
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 21: 
                    case 26: 
                    case 27: {
                        if (!Binding.isValidBinding((IBinding)declaringPart)) break;
                        address = new BoundPartAddress(this.getFileForNode(declaringPart), declaringPart.getName());
                        break;
                    }
                    case 5: {
                        if (!Binding.isValidBinding((IBinding)declaringPart)) break;
                        address = new BoundStructureItemBindingAddress(this.getFileForNode(declaringPart), declaringPart.getName(), dataBinding.getKind(), this.getStructureItemAddressInfos((StructureItemBinding)dataBinding));
                        break;
                    }
                    case 7: {
                        if (!Binding.isValidBinding((IBinding)declaringPart)) break;
                        FormBinding form = (FormBinding)declaringPart;
                        if (form.getEnclosingFormGroup() == null) {
                            address = new BoundFormFieldBindingAddress(this.getFileForNode(declaringPart), declaringPart.getName(), null, dataBinding.getName());
                            break;
                        }
                        address = new BoundFormFieldBindingAddress(this.getFileForNode((IPartBinding)form.getEnclosingFormGroup()), form.getEnclosingFormGroup().getName(), form.getName(), dataBinding.getName());
                        break;
                    }
                    case 0: {
                        if (!Binding.isValidBinding((IBinding)declaringPart)) break;
                        address = new BoundFunctionParameterBindingAddress(this.getFileForNode(declaringPart), declaringPart.getName(), (FunctionParameterBinding)dataBinding);
                        break;
                    }
                    default: {
                        if (!Binding.isValidBinding((IBinding)declaringPart)) break;
                        address = new BoundDataBindingAddress(this.getFileForNode(declaringPart), declaringPart.getName(), dataBinding.getKind(), dataBinding.getName());
                    }
                }
            }
        }
        return address;
    }

    private IFile getFileForNode(IPartBinding partBinding) {
        IFile result = null;
        String[] packageName = partBinding.getPackageName();
        String partName = partBinding.getName();
        IEnvironment ienv = partBinding.getEnvironment();
        if (ienv instanceof WorkingCopyProjectEnvironment) {
            WorkingCopyProjectEnvironment environment = (WorkingCopyProjectEnvironment)ienv;
            IPartOrigin origin = environment.getPartOrigin(packageName, partName);
            if (origin == null) {
                return null;
            }
            result = origin.getEGLFile();
        } else if (ienv instanceof SystemEnvironment) {
            List list = ((SystemEnvironment)ienv).getSysPackages();
            for (ISystemPackageBuildPathEntry entry : list) {
                if (entry instanceof SystemPackageMOFPathEntry || entry.getPartBinding(packageName, partName) == null) continue;
                String mofSignature = String.valueOf(IRUtils.concatWithSeparator((String[])packageName, (String)".")) + "." + partName;
                String eglSignature = "egl:" + mofSignature;
                EObject irPart = null;
                String sourceName = null;
                String irName = null;
                try {
                    irPart = ((SystemEnvironment)ienv).getIREnvironment().find(eglSignature);
                    sourceName = irPart.eGet("filename").toString();
                    irName = IRFileNameUtility.toIRFileName((String)irPart.eGet("name").toString());
                }
                catch (MofObjectNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (DeserializationException e1) {
                    e1.printStackTrace();
                }
                result = new BinaryReadOnlyFile(entry.getID(), sourceName, irName);
                break;
            }
        }
        return result;
    }

    public Node getASTNodeForAddress(final IBoundNodeAddress address, IWorkingCopy[] workingCopies) {
        if (address.getDeclaringFile() == null) {
            return null;
        }
        final Node[] astNode = new Node[1];
        WorkingCopyCompiler compiler = WorkingCopyCompiler.getInstance();
        String[] packageName = address.getDeclaringFile().isReadOnly() ? ((BinaryReadOnlyFile)address.getDeclaringFile()).getPackageSegments() : ((EGLFile)EGLCore.create(address.getDeclaringFile())).getPackageName();
        if (packageName == null) {
            return null;
        }
        compiler.compilePart(address.getDeclaringFile().getProject(), packageName, address.getDeclaringFile(), workingCopies, address.getPartName(), new IWorkingCopyCompileRequestor(){

            @Override
            public void acceptResult(WorkingCopyCompilationResult result) {
                Node boundPart = result.getBoundPart();
                if (boundPart instanceof Part) {
                    Part part = (Part)boundPart;
                    if (address instanceof BoundDataBindingAddress) {
                        BoundDataBindingNodeLocator locator = new BoundDataBindingNodeLocator((BoundDataBindingAddress)address);
                        part.accept((IASTVisitor)locator);
                        astNode[0] = locator.result;
                    } else if (address instanceof BoundFunctionParameterBindingAddress) {
                        BoundFunctionParameterBindingNodeLocator locator = new BoundFunctionParameterBindingNodeLocator((BoundFunctionParameterBindingAddress)address);
                        part.accept((IASTVisitor)locator);
                        astNode[0] = locator.result;
                    } else if (address instanceof BoundStructureItemBindingAddress) {
                        BoundStructureItemBindingNodeLocator locator = new BoundStructureItemBindingNodeLocator((BoundStructureItemBindingAddress)address);
                        part.accept((IASTVisitor)locator);
                        astNode[0] = locator.result;
                    } else if (address instanceof BoundFormBindingAddress) {
                        BoundFormBindingNodeLocator locator = new BoundFormBindingNodeLocator((BoundFormBindingAddress)address);
                        part.accept((IASTVisitor)locator);
                        astNode[0] = locator.result;
                    } else if (address instanceof BoundFormFieldBindingAddress) {
                        BoundFormFieldBindingNodeLocator locator = new BoundFormFieldBindingNodeLocator((BoundFormFieldBindingAddress)address);
                        part.accept((IASTVisitor)locator);
                        astNode[0] = locator.result;
                    } else {
                        astNode[0] = part;
                    }
                } else {
                    result.getDeclaringFile().equals((Object)address.getDeclaringFile());
                }
            }
        });
        return astNode[0];
    }

    private StructureItemAddressInfo[] getStructureItemAddressInfos(StructureItemBinding binding) {
        ArrayList<StructureItemAddressInfo> segments = new ArrayList<StructureItemAddressInfo>();
        segments.add(new StructureItemAddressInfo(binding.getName(), this.getIndexInContainer(binding)));
        IPartBinding declaringPart = binding.getDeclaringPart();
        StructureItemBinding parentItem = binding.getParentItem();
        while (parentItem != null && parentItem.getDeclaringPart() == declaringPart) {
            segments.add(0, new StructureItemAddressInfo(parentItem.getName(), this.getIndexInContainer(parentItem)));
            parentItem = parentItem.getParentItem();
        }
        return segments.toArray(new StructureItemAddressInfo[segments.size()]);
    }

    private int getIndexInContainer(StructureItemBinding binding) {
        List structureItems = Collections.EMPTY_LIST;
        StructureItemBinding parentItem = binding.getParentItem();
        if (parentItem == null) {
            FixedStructureBinding enclosingStructureBinding = binding.getEnclosingStructureBinding();
            structureItems = enclosingStructureBinding.getStructureItems();
        } else {
            structureItems = parentItem.getChildren();
        }
        int i = 0;
        while (i < structureItems.size()) {
            if (binding == structureItems.get(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static String getSignature(IFunctionBinding functionBinding) {
        StringBuffer sig = new StringBuffer();
        if (functionBinding == null) {
            sig.append("null");
        } else {
            sig.append(functionBinding.getName());
            Iterator iter = functionBinding.getParameters().iterator();
            while (iter.hasNext()) {
                sig.append("|");
                ITypeBinding tBinding = ((IDataBinding)iter.next()).getType();
                sig.append(tBinding == null ? "null" : tBinding.getPackageQualifiedName());
            }
            ITypeBinding tBinding = functionBinding.getReturnType();
            if (tBinding != null) {
                sig.append("|");
                sig.append(tBinding.getPackageQualifiedName());
            }
        }
        return sig.toString();
    }

    private static class BoundDataBindingAddress
    extends BoundPartAddress {
        private int bindingKind;
        private String address;

        public BoundDataBindingAddress(IFile declaringFile, String partName, int bindingKind, String address) {
            super(declaringFile, partName);
            this.bindingKind = bindingKind;
            this.address = address;
        }
    }

    private class BoundDataBindingNodeLocator
    extends AbstractASTVisitor {
        private BoundDataBindingAddress address;
        private Node result;

        public BoundDataBindingNodeLocator(BoundDataBindingAddress address) {
            this.address = address;
        }

        public boolean visit(ClassDataDeclaration classDataDeclaration) {
            if (this.address.bindingKind == 3) {
                for (Name name : classDataDeclaration.getNames()) {
                    if (name.getIdentifier() != this.address.address) continue;
                    this.result = classDataDeclaration;
                    return false;
                }
            }
            return true;
        }

        public boolean visit(NestedFunction nestedFunction) {
            if (this.address.bindingKind == 20 && this.address.address == nestedFunction.getName().getIdentifier()) {
                this.result = nestedFunction;
                return false;
            }
            return true;
        }

        public boolean visit(ProgramParameter programParameter) {
            if (this.address.bindingKind == 1 && this.address.address == programParameter.getName().getIdentifier()) {
                this.result = programParameter;
                return false;
            }
            return false;
        }

        public boolean visit(StructureItem structureItem) {
            IDataBinding binding = (IDataBinding)structureItem.resolveBinding();
            if (binding != null && this.address.bindingKind == 14 && binding.getKind() == 14 && structureItem.getName() != null && this.address.address == structureItem.getName().getIdentifier()) {
                this.result = structureItem;
                return false;
            }
            return true;
        }
    }

    private class BoundFormBindingAddress
    extends BoundPartAddress {
        private String formName;

        public BoundFormBindingAddress(IFile declaringFile, String partName, String formName) {
            super(declaringFile, partName);
            this.formName = formName;
        }
    }

    private class BoundFormBindingNodeLocator
    extends AbstractASTVisitor {
        private BoundFormBindingAddress address;
        private Node result;

        public BoundFormBindingNodeLocator(BoundFormBindingAddress address) {
            this.address = address;
        }

        public boolean visit(NestedForm nestedForm) {
            if (this.address.formName == nestedForm.getName().getIdentifier()) {
                this.result = nestedForm;
                return false;
            }
            return false;
        }
    }

    private class BoundFormFieldBindingAddress
    extends BoundPartAddress {
        private String formName;
        private String fieldName;

        public BoundFormFieldBindingAddress(IFile declaringFile, String partName, String formName, String fieldName) {
            super(declaringFile, partName);
            this.formName = formName;
            this.fieldName = fieldName;
        }
    }

    private class BoundFormFieldBindingNodeLocator
    extends DefaultASTVisitor {
        private BoundFormFieldBindingAddress address;
        private Node result;

        public BoundFormFieldBindingNodeLocator(BoundFormFieldBindingAddress address) {
            this.address = address;
        }

        public boolean visit(FormGroup fg) {
            return true;
        }

        public boolean visit(NestedForm nestedForm) {
            return this.address.formName == nestedForm.getName().getIdentifier();
        }

        public boolean visit(TopLevelForm tlForm) {
            return true;
        }

        public boolean visit(VariableFormField field) {
            if (this.result != null) {
                return false;
            }
            IDataBinding binding = field.getName().resolveDataBinding();
            if (Binding.isValidBinding((IBinding)binding) && binding.getName() == this.address.fieldName) {
                this.result = field;
            }
            return false;
        }
    }

    private static class BoundFunctionParameterBindingAddress
    extends BoundPartAddress {
        private String address;
        private String functionSignature;

        public BoundFunctionParameterBindingAddress(IFile declaringFile, String partName, FunctionParameterBinding binding) {
            super(declaringFile, partName);
            this.address = binding.getName();
            this.functionSignature = BoundNodeLocationUtility.getSignature(binding.getFunctionBinding());
        }
    }

    private class BoundFunctionParameterBindingNodeLocator
    extends AbstractASTVisitor {
        private BoundFunctionParameterBindingAddress address;
        private Node result;

        public BoundFunctionParameterBindingNodeLocator(BoundFunctionParameterBindingAddress address) {
            this.address = address;
        }

        public boolean visit(FunctionParameter functionParameter) {
            IDataBinding binding = functionParameter.getName().resolveDataBinding();
            if (Binding.isValidBinding((IBinding)binding) && this.address.address == binding.getName() && this.address.functionSignature.equals(BoundNodeLocationUtility.getSignature(((FunctionParameterBinding)binding).getFunctionBinding()))) {
                this.result = functionParameter;
                return false;
            }
            return true;
        }
    }

    private static class BoundPartAddress
    implements IBoundNodeAddress {
        private IFile declaringFile;
        private String partName;

        public BoundPartAddress(IFile declaringFile, String partName) {
            this.declaringFile = declaringFile;
            this.partName = partName;
        }

        @Override
        public IFile getDeclaringFile() {
            return this.declaringFile;
        }

        @Override
        public String getPartName() {
            return this.partName;
        }
    }

    private class BoundStructureItemBindingAddress
    extends BoundPartAddress {
        private int bindingKind;
        private StructureItemAddressInfo[] address;

        public BoundStructureItemBindingAddress(IFile declaringFile, String partName, int bindingKind, StructureItemAddressInfo[] address) {
            super(declaringFile, partName);
            this.bindingKind = bindingKind;
            this.address = address;
        }
    }

    private class BoundStructureItemBindingNodeLocator
    extends AbstractASTVisitor {
        protected BoundStructureItemBindingAddress address;
        protected Node result;

        public BoundStructureItemBindingNodeLocator(BoundStructureItemBindingAddress address) {
            this.address = address;
        }

        public boolean visit(StructureItem structureItem) {
            StructureItemBinding sItemBinding;
            StructureItemAddressInfo[] structureItemNameSegments;
            if (this.result != null) {
                return false;
            }
            IDataBinding binding = (IDataBinding)structureItem.resolveBinding();
            if (this.address.bindingKind == 5 && binding.getKind() == 5 && (structureItemNameSegments = BoundNodeLocationUtility.this.getStructureItemAddressInfos(sItemBinding = (StructureItemBinding)binding)).length == this.address.address.length) {
                boolean equalNames = true;
                int i = 0;
                while (i < structureItemNameSegments.length) {
                    if (structureItemNameSegments[i].name != ((BoundStructureItemBindingAddress)this.address).address[i].name || structureItemNameSegments[i].indexInContainer != ((BoundStructureItemBindingAddress)this.address).address[i].indexInContainer) {
                        equalNames = false;
                        break;
                    }
                    ++i;
                }
                if (equalNames) {
                    this.result = structureItem;
                }
            }
            return true;
        }
    }

    private static class StructureItemAddressInfo {
        String name;
        int indexInContainer;

        public StructureItemAddressInfo(String name, int indexInContainer) {
            this.name = name;
            this.indexInContainer = indexInContainer;
        }
    }
}

