/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.util;

import eglx.lang.AnyException;
import eglx.lang.InvalidArgumentException;
import java.math.BigInteger;
import org.eclipse.edt.javart.resources.Platform;

public class NumericUtil {
    private static final BigInteger TEN_TO_THE_SEVENTEENTH = BigInteger.valueOf(100000000000000000L);
    public static final byte ASCII_POSITIVE_NUM_NUMC_MASK = 48;
    public static final byte EBCDIC_POSITIVE_NUM_MASK = -16;
    public static final byte LOCAL_POSITIVE_NUM_MASK;
    public static final byte EBCDIC_POSITIVE_NUMC_MASK = -64;
    public static final byte LOCAL_POSITIVE_NUMC_MASK;
    public static final byte ASCII_NEGATIVE_NUM_NUMC_MASK = 112;
    public static final byte EBCDIC_NEGATIVE_NUM_NUMC_MASK = -48;
    public static final byte LOCAL_NEGATIVE_NUM_NUMC_MASK;
    public static final byte ASCII_ZERO_DIFF = 48;
    public static final byte EBCDIC_ZERO_DIFF = -16;
    public static final byte LOCAL_ZERO_DIFF;
    private static final int FLOAT_SIGN_MASK = Integer.MIN_VALUE;
    private static final int FLOAT_EXPONENT_MASK = 2139095040;
    private static final int FLOAT_MANTISSA_MASK = 0x7FFFFF;
    private static final int FLOAT_MANTISSA_MSB_MASK = 0x800000;
    private static final int FLOAT_BIAS = 126;
    private static final int S390_FLOAT_BIAS = 64;
    private static final int S390_FLOAT_EXPONENT_MASK = 0x7F000000;
    private static final int S390_FLOAT_MANTISSA_MASK = 0xFFFFFF;
    private static final long DOUBLE_SIGN_MASK = Long.MIN_VALUE;
    private static final long DOUBLE_EXPONENT_MASK = 0x7FF0000000000000L;
    private static final long DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFL;
    private static final long DOUBLE_MANTISSA_MSB_MASK = 0x10000000000000L;
    private static final long DOUBLE_BIAS = 1022L;
    private static final int S390_DOUBLE_BIAS = 64;
    private static final long S390_DOUBLE_EXPONENT_MASK = 0x7F00000000000000L;
    private static final long S390_DOUBLE_MANTISSA_MASK = 0xFFFFFFFFFFFFFFL;

    static {
        if (Platform.IS_ASCII) {
            LOCAL_POSITIVE_NUM_MASK = (byte)48;
            LOCAL_POSITIVE_NUMC_MASK = (byte)48;
            LOCAL_NEGATIVE_NUM_NUMC_MASK = (byte)112;
            LOCAL_ZERO_DIFF = (byte)48;
        } else {
            LOCAL_POSITIVE_NUM_MASK = (byte)-16;
            LOCAL_POSITIVE_NUMC_MASK = (byte)-64;
            LOCAL_NEGATIVE_NUM_NUMC_MASK = (byte)-48;
            LOCAL_ZERO_DIFF = (byte)-16;
        }
    }

    public static int getLengthInBytes(int digits, boolean isNum) {
        if (isNum) {
            return digits;
        }
        return digits / 2 + 1;
    }

    public static void toDecimal(int value, byte[] buffer, int offset, int length, int itemLength, byte pos) {
        int bufferIndex = offset + itemLength - 1;
        if (value >= 0) {
            buffer[bufferIndex] = pos;
        } else {
            value = -value;
            buffer[bufferIndex] = 13;
        }
        boolean wroteLow = true;
        int digitsToWrite = length;
        while (value > 0 && digitsToWrite > 0) {
            int n = bufferIndex--;
            buffer[n] = (byte)(buffer[n] | (byte)(value % 10 << 4));
            wroteLow = false;
            if ((value /= 10) == 0 || --digitsToWrite == 0) break;
            buffer[bufferIndex] = (byte)(value % 10);
            --digitsToWrite;
            wroteLow = true;
            value /= 10;
        }
        if (digitsToWrite > 0) {
            if (wroteLow) {
                --digitsToWrite;
                --bufferIndex;
            }
            while (digitsToWrite > 0) {
                buffer[bufferIndex] = 0;
                --bufferIndex;
                digitsToWrite -= 2;
            }
        }
    }

    public static void toDecimal(long value, byte[] buffer, int offset, int length, int itemLength, byte pos) {
        int bufferIndex = offset + itemLength - 1;
        if (value >= 0L) {
            buffer[bufferIndex] = pos;
        } else {
            value = -value;
            buffer[bufferIndex] = 13;
        }
        boolean wroteLow = true;
        int digitsToWrite = length;
        while (value > 0L && digitsToWrite > 0) {
            int n = bufferIndex--;
            buffer[n] = (byte)(buffer[n] | (byte)(value % 10L << 4));
            wroteLow = false;
            if ((value /= 10L) == 0L || --digitsToWrite == 0) break;
            buffer[bufferIndex] = (byte)(value % 10L);
            --digitsToWrite;
            wroteLow = true;
            value /= 10L;
        }
        if (digitsToWrite > 0) {
            if (wroteLow) {
                --digitsToWrite;
                --bufferIndex;
            }
            while (digitsToWrite > 0) {
                buffer[bufferIndex] = 0;
                --bufferIndex;
                digitsToWrite -= 2;
            }
        }
    }

    public static void toDecimal(BigInteger value, byte[] buffer, int offset, int length, int itemLength, byte pos) {
        if (value.bitLength() < 63) {
            NumericUtil.toDecimal(value.longValue(), buffer, offset, length, itemLength, pos);
            return;
        }
        BigInteger[] topAndBottom = value.divideAndRemainder(TEN_TO_THE_SEVENTEENTH);
        int byteOfSeventeethDigit = offset + length / 2 - 8;
        long bottom = topAndBottom[1].longValue();
        NumericUtil.toDecimal(bottom, buffer, byteOfSeventeethDigit, 17, 9, pos);
        long top = topAndBottom[0].longValue();
        if (top < 0L) {
            top = -top;
        }
        int digitsToWrite = length - 17;
        int bufferIndex = byteOfSeventeethDigit - 1;
        while (top > 0L && digitsToWrite > 0) {
            buffer[bufferIndex] = (byte)(top % 10L);
            if ((top /= 10L) == 0L || --digitsToWrite == 0) {
                --bufferIndex;
                --digitsToWrite;
                break;
            }
            int n = bufferIndex--;
            buffer[n] = (byte)(buffer[n] | (byte)(top % 10L << 4));
            --digitsToWrite;
            top /= 10L;
        }
        while (digitsToWrite > 0) {
            buffer[bufferIndex] = 0;
            --bufferIndex;
            digitsToWrite -= 2;
        }
    }

    public static long decimalToLong(byte[] buffer, int offset, int length) throws AnyException {
        long result = (buffer[offset] & 0xF0) >> 4;
        int lastByte = offset + length / 2;
        while (offset < lastByte) {
            int nextDigit = buffer[offset] & 0xF;
            if (nextDigit >= 10) {
                throw new InvalidArgumentException().fillInMessage("EGL0053E", "decimal");
            }
            result = result * 10L + (long)nextDigit;
            nextDigit = (buffer[++offset] & 0xF0) >> 4;
            if (nextDigit < 10) {
                result = result * 10L + (long)nextDigit;
                continue;
            }
            throw new InvalidArgumentException().fillInMessage("EGL0053E", "decimal");
        }
        int sign = buffer[offset] & 0xF;
        if (sign == 12 || sign == 15) {
            return result;
        }
        if (sign == 13 || sign == 11) {
            return -result;
        }
        throw new InvalidArgumentException().fillInMessage("EGL0053E", "decimal");
    }

    public static BigInteger decimalToBigInteger(byte[] buffer, int offset, int length) throws AnyException {
        BigInteger bi;
        long top;
        int byteOfSeventeethDigit = offset + length / 2 - 8;
        long bottom = NumericUtil.decimalToLong(buffer, byteOfSeventeethDigit, 17);
        boolean positive = true;
        if (bottom < 0L) {
            bottom = -bottom;
            positive = false;
        }
        if ((top = (long)((buffer[offset] & 0xF0) >> 4)) > 9L) {
            throw new InvalidArgumentException().fillInMessage("EGL0053E", "decimal");
        }
        int nextDigit = buffer[offset] & 0xF;
        if (nextDigit >= 10) {
            throw new InvalidArgumentException().fillInMessage("EGL0053E", "decimal");
        }
        top = top * 10L + (long)nextDigit;
        ++offset;
        while (offset < byteOfSeventeethDigit) {
            nextDigit = (buffer[offset] & 0xF0) >> 4;
            if (nextDigit >= 10) {
                throw new InvalidArgumentException().fillInMessage("EGL0053E", "decimal");
            }
            top = top * 10L + (long)nextDigit;
            nextDigit = buffer[offset] & 0xF;
            if (nextDigit >= 10) {
                throw new InvalidArgumentException().fillInMessage("EGL0053E", "decimal");
            }
            top = top * 10L + (long)nextDigit;
            ++offset;
        }
        if (top == 0L) {
            bi = BigInteger.valueOf(bottom);
        } else {
            bi = BigInteger.valueOf(top);
            bi = bi.multiply(TEN_TO_THE_SEVENTEENTH);
            bi = bi.add(BigInteger.valueOf(bottom));
        }
        if (positive) {
            return bi;
        }
        return bi.negate();
    }

    public static void toZero(byte[] buffer, int offset, int itemLength, byte pos, byte zero) {
        int i = 0;
        while (i < itemLength - 1) {
            buffer[offset + i] = zero;
            ++i;
        }
        buffer[offset + i] = pos;
    }

    public static void toNum(int value, byte[] buffer, int offset, int length, boolean ascii, boolean num) {
        if (ascii) {
            NumericUtil.toNum(value, buffer, offset, length, (byte)48, (byte)112, (byte)48);
        } else {
            NumericUtil.toNum(value, buffer, offset, length, num ? (byte)-16 : -64, (byte)-48, (byte)-16);
        }
    }

    public static void toNum(int value, byte[] buffer, int offset, int length, byte pos, byte neg, byte zero) {
        int bufferIndex = offset + length - 1;
        if (value >= 0) {
            buffer[bufferIndex] = (byte)(pos | value % 10);
        } else {
            value = -value;
            buffer[bufferIndex] = (byte)(neg | value % 10);
        }
        int digitsToWrite = length - 1;
        value /= 10;
        while (value > 0 && digitsToWrite > 0) {
            buffer[--bufferIndex] = (byte)(value % 10 + zero);
            value /= 10;
            --digitsToWrite;
        }
        while (digitsToWrite > 0) {
            --digitsToWrite;
            buffer[--bufferIndex] = zero;
        }
    }

    public static void toNum(long value, byte[] buffer, int offset, int length, boolean ascii, boolean num) {
        if (ascii) {
            NumericUtil.toNum(value, buffer, offset, length, (byte)48, (byte)112, (byte)48);
        } else {
            NumericUtil.toNum(value, buffer, offset, length, num ? (byte)-16 : -64, (byte)-48, (byte)-16);
        }
    }

    public static void toNum(long value, byte[] buffer, int offset, int length, byte pos, byte neg, byte zero) {
        int bufferIndex = offset + length - 1;
        if (value >= 0L) {
            buffer[bufferIndex] = (byte)((long)pos | value % 10L);
        } else {
            value = -value;
            buffer[bufferIndex] = (byte)((long)neg | value % 10L);
        }
        int digitsToWrite = length - 1;
        value /= 10L;
        while (value > 0L && digitsToWrite > 0) {
            buffer[--bufferIndex] = (byte)(value % 10L + (long)zero);
            value /= 10L;
            --digitsToWrite;
        }
        while (digitsToWrite > 0) {
            --digitsToWrite;
            buffer[--bufferIndex] = zero;
        }
    }

    public static void toNum(BigInteger value, byte[] buffer, int offset, int length, boolean ascii, boolean num) {
        if (ascii) {
            NumericUtil.toNum(value, buffer, offset, length, (byte)48, (byte)112, (byte)48);
        } else {
            NumericUtil.toNum(value, buffer, offset, length, num ? (byte)-16 : -64, (byte)-48, (byte)-16);
        }
    }

    public static void toNum(BigInteger value, byte[] buffer, int offset, int length, byte pos, byte neg, byte zero) {
        if (value.bitLength() < 63) {
            NumericUtil.toNum(value.longValue(), buffer, offset, length, pos, neg, zero);
            return;
        }
        BigInteger[] topAndBottom = value.divideAndRemainder(TEN_TO_THE_SEVENTEENTH);
        int byteOfSeventeethDigit = offset + length - 17;
        long bottom = topAndBottom[1].longValue();
        NumericUtil.toNum(bottom, buffer, byteOfSeventeethDigit, 17, pos, neg, zero);
        long top = topAndBottom[0].longValue();
        if (top < 0L) {
            top = -top;
        }
        int digitsToWrite = length - 17;
        int bufferIndex = byteOfSeventeethDigit;
        while (top > 0L && digitsToWrite > 0) {
            buffer[--bufferIndex] = (byte)(top % 10L + (long)zero);
            top /= 10L;
            --digitsToWrite;
        }
        while (digitsToWrite > 0) {
            --digitsToWrite;
            buffer[--bufferIndex] = zero;
        }
    }

    public static void numToRemote(byte[] source, int sourceOffset, int length, boolean isNum, byte[] target, int targetOffset) {
        int zero = Platform.IS_ASCII ? -16 : 48;
        int i = 0;
        while (i < length - 1) {
            target[targetOffset + i] = (byte)(zero + (byte)(source[sourceOffset + i] & 0xF));
            ++i;
        }
        target[targetOffset + length - 1] = (byte)(source[sourceOffset + length - 1] & 0xF);
        byte sign = (byte)(source[sourceOffset + length - 1] & 0xF0);
        if (Platform.IS_ASCII) {
            if (sign == 48) {
                int posSign = isNum ? -16 : -64;
                int n = targetOffset + length - 1;
                target[n] = (byte)(target[n] | posSign);
            } else {
                int n = targetOffset + length - 1;
                target[n] = (byte)(target[n] | 0xFFFFFFD0);
            }
        } else if (sign == -16 || sign == -64) {
            int n = targetOffset + length - 1;
            target[n] = (byte)(target[n] | 0x30);
        } else {
            int n = targetOffset + length - 1;
            target[n] = (byte)(target[n] | 0x70);
        }
    }

    public static int floatToS390IntBits(float ieeeFloat) {
        int quotient;
        boolean positive;
        int ieeeIntBits = Float.floatToIntBits(ieeeFloat);
        boolean bl = positive = (ieeeIntBits & Integer.MIN_VALUE) == 0;
        if ((ieeeIntBits & Integer.MAX_VALUE) == 0) {
            return ieeeIntBits;
        }
        int exponent = ieeeIntBits & 0x7F800000;
        exponent >>>= 23;
        int mantissa = ieeeIntBits & 0x7FFFFF;
        if ((exponent -= 126) > -126) {
            mantissa |= 0x800000;
        }
        int remainder = Math.abs(exponent) % 4;
        int s390Exponent = quotient = Math.abs(exponent) / 4;
        if (exponent > 0 && remainder != 0) {
            ++s390Exponent;
        }
        if (exponent < 0) {
            s390Exponent = -s390Exponent;
        }
        s390Exponent += 64;
        int s390Mantissa = mantissa;
        if (remainder > 0) {
            int shift_places;
            if (exponent > 0) {
                shift_places = 4 - remainder;
                s390Mantissa >>>= shift_places;
            } else {
                if (exponent == -126 && (s390Mantissa & 0xF00000) == 0) {
                    s390Mantissa <<= 4;
                    --s390Exponent;
                }
                shift_places = remainder;
                s390Mantissa >>>= shift_places;
            }
        }
        if (exponent == -126) {
            s390Mantissa <<= 1;
            while (s390Mantissa != 0 && (s390Mantissa & 0xF00000) == 0) {
                s390Mantissa <<= 4;
                --s390Exponent;
            }
        }
        int s390Float = 0;
        int s390ExponentBits = s390Exponent & 0x7F;
        s390Float = s390ExponentBits << 24;
        if (!positive) {
            s390Float |= Integer.MIN_VALUE;
        }
        return s390Float |= s390Mantissa;
    }

    public static float intS390BitsToFloat(int floatBits) {
        boolean positive;
        boolean bl = positive = (floatBits & Integer.MIN_VALUE) == 0;
        if ((floatBits & Integer.MAX_VALUE) == 0) {
            if (positive) {
                return 0.0f;
            }
            return -0.0f;
        }
        int mantissa = floatBits & 0xFFFFFF;
        int exponent = floatBits & 0x7F000000;
        exponent >>= 24;
        int ieeeExponent = (exponent -= 64) * 4;
        int ieeeMantissa = mantissa;
        if (ieeeExponent <= -126) {
            ieeeMantissa >>= 1;
            while (ieeeExponent < -126) {
                ++ieeeExponent;
                ieeeMantissa >>= 1;
            }
        }
        while (ieeeMantissa != 0 && (ieeeMantissa & 0x800000) == 0 && ieeeExponent > -126) {
            ieeeMantissa <<= 1;
            --ieeeExponent;
        }
        if (ieeeExponent < -149) {
            return 0.0f;
        }
        if (ieeeExponent > 128) {
            if (positive) {
                return Float.POSITIVE_INFINITY;
            }
            return Float.NEGATIVE_INFINITY;
        }
        int ieeeBits = 0;
        if (!positive) {
            ieeeBits |= Integer.MIN_VALUE;
        }
        ieeeExponent += 126;
        ieeeBits |= (ieeeExponent <<= 23);
        return Float.intBitsToFloat(ieeeBits |= (ieeeMantissa &= 0x7FFFFF));
    }

    public static long doubleToS390LongBits(double ieeeDouble) {
        long quotient;
        boolean positive;
        long ieeeLongBits = Double.doubleToLongBits(ieeeDouble);
        boolean bl = positive = (ieeeLongBits & Long.MIN_VALUE) == 0L;
        if ((ieeeLongBits & Long.MAX_VALUE) == 0L) {
            return ieeeLongBits;
        }
        long exponent = ieeeLongBits & 0x7FF0000000000000L;
        exponent >>>= 52;
        long mantissa = ieeeLongBits & 0xFFFFFFFFFFFFFL;
        long remainder = Math.abs(exponent -= 1022L) % 4L;
        long s390Exponent = quotient = Math.abs(exponent) / 4L;
        if (exponent > 0L && remainder != 0L) {
            ++s390Exponent;
        }
        if (exponent < 0L) {
            s390Exponent = -s390Exponent;
        }
        s390Exponent += 64L;
        long s390Mantissa = mantissa;
        s390Mantissa = exponent > -1022L ? (s390Mantissa |= 0x10000000000000L) : (s390Mantissa <<= 1);
        s390Mantissa <<= 3;
        if (remainder > 0L) {
            if (exponent > 0L) {
                int shift_places = (int)(4L - remainder);
                s390Mantissa >>>= shift_places;
            } else {
                if (exponent == -1022L && (s390Mantissa & 0xF0000000000000L) == 0L) {
                    s390Mantissa <<= 4;
                    --s390Exponent;
                }
                s390Mantissa >>>= (int)remainder;
            }
        }
        if (exponent == -1022L) {
            while (s390Mantissa != 0L && (s390Mantissa & 0xF0000000000000L) == 0L) {
                s390Mantissa <<= 4;
                --s390Exponent;
            }
        }
        if (s390Exponent > 127L) {
            throw new RuntimeException("Number outside of range for double precision OS390 Float");
        }
        if (s390Exponent < 0L) {
            return 0L;
        }
        long s390Double = 0L;
        long s390ExponentBits = s390Exponent & 0x7FL;
        s390Double = s390ExponentBits << 56;
        if (!positive) {
            s390Double |= Long.MIN_VALUE;
        }
        return s390Double |= s390Mantissa;
    }

    public static double longS390BitsToDouble(long doubleBits) {
        boolean positive;
        boolean bl = positive = (doubleBits & Long.MIN_VALUE) == 0L;
        if ((doubleBits & Long.MAX_VALUE) == 0L) {
            if (positive) {
                return 0.0;
            }
            return -0.0;
        }
        long mantissa = doubleBits & 0xFFFFFFFFFFFFFFL;
        long exponent = doubleBits & 0x7F00000000000000L;
        exponent >>= 56;
        long ieeeExponent = (exponent -= 64L) * 4L;
        long ieeeMantissa = mantissa;
        ieeeMantissa >>= 3;
        if (ieeeExponent <= -1022L) {
            ieeeMantissa >>= 1;
            while (ieeeExponent < -1022L) {
                ++ieeeExponent;
                ieeeMantissa >>= 1;
            }
        }
        while (ieeeMantissa != 0L && (ieeeMantissa & 0x10000000000000L) == 0L && ieeeExponent > -1022L) {
            ieeeMantissa <<= 1;
            --ieeeExponent;
        }
        if (ieeeExponent < -1045L) {
            return 0.0;
        }
        if (ieeeExponent > 1024L) {
            if (positive) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NEGATIVE_INFINITY;
        }
        long ieeeBits = 0L;
        if (!positive) {
            ieeeBits |= Long.MIN_VALUE;
        }
        ieeeExponent += 1022L;
        ieeeBits |= (ieeeExponent <<= 52);
        return Double.longBitsToDouble(ieeeBits |= (ieeeMantissa &= 0xFFFFFFFFFFFFFL));
    }
}

