/*******************************************************************************
 * Copyright © 2011, 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
/* The following code was generated by JFlex 1.4.1 on 4/27/05 2:18 PM */

package org.eclipse.edt.compiler.internal.dli;
import java_cup.runtime.Symbol;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 4/27/05 2:18 PM from the specification file
 * <tt>dli.flex</tt>
 */
class DLILexer implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int SINGLE_QUOTED_STRINGLIT = 2;
  public static final int STRINGLIT = 1;
  public static final int HOSTVAR = 3;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\7\1\3\1\1\1\0\1\3\1\2\16\7\4\0\1\3\1\20"+
    "\1\57\1\25\1\6\1\0\1\23\1\60\1\26\1\27\1\16\1\14"+
    "\1\0\1\14\1\12\1\15\12\11\1\56\1\0\1\22\1\17\1\21"+
    "\1\0\1\5\1\54\1\53\1\31\1\34\1\13\1\37\1\40\1\41"+
    "\1\45\1\4\1\50\1\32\1\51\1\42\1\47\1\43\1\35\1\46"+
    "\1\33\1\36\1\44\2\4\1\55\1\52\1\4\1\30\1\61\1\10"+
    "\1\0\1\4\1\0\1\54\1\62\1\31\1\34\1\13\1\63\1\40"+
    "\1\41\1\45\1\4\1\50\1\32\1\51\1\64\1\47\1\43\1\35"+
    "\1\65\1\33\1\66\1\44\2\4\1\55\1\52\1\4\1\0\1\24"+
    "\2\0\41\7\2\0\4\4\4\0\1\4\12\0\1\4\4\0\1\4"+
    "\5\0\27\4\1\0\37\4\1\0\u0128\4\2\0\22\4\34\0\136\4"+
    "\2\0\11\4\2\0\7\4\16\0\2\4\16\0\5\4\11\0\1\4"+
    "\21\0\117\7\21\0\3\7\27\0\1\4\13\0\1\4\1\0\3\4"+
    "\1\0\1\4\1\0\24\4\1\0\54\4\1\0\10\4\2\0\32\4"+
    "\14\0\202\4\1\0\4\7\5\0\71\4\2\0\2\4\2\0\2\4"+
    "\3\0\46\4\2\0\2\4\67\0\46\4\2\0\1\4\7\0\47\4"+
    "\11\0\21\7\1\0\27\7\1\0\3\7\1\0\1\7\1\0\2\7"+
    "\1\0\1\7\13\0\33\4\5\0\3\4\56\0\32\4\5\0\13\4"+
    "\13\7\12\0\12\7\6\0\1\7\143\4\1\0\1\4\7\7\2\0"+
    "\6\7\2\4\2\7\1\0\4\7\2\0\12\7\3\4\22\0\1\7"+
    "\1\4\1\7\33\4\3\0\33\7\65\0\46\4\13\7\u0150\0\3\7"+
    "\1\0\65\4\2\0\1\7\1\4\20\7\2\0\1\4\4\7\3\0"+
    "\12\4\2\7\2\0\12\7\21\0\3\7\1\0\10\4\2\0\2\4"+
    "\2\0\26\4\1\0\7\4\1\0\1\4\3\0\4\4\2\0\1\7"+
    "\1\0\7\7\2\0\2\7\2\0\3\7\11\0\1\7\4\0\2\4"+
    "\1\0\3\4\2\7\2\0\12\7\4\4\16\0\1\7\2\0\6\4"+
    "\4\0\2\4\2\0\26\4\1\0\7\4\1\0\2\4\1\0\2\4"+
    "\1\0\2\4\2\0\1\7\1\0\5\7\4\0\2\7\2\0\3\7"+
    "\13\0\4\4\1\0\1\4\7\0\14\7\3\4\14\0\3\7\1\0"+
    "\7\4\1\0\1\4\1\0\3\4\1\0\26\4\1\0\7\4\1\0"+
    "\2\4\1\0\5\4\2\0\1\7\1\4\10\7\1\0\3\7\1\0"+
    "\3\7\2\0\1\4\17\0\1\4\5\0\12\7\21\0\3\7\1\0"+
    "\10\4\2\0\2\4\2\0\26\4\1\0\7\4\1\0\2\4\2\0"+
    "\4\4\2\0\1\7\1\4\6\7\3\0\2\7\2\0\3\7\10\0"+
    "\2\7\4\0\2\4\1\0\3\4\4\0\12\7\22\0\2\7\1\0"+
    "\6\4\3\0\3\4\1\0\4\4\3\0\2\4\1\0\1\4\1\0"+
    "\2\4\3\0\2\4\3\0\3\4\3\0\10\4\1\0\3\4\4\0"+
    "\5\7\3\0\3\7\1\0\4\7\11\0\1\7\17\0\11\7\21\0"+
    "\3\7\1\0\10\4\1\0\3\4\1\0\27\4\1\0\12\4\1\0"+
    "\5\4\4\0\7\7\1\0\3\7\1\0\4\7\7\0\2\7\11\0"+
    "\2\4\4\0\12\7\22\0\2\7\1\0\10\4\1\0\3\4\1\0"+
    "\27\4\1\0\12\4\1\0\5\4\4\0\7\7\1\0\3\7\1\0"+
    "\4\7\7\0\2\7\7\0\1\4\1\0\2\4\4\0\12\7\22\0"+
    "\2\7\1\0\10\4\1\0\3\4\1\0\27\4\1\0\20\4\4\0"+
    "\6\7\2\0\3\7\1\0\4\7\11\0\1\7\10\0\2\4\4\0"+
    "\12\7\22\0\2\7\1\0\22\4\3\0\30\4\1\0\11\4\1\0"+
    "\1\4\2\0\7\4\3\0\1\7\4\0\6\7\1\0\1\7\1\0"+
    "\10\7\22\0\2\7\15\0\60\4\1\7\2\4\7\7\4\0\10\4"+
    "\10\7\1\0\12\7\47\0\2\4\1\0\1\4\2\0\2\4\1\0"+
    "\1\4\2\0\1\4\6\0\4\4\1\0\7\4\1\0\3\4\1\0"+
    "\1\4\1\0\1\4\2\0\2\4\1\0\4\4\1\7\2\4\6\7"+
    "\1\0\2\7\1\4\2\0\5\4\1\0\1\4\1\0\6\7\2\0"+
    "\12\7\2\0\2\4\42\0\1\4\27\0\2\7\6\0\12\7\13\0"+
    "\1\7\1\0\1\7\1\0\1\7\4\0\2\7\10\4\1\0\42\4"+
    "\6\0\24\7\1\0\2\7\4\4\4\0\10\7\1\0\44\7\11\0"+
    "\1\7\71\0\42\4\1\0\5\4\1\0\2\4\1\0\7\7\3\0"+
    "\4\7\6\0\12\7\6\0\6\4\4\7\106\0\46\4\12\0\47\4"+
    "\11\0\132\4\5\0\104\4\5\0\122\4\6\0\7\4\1\0\77\4"+
    "\1\0\1\4\1\0\4\4\2\0\7\4\1\0\1\4\1\0\4\4"+
    "\2\0\47\4\1\0\1\4\1\0\4\4\2\0\37\4\1\0\1\4"+
    "\1\0\4\4\2\0\7\4\1\0\1\4\1\0\4\4\2\0\7\4"+
    "\1\0\7\4\1\0\27\4\1\0\37\4\1\0\1\4\1\0\4\4"+
    "\2\0\7\4\1\0\47\4\1\0\23\4\16\0\11\7\56\0\125\4"+
    "\14\0\u026c\4\2\0\10\4\12\0\32\4\5\0\113\4\225\0\64\4"+
    "\40\7\7\0\1\4\4\0\12\7\41\0\4\7\1\0\12\7\6\0"+
    "\130\4\10\0\51\4\1\7\u0556\0\234\4\4\0\132\4\6\0\26\4"+
    "\2\0\6\4\2\0\46\4\2\0\6\4\2\0\10\4\1\0\1\4"+
    "\1\0\1\4\1\0\1\4\1\0\37\4\2\0\65\4\1\0\7\4"+
    "\1\0\1\4\3\0\3\4\1\0\7\4\3\0\4\4\2\0\6\4"+
    "\4\0\15\4\5\0\3\4\1\0\7\4\17\0\4\7\32\0\5\7"+
    "\20\0\2\4\51\0\6\7\17\0\1\4\40\0\20\4\40\0\15\7"+
    "\4\0\1\7\40\0\1\4\4\0\1\4\2\0\12\4\1\0\1\4"+
    "\3\0\5\4\6\0\1\4\1\0\1\4\1\0\1\4\1\0\4\4"+
    "\1\0\3\4\1\0\7\4\46\0\44\4\u0e81\0\3\4\31\0\11\4"+
    "\6\7\1\0\5\4\2\0\3\4\6\0\124\4\4\0\2\7\2\0"+
    "\2\4\2\0\136\4\6\0\50\4\4\0\136\4\21\0\30\4\u0248\0"+
    "\u19b6\4\112\0\u51a6\4\132\0\u048d\4\u0773\0\u2ba4\4\u215c\0\u012e\4\322\0"+
    "\7\4\14\0\5\4\5\0\1\4\1\7\12\4\1\0\15\4\1\0"+
    "\5\4\1\0\1\4\1\0\2\4\1\0\2\4\1\0\154\4\41\0"+
    "\u016b\4\22\0\100\4\2\0\66\4\50\0\14\4\44\0\4\7\17\0"+
    "\2\4\30\0\3\4\31\0\1\4\6\0\3\4\1\0\1\4\1\0"+
    "\207\4\2\0\1\7\4\0\1\4\13\0\12\7\7\0\32\4\4\0"+
    "\1\4\1\0\32\4\12\0\132\4\3\0\6\4\2\0\6\4\2\0"+
    "\6\4\2\0\3\4\3\0\2\4\3\0\2\4\22\0\3\7\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\4\0\1\1\2\2\1\3\1\4\1\5\2\1\1\6"+
    "\1\7\1\1\1\10\1\11\1\12\1\13\1\14\1\15"+
    "\1\16\1\17\14\3\1\20\1\21\1\22\1\23\2\24"+
    "\1\25\1\26\1\23\2\27\1\26\1\30\1\0\2\3"+
    "\1\31\1\0\1\2\1\0\1\32\1\33\1\34\15\3"+
    "\1\35\1\36\12\3\1\37\1\26\1\40\1\41\1\42"+
    "\1\43\1\44\1\45\1\46\2\0\2\3\1\47\4\3"+
    "\1\50\2\3\1\51\1\3\1\52\1\53\1\54\1\3"+
    "\1\55\11\3\1\56\1\57\1\60\1\61\1\62\1\63"+
    "\1\64\1\65\1\66\1\67\1\70\1\71\1\72\1\73"+
    "\1\74\1\75\1\76\1\77\1\100\1\101\1\102\1\103"+
    "\1\104";

  private static int [] zzUnpackAction() {
    int [] result = new int[143];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\67\0\156\0\245\0\334\0\334\0\u0113\0\u014a"+
    "\0\334\0\u0181\0\u01b8\0\u01ef\0\334\0\334\0\u0226\0\u025d"+
    "\0\u0294\0\334\0\334\0\u014a\0\334\0\334\0\334\0\u02cb"+
    "\0\u0302\0\u0339\0\u0370\0\u03a7\0\u03de\0\u0415\0\u044c\0\u0483"+
    "\0\u04ba\0\u04f1\0\u0528\0\334\0\334\0\334\0\u055f\0\334"+
    "\0\u0596\0\334\0\u05cd\0\u0604\0\334\0\u063b\0\u0672\0\334"+
    "\0\u06a9\0\u06e0\0\u06a9\0\u0717\0\u074e\0\u0785\0\u07bc\0\334"+
    "\0\334\0\334\0\u07f3\0\u082a\0\u0861\0\u0898\0\u08cf\0\u0906"+
    "\0\u093d\0\u0974\0\u09ab\0\u09e2\0\u0a19\0\u0a50\0\u0a87\0\u0abe"+
    "\0\u014a\0\u0af5\0\u0b2c\0\u0b63\0\u0b9a\0\u0bd1\0\u0c08\0\u0c3f"+
    "\0\u0c76\0\u0cad\0\u0ce4\0\334\0\334\0\334\0\334\0\334"+
    "\0\334\0\334\0\334\0\u0d1b\0\u0d1b\0\u0d52\0\u0d89\0\u0dc0"+
    "\0\u014a\0\u0df7\0\u0e2e\0\u0e65\0\u0e9c\0\u014a\0\u0ed3\0\u0f0a"+
    "\0\u014a\0\u0f41\0\u0f78\0\u014a\0\u014a\0\u0faf\0\u014a\0\u0fe6"+
    "\0\u101d\0\u1054\0\u108b\0\u10c2\0\u10f9\0\u1130\0\u1167\0\u119e"+
    "\0\u014a\0\u014a\0\u014a\0\u014a\0\u014a\0\u014a\0\u014a\0\u014a"+
    "\0\u014a\0\u014a\0\u014a\0\u014a\0\u014a\0\u014a\0\u014a\0\u014a"+
    "\0\u014a\0\u014a\0\u014a\0\u014a\0\u014a\0\u014a\0\u014a";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[143];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\5\1\6\1\7\1\6\3\10\1\5\1\11\1\12"+
    "\1\13\1\10\1\5\1\14\1\15\1\16\1\17\1\20"+
    "\1\21\1\22\1\23\1\24\1\25\1\26\1\27\1\30"+
    "\1\31\1\32\1\33\1\10\1\34\1\35\1\36\2\10"+
    "\1\37\1\10\1\40\1\41\1\42\5\10\1\43\1\44"+
    "\1\45\1\46\1\5\1\10\1\35\1\10\1\41\1\34"+
    "\1\47\1\50\1\51\54\47\1\52\1\47\1\53\5\47"+
    "\1\54\1\55\1\56\55\54\1\55\1\57\5\54\1\60"+
    "\1\5\65\60\70\0\1\6\71\0\1\10\1\61\1\62"+
    "\1\10\1\0\1\10\1\0\1\10\11\0\1\63\3\0"+
    "\25\10\4\0\5\10\11\0\1\12\1\64\1\65\64\0"+
    "\1\64\72\0\1\66\1\67\67\0\1\70\66\0\1\71"+
    "\66\0\1\72\53\0\1\10\1\61\1\62\1\10\1\0"+
    "\1\10\1\0\1\10\11\0\1\63\3\0\1\10\1\73"+
    "\6\10\1\74\14\10\4\0\5\10\4\0\1\10\1\61"+
    "\1\62\1\10\1\0\1\10\1\0\1\10\11\0\1\63"+
    "\3\0\16\10\1\75\6\10\4\0\5\10\4\0\1\10"+
    "\1\61\1\62\1\10\1\0\1\10\1\0\1\76\11\0"+
    "\1\63\3\0\5\10\1\77\3\10\1\100\7\10\1\101"+
    "\3\10\4\0\2\10\1\100\1\10\1\77\4\0\1\10"+
    "\1\61\1\62\1\10\1\0\1\10\1\0\1\102\11\0"+
    "\1\63\3\0\1\10\1\103\23\10\4\0\5\10\4\0"+
    "\1\10\1\61\1\62\1\10\1\0\1\10\1\0\1\104"+
    "\11\0\1\63\3\0\25\10\4\0\5\10\4\0\1\10"+
    "\1\61\1\62\1\10\1\0\1\10\1\0\1\10\11\0"+
    "\1\63\3\0\1\10\1\105\23\10\4\0\5\10\4\0"+
    "\1\10\1\61\1\62\1\10\1\0\1\10\1\0\1\10"+
    "\11\0\1\63\3\0\2\10\1\106\5\10\1\107\1\110"+
    "\1\10\1\111\4\10\1\112\4\10\4\0\2\10\1\110"+
    "\2\10\4\0\1\10\1\61\1\62\1\10\1\0\1\10"+
    "\1\0\1\10\11\0\1\63\3\0\16\10\1\113\6\10"+
    "\4\0\5\10\4\0\1\10\1\61\1\62\1\10\1\0"+
    "\1\10\1\0\1\10\11\0\1\63\3\0\1\114\1\10"+
    "\1\115\6\10\1\116\13\10\4\0\2\10\1\116\2\10"+
    "\4\0\1\10\1\61\1\62\1\10\1\0\1\10\1\0"+
    "\1\117\11\0\1\63\3\0\1\120\15\10\1\121\6\10"+
    "\4\0\5\10\4\0\1\10\1\61\1\62\1\10\1\0"+
    "\1\10\1\0\1\10\11\0\1\63\3\0\12\10\1\122"+
    "\12\10\4\0\5\10\4\0\1\10\1\61\1\62\1\10"+
    "\1\0\1\10\1\0\1\10\11\0\1\63\3\0\15\10"+
    "\1\123\7\10\4\0\3\10\1\123\1\10\1\47\2\0"+
    "\54\47\1\0\1\47\1\0\5\47\1\0\1\50\144\0"+
    "\1\124\1\0\1\125\1\126\1\127\1\130\1\131\1\132"+
    "\1\54\2\0\55\54\2\0\5\54\1\0\1\55\145\0"+
    "\1\133\1\125\1\126\1\127\1\130\1\131\1\132\10\0"+
    "\1\10\62\0\1\10\1\61\1\62\3\10\1\0\1\10"+
    "\11\0\1\63\3\0\25\10\4\0\5\10\11\0\1\64"+
    "\1\0\1\65\64\0\1\134\2\0\1\135\52\0\1\66"+
    "\1\6\1\7\64\66\16\67\1\136\50\67\4\0\1\10"+
    "\1\61\1\62\1\10\1\0\1\10\1\0\1\10\11\0"+
    "\1\63\3\0\2\10\1\137\22\10\4\0\5\10\4\0"+
    "\1\10\1\61\1\62\1\10\1\0\1\10\1\0\1\10"+
    "\11\0\1\63\3\0\17\10\1\140\5\10\4\0\5\10"+
    "\4\0\1\10\1\61\1\62\1\10\1\0\1\10\1\0"+
    "\1\10\11\0\1\63\3\0\7\10\1\141\15\10\4\0"+
    "\5\10\4\0\1\10\1\61\1\62\1\10\1\0\1\10"+
    "\1\0\1\10\11\0\1\63\3\0\5\10\1\142\17\10"+
    "\4\0\4\10\1\142\4\0\1\10\1\61\1\62\1\10"+
    "\1\0\1\10\1\0\1\10\11\0\1\63\3\0\23\10"+
    "\1\143\1\10\4\0\5\10\4\0\1\10\1\61\1\62"+
    "\1\10\1\0\1\10\1\0\1\10\11\0\1\63\3\0"+
    "\23\10\1\144\1\10\4\0\5\10\4\0\1\10\1\61"+
    "\1\62\1\10\1\0\1\10\1\0\1\10\11\0\1\63"+
    "\3\0\11\10\1\145\13\10\4\0\2\10\1\145\2\10"+
    "\4\0\1\10\1\61\1\62\1\10\1\0\1\10\1\0"+
    "\1\10\11\0\1\63\3\0\4\10\1\146\20\10\4\0"+
    "\5\10\4\0\1\10\1\61\1\62\1\10\1\0\1\10"+
    "\1\0\1\147\11\0\1\63\3\0\25\10\4\0\5\10"+
    "\4\0\1\10\1\61\1\62\1\10\1\0\1\10\1\0"+
    "\1\10\11\0\1\63\3\0\15\10\1\150\7\10\4\0"+
    "\3\10\1\150\1\10\4\0\1\10\1\61\1\62\1\10"+
    "\1\0\1\10\1\0\1\10\11\0\1\63\3\0\3\10"+
    "\1\151\21\10\4\0\5\10\4\0\1\10\1\61\1\62"+
    "\1\10\1\0\1\10\1\0\1\10\11\0\1\63\3\0"+
    "\1\152\24\10\4\0\5\10\4\0\1\10\1\61\1\62"+
    "\1\10\1\0\1\10\1\0\1\10\11\0\1\63\3\0"+
    "\11\10\1\153\1\10\1\154\11\10\4\0\2\10\1\153"+
    "\2\10\4\0\1\10\1\61\1\62\1\10\1\0\1\10"+
    "\1\0\1\10\11\0\1\63\3\0\12\10\1\155\12\10"+
    "\4\0\5\10\4\0\1\10\1\61\1\62\1\10\1\0"+
    "\1\10\1\0\1\10\11\0\1\63\3\0\2\10\1\156"+
    "\22\10\4\0\5\10\4\0\1\10\1\61\1\62\1\10"+
    "\1\0\1\10\1\0\1\10\11\0\1\63\3\0\2\10"+
    "\1\157\22\10\4\0\5\10\4\0\1\10\1\61\1\62"+
    "\1\10\1\0\1\10\1\0\1\10\11\0\1\63\3\0"+
    "\20\10\1\160\4\10\4\0\5\10\4\0\1\10\1\61"+
    "\1\62\1\10\1\0\1\10\1\0\1\10\11\0\1\63"+
    "\3\0\15\10\1\161\7\10\4\0\3\10\1\161\1\10"+
    "\4\0\1\10\1\61\1\62\1\10\1\0\1\10\1\0"+
    "\1\10\11\0\1\63\3\0\4\10\1\162\7\10\1\163"+
    "\10\10\4\0\5\10\4\0\1\10\1\61\1\62\1\10"+
    "\1\0\1\10\1\0\1\10\11\0\1\63\3\0\12\10"+
    "\1\164\12\10\4\0\5\10\4\0\1\10\1\61\1\62"+
    "\1\10\1\0\1\10\1\0\1\10\11\0\1\63\3\0"+
    "\20\10\1\165\4\10\4\0\5\10\4\0\1\10\1\61"+
    "\1\62\1\10\1\0\1\10\1\0\1\10\11\0\1\63"+
    "\3\0\1\10\1\166\23\10\4\0\5\10\4\0\1\10"+
    "\1\61\1\62\1\10\1\0\1\10\1\0\1\167\11\0"+
    "\1\63\3\0\25\10\4\0\5\10\4\0\1\10\1\61"+
    "\1\62\1\10\1\0\1\10\1\0\1\10\11\0\1\63"+
    "\3\0\2\10\1\170\22\10\4\0\5\10\11\0\1\134"+
    "\55\0\15\67\1\6\1\136\50\67\4\0\1\10\1\61"+
    "\1\62\1\10\1\0\1\10\1\0\1\171\11\0\1\63"+
    "\3\0\25\10\4\0\5\10\4\0\1\10\1\61\1\62"+
    "\1\10\1\0\1\10\1\0\1\10\11\0\1\63\3\0"+
    "\12\10\1\172\12\10\4\0\5\10\4\0\1\10\1\61"+
    "\1\62\1\10\1\0\1\10\1\0\1\10\11\0\1\63"+
    "\3\0\2\10\1\173\10\10\1\174\11\10\4\0\5\10"+
    "\4\0\1\10\1\61\1\62\1\10\1\0\1\10\1\0"+
    "\1\10\11\0\1\63\3\0\5\10\1\175\17\10\4\0"+
    "\4\10\1\175\4\0\1\10\1\61\1\62\1\10\1\0"+
    "\1\10\1\0\1\10\11\0\1\63\3\0\12\10\1\176"+
    "\12\10\4\0\5\10\4\0\1\10\1\61\1\62\1\10"+
    "\1\0\1\10\1\0\1\10\11\0\1\63\3\0\1\177"+
    "\24\10\4\0\5\10\4\0\1\10\1\61\1\62\1\10"+
    "\1\0\1\10\1\0\1\10\11\0\1\63\3\0\5\10"+
    "\1\200\17\10\4\0\4\10\1\200\4\0\1\10\1\61"+
    "\1\62\1\10\1\0\1\10\1\0\1\10\11\0\1\63"+
    "\3\0\20\10\1\201\4\10\4\0\5\10\4\0\1\10"+
    "\1\61\1\62\1\10\1\0\1\10\1\0\1\10\11\0"+
    "\1\63\3\0\3\10\1\202\21\10\4\0\5\10\4\0"+
    "\1\10\1\61\1\62\1\10\1\0\1\10\1\0\1\10"+
    "\11\0\1\63\3\0\12\10\1\203\12\10\4\0\5\10"+
    "\4\0\1\10\1\61\1\62\1\10\1\0\1\10\1\0"+
    "\1\10\11\0\1\63\3\0\7\10\1\204\15\10\4\0"+
    "\5\10\4\0\1\10\1\61\1\62\1\10\1\0\1\10"+
    "\1\0\1\10\11\0\1\63\3\0\3\10\1\205\21\10"+
    "\4\0\5\10\4\0\1\10\1\61\1\62\1\10\1\0"+
    "\1\10\1\0\1\10\11\0\1\63\3\0\5\10\1\206"+
    "\17\10\4\0\4\10\1\206\4\0\1\10\1\61\1\62"+
    "\1\10\1\0\1\10\1\0\1\10\11\0\1\63\3\0"+
    "\21\10\1\207\3\10\4\0\5\10\4\0\1\10\1\61"+
    "\1\62\1\10\1\0\1\10\1\0\1\10\11\0\1\63"+
    "\3\0\5\10\1\210\17\10\4\0\4\10\1\210\4\0"+
    "\1\10\1\61\1\62\1\10\1\0\1\10\1\0\1\10"+
    "\11\0\1\63\3\0\1\10\1\211\23\10\4\0\5\10"+
    "\4\0\1\10\1\61\1\62\1\10\1\0\1\10\1\0"+
    "\1\10\11\0\1\63\3\0\3\10\1\212\21\10\4\0"+
    "\5\10\4\0\1\10\1\61\1\62\1\10\1\0\1\10"+
    "\1\0\1\10\11\0\1\63\3\0\1\10\1\213\1\214"+
    "\17\10\1\215\2\10\4\0\1\215\4\10\4\0\1\10"+
    "\1\61\1\62\1\10\1\0\1\10\1\0\1\10\11\0"+
    "\1\63\3\0\11\10\1\216\13\10\4\0\2\10\1\216"+
    "\2\10\4\0\1\10\1\61\1\62\1\10\1\0\1\10"+
    "\1\0\1\10\11\0\1\63\3\0\5\10\1\217\17\10"+
    "\4\0\4\10\1\217";

  private static int [] zzUnpackTrans() {
    int [] result = new int[4565];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\4\0\2\11\2\1\1\11\3\1\2\11\3\1\2\11"+
    "\1\1\3\11\14\1\3\11\1\1\1\11\1\1\1\11"+
    "\2\1\1\11\2\1\1\11\1\0\3\1\1\0\1\1"+
    "\1\0\3\11\31\1\10\11\1\1\2\0\61\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[143];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
	private StringBuffer stringBuffer;
	private int matchLength;
	private int matchStart;

	private Symbol symbol(int type) {
		return new Symbol(type, yychar, yychar + yylength());
	}

	private Symbol symbol(int type, Object value) {
		return new Symbol(type, yychar, yychar + yylength(), value);
	}

	private Symbol stringSymbol(int type) {
		String string = stringBuffer.toString();
		stringBuffer = null;
		return new Symbol(type, matchStart, matchStart + matchLength, string);
	}
	
	private int hostvarLength;

	private DLIParser parser;
	
	public void setParser(DLIParser parser) {
		this.parser = parser;
	}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  DLILexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  DLILexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1680) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 65: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "ROLS");
          }
        case 69: break;
        case 66: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "ROLB");
          }
        case 70: break;
        case 50: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "STAT");
          }
        case 71: break;
        case 43: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "GHU");
          }
        case 72: break;
        case 34: 
          { stringBuffer.append("\n"); matchLength += yylength();
          }
        case 73: break;
        case 52: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "SYNC");
          }
        case 74: break;
        case 68: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "XRST");
          }
        case 75: break;
        case 38: 
          { return symbol(DLINodeTypes.FLOATLIT, yytext());
          }
        case 76: break;
        case 10: 
          { return symbol(DLINodeTypes.BOOLEANOP, "&");
          }
        case 77: break;
        case 57: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "GMSG");
          }
        case 78: break;
        case 64: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "ROLL");
          }
        case 79: break;
        case 25: 
          { return symbol(DLINodeTypes.DECIMALLIT, yytext());
          }
        case 80: break;
        case 37: 
          { stringBuffer.append("'"); matchLength += yylength();
          }
        case 81: break;
        case 42: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "GHN");
          }
        case 82: break;
        case 20: 
          { yybegin(YYINITIAL); matchLength += yylength(); return stringSymbol(DLINodeTypes.STRINGLIT);
          }
        case 83: break;
        case 31: 
          { stringBuffer.append("\""); matchLength += yylength();
          }
        case 84: break;
        case 51: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "SNAP");
          }
        case 85: break;
        case 17: 
          { yybegin(STRINGLIT); matchStart = yychar; matchLength = 1; stringBuffer = new StringBuffer();
          }
        case 86: break;
        case 13: 
          { return symbol(DLINodeTypes.LPAREN);
          }
        case 87: break;
        case 28: 
          { return symbol(DLINodeTypes.RELATIONOP, "<=");
          }
        case 88: break;
        case 44: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "GNP");
          }
        case 89: break;
        case 58: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "ICMD");
          }
        case 90: break;
        case 33: 
          { stringBuffer.append("\f"); matchLength += yylength();
          }
        case 91: break;
        case 55: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "GSCD");
          }
        case 92: break;
        case 7: 
          { return symbol(DLINodeTypes.RELATIONOP, "=");
          }
        case 93: break;
        case 67: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "OPEN");
          }
        case 94: break;
        case 63: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "RCMD");
          }
        case 95: break;
        case 47: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "CHKP");
          }
        case 96: break;
        case 19: 
          { stringBuffer.append(yytext()); matchLength += yylength();
          }
        case 97: break;
        case 11: 
          { return symbol(DLINodeTypes.BOOLEANOP, "|");
          }
        case 98: break;
        case 35: 
          { stringBuffer.append("\r"); matchLength += yylength();
          }
        case 99: break;
        case 41: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "FLD");
          }
        case 100: break;
        case 22: 
          { stringBuffer.append("\\"); matchLength += yylength();
          }
        case 101: break;
        case 49: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "SETU");
          }
        case 102: break;
        case 5: 
          { return symbol(DLINodeTypes.INTEGERLIT, yytext());
          }
        case 103: break;
        case 2: 
          { /* Do nothing */
          }
        case 104: break;
        case 15: 
          { return symbol(DLINodeTypes.LBRACKET);
          }
        case 105: break;
        case 3: 
          { return symbol(DLINodeTypes.ID, yytext());
          }
        case 106: break;
        case 60: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "INQY");
          }
        case 107: break;
        case 36: 
          { stringBuffer.append("\t"); matchLength += yylength();
          }
        case 108: break;
        case 30: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "GU");
          }
        case 109: break;
        case 24: 
          { stringBuffer.append(yytext());
							matchLength++;
							if(--hostvarLength == 0) {
								yybegin(YYINITIAL);
								return stringSymbol(DLINodeTypes.HOSTVAR);
							}
          }
        case 110: break;
        case 56: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "GHNP");
          }
        case 111: break;
        case 40: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "DEQ");
          }
        case 112: break;
        case 16: 
          { stringBuffer = new StringBuffer();
							hostvarLength = parser.getHostVariableLength(yychar + 1);
							matchStart = yychar;
							matchLength = 1;

							if(hostvarLength == 0) {
								return stringSymbol(DLINodeTypes.HOSTVAR);
							}
							else {
								yybegin(HOSTVAR);
							}
          }
        case 113: break;
        case 48: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "SETS");
          }
        case 114: break;
        case 61: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "INIT");
          }
        case 115: break;
        case 29: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "GN");
          }
        case 116: break;
        case 26: 
          { return symbol(DLINodeTypes.RELATIONOP, "!=");
          }
        case 117: break;
        case 18: 
          { yybegin(SINGLE_QUOTED_STRINGLIT); matchStart = yychar; matchLength = 1; stringBuffer = new StringBuffer();
          }
        case 118: break;
        case 14: 
          { return symbol(DLINodeTypes.RPAREN);
          }
        case 119: break;
        case 53: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "DLET");
          }
        case 120: break;
        case 54: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "TERM");
          }
        case 121: break;
        case 46: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "CLSE");
          }
        case 122: break;
        case 1: 
          { return symbol(DLINodeTypes.ERROR);
          }
        case 123: break;
        case 6: 
          { return symbol(DLINodeTypes.ASTERISK);
          }
        case 124: break;
        case 8: 
          { return symbol(DLINodeTypes.RELATIONOP, ">");
          }
        case 125: break;
        case 27: 
          { return symbol(DLINodeTypes.RELATIONOP, ">=");
          }
        case 126: break;
        case 4: 
          { return symbol(DLINodeTypes.RBRACKET);
          }
        case 127: break;
        case 21: 
          { yybegin(YYINITIAL); matchLength++; return stringSymbol(DLINodeTypes.STRINGLIT);
          }
        case 128: break;
        case 59: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "ISRT");
          }
        case 129: break;
        case 62: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "REPL");
          }
        case 130: break;
        case 12: 
          { return symbol(DLINodeTypes.BOOLEANOP, "#");
          }
        case 131: break;
        case 23: 
          { yybegin(YYINITIAL); matchLength++; return stringSymbol(DLINodeTypes.SINGLE_QUOTED_STRINGLIT);
          }
        case 132: break;
        case 45: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "POS");
          }
        case 133: break;
        case 39: 
          { return symbol(DLINodeTypes.FUNCTIONNAME, "LOG");
          }
        case 134: break;
        case 9: 
          { return symbol(DLINodeTypes.RELATIONOP, "<");
          }
        case 135: break;
        case 32: 
          { stringBuffer.append("\b"); matchLength += yylength();
          }
        case 136: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              { return new java_cup.runtime.Symbol(DLINodeTypes.EOF); }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
