/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.internal.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.ide.deployment.internal.Logger;
import org.eclipse.edt.ide.deployment.operation.IDeploymentOperation;
import org.eclipse.edt.ide.deployment.solution.IDeploymentSolution;

public class ContributionsRegistry {
    private boolean initialized;
    private List solutionsContributions = new ArrayList();
    private HashMap solutionContributionsById = new HashMap();
    private HashMap operationContributions = new HashMap();
    public static final ContributionsRegistry singleton = new ContributionsRegistry();

    private ContributionsRegistry() {
    }

    private void initialize() {
        IConfigurationElement currentConf;
        this.initialized = true;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] conf = reg.getConfigurationElementsFor("org.eclipse.edt.ide.deployment.deploymentSolution");
        int i = 0;
        while (i < conf.length) {
            currentConf = conf[i];
            this.solutionsContributions.add(currentConf);
            this.solutionContributionsById.put(this.getIdForContribution(currentConf), currentConf);
            ++i;
        }
        conf = reg.getConfigurationElementsFor("org.eclipse.edt.ide.deployment.deploymentOperation");
        i = 0;
        while (i < conf.length) {
            currentConf = conf[i];
            String solutionName = this.getSolutionNameForContribution(currentConf);
            ArrayList<IConfigurationElement> operations = (ArrayList<IConfigurationElement>)this.operationContributions.get(solutionName);
            if (operations == null) {
                operations = new ArrayList<IConfigurationElement>();
                this.operationContributions.put(solutionName, operations);
            }
            operations.add(currentConf);
            ++i;
        }
    }

    public List getContributions() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.solutionsContributions;
    }

    public String getIdForContribution(IConfigurationElement contribution) {
        if (!this.initialized) {
            this.initialize();
        }
        return contribution.getAttribute("id");
    }

    public String getSolutionNameForContribution(IConfigurationElement contribution) {
        if (!this.initialized) {
            this.initialize();
        }
        return contribution.getAttribute("deploymentSolutionName");
    }

    public IConfigurationElement getContributionForId(String id) {
        if (!this.initialized) {
            this.initialize();
        }
        return (IConfigurationElement)this.solutionContributionsById.get(id);
    }

    public IDeploymentSolution getDeploymentSolution(IConfigurationElement contribution) {
        if (!this.initialized) {
            this.initialize();
        }
        IDeploymentSolution result = null;
        try {
            result = (IDeploymentSolution)contribution.createExecutableExtension("class");
            List operations = (List)this.operationContributions.get(this.getIdForContribution(contribution));
            if (operations != null) {
                int i = 0;
                while (i < operations.size()) {
                    IConfigurationElement ele = (IConfigurationElement)operations.get(i);
                    result.addOperation((IDeploymentOperation)ele.createExecutableExtension("class"));
                    ++i;
                }
            }
        }
        catch (Exception exc) {
            Logger.logException("Failed to create an instance of IDeploymentSolution", exc);
        }
        return result;
    }
}

