/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.egl.templates;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.edt.gen.egl.Context;
import org.eclipse.edt.gen.egl.templates.CommonUtilities;
import org.eclipse.edt.gen.egl.templates.EglTemplate;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ExternalType;
import org.eclipse.edt.mof.egl.Interface;
import org.eclipse.edt.mof.egl.LogicAndDataPart;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.MofObjectNotFoundException;

public class ClassTemplate
extends EglTemplate {
    public void genPart(Class<?> clazz, Context ctx) {
        if (clazz.isInterface()) {
            ctx.invoke("genInterface", clazz, new Object[]{ctx});
        } else {
            ctx.invoke("genExternalType", clazz, new Object[]{ctx});
        }
    }

    public void genInterface(Class<?> clazz, Context ctx) {
        Interface iFace = ctx.getFactory().createInterface();
        ctx.setResult((LogicAndDataPart)iFace);
        this.basicConfig(clazz, (LogicAndDataPart)iFace);
        ctx.invoke("genExtends", clazz, new Object[]{ctx, iFace});
        ctx.invoke("genFunctions", clazz, new Object[]{ctx, iFace});
        ctx.invoke("genAnnotations", clazz, new Object[]{ctx, iFace});
    }

    public void genExternalType(Class<?> clazz, Context ctx) {
        ExternalType eType = ctx.getFactory().createExternalType();
        ctx.setResult((LogicAndDataPart)eType);
        this.basicConfig(clazz, (LogicAndDataPart)eType);
        if (Modifier.isAbstract(clazz.getModifiers())) {
            eType.setIsAbstract(Boolean.valueOf(Modifier.isAbstract(clazz.getModifiers())));
        }
        ctx.invoke("genExtends", clazz, new Object[]{ctx, eType});
        ctx.invoke("genSubType", clazz, new Object[]{ctx, eType});
        ctx.invoke("genConstructors", clazz, new Object[]{ctx, eType});
        ctx.invoke("genFields", clazz, new Object[]{ctx, eType});
        ctx.invoke("genFunctions", clazz, new Object[]{ctx, eType});
        ctx.invoke("genAnnotations", clazz, new Object[]{ctx, eType});
    }

    private void basicConfig(Class<?> clazz, LogicAndDataPart part) {
        part.setPackageName(CommonUtilities.getValidEGLName(clazz.getPackage().getName()));
        part.setName(CommonUtilities.getValidEGLName(clazz.getSimpleName()));
    }

    public void genSubType(Class<?> clazz, Context ctx, LogicAndDataPart eType) throws MofObjectNotFoundException, DeserializationException {
        Annotation javaObject = CommonUtilities.getAnnotation(ctx, "egl:eglx.lang.Property");
        if (javaObject != null) {
            eType.addAnnotation(javaObject);
            if (!clazz.getSimpleName().equals(eType.getName())) {
                javaObject.setValue("javaName", (Object)clazz.getSimpleName());
            }
            if (!clazz.getPackage().getName().equals(eType.getPackageName())) {
                javaObject.setValue("packageName", (Object)clazz.getPackage().getName());
            }
        }
    }

    public void genFunctions(Class<?> clazz, Context ctx, LogicAndDataPart part) {
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            ctx.invoke("genFunction", (Object)method, new Object[]{ctx, clazz, part});
            ++n2;
        }
    }

    public void genConstructors(Class<?> clazz, Context ctx, LogicAndDataPart part) {
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            ctx.invoke("genConstructor", constructor, new Object[]{ctx, clazz, part});
            ++n2;
        }
    }

    public void genFields(Class<?> clazz, Context ctx, LogicAndDataPart part) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            ctx.invoke("genField", (Object)field, new Object[]{ctx, clazz, part});
            ++n2;
        }
    }

    public void genAnnotations(Class<?> clazz, Context ctx, LogicAndDataPart part) {
        java.lang.annotation.Annotation[] annotationArray = clazz.getDeclaredAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            java.lang.annotation.Annotation annotation = annotationArray[n2];
            ctx.invoke("genAnnotation", (Object)annotation, new Object[]{ctx, part});
            ++n2;
        }
    }

    public void genExtends(Class<?> clazz, Context ctx, LogicAndDataPart part) throws MofObjectNotFoundException, DeserializationException {
        Type type;
        Class<?> extend = clazz.getSuperclass();
        if (extend != null && !Object.class.equals(extend) && (type = CommonUtilities.findType(ctx, extend.getName())) instanceof StructPart) {
            part.getSuperTypes().add((StructPart)type);
        }
    }
}

