/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates;

import java.util.List;
import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.gen.javascript.CommonUtilities;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.JavaScriptAliaser;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.Template;
import org.eclipse.edt.mof.codegen.api.TemplateException;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ConstantField;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.ExternalType;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.Handler;
import org.eclipse.edt.mof.egl.Library;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.NamedElement;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.IRUtils;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class EGLClassTemplate
extends JavaScriptTemplate {
    private static final String INITIALIZER_FUNCTION = "eze$$setInitial";
    private static final String DEFAULTS_FUNCTION = "eze$$setEmpty";

    public void preGenClassBody(EGLClass part, Context ctx) {
        ctx.invoke("preGenUsedParts", (Type)part, new Object[]{ctx});
        ctx.invoke("preGenFields", (Type)part, new Object[]{ctx});
        ctx.invoke("preGenFunctions", (Type)part, new Object[]{ctx});
        if (org.eclipse.edt.gen.CommonUtilities.getAnnotation((Element)part, (String)"eglx.xml.binding.annotation.XMLRootElement", (EglContext)ctx) == null) {
            try {
                Annotation annotation = org.eclipse.edt.gen.CommonUtilities.annotationNewInstance((EglContext)ctx, (String)"egl:eglx.xml.binding.annotation.XMLRootElement");
                annotation.setValue("name", (Object)part.getId());
                org.eclipse.edt.gen.CommonUtilities.addGeneratorAnnotation((Element)part, (Annotation)annotation, (EglContext)ctx);
            }
            catch (Exception exception) {}
        }
        this.addNamespaceMap(part, ctx);
    }

    private void addNamespaceMap(EGLClass part, Context ctx) {
        String localName = part.getName();
        String namespace = CommonUtilities.createNamespaceFromPackage((Part)part);
        Annotation annot = org.eclipse.edt.gen.CommonUtilities.getAnnotation((Element)part, (String)"eglx.xml.binding.annotation.XMLRootElement", (EglContext)ctx);
        if (annot != null) {
            if (annot.getValue("namespace") != null && ((String)annot.getValue("namespace")).length() > 0) {
                namespace = (String)annot.getValue("namespace");
            }
            if (annot.getValue("name") != null && ((String)annot.getValue("name")).length() > 0) {
                localName = (String)annot.getValue("name");
            }
        }
        ctx.addNamespace(namespace, localName, part.getFullyQualifiedName());
    }

    public void preGenUsedParts(EGLClass part, Context ctx) {
        for (Part item : IRUtils.getReferencedPartsFor((Part)part)) {
            ctx.invoke("preGenUsedPart", (Type)part, new Object[]{ctx, item});
        }
    }

    public void preGenUsedPart(EGLClass part, Context ctx, Part arg) {
        ctx.invoke("preGen", (Type)arg, new Object[]{ctx});
    }

    public void preGenFields(EGLClass part, Context ctx) {
        for (Field field : part.getFields()) {
            ctx.invoke("preGenField", (Type)part, new Object[]{ctx, field});
        }
    }

    public void preGenField(EGLClass part, Context ctx, Field arg) {
        ctx.invoke("preGen", (EObject)arg, new Object[]{ctx});
    }

    public void preGenFunctions(EGLClass part, Context ctx) {
        for (Function function : part.getFunctions()) {
            ctx.invoke("preGenFunction", (Type)part, new Object[]{ctx, function});
        }
    }

    public void preGenFunction(EGLClass part, Context ctx, Function arg) {
        ctx.invoke("preGen", (EObject)arg, new Object[]{ctx});
    }

    public void genPart(EGLClass part, Context ctx, TabbedWriter out) {
        ctx.invoke("genAMDHeader", (Type)part, new Object[]{ctx, out});
        ctx.invokeSuper((Template)this, "genPart", (Type)part, new Object[]{ctx, out});
        out.println("});");
    }

    public void genModuleName(EGLClass part, StringBuilder buf) {
        buf.append("\"");
        String pkg = part.getPackageName();
        if (pkg.length() > 0) {
            buf.append(JavaScriptAliaser.packageNameAlias((String[])pkg.split("[.]"), (char)'/'));
            buf.append('/');
        }
        buf.append(JavaScriptAliaser.getAlias((String)part.getId()));
        buf.append("\"");
    }

    public void genCSSFile(EGLClass part, TabbedWriter out) {
    }

    private String getIncludeFileName(EGLClass part) {
        Annotation a = null;
        if (part instanceof Handler) {
            a = part.getAnnotation(CommonUtilities.isRUIHandler((Object)part) ? "eglx.ui.rui.RUIHandler" : "eglx.ui.rui.RUIWidget");
        } else if (part instanceof ExternalType) {
            a = part.getAnnotation("eglx.javascript.JavaScriptObject");
        }
        if (a != null) {
            String fileName = (String)a.getValue("includeFile");
            return fileName;
        }
        return null;
    }

    public void genIncludeFile(EGLClass part, TabbedWriter out) {
        String fileName = this.getIncludeFileName(part);
        if (fileName != null && fileName.length() > 0) {
            out.println("egl.loadFile(\"" + fileName + "\",\"" + part.getFullyQualifiedName() + "\");");
        }
    }

    public void genIncludeFileDependent(EGLClass part, TabbedWriter out) {
        String fileName = this.getIncludeFileName(part);
        if (fileName != null && fileName.length() > 0 && (fileName.endsWith(".html") || fileName.endsWith(".htm"))) {
            out.print(".concat(egl.eze$$externalJS[\"" + part.getFullyQualifiedName() + "\"])");
        }
    }

    public void genAMDHeader(EGLClass part, Context ctx, TabbedWriter out) throws NoSuchMethodException {
        ctx.invoke("genIncludeFile", (Type)part, new Object[]{out});
        out.print("define([");
        StringBuilder buf = new StringBuilder();
        ctx.invoke("genDependent", (Type)part, new Object[]{ctx, out, buf});
        if (buf.length() > 0) {
            String bufStr = buf.toString().substring(0, buf.length() - 2);
            out.print(bufStr);
        }
        out.print("]");
        ctx.invoke("genIncludeFileDependent", (Type)part, new Object[]{out});
        out.println(",function(){");
        ctx.invoke("genCSSFile", (Type)part, new Object[]{out});
    }

    public void genDependent(EGLClass part, Context ctx, TabbedWriter out, StringBuilder buf) throws NoSuchMethodException {
        for (Part refPart : IRUtils.getReferencedPartsFor((Part)part)) {
            if (!CommonUtilities.canBeGeneratedToJavaScript((Part)refPart) || !CommonUtilities.isNativeType((Part)refPart)) continue;
            ctx.invoke("genModuleName", (Type)refPart, new Object[]{buf});
            buf.append(", ");
        }
    }

    public void genClassHeader(EGLClass part, Context ctx, TabbedWriter out) {
        out.print("egl.defineClass(");
        out.print(EGLClassTemplate.singleQuoted((String)part.getPackageName().toLowerCase()));
        out.print(", ");
        out.print(EGLClassTemplate.quoted((String)part.getName()));
        out.print(", ");
        ctx.invoke("genSuperClass", (Type)part, new Object[]{ctx, out});
        out.print(", ");
        out.println("{");
        out.print(EGLClassTemplate.quoted((String)"eze$$fileName"));
        out.print(" : ");
        out.print(EGLClassTemplate.quoted((String)part.getFileName()));
        out.println(", ");
    }

    public void genClassBody(EGLClass part, Context ctx, TabbedWriter out) {
        ctx.invoke("genConstructors", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genSetEmptyMethods", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genInitializeMethods", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genCloneMethods", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genAnnotations", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genFieldAnnotations", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genFunctions", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genGetterSetters", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genToString", (Type)part, new Object[]{ctx, out});
    }

    public void genToString(EGLClass part, Context ctx, TabbedWriter out) {
        out.println(",");
        out.print(EGLClassTemplate.quoted((String)"toString"));
        out.println(": function() {");
        out.println("return \"[" + part.getId() + "]\";");
        out.println("}");
    }

    public void genFields(EGLClass part, Context ctx, TabbedWriter out) {
        for (Field field : part.getFields()) {
            ctx.invoke("genField", (Type)part, new Object[]{ctx, out, field});
        }
    }

    public void genField(EGLClass part, Context ctx, TabbedWriter out, Field arg) {
        if (arg instanceof ConstantField) {
            ctx.invoke("genDeclaration", (EObject)arg, new Object[]{ctx, out});
        }
    }

    public void genConstructors(EGLClass part, Context ctx, TabbedWriter out) {
        ctx.invoke("genConstructor", (Type)part, new Object[]{ctx, out});
    }

    public void genConstructor(EGLClass part, Context ctx, TabbedWriter out) {
        out.print(EGLClassTemplate.quoted((String)"constructor"));
        out.println(": function() {");
        out.println("}");
    }

    public void genLibraries(EGLClass part, Context ctx, TabbedWriter out) {
        List libraries = (List)ctx.getAttribute(ctx.getClass(), "partLibrariesUsed");
        for (Library library : libraries) {
            ctx.invoke("genLibrary", (Type)part, new Object[]{ctx, out, library});
        }
    }

    public void genLibrary(EGLClass part, Context ctx, TabbedWriter out, Library arg) {
        ctx.invoke("genInstantiation", (Type)arg, new Object[]{ctx, out});
        out.println(";");
    }

    public void genSetEmptyMethods(EGLClass part, Context ctx, TabbedWriter out) {
        out.println(",");
        out.print(EGLClassTemplate.quoted((String)DEFAULTS_FUNCTION));
        out.println(": function() {");
        ctx.invoke("genSetEmptyMethodBody", (Type)part, new Object[]{ctx, out});
        out.println("}");
    }

    public void genSetEmptyMethodBody(EGLClass part, Context ctx, TabbedWriter out) {
        ctx.invoke("genLibraries", (Type)part, new Object[]{ctx, out});
        ctx.invoke("genFields", (Type)part, new Object[]{ctx, out});
        for (Field field : part.getFields()) {
            if (field instanceof ConstantField) continue;
            ctx.invoke("genSetEmptyMethod", (Type)part, new Object[]{ctx, out, field});
        }
    }

    public void genSetEmptyMethod(EGLClass part, Context ctx, TabbedWriter out, Field arg) {
        out.print("this.");
        ctx.invoke("genName", (EObject)arg, new Object[]{ctx, out});
        out.print(" = ");
        ctx.invoke("genInitialization", (EObject)arg, new Object[]{ctx, out});
        out.println(";");
    }

    public void genInitializeMethods(EGLClass part, Context ctx, TabbedWriter out) {
        out.println(",");
        out.print(EGLClassTemplate.quoted((String)INITIALIZER_FUNCTION));
        out.println(": function() {");
        ctx.invoke("genInitializeMethodBody", (Type)part, new Object[]{ctx, out});
        out.println("}");
    }

    public void genInitializeMethodBody(EGLClass part, Context ctx, TabbedWriter out) {
        out.println("this.eze$$setEmpty();");
        for (Field field : part.getFields()) {
            for (Annotation annot : org.eclipse.edt.gen.CommonUtilities.getAnnotations((Element)field, (EglContext)ctx)) {
                try {
                    ctx.invoke("genAnnotation", (EType)annot.getEClass(), new Object[]{ctx, out, annot, field, "genInitializeMethod"});
                }
                catch (TemplateException templateException) {}
            }
            ctx.invoke("genInitializeMethod", (Type)part, new Object[]{ctx, out, field});
        }
        if (part.getInitializerStatements() != null) {
            ctx.invoke("genStatementNoBraces", (EObject)part.getInitializerStatements(), new Object[]{ctx, out});
        }
    }

    public void genInitializeMethod(EGLClass part, Context ctx, TabbedWriter out, Field arg) {
        if (!(arg instanceof ConstantField)) {
            ctx.invoke("genInitializeStatement", arg.getType(), new Object[]{ctx, out, arg});
        }
    }

    public void genInitializerStatements(Field field, Context ctx, TabbedWriter out) {
        ctx.invoke("genStatementNoBraces", (EObject)field.getInitializerStatements(), new Object[]{ctx, out});
    }

    public void genCloneMethods(EGLClass part, Context ctx, TabbedWriter out) {
        out.println(",");
        out.print(EGLClassTemplate.quoted((String)"eze$$clone"));
        out.println(": function() {");
        ctx.invoke("genCloneMethodBody", (Type)part, new Object[]{ctx, out});
        out.println("}");
    }

    public void genCloneMethodBody(EGLClass part, Context ctx, TabbedWriter out) {
        String temp1 = "ezert$$1";
        String temp2 = "ezert$$2";
        out.print("var ");
        out.print(temp1);
        out.println(" = this;");
        out.print("var ");
        out.print(temp2);
        out.print(" = ");
        ctx.invoke("genInstantiation", (Type)part, new Object[]{ctx, out});
        out.println(";");
        for (Field field : part.getFields()) {
            ctx.invoke("genCloneMethod", (Type)part, new Object[]{ctx, out, field});
        }
        out.print("return ");
        out.print(temp2);
        out.println(";");
    }

    public void genCloneMethod(EGLClass part, Context ctx, TabbedWriter out, Field arg) {
        String temp1 = "ezert$$1";
        String temp2 = "ezert$$2";
        out.print(temp2);
        out.print(".");
        ctx.invoke("genName", (EObject)arg, new Object[]{ctx, out});
        out.print(" = ");
        out.print(temp1);
        out.print(".");
        ctx.invoke("genName", (EObject)arg, new Object[]{ctx, out});
        if (arg.isNullable() || TypeUtils.isReferenceType((Type)arg.getType())) {
            out.print(" === null ? null : ");
            out.print(temp1);
            out.print(".");
            ctx.invoke("genName", (EObject)arg, new Object[]{ctx, out});
            ctx.invoke("genCloneMethod", arg.getType(), new Object[]{ctx, out});
        }
        out.println(";");
    }

    public void genGetterSetters(EGLClass part, Context ctx, TabbedWriter out) {
        for (Field field : part.getFields()) {
            ctx.invoke("genGetterSetter", (Type)part, new Object[]{ctx, out, field});
        }
    }

    public void genGetterSetter(EGLClass part, Context ctx, TabbedWriter out, Field arg) {
    }

    public void genFunctions(EGLClass part, Context ctx, TabbedWriter out) {
        for (Function function : part.getFunctions()) {
            ctx.invoke("genFunction", (Type)part, new Object[]{ctx, out, function});
        }
    }

    public void genFunction(EGLClass part, Context ctx, TabbedWriter out, Function arg) {
        out.println(",");
        ctx.invoke("genDeclaration", (EObject)arg, new Object[]{ctx, out});
    }

    public void genAdditionalConstructorParams(EGLClass part, Context ctx, TabbedWriter out) {
    }

    public void genAdditionalSuperConstructorArgs(EGLClass part, Context ctx, TabbedWriter out) {
    }

    public void genDeclaration(EGLClass part, Context ctx, TabbedWriter out) {
    }

    public void genSuperClass(EGLClass part, Context ctx, TabbedWriter out) {
    }

    public void genAnnotations(EGLClass part, Context ctx, TabbedWriter out) {
        out.println(",");
        out.print(EGLClassTemplate.quoted((String)"eze$$getAnnotations"));
        out.println(": function() {");
        out.println("if(this.annotations === undefined){");
        out.println("this.annotations = {};");
        for (Annotation annot : org.eclipse.edt.gen.CommonUtilities.getAnnotations((Element)part, (EglContext)ctx)) {
            ctx.invoke("genConversionControlAnnotation", (EType)annot.getEClass(), new Object[]{ctx, out, annot, part});
        }
        out.println("}");
        out.println("return this.annotations;");
        out.println("}");
    }

    public void genFieldAnnotations(EGLClass part, Context ctx, TabbedWriter out) {
        out.println(",");
        out.print(EGLClassTemplate.quoted((String)"eze$$getFieldInfos"));
        out.println(": function() {");
        out.println("if(this.fieldInfos === undefined){");
        out.println("var annotations;");
        out.println("this.fieldInfos = new Array();");
        int idx = 0;
        for (Field field : part.getFields()) {
            if (field instanceof ConstantField || field.isStatic().booleanValue()) continue;
            ctx.invoke("genAnnotations", (EObject)field, new Object[]{ctx, out, idx});
            ++idx;
        }
        out.println("}");
        out.println("return this.fieldInfos;");
        out.println("}");
    }

    public void genQualifier(EGLClass part, Context ctx, TabbedWriter out, NamedElement arg) {
        for (Member mbr : part.getAllMembers()) {
            if (!mbr.getId().equalsIgnoreCase(arg.getId())) continue;
            Object alias = ctx.getAttribute(ctx.getClass(), "QUALIFIER_ALIAS");
            if (alias != null) {
                out.print(alias.toString());
                break;
            }
            out.print("this.");
            break;
        }
    }
}

