/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.FunctionDataDeclaration;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.AssignmentLocator;
import org.eclipse.edt.ide.rui.document.utils.DocumentUtil;
import org.eclipse.edt.ide.rui.document.utils.InitializerLocator;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class SetEventValueOperation {
    private IEGLDocument currentDocument;
    private IFile currentFile;

    public SetEventValueOperation(IEGLDocument currentDocument, IFile currentFile) {
        this.currentDocument = currentDocument;
        this.currentFile = currentFile;
    }

    public void setEventValue(final String eventName, final String eventValue, int widgetOffset, int widgetLength) {
        try {
            IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this.currentFile);
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            sharedWorkingCopy.open(null);
            sharedWorkingCopy.reconcile(false, null);
            try {
                try {
                    final File fileAST = this.currentDocument.getNewModelEGLFile();
                    Node widgetReference = DocumentUtil.getWidgetNode(this.currentDocument, widgetOffset, widgetLength);
                    if (widgetReference != null) {
                        widgetReference.accept((IASTVisitor)new DefaultASTVisitor(){

                            public boolean visit(NewExpression newExpression) {
                                try {
                                    if (newExpression.hasSettingsBlock()) {
                                        SettingsBlock settingsBlockOpt = newExpression.getSettingsBlock();
                                        AssignmentLocator assignmentLocator = new AssignmentLocator(InternUtil.intern((String)eventName));
                                        settingsBlockOpt.accept((IASTVisitor)assignmentLocator);
                                        Assignment setting = assignmentLocator.getAssignment();
                                        if (setting != null) {
                                            ASTRewrite rewrite = ASTRewrite.create((File)fileAST);
                                            rewrite.setText((Node)setting, String.valueOf(eventName) + " ::= " + eventValue);
                                            rewrite.rewriteAST((IDocument)SetEventValueOperation.this.currentDocument).apply((IDocument)SetEventValueOperation.this.currentDocument);
                                        } else {
                                            SetEventValueOperation.this.addEvent(eventName, eventValue, fileAST, settingsBlockOpt);
                                        }
                                    } else {
                                        ASTRewrite rewrite = ASTRewrite.create((File)fileAST);
                                        rewrite.setText((Node)newExpression, String.valueOf(newExpression.getCanonicalString()) + "{ " + eventName + " ::= " + eventValue + " }");
                                        rewrite.rewriteAST((IDocument)SetEventValueOperation.this.currentDocument).apply((IDocument)SetEventValueOperation.this.currentDocument);
                                    }
                                }
                                catch (BadLocationException e) {
                                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Set Event: Error processing new expression", (Throwable)e));
                                }
                                return false;
                            }

                            public boolean visit(SimpleName simpleName) {
                                Node parentNode = simpleName.getParent();
                                if (parentNode != null) {
                                    parentNode.accept((IASTVisitor)new DefaultASTVisitor(){

                                        public boolean visit(ClassDataDeclaration classDataDeclaration) {
                                            try {
                                                ASTRewrite rewrite;
                                                AssignmentLocator assignmentLocator;
                                                SettingsBlock fieldSettingsBlock = null;
                                                SettingsBlock initializerSettingsBlock = null;
                                                NewExpression initializer = null;
                                                if (classDataDeclaration.hasSettingsBlock()) {
                                                    fieldSettingsBlock = classDataDeclaration.getSettingsBlockOpt();
                                                }
                                                if (classDataDeclaration.hasInitializer()) {
                                                    Expression theInitializer = classDataDeclaration.getInitializer();
                                                    InitializerLocator locator = new InitializerLocator();
                                                    theInitializer.accept((IASTVisitor)locator);
                                                    initializer = locator.getInitializer();
                                                    if (initializer != null && initializer.hasSettingsBlock()) {
                                                        initializerSettingsBlock = initializer.getSettingsBlock();
                                                    }
                                                }
                                                Assignment setting = null;
                                                if (fieldSettingsBlock != null) {
                                                    assignmentLocator = new AssignmentLocator(InternUtil.intern((String)eventName));
                                                    fieldSettingsBlock.accept((IASTVisitor)assignmentLocator);
                                                    setting = assignmentLocator.getAssignment();
                                                }
                                                if (setting == null && initializerSettingsBlock != null) {
                                                    assignmentLocator = new AssignmentLocator(InternUtil.intern((String)eventName));
                                                    initializerSettingsBlock.accept((IASTVisitor)assignmentLocator);
                                                    setting = assignmentLocator.getAssignment();
                                                }
                                                if (setting != null) {
                                                    rewrite = ASTRewrite.create((File)fileAST);
                                                    rewrite.setText((Node)setting, String.valueOf(eventName) + " ::= " + eventValue);
                                                    rewrite.rewriteAST((IDocument)SetEventValueOperation.this.currentDocument).apply((IDocument)SetEventValueOperation.this.currentDocument);
                                                } else if (fieldSettingsBlock != null || initializerSettingsBlock != null) {
                                                    if (initializerSettingsBlock != null) {
                                                        SetEventValueOperation.this.addEvent(eventName, eventValue, fileAST, initializerSettingsBlock);
                                                    } else {
                                                        SetEventValueOperation.this.addEvent(eventName, eventValue, fileAST, fieldSettingsBlock);
                                                    }
                                                } else if (initializer != null) {
                                                    rewrite = ASTRewrite.create((File)fileAST);
                                                    Type type = initializer.getType();
                                                    rewrite.setText((Node)type, String.valueOf(type.getCanonicalName()) + "{ " + eventName + " ::= " + eventValue + " }");
                                                    rewrite.rewriteAST((IDocument)SetEventValueOperation.this.currentDocument).apply((IDocument)SetEventValueOperation.this.currentDocument);
                                                } else {
                                                    rewrite = ASTRewrite.create((File)fileAST);
                                                    Type type = classDataDeclaration.getType();
                                                    rewrite.setText((Node)type, String.valueOf(type.getCanonicalName()) + "{ " + eventName + " ::= " + eventValue + " }");
                                                    rewrite.rewriteAST((IDocument)SetEventValueOperation.this.currentDocument).apply((IDocument)SetEventValueOperation.this.currentDocument);
                                                }
                                            }
                                            catch (BadLocationException e) {
                                                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Set Event: Error processing class field expression", (Throwable)e));
                                            }
                                            return false;
                                        }

                                        public boolean visit(FunctionDataDeclaration functionDataDeclaration) {
                                            try {
                                                ASTRewrite rewrite;
                                                AssignmentLocator assignmentLocator;
                                                SettingsBlock fieldSettingsBlock = null;
                                                SettingsBlock initializerSettingsBlock = null;
                                                NewExpression initializer = null;
                                                if (functionDataDeclaration.hasSettingsBlock()) {
                                                    fieldSettingsBlock = functionDataDeclaration.getSettingsBlockOpt();
                                                }
                                                if (functionDataDeclaration.hasInitializer()) {
                                                    Expression theInitializer = functionDataDeclaration.getInitializer();
                                                    InitializerLocator locator = new InitializerLocator();
                                                    theInitializer.accept((IASTVisitor)locator);
                                                    initializer = locator.getInitializer();
                                                    if (initializer != null && initializer.hasSettingsBlock()) {
                                                        initializerSettingsBlock = initializer.getSettingsBlock();
                                                    }
                                                }
                                                Assignment setting = null;
                                                if (fieldSettingsBlock != null) {
                                                    assignmentLocator = new AssignmentLocator(InternUtil.intern((String)eventName));
                                                    fieldSettingsBlock.accept((IASTVisitor)assignmentLocator);
                                                    setting = assignmentLocator.getAssignment();
                                                }
                                                if (setting == null && initializerSettingsBlock != null) {
                                                    assignmentLocator = new AssignmentLocator(InternUtil.intern((String)eventName));
                                                    initializerSettingsBlock.accept((IASTVisitor)assignmentLocator);
                                                    setting = assignmentLocator.getAssignment();
                                                }
                                                if (setting != null) {
                                                    rewrite = ASTRewrite.create((File)fileAST);
                                                    rewrite.setText((Node)setting, String.valueOf(eventName) + " ::= " + eventValue);
                                                    rewrite.rewriteAST((IDocument)SetEventValueOperation.this.currentDocument).apply((IDocument)SetEventValueOperation.this.currentDocument);
                                                } else if (fieldSettingsBlock != null || initializerSettingsBlock != null) {
                                                    if (initializerSettingsBlock != null) {
                                                        SetEventValueOperation.this.addEvent(eventName, eventValue, fileAST, initializerSettingsBlock);
                                                    } else {
                                                        SetEventValueOperation.this.addEvent(eventName, eventValue, fileAST, fieldSettingsBlock);
                                                    }
                                                } else if (initializer != null) {
                                                    rewrite = ASTRewrite.create((File)fileAST);
                                                    Type type = initializer.getType();
                                                    rewrite.setText((Node)type, String.valueOf(type.getCanonicalName()) + "{ " + eventName + " ::= " + eventValue + " }");
                                                    rewrite.rewriteAST((IDocument)SetEventValueOperation.this.currentDocument).apply((IDocument)SetEventValueOperation.this.currentDocument);
                                                } else {
                                                    rewrite = ASTRewrite.create((File)fileAST);
                                                    Type type = functionDataDeclaration.getType();
                                                    rewrite.setText((Node)type, String.valueOf(type.getCanonicalName()) + "{ " + eventName + " ::= " + eventValue + " }");
                                                    rewrite.rewriteAST((IDocument)SetEventValueOperation.this.currentDocument).apply((IDocument)SetEventValueOperation.this.currentDocument);
                                                }
                                            }
                                            catch (BadLocationException e) {
                                                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Set Event: Error processing function field expression", (Throwable)e));
                                            }
                                            return false;
                                        }
                                    });
                                }
                                return false;
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Set Event: Error setting event", (Throwable)e));
                    sharedWorkingCopy.destroy();
                }
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (EGLModelException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Set Event: Error creating working copy", (Throwable)e));
        }
    }

    private void addEvent(String eventName, String eventValue, File fileAST, SettingsBlock settingsBlockOpt) throws BadLocationException {
        List settings = settingsBlockOpt.getSettings();
        if (settings.size() > 0) {
            Node lastSetting = (Node)settings.get(settings.size() - 1);
            this.currentDocument.replace(lastSetting.getOffset() + lastSetting.getLength(), 0, ", " + eventName + " ::= " + eventValue);
        } else {
            ASTRewrite rewrite = ASTRewrite.create((File)fileAST);
            rewrite.setText((Node)settingsBlockOpt, "{ " + eventName + " ::= " + eventValue + " }");
            rewrite.rewriteAST((IDocument)this.currentDocument).apply((IDocument)this.currentDocument);
        }
    }
}

