/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates.eglx.lang;

import org.eclipse.edt.gen.GenerationException;
import org.eclipse.edt.gen.javascript.CommonUtilities;
import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.InvocationExpression;
import org.eclipse.edt.mof.egl.ParameterizableType;
import org.eclipse.edt.mof.egl.SequenceType;
import org.eclipse.edt.mof.egl.Type;

public class StringTypeTemplate
extends JavaScriptTemplate {
    public void genDefaultValue(SequenceType type, Context ctx, TabbedWriter out) {
        this.processDefaultValue((Type)type, ctx, out);
    }

    public void genDefaultValue(ParameterizableType type, Context ctx, TabbedWriter out) {
        this.processDefaultValue((Type)type, ctx, out);
    }

    public void processDefaultValue(Type type, Context ctx, TabbedWriter out) {
        out.print(StringTypeTemplate.quoted((String)""));
    }

    public void genSignature(SequenceType type, Context ctx, TabbedWriter out) {
        StringBuilder signature = new StringBuilder("s");
        if (type.getLength() != null && type.getLength() > 0) {
            signature.append(type.getLength());
        }
        signature.append(';');
        out.print(signature.toString());
    }

    public void genSignature(ParameterizableType type, Context ctx, TabbedWriter out) {
        String signature = "S;";
        out.print(signature);
    }

    public void genBinaryExpression(EGLClass type, Context ctx, TabbedWriter out, BinaryExpression arg) throws GenerationException {
        if (arg.getLHS().isNullable() || arg.getRHS().isNullable() || this.getNativeStringOperation(arg).length() == 0) {
            out.print(String.valueOf(ctx.getNativeImplementationMapping((Type)arg.getOperation().getContainer())) + '.');
            out.print(CommonUtilities.getNativeRuntimeOperationName((BinaryExpression)arg));
            out.print("(");
            ctx.invoke("genExpression", (EObject)arg.getLHS(), new Object[]{ctx, out, arg.getOperation().getParameters().get(0)});
            out.print(", ");
            ctx.invoke("genExpression", (EObject)arg.getRHS(), new Object[]{ctx, out, arg.getOperation().getParameters().get(1)});
            out.print(")" + CommonUtilities.getNativeRuntimeComparisionOperation((BinaryExpression)arg));
        } else {
            out.print(this.getNativeStringPrefixOperation(arg));
            out.print("(");
            ctx.invoke("genExpression", (EObject)arg.getLHS(), new Object[]{ctx, out});
            out.print(")");
            out.print(this.getNativeStringOperation(arg));
            ctx.invoke("genExpression", (EObject)arg.getRHS(), new Object[]{ctx, out});
            out.print(this.getNativeStringComparisionOperation(arg));
        }
    }

    protected String getNativeStringPrefixOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("!=")) {
            return "";
        }
        return "";
    }

    protected String getNativeStringOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("+")) {
            return " + ";
        }
        if (op.equals("==")) {
            return " == ";
        }
        if (op.equals("!=")) {
            return " != ";
        }
        if (op.equals("<")) {
            return " < ";
        }
        if (op.equals(">")) {
            return " > ";
        }
        if (op.equals("<=")) {
            return " <= ";
        }
        if (op.equals(">=")) {
            return " >= ";
        }
        if (op.equals("&&")) {
            return " && ";
        }
        if (op.equals("||")) {
            return " || ";
        }
        if (op.equals("::")) {
            return " + ";
        }
        return "";
    }

    protected String getNativeStringComparisionOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("==")) {
            return "";
        }
        if (op.equals("!=")) {
            return "";
        }
        if (op.equals("<")) {
            return "";
        }
        if (op.equals(">")) {
            return "";
        }
        if (op.equals("<=")) {
            return "";
        }
        if (op.equals(">=")) {
            return "";
        }
        return "";
    }

    public void genContainerBasedInvocation(EGLClass type, Context ctx, TabbedWriter out, InvocationExpression expr) {
        ctx.invoke("genRuntimeTypeName", (Type)type, new Object[]{ctx, out, JavaScriptTemplate.TypeNameKind.EGLImplementation});
        out.print(".");
        ctx.invoke("genName", (EObject)expr.getTarget(), new Object[]{ctx, out});
        out.print("(");
        ctx.invoke("genExpression", (EObject)expr.getQualifier(), new Object[]{ctx, out});
        if (expr.getArguments() != null && expr.getArguments().size() > 0) {
            out.print(", ");
        }
        ctx.invoke("genInvocationArguments", (EObject)expr, new Object[]{ctx, out});
        out.print(")");
    }
}

