/*
 * Decompiled with CFR 0.152.
 */
package eglx.lang;

import eglx.lang.AnyException;
import eglx.lang.InvocationException;
import eglx.lang.NullValueException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Locale;
import org.eclipse.edt.javart.resources.ExecutableBase;
import org.eclipse.edt.javart.resources.Platform;

public class SysLib
extends ExecutableBase {
    private static final long serialVersionUID = 10L;

    public static String getProperty(String propertyName) {
        String value = org.eclipse.edt.javart.Runtime.getRunUnit().getProperties().get(propertyName.trim());
        if (value == null) {
            value = System.getProperty(propertyName.trim());
        }
        return value;
    }

    public static void wait(BigDecimal time) {
        time = time.movePointRight(2);
        time = new BigDecimal(BigInteger.valueOf(time.longValue()));
        try {
            Thread.sleep(time.longValue() * 10L);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    public static int callCmd(String commandString) throws AnyException {
        return SysLib.runCommand(commandString, true, true);
    }

    public static void startCmd(String commandString) throws AnyException {
        SysLib.runCommand(commandString, true, false);
    }

    private static int runCommand(String commandString, boolean lineMode, boolean wait) throws AnyException {
        Process proc;
        try {
            String[] stringArray;
            Runtime runtime = Runtime.getRuntime();
            if (Platform.SYSTEM_TYPE == "WIN     ") {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "cmd";
                stringArray2[1] = "/c";
                stringArray = stringArray2;
                stringArray2[2] = commandString;
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = "/bin/sh";
                stringArray3[1] = "-c";
                stringArray = stringArray3;
                stringArray3[2] = commandString;
            }
            proc = runtime.exec(stringArray);
        }
        catch (IOException ex) {
            InvocationException ix = new InvocationException();
            ix.name = commandString;
            ix.initCause(ex);
            throw ix.fillInMessage("EGL0015E", commandString, ex);
        }
        if (wait) {
            new Thread(){

                @Override
                public void run() {
                    InputStream inputStream = proc.getErrorStream();
                    try {
                        while (inputStream.read() != -1) {
                        }
                    }
                    catch (IOException iOException) {}
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    InputStream inputStream = proc.getInputStream();
                    try {
                        while (inputStream.read() != -1) {
                        }
                    }
                    catch (IOException iOException) {}
                }
            }.start();
            try {
                return proc.waitFor();
            }
            catch (InterruptedException ex) {
                InvocationException ix = new InvocationException();
                ix.name = commandString;
                ix.initCause(ex);
                throw ix.fillInMessage("EGL0015E", commandString, ex);
            }
        }
        return 0;
    }

    public static String getMessage(String key) {
        return SysLib.getMessage(key, null);
    }

    public static String getMessage(String key, List<String> inserts) {
        Object[] insertStrings = null;
        if (inserts != null) {
            insertStrings = new String[inserts.size()];
            int i = 0;
            while (i < insertStrings.length) {
                insertStrings[i] = inserts.get(i);
                ++i;
            }
        }
        key = key.trim();
        String message = org.eclipse.edt.javart.Runtime.getRunUnit().getLocalizedText().getMessage(key, insertStrings);
        return message;
    }

    public static void commit() throws AnyException {
        org.eclipse.edt.javart.Runtime.getRunUnit().commit();
    }

    public static void rollback() throws AnyException {
        org.eclipse.edt.javart.Runtime.getRunUnit().rollback();
    }

    public static void setLocale(String languageCode) {
        Locale locale = new Locale(languageCode);
        org.eclipse.edt.javart.Runtime.getRunUnit().switchLocale(locale);
    }

    public static void setLocale(String languageCode, String countryCode) {
        Locale locale = new Locale(languageCode, countryCode);
        org.eclipse.edt.javart.Runtime.getRunUnit().switchLocale(locale);
    }

    public static void setLocale(String languageCode, String countryCode, String variant) {
        Locale locale = new Locale(languageCode, countryCode, variant);
        org.eclipse.edt.javart.Runtime.getRunUnit().switchLocale(locale);
    }

    public static void writeStdout(String output) {
        if (output == null) {
            NullValueException nvx = new NullValueException();
            throw nvx.fillInMessage("EGL0016E", new Object[0]);
        }
        System.out.println(output);
    }

    public static void writeStderr(String output) {
        if (output == null) {
            NullValueException nvx = new NullValueException();
            throw nvx.fillInMessage("EGL0016E", new Object[0]);
        }
        System.err.println(output);
    }
}

