/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.codemanipulation;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLUIStatus;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.codemanipulation.OrganizeImportsOperation;
import org.eclipse.edt.ide.ui.internal.editor.util.BoundNodeModelUtility;
import org.eclipse.edt.ide.ui.internal.editor.util.IBoundNodeRequestor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;

public class AddImportOperation
extends OrganizeImportsOperation {
    private IEGLDocument fEGLDoc;
    private int fSelectionOffset;
    private int fSelectionLength;
    private IStatus fStatus;

    public AddImportOperation(IEGLFile file, IEGLDocument egldoc, int offset, int length, boolean needSave, OrganizeImportsOperation.IChooseImportQuery query) {
        super(file, needSave, query);
        this.fEGLDoc = egldoc;
        this.fSelectionOffset = offset;
        this.fSelectionLength = length;
        this.fStatus = Status.OK_STATUS;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                monitor.beginTask(UINlsStrings.AddImportsOperation_description, 15);
                String identifier = this.fEGLDoc.get(this.fSelectionOffset, this.fSelectionLength);
                IPackageFragment currPkgFrag = (IPackageFragment)this.feglfile.getParent();
                String currPackageName = currPkgFrag.getElementName();
                final OrganizeImportsOperation.OrganizedImportSection resolvedTypes = new OrganizeImportsOperation.OrganizedImportSection(currPackageName);
                Node node = this.fEGLDoc.getNewModelNodeAtOffset(this.fSelectionOffset);
                Name nameNode = null;
                if (node instanceof Name) {
                    nameNode = (Name)node;
                    identifier = nameNode.getIdentifier();
                }
                if (nameNode != null) {
                    IEGLProject eglProj = this.feglfile.getEGLProject();
                    final HashSet oldImports = new HashSet();
                    final int[] oldLastImportEndOffset = new int[1];
                    File fileAST = this.fEGLDoc.getNewModelEGLFile();
                    fileAST.accept((IASTVisitor)new DefaultASTVisitor(){

                        public boolean visit(File file) {
                            return true;
                        }

                        public boolean visit(ImportDeclaration importDeclaration) {
                            oldImports.add(importDeclaration);
                            Name importName = importDeclaration.getName();
                            String packageName = "";
                            if (!importDeclaration.isOnDemand()) {
                                String existingPartName = importName.getIdentifier();
                                if (importName instanceof QualifiedName) {
                                    packageName = ((QualifiedName)importName).getQualifier().getCanonicalName();
                                }
                                resolvedTypes.addImport(packageName, existingPartName);
                            } else {
                                packageName = importName.getCanonicalName();
                                resolvedTypes.addImport(packageName, "*");
                            }
                            return false;
                        }

                        public void endVisit(ImportDeclaration importDeclaration) {
                            oldLastImportEndOffset[0] = importDeclaration.getOffset() + importDeclaration.getLength();
                        }
                    });
                    ASTRewrite rewrite = ASTRewrite.create((File)fileAST);
                    LinkedHashMap<String, Name> unresolvedTypes = new LinkedHashMap<String, Name>();
                    unresolvedTypes.put(identifier, nameNode);
                    this.try2ResolveUnresolvedTypes(resolvedTypes, unresolvedTypes, eglProj, oldImports, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                    this.writeToFile(resolvedTypes, oldImports, this.fEGLDoc, rewrite, fileAST, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    final int[] newLastImportEndOffset = new int[1];
                    fileAST = this.fEGLDoc.getNewModelEGLFile();
                    fileAST.accept((IASTVisitor)new DefaultASTVisitor(){

                        public boolean visit(File file) {
                            return true;
                        }

                        public void endVisit(ImportDeclaration importDeclaration) {
                            newLastImportEndOffset[0] = importDeclaration.getOffset() + importDeclaration.getLength();
                        }
                    });
                    int offsetdelta = newLastImportEndOffset[0] - oldLastImportEndOffset[0];
                    IFile file = (IFile)this.feglfile.getCorrespondingResource();
                    BoundNodeModelUtility.getBoundNodeAtOffset(file, this.fSelectionOffset + offsetdelta, new IBoundNodeRequestor(){

                        @Override
                        public void acceptNode(Node boundPart, Node selectedNode) {
                            if (selectedNode instanceof QualifiedName) {
                                QualifiedName qualifiednamenode = (QualifiedName)selectedNode;
                                String fullyQualifiedPackageName = qualifiednamenode.getQualifier().getCanonicalName();
                                String[] conflictPkgNames = new String[1];
                                String qualifiedNameID = qualifiednamenode.getIdentifier();
                                if (!resolvedTypes.isConflict(fullyQualifiedPackageName, qualifiedNameID, conflictPkgNames)) {
                                    ITypeBinding typeBinding = qualifiednamenode.resolveTypeBinding();
                                    if (typeBinding != null && typeBinding.isPartBinding()) {
                                        String[] names = qualifiednamenode.getNameComponents();
                                        ReplaceEdit replace = new ReplaceEdit(selectedNode.getOffset(), selectedNode.getLength(), names[names.length - 1]);
                                        try {
                                            replace.apply((IDocument)AddImportOperation.this.fEGLDoc);
                                        }
                                        catch (MalformedTreeException e) {
                                            EDTUIPlugin.log(e);
                                        }
                                        catch (BadLocationException e) {
                                            EDTUIPlugin.log(e);
                                        }
                                    }
                                } else {
                                    String conflictImportEntry = conflictPkgNames[0];
                                    if (conflictImportEntry.length() > 0) {
                                        conflictImportEntry = String.valueOf(conflictImportEntry) + ".";
                                    }
                                    conflictImportEntry = String.valueOf(conflictImportEntry) + qualifiedNameID;
                                    AddImportOperation.this.fStatus = EGLUIStatus.createError(4, MessageFormat.format(UINlsStrings.AddImportsOperation_error_importclash, conflictImportEntry), null);
                                }
                            }
                        }
                    });
                } else {
                    this.fStatus = EGLUIStatus.createError(4, MessageFormat.format(UINlsStrings.AddImportsOperation_error_notresolved_message, identifier), null);
                }
            }
            catch (BadLocationException e) {
                throw new CoreException(EGLUIStatus.createError(4, e));
            }
        }
        finally {
            monitor.done();
        }
    }

    private QualifiedName getFullyQualifedNameNodeIfPossible(Name nameNode) {
        final QualifiedName[] possibleQualifiedName = new QualifiedName[1];
        if (nameNode instanceof QualifiedName) {
            possibleQualifiedName[0] = (QualifiedName)nameNode;
        }
        if (nameNode instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)nameNode;
            simpleName.getParent().accept((IASTVisitor)new DefaultASTVisitor(){

                public boolean visit(QualifiedName qualifiedName) {
                    qualifiedName.getParent().accept((IASTVisitor)this);
                    return false;
                }

                public void endVisit(QualifiedName qualifiedName) {
                    if (possibleQualifiedName[0] == null) {
                        possibleQualifiedName[0] = qualifiedName;
                        if (qualifiedName.getParent() instanceof FunctionInvocation && qualifiedName == ((FunctionInvocation)qualifiedName.getParent()).getTarget()) {
                            Name possibleQualifier = qualifiedName.getQualifier();
                            possibleQualifiedName[0] = possibleQualifier.isQualifiedName() ? (QualifiedName)possibleQualifier : null;
                        }
                    }
                }
            });
        }
        return possibleQualifiedName[0];
    }
}

