/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ClassFieldBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.AsExpression;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLVariableDotProposalHandler;
import org.eclipse.edt.ide.ui.internal.contentassist.referencecompletion.EGLAbstractReferenceCompletion;
import org.eclipse.jface.text.ITextViewer;

public class EGLVariableDotReferenceCompletion
extends EGLAbstractReferenceCompletion {
    @Override
    protected void precompileContexts() {
        this.addContext("package a; function a() var.");
        this.addContext("package a; function a() (var).");
    }

    @Override
    protected List returnCompletionProposals(ParseStack parseStack, final String prefix, final ITextViewer viewer, final int documentOffset) {
        final ArrayList result = new ArrayList();
        this.getBoundASTNode(viewer, documentOffset, new String[]{"x", "x;", "x=x;", "x);", "x to x;"}, new EGLAbstractReferenceCompletion.CompletedNodeVerifier(){

            @Override
            public boolean nodeIsValid(Node astNode) {
                final boolean[] isValid = new boolean[1];
                if (astNode != null) {
                    astNode.accept((IASTVisitor)new DefaultASTVisitor(){

                        public boolean visit(QualifiedName qualifiedName) {
                            isValid[0] = true;
                            return false;
                        }

                        public boolean visit(FieldAccess fieldAccess) {
                            isValid[0] = true;
                            return false;
                        }
                    });
                }
                return isValid[0];
            }
        }, new EGLAbstractReferenceCompletion.IBoundNodeProcessor(){

            @Override
            public void processBoundNode(Node boundNode) {
                boundNode.accept((IASTVisitor)new DefaultASTVisitor(){

                    public boolean visit(QualifiedName qualifiedName) {
                        this.handleQualifier((Expression)qualifiedName.getQualifier());
                        return false;
                    }

                    public boolean visit(FieldAccess fieldAccess) {
                        this.handleQualifier(fieldAccess.getPrimary());
                        return false;
                    }

                    private void handleQualifier(Expression qualifier) {
                        IDataBinding dBinding = qualifier.resolveDataBinding();
                        ITypeBinding tBinding = qualifier.resolveTypeBinding();
                        if (dBinding == null && Binding.isValidBinding((IBinding)tBinding) && EGLVariableDotReferenceCompletion.this.wantFieldsForType(qualifier)) {
                            dBinding = new ClassFieldBinding(tBinding.getCaseSensitiveName(), null, tBinding);
                        }
                        result.addAll(new EGLVariableDotProposalHandler(viewer, documentOffset, prefix, (this).EGLVariableDotReferenceCompletion.this.editor, dBinding, tBinding, qualifier).getProposals(null));
                    }
                });
            }
        });
        return result;
    }

    protected boolean wantFieldsForType(Expression expr) {
        final boolean[] result = new boolean[1];
        expr.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                return true;
            }

            public boolean visit(AsExpression asExpression) {
                result[0] = true;
                return false;
            }

            public boolean visit(FunctionInvocation fInvocation) {
                result[0] = true;
                return false;
            }
        });
        return result[0];
    }
}

