/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor.folding;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.core.model.document.IEGLModelChangeListener;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.editor.IFoldingStructureProvider;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.editor.folding.FoldingVisitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class FoldingStructureProvider
implements IProjectionListener,
IEGLModelChangeListener,
IFoldingStructureProvider,
IPropertyChangeListener {
    public static final String CATEGORY_EGLFOLDING = "EGL.FOLD.CUSTOM";
    private EGLEditor fEditor;
    private IEGLDocument fEGLDocument;
    private ProjectionViewer fViewer;
    private DefaultPositionUpdater fCustomFoldingPositionUpdater;
    private Reconciler reconciler = new Reconciler();
    private boolean fAllowCollapsing;
    private IPreferenceStore fstore = EDTUIPlugin.getDefault().getPreferenceStore();
    private static final int DELAY = 2000;

    public void modelChanged() {
        if (this.fViewer != null && this.fViewer.getControl() != null && !this.fViewer.getControl().isDisposed()) {
            this.fViewer.getControl().getDisplay().timerExec(2000, (Runnable)this.reconciler);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("editor_folding_propertiesblocks_threshold".equals(property)) {
            this.modelChanged();
        }
    }

    public void updateFoldingRegions(File eglFile) {
        try {
            ProjectionAnnotationModel model = (ProjectionAnnotationModel)this.fEditor.getAdapter(ProjectionAnnotationModel.class);
            if (model == null) {
                return;
            }
            Hashtable currentRegions = new Hashtable();
            this.addFoldingRegions(currentRegions, eglFile);
            this.updateFoldingRegions(model, currentRegions);
        }
        catch (BadLocationException badLocationException) {}
    }

    private void updateFoldingRegions(ProjectionAnnotationModel model, Hashtable currentRegions) {
        Annotation[] deletions = this.computeDifferences(model, currentRegions);
        HashMap additionsMap = new HashMap();
        Enumeration enums = currentRegions.keys();
        while (enums.hasMoreElements()) {
            Object key = enums.nextElement();
            Boolean IsCollapsed = (Boolean)currentRegions.get(key);
            additionsMap.put(new ProjectionAnnotation(IsCollapsed.booleanValue()), key);
        }
        if (deletions.length != 0 || additionsMap.size() != 0) {
            model.modifyAnnotations(deletions, additionsMap, new Annotation[0]);
        }
    }

    private Annotation[] computeDifferences(ProjectionAnnotationModel model, Hashtable current) {
        ArrayList deletions = new ArrayList();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Position position;
            Object annotation = iter.next();
            if (!(annotation instanceof ProjectionAnnotation) || this.fEGLDocument.containsPosition(CATEGORY_EGLFOLDING, (position = model.getPosition((Annotation)annotation)).getOffset(), position.getLength())) continue;
            if (current.containsKey(position)) {
                current.remove(position);
                continue;
            }
            deletions.add(annotation);
        }
        return deletions.toArray(new Annotation[deletions.size()]);
    }

    private void addFoldingRegions(Hashtable regions, File eglFile) throws BadLocationException {
        FoldingVisitor visitor = new FoldingVisitor((IDocument)this.fEGLDocument, regions, this.fAllowCollapsing);
        eglFile.accept((IASTVisitor)visitor);
    }

    public void projectionEnabled() {
        this.projectionDisabled();
        if (this.fEditor instanceof EGLEditor) {
            this.fAllowCollapsing = true;
            this.initialize();
            if (this.fEGLDocument != null) {
                this.fEGLDocument.addModelChangeListener((IEGLModelChangeListener)this);
                this.updateFoldingRegions(this.fEGLDocument.getNewModelEGLFile());
            }
            this.fAllowCollapsing = false;
        }
        if (this.fstore != null) {
            this.fstore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fstore.addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    public void projectionDisabled() {
        try {
            if (this.fEGLDocument != null) {
                this.fEGLDocument.removeModelChangeListener((IEGLModelChangeListener)this);
                if (this.fEGLDocument.containsPositionCategory(CATEGORY_EGLFOLDING)) {
                    this.fEGLDocument.removePositionCategory(CATEGORY_EGLFOLDING);
                }
                this.fEGLDocument.removePositionUpdater((IPositionUpdater)this.fCustomFoldingPositionUpdater);
                this.fEGLDocument = null;
            }
            this.fstore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        catch (BadPositionCategoryException e) {
            EDTUIPlugin.log(e);
        }
    }

    @Override
    public void install(ITextEditor editor, ProjectionViewer viewer) {
        if (editor instanceof EGLEditor) {
            this.fEditor = (EGLEditor)editor;
            this.fViewer = viewer;
            this.fViewer.addProjectionListener((IProjectionListener)this);
        }
    }

    @Override
    public void uninstall() {
        if (this.isInstalled()) {
            this.projectionDisabled();
            this.fViewer.removeProjectionListener((IProjectionListener)this);
            this.fViewer = null;
            this.fEditor = null;
        }
    }

    protected boolean isInstalled() {
        return this.fEditor != null;
    }

    @Override
    public void initialize() {
        if (!this.isInstalled()) {
            return;
        }
        IDocumentProvider provider = this.fEditor.getDocumentProvider();
        IDocument doc = provider.getDocument((Object)this.fEditor.getEditorInput());
        if (doc instanceof IEGLDocument) {
            this.fEGLDocument = (IEGLDocument)doc;
        }
    }

    private class Reconciler
    implements Runnable {
        private Reconciler() {
        }

        @Override
        public void run() {
            if (FoldingStructureProvider.this.fEGLDocument != null) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - FoldingStructureProvider.this.fEGLDocument.getLastUpdateTime() < 2000L) {
                    if (!FoldingStructureProvider.this.fViewer.getControl().isDisposed()) {
                        FoldingStructureProvider.this.fViewer.getControl().getDisplay().timerExec(2000, (Runnable)FoldingStructureProvider.this.reconciler);
                    }
                    return;
                }
                if (!FoldingStructureProvider.this.fViewer.getControl().isDisposed()) {
                    FoldingStructureProvider.this.updateFoldingRegions(FoldingStructureProvider.this.fEGLDocument.getNewModelEGLFile());
                }
            }
        }
    }
}

