/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.ide.core.ast.GetNodeAtOffsetVisitor;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.IWorkingCopyCompileRequestor;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompilationResult;
import org.eclipse.edt.ide.core.internal.compiler.workingcopy.WorkingCopyCompiler;
import org.eclipse.edt.ide.core.internal.model.EGLFile;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IBufferFactory;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.core.utils.BinaryReadOnlyFile;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.editor.util.IBoundNodeRequestor;

public class BoundNodeModelUtility {
    private static BoundNodeModelUtility instance;
    private IEGLDocument document;
    private int documentOffset;
    private int length = 0;

    public static Node getBoundNodeAtOffset(IEGLDocument document, int documentOffset, int length, IFile file) {
        return BoundNodeModelUtility.getInstance().getInternalBoundNodesAtOffset(document, documentOffset, length, file)[0];
    }

    private static BoundNodeModelUtility getInstance() {
        if (instance == null) {
            instance = new BoundNodeModelUtility();
        }
        return instance;
    }

    private Node[] getInternalBoundNodesAtOffset(IEGLDocument document, int documentOffset, int selLength, IFile file) {
        this.document = document;
        this.documentOffset = documentOffset;
        this.length = selLength;
        IPath path = file.getFullPath();
        WorkingCopyCompileRequestor requestor = new WorkingCopyCompileRequestor();
        WorkingCopyCompiler compiler = WorkingCopyCompiler.getInstance();
        compiler.compileAllParts(file.getProject(), this.getPackageName(path), file, EGLCore.getSharedWorkingCopies((IBufferFactory)EGLUI.getBufferFactory()), (IWorkingCopyCompileRequestor)requestor);
        return new Node[]{requestor.getBoundNode(), requestor.getBoundPart()};
    }

    private String[] getPackageName(IPath path) {
        String[] packageName = new String[path.segmentCount() - 3];
        if (path.segmentCount() > 3) {
            int i = 2;
            while (i < path.segmentCount() - 1) {
                packageName[i - 2] = path.segment(i);
                ++i;
            }
        }
        return packageName;
    }

    public static void getBoundNodeAtOffset(IFile file, final int offset, final IBoundNodeRequestor requestor) {
        WorkingCopyCompiler compiler = WorkingCopyCompiler.getInstance();
        String[] packageName = file instanceof BinaryReadOnlyFile ? ((BinaryReadOnlyFile)file).getPackageSegments() : ((EGLFile)EGLCore.create((IFile)file)).getPackageName();
        compiler.compileAllParts(file.getProject(), packageName, file, EGLCore.getSharedWorkingCopies((IBufferFactory)EGLUI.getBufferFactory()), new IWorkingCopyCompileRequestor(){

            public void acceptResult(WorkingCopyCompilationResult result) {
                Node boundPart = result.getBoundPart();
                if (boundPart.getOffset() <= offset && boundPart.getOffset() + boundPart.getLength() >= offset) {
                    GetNodeAtOffsetVisitor visitor = new GetNodeAtOffsetVisitor(offset);
                    result.getBoundPart().accept((IASTVisitor)visitor);
                    Node selectedNode = visitor.getNode();
                    requestor.acceptNode(boundPart, selectedNode);
                }
            }
        });
    }

    private class WorkingCopyCompileRequestor
    implements IWorkingCopyCompileRequestor {
        private Node boundNode = null;
        private Part boundPart = null;

        private WorkingCopyCompileRequestor() {
        }

        public void acceptResult(WorkingCopyCompilationResult result) {
            if (this.boundNode == null) {
                this.boundNode = BoundNodeModelUtility.this.document.getNewModelNodeAtOffset(BoundNodeModelUtility.this.documentOffset, BoundNodeModelUtility.this.length, result.getBoundPart());
                this.boundPart = (Part)result.getBoundPart();
            }
        }

        public Node getBoundNode() {
            return this.boundNode;
        }

        public Part getBoundPart() {
            return this.boundPart;
        }
    }
}

