/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.preferences;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.core.model.EGLConventions;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;
import org.eclipse.edt.ide.ui.internal.preferences.ImportOrganizeInputDialog;
import org.eclipse.edt.ide.ui.internal.preferences.OptionsConfigurationBlock;
import org.eclipse.edt.ide.ui.internal.util.PixelConverter;
import org.eclipse.edt.ide.ui.internal.wizards.IStatusChangeListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.IListAdapter;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.ListDialogField;
import org.eclipse.edt.ide.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ImportOrganizeConfigurationBlock
extends OptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_IMPORTORDER = ImportOrganizeConfigurationBlock.getEGLUIKey("org.eclipse.egl.ui.importorder");
    private static final OptionsConfigurationBlock.Key PREF_ONDEMANDTHRESHOLD = ImportOrganizeConfigurationBlock.getEGLUIKey("org.eclipse.egl.ui.ondemandthreshold");
    private static final String DIALOGSETTING_LASTLOADPATH = "org.eclipse.edt.ide.ui.importorder.loadpath";
    private static final String DIALOGSETTING_LASTSAVEPATH = "org.eclipse.edt.ide.ui.importorder.savepath";
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 2;
    private static final int IDX_REMOVE = 3;
    private static final int IDX_UP = 5;
    private static final int IDX_DOWN = 6;
    private static final int IDX_LOAD = 8;
    private static final int IDX_SAVE = 9;
    private ListDialogField fOrderListField;
    private StringDialogField fThresholdField;
    private PixelConverter fPixelConverter;

    private static OptionsConfigurationBlock.Key[] getAllKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_IMPORTORDER, PREF_ONDEMANDTHRESHOLD};
    }

    public ImportOrganizeConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, ImportOrganizeConfigurationBlock.getAllKeys(), container);
        String[] stringArray = new String[10];
        stringArray[0] = UINlsStrings.ImportOrganizeConfigurationBlock_order_add_button;
        stringArray[2] = UINlsStrings.ImportOrganizeConfigurationBlock_order_edit_button;
        stringArray[3] = UINlsStrings.ImportOrganizeConfigurationBlock_order_remove_button;
        stringArray[5] = UINlsStrings.ImportOrganizeConfigurationBlock_order_up_button;
        stringArray[6] = UINlsStrings.ImportOrganizeConfigurationBlock_order_down_button;
        stringArray[8] = UINlsStrings.ImportOrganizeConfigurationBlock_order_load_button;
        stringArray[9] = UINlsStrings.ImportOrganizeConfigurationBlock_order_save_button;
        String[] buttonLabels = stringArray;
        ImportOrganizeAdapter adapter = new ImportOrganizeAdapter();
        this.fOrderListField = new ListDialogField(adapter, buttonLabels, (ILabelProvider)new ImportOrganizeLabelProvider());
        this.fOrderListField.setDialogFieldListener(adapter);
        this.fOrderListField.setLabelText(UINlsStrings.ImportOrganizeConfigurationBlock_order_label);
        this.fOrderListField.setUpButtonIndex(5);
        this.fOrderListField.setDownButtonIndex(6);
        this.fOrderListField.setRemoveButtonIndex(3);
        this.fOrderListField.enableButton(2, false);
        this.fThresholdField = new StringDialogField();
        this.fThresholdField.setDialogFieldListener(adapter);
        this.fThresholdField.setLabelText(UINlsStrings.ImportOrganizeConfigurationBlock_threshold_label);
        this.updateControls();
    }

    private void doThresholdChanged() {
        StatusInfo status = new StatusInfo();
        String thresholdString = this.fThresholdField.getText();
        try {
            int threshold = Integer.parseInt(thresholdString);
            if (threshold < 0) {
                status.setError(UINlsStrings.ImportOrganizeConfigurationBlock_error_invalidthreshold);
            }
        }
        catch (NumberFormatException numberFormatException) {
            status.setError(UINlsStrings.ImportOrganizeConfigurationBlock_error_invalidthreshold);
        }
        this.updateStatus(status);
    }

    private void doButtonPressed(int index) {
        if (index == 0) {
            List existing = this.fOrderListField.getElements();
            ImportOrganizeInputDialog dialog = new ImportOrganizeInputDialog(this.getShell(), existing);
            if (dialog.open() == 0) {
                List selectedElements = this.fOrderListField.getSelectedElements();
                if (selectedElements.size() == 1) {
                    int insertionIndex = this.fOrderListField.getIndexOfElement(selectedElements.get(0)) + 1;
                    this.fOrderListField.insertElementAt(dialog.getResult(), insertionIndex);
                } else {
                    this.fOrderListField.addElement(dialog.getResult());
                }
            }
        } else if (index == 2) {
            List selected = this.fOrderListField.getSelectedElements();
            if (selected.isEmpty()) {
                return;
            }
            ImportOrderEntry editedEntry = (ImportOrderEntry)selected.get(0);
            List existing = this.fOrderListField.getElements();
            existing.remove(editedEntry);
            ImportOrganizeInputDialog dialog = new ImportOrganizeInputDialog(this.getShell(), existing);
            dialog.setInitialSelection(editedEntry);
            if (dialog.open() == 0) {
                this.fOrderListField.replaceElement(editedEntry, dialog.getResult());
            }
        } else if (index == 8) {
            List order = this.loadImportOrder();
            if (order != null) {
                this.fOrderListField.setElements(order);
            }
        } else if (index == 9) {
            this.saveImportOrder(this.fOrderListField.getElements());
        }
    }

    @Override
    protected Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        this.fPixelConverter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.fOrderListField.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fOrderListField.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fOrderListField.getLabelControl(null), this.fPixelConverter.convertWidthInCharsToPixels(60));
        LayoutUtil.setHorizontalGrabbing(this.fOrderListField.getListControl(null));
        this.fThresholdField.doFillIntoGrid(composite, 2);
        ((GridData)this.fThresholdField.getTextControl(null).getLayoutData()).grabExcessHorizontalSpace = false;
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private List loadFromProperties(Properties properties) {
        ArrayList<ImportOrderEntry> res = new ArrayList<ImportOrderEntry>();
        int nEntries = properties.size();
        int i = 0;
        while (i < nEntries) {
            ImportOrderEntry entry;
            String curr = properties.getProperty(String.valueOf(i));
            if (curr != null) {
                entry = ImportOrderEntry.fromSerialized(curr);
                if (EGLConventions.validatePackageName((String)entry.name).matches(4)) {
                    return null;
                }
            } else {
                return res;
            }
            res.add(entry);
            ++i;
        }
        return res;
    }

    /*
     * Unable to fully structure code
     */
    private List loadImportOrder() {
        dialogSettings = EDTUIPlugin.getDefault().getDialogSettings();
        dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(UINlsStrings.ImportOrganizeConfigurationBlock_loadDialog_title);
        dialog.setFilterExtensions(new String[]{"*.importorder", "*.*"});
        lastPath = dialogSettings.get("org.eclipse.edt.ide.ui.importorder.loadpath");
        if (lastPath != null) {
            dialog.setFilterPath(lastPath);
        }
        if ((fileName = dialog.open()) != null) {
            block19: {
                block17: {
                    block18: {
                        dialogSettings.put("org.eclipse.edt.ide.ui.importorder.loadpath", dialog.getFilterPath());
                        properties = new Properties();
                        fis = null;
                        fis = new FileInputStream(fileName);
                        properties.load(fis);
                        res = this.loadFromProperties(properties);
                        if (res == null) break block17;
                        var9_9 = res;
                        if (fis == null) break block18;
                        try {
                            fis.close();
                        }
                        catch (IOException v0) {}
                    }
                    return var9_9;
                    catch (IOException e) {
                        try {
                            EDTUIPlugin.log(e);
                            ** if (fis == null) goto lbl-1000
                        }
                        catch (Throwable var8_10) {
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (IOException v2) {}
                            }
                            throw var8_10;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                fis.close();
                            }
                            catch (IOException v1) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block19;
                        }
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException v3) {}
                }
            }
            title = UINlsStrings.ImportOrganizeConfigurationBlock_loadDialog_error_title;
            message = UINlsStrings.ImportOrganizeConfigurationBlock_loadDialog_error_message;
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
        }
        return null;
    }

    private void saveImportOrder(List elements) {
        block17: {
            String fileName;
            IDialogSettings dialogSettings = EDTUIPlugin.getDefault().getDialogSettings();
            FileDialog dialog = new FileDialog(this.getShell(), 8192);
            dialog.setText(UINlsStrings.ImportOrganizeConfigurationBlock_saveDialog_title);
            dialog.setFilterExtensions(new String[]{"*.importorder", "*.*"});
            dialog.setFileName("example.importorder");
            String lastPath = dialogSettings.get(DIALOGSETTING_LASTSAVEPATH);
            if (lastPath != null) {
                dialog.setFilterPath(lastPath);
            }
            if ((fileName = dialog.open()) != null) {
                dialogSettings.put(DIALOGSETTING_LASTSAVEPATH, dialog.getFilterPath());
                Properties properties = new Properties();
                int i = 0;
                while (i < elements.size()) {
                    ImportOrderEntry entry = (ImportOrderEntry)elements.get(i);
                    properties.setProperty(String.valueOf(i), entry.serialize());
                    ++i;
                }
                FileOutputStream fos = null;
                try {
                    try {
                        fos = new FileOutputStream(fileName);
                        properties.store(fos, "Organize Import Order");
                    }
                    catch (IOException e) {
                        EDTUIPlugin.log(e);
                        String title = UINlsStrings.ImportOrganizeConfigurationBlock_saveDialog_error_title;
                        String message = UINlsStrings.ImportOrganizeConfigurationBlock_saveDialog_error_message;
                        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void updateStatus(IStatus status) {
        this.fContext.statusChanged(status);
    }

    @Override
    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
    }

    @Override
    protected void updateControls() {
        ImportOrderEntry[] importOrder = this.getImportOrderPreference();
        int threshold = this.getImportNumberThreshold();
        this.fOrderListField.removeAllElements();
        int i = 0;
        while (i < importOrder.length) {
            this.fOrderListField.addElement(importOrder[i]);
            ++i;
        }
        this.fThresholdField.setText(String.valueOf(threshold));
    }

    protected final void updateModel(DialogField field) {
        if (field == this.fOrderListField) {
            this.setValue(PREF_IMPORTORDER, ImportOrganizeConfigurationBlock.packOrderList(this.fOrderListField.getElements()));
        } else if (field == this.fThresholdField) {
            this.setValue(PREF_ONDEMANDTHRESHOLD, this.fThresholdField.getText());
            this.doThresholdChanged();
        }
    }

    @Override
    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }

    private static ImportOrderEntry[] unpackOrderList(String str) {
        int end;
        ArrayList<ImportOrderEntry> res = new ArrayList<ImportOrderEntry>();
        int start = 0;
        do {
            if ((end = str.indexOf(59, start)) == -1) {
                end = str.length();
            }
            res.add(ImportOrderEntry.fromSerialized(str.substring(start, end)));
        } while ((start = end + 1) < str.length());
        return res.toArray(new ImportOrderEntry[res.size()]);
    }

    private static String packOrderList(List orderList) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < orderList.size()) {
            ImportOrderEntry entry = (ImportOrderEntry)orderList.get(i);
            buf.append(entry.serialize());
            buf.append(';');
            ++i;
        }
        return buf.toString();
    }

    private ImportOrderEntry[] getImportOrderPreference() {
        String str = this.getValue(PREF_IMPORTORDER);
        if (str != null) {
            return ImportOrganizeConfigurationBlock.unpackOrderList(str);
        }
        return new ImportOrderEntry[0];
    }

    private int getImportNumberThreshold() {
        String thresholdStr = this.getValue(PREF_ONDEMANDTHRESHOLD);
        try {
            int threshold = Integer.parseInt(thresholdStr);
            if (threshold < 0) {
                threshold = Integer.MAX_VALUE;
            }
            return threshold;
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MAX_VALUE;
        }
    }

    public static class ImportOrderEntry {
        public final String name;

        public ImportOrderEntry(String name) {
            this.name = name;
        }

        public String serialize() {
            return this.name;
        }

        public static ImportOrderEntry fromSerialized(String str) {
            return new ImportOrderEntry(str);
        }
    }

    private class ImportOrganizeAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private ImportOrganizeAdapter() {
        }

        private boolean canEdit(ListDialogField field) {
            List selected = field.getSelectedElements();
            return selected.size() == 1;
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
            ImportOrganizeConfigurationBlock.this.doButtonPressed(index);
        }

        @Override
        public void selectionChanged(ListDialogField field) {
            ImportOrganizeConfigurationBlock.this.fOrderListField.enableButton(2, this.canEdit(field));
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            ImportOrganizeConfigurationBlock.this.updateModel(field);
        }

        @Override
        public void doubleClicked(ListDialogField field) {
            if (this.canEdit(field)) {
                ImportOrganizeConfigurationBlock.this.doButtonPressed(2);
            }
        }
    }

    private static class ImportOrganizeLabelProvider
    extends LabelProvider {
        private final Image PCK_ICON = PluginImages.get("org.eclipse.edt.ide.ui.eglpkg_obj.gif");

        public Image getImage(Object element) {
            return this.PCK_ICON;
        }

        public String getText(Object element) {
            ImportOrderEntry entry = (ImportOrderEntry)element;
            String name = entry.name;
            if (name.length() > 0) {
                return name;
            }
            return UINlsStrings.ImportOrganizeConfigurationBlock_other_normal;
        }
    }
}

