/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.util;

import org.eclipse.edt.ide.core.internal.search.PartDeclarationInfo;
import org.eclipse.edt.ide.core.internal.search.PartInfo;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class PartInfoLabelProvider
extends LabelProvider {
    public static final int SHOW_FULLYQUALIFIED = 1;
    public static final int SHOW_PACKAGE_POSTFIX = 2;
    public static final int SHOW_PACKAGE_ONLY = 4;
    public static final int SHOW_ROOT_POSTFIX = 8;
    public static final int SHOW_TYPE_ONLY = 16;
    public static final int SHOW_TYPE_CONTAINER_ONLY = 32;
    private static final Image EGLFILE_ICON = PluginImages.get("org.eclipse.edt.ide.ui.eglfile_obj.gif");
    private static final Image PGM_ICON = PluginImages.get("org.eclipse.edt.ide.ui.prgm_obj.gif");
    private static final Image PAGE_ICON = PluginImages.get("org.eclipse.edt.ide.ui.paghdl_obj.gif");
    private static final Image FUNCTION_ICON = PluginImages.get("org.eclipse.edt.ide.ui.funct_obj.gif");
    private static final Image RECORD_ICON = PluginImages.get("org.eclipse.edt.ide.ui.record_obj.gif");
    private static final Image TABLE_ICON = PluginImages.get("org.eclipse.edt.ide.ui.dtatbl_obj.gif");
    private static final Image LIBRARY_ICON = PluginImages.get("org.eclipse.edt.ide.ui.libry_obj.gif");
    private static final Image ITEM_ICON = PluginImages.get("org.eclipse.edt.ide.ui.dtaitm_obj.gif");
    private static final Image FORM_ICON = PluginImages.get("org.eclipse.edt.ide.ui.form_obj.gif");
    private static final Image FORMGRP_ICON = PluginImages.get("org.eclipse.edt.ide.ui.frmgrp_obj.gif");
    private static final Image PKG_ICON = PluginImages.get("org.eclipse.edt.ide.ui.eglpkg_obj.gif");
    private static final Image SERVICE_ICON = PluginImages.get("org.eclipse.edt.ide.ui.svc_obj.gif");
    private static final Image INTERFACE_ICON = PluginImages.get("org.eclipse.edt.ide.ui.int_obj.gif");
    private static final Image HANDLER_ICON = PluginImages.get("org.eclipse.edt.ide.ui.handler_obj.gif");
    private static final Image ENUM_ICON = PluginImages.get("org.eclipse.edt.ide.ui.enum_obj.gif");
    private static final Image EXTERNAL_TYPE_ICON = PluginImages.get("org.eclipse.edt.ide.ui.exttyp_obj.gif");
    private static final Image DELEGATE_ICON = PluginImages.get("org.eclipse.edt.ide.ui.delgat_obj.gif");
    private int fFlags;

    public PartInfoLabelProvider(int flags) {
        this.fFlags = flags;
    }

    private boolean isSet(int flag) {
        return (this.fFlags & flag) != 0;
    }

    private String getPackageName(String packName) {
        if (packName.length() == 0) {
            return UINlsStrings.OpenPartDialog_DefaultPackage;
        }
        return packName;
    }

    public String getText(Object element) {
        if (!(element instanceof PartInfo)) {
            return super.getText(element);
        }
        PartInfo typeRef = (PartInfo)element;
        StringBuffer buf = new StringBuffer();
        if (this.isSet(16)) {
            buf.append(typeRef.getPartName());
        } else if (this.isSet(32)) {
            String containerName = typeRef.getPartContainerName();
            buf.append(this.getPackageName(containerName));
            if (typeRef instanceof PartDeclarationInfo) {
                buf.append(this.getFileName((PartDeclarationInfo)typeRef));
            }
        } else if (this.isSet(4)) {
            String packName = typeRef.getPackageName();
            buf.append(this.getPackageName(packName));
        } else {
            if (this.isSet(1)) {
                buf.append(typeRef.getFullyQualifiedName());
            } else {
                buf.append(typeRef.getPartQualifiedName());
            }
            if (this.isSet(2)) {
                buf.append("--");
                String packName = typeRef.getPackageName();
                buf.append(this.getPackageName(packName));
            }
        }
        if (this.isSet(8)) {
            buf.append("--");
            if (typeRef instanceof PartDeclarationInfo) {
                buf.append(((PartDeclarationInfo)typeRef).getContainerPath());
            } else {
                buf.append(typeRef.getPackageFragmentRootPath().toString());
            }
        }
        return buf.toString();
    }

    private String getFileName(PartDeclarationInfo typeRef) {
        StringBuffer buf = new StringBuffer();
        buf.append(".");
        buf.append(typeRef.getFileName());
        buf.append("." + typeRef.getExtension());
        return buf.toString();
    }

    public Image getImage(Object element) {
        if (!(element instanceof PartInfo)) {
            return super.getImage(element);
        }
        if (this.isSet(32)) {
            PartInfo typeRef = (PartInfo)element;
            if (typeRef.getPackageName().equals(typeRef.getPartContainerName())) {
                return PKG_ICON;
            }
            return EGLFILE_ICON;
        }
        if (this.isSet(4)) {
            return PKG_ICON;
        }
        if (element instanceof PartDeclarationInfo) {
            switch (((PartDeclarationInfo)element).getPartType()) {
                case '\u0001': {
                    return PGM_ICON;
                }
                case '\u0100': {
                    return LIBRARY_ICON;
                }
                case '\b': {
                    return RECORD_ICON;
                }
                case '\u0004': {
                    return TABLE_ICON;
                }
                case '\u0010': {
                    return ITEM_ICON;
                }
                case ' ': {
                    return FORM_ICON;
                }
                case '@': {
                    return FORMGRP_ICON;
                }
                case '\u0080': {
                    return FUNCTION_ICON;
                }
                case '\u0400': {
                    return SERVICE_ICON;
                }
                case '\u0800': {
                    return INTERFACE_ICON;
                }
                case '\u2000': {
                    return EXTERNAL_TYPE_ICON;
                }
                case '\u0200': {
                    return HANDLER_ICON;
                }
                case '\u4000': {
                    return ENUM_ICON;
                }
                case '\u1000': {
                    return DELEGATE_ICON;
                }
            }
            return null;
        }
        return EGLFILE_ICON;
    }
}

