/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.eunit.ui.testresult;

import java.util.ArrayList;
import org.eclipse.edt.ide.eunit.ui.testresult.RSTreeContentProvider;
import org.eclipse.edt.ide.eunit.ui.testresult.RSTreeLabelProvider;
import org.eclipse.edt.ide.eunit.ui.testresult.TestResultDetailPageProvider;
import org.eclipse.edt.ide.eunit.ui.testresult.TestResultViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.w3c.dom.Element;

public class ResultSummaryBlock
extends MasterDetailsBlock {
    private SectionPart spart;
    protected FormPage fPage;
    private static final String TREEROOTNODENAME = "Test Result Summary:";

    public ResultSummaryBlock(FormPage page) {
        this.fPage = page;
    }

    protected Element getResultSummaryRoot() {
        FormEditor formEditor = this.fPage.getEditor();
        if (formEditor instanceof TestResultViewer) {
            return ((TestResultViewer)formEditor).getResultSummaryRoot();
        }
        return null;
    }

    protected void createMasterPart(IManagedForm managedForm, Composite parent) {
        FormToolkit toolkit = managedForm.getToolkit();
        Section section = toolkit.createSection(parent, 384);
        section.setText("shows the test result summary");
        section.setDescription("click on the node to view the details");
        section.marginHeight = 5;
        section.marginWidth = 10;
        Composite seprator = toolkit.createCompositeSeparator((Composite)section);
        GridData gd = new GridData(1808);
        gd.heightHint = 3;
        seprator.setLayoutData((Object)gd);
        this.createResultSummarySection(managedForm, section, toolkit);
    }

    private void createResultSummarySection(final IManagedForm managedForm, Section section, FormToolkit toolkit) {
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        Tree tr = this.createResultSummaryTreeControl(client, toolkit);
        section.setClient((Control)client);
        this.spart = new SectionPart(section);
        managedForm.addPart((IFormPart)this.spart);
        TreeViewer fTreeViewer = new TreeViewer(tr);
        fTreeViewer.setContentProvider((IContentProvider)new RSTreeContentProvider());
        fTreeViewer.setLabelProvider((IBaseLabelProvider)new RSTreeLabelProvider());
        TestResultRootNode rootNode = this.createNewRootNode();
        managedForm.setInput((Object)rootNode);
        fTreeViewer.setInput((Object)managedForm);
        fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                managedForm.fireSelectionChanged((IFormPart)ResultSummaryBlock.this.spart, event.getSelection());
                ResultSummaryBlock.this.HandleTreeSelectionChanged(event);
            }
        });
        fTreeViewer.setSorter(new ViewerSorter());
    }

    private TestResultRootNode createNewRootNode() {
        TestResultRootNode rootNode = new TestResultRootNode();
        rootNode.elemRoot = this.getResultSummaryRoot();
        IEditorInput editorinput = this.fPage.getEditor().getEditorInput();
        if (editorinput instanceof IFileEditorInput) {
            IFileEditorInput fileinput = (IFileEditorInput)editorinput;
            String parentSegment = fileinput.getFile().getParent().getName();
            rootNode.rootname = "Test Result Summary: " + parentSegment;
        }
        return rootNode;
    }

    protected void HandleTreeSelectionChanged(SelectionChangedEvent event) {
    }

    private Tree createResultSummaryTreeControl(Composite client, FormToolkit toolkit) {
        Tree tr = toolkit.createTree(client, 512);
        tr.setHeaderVisible(true);
        tr.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = 20;
        gd.widthHint = 100;
        tr.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
        return tr;
    }

    protected void createToolBarActions(IManagedForm arg0) {
    }

    protected void registerPages(DetailsPart arg0) {
        this.detailsPart.setPageProvider((IDetailsPageProvider)new TestResultDetailPageProvider());
    }

    public static class Record_ResultSummary {
        String pkgName;
        String name;
        int resultCode;
        boolean isSuccessful;
        ResultStatisticCnts statisticCnts;

        public Record_ResultSummary(String pkgName, String name, int resultCode, ResultStatisticCnts statisticCnts) {
            this.pkgName = pkgName;
            this.name = name;
            this.resultCode = resultCode;
            this.isSuccessful = this.resultCode == 0;
            this.statisticCnts = statisticCnts.clone();
        }
    }

    public static class ResultStatisticCnts {
        private int testCnt;
        private int expCnt;
        private int passedCnt;
        private int failedCnt;
        private int exCnt;
        private int badCnt;
        private int notRunCnt;

        public int getTestCnt() {
            return this.testCnt;
        }

        public int getExpectedCnt() {
            return this.expCnt;
        }

        public int getPassedCnt() {
            return this.passedCnt;
        }

        public int getFailedCnt() {
            return this.failedCnt;
        }

        public int getExCnt() {
            return this.exCnt;
        }

        public int getBadCnt() {
            return this.badCnt;
        }

        public int getNotRunCnt() {
            return this.notRunCnt;
        }

        public ResultStatisticCnts() {
            this(0, 0, 0, 0, 0, 0, 0);
        }

        public ResultStatisticCnts(int testCnt, int expCnt, int passedCnt, int failedCnt, int exCnt, int badCnt, int notRunCnt) {
            this.testCnt = testCnt;
            this.expCnt = expCnt;
            this.passedCnt = passedCnt;
            this.failedCnt = failedCnt;
            this.exCnt = exCnt;
            this.badCnt = badCnt;
            this.notRunCnt = notRunCnt;
        }

        public ResultStatisticCnts clone() {
            return new ResultStatisticCnts(this.testCnt, this.expCnt, this.passedCnt, this.failedCnt, this.exCnt, this.badCnt, this.notRunCnt);
        }

        public ResultStatisticCnts plus(ResultStatisticCnts other) {
            return new ResultStatisticCnts(this.testCnt + other.testCnt, this.expCnt + other.expCnt, this.passedCnt + other.passedCnt, this.failedCnt + other.failedCnt, this.exCnt + other.exCnt, this.badCnt + other.badCnt, this.notRunCnt + other.notRunCnt);
        }

        public int overallResult() {
            if (this.failedCnt > 0) {
                return 1;
            }
            if (this.exCnt > 0) {
                return 2;
            }
            if (this.notRunCnt > 0) {
                return 3;
            }
            return 0;
        }
    }

    public static class TestResultPkgNode {
        String pkgName;
        boolean isSuccessful = true;
        ResultStatisticCnts statisticCnts = new ResultStatisticCnts();
        ArrayList<Record_ResultSummary> listRS = new ArrayList();
    }

    public static class TestResultRootNode {
        String rootname;
        boolean isSuccessful = true;
        int expectedTotalTestVariationCnt = -1;
        String startTS = "";
        String endRunTS = "";
        String finalTS = "";
        Element elemRoot;
        ResultStatisticCnts statisticCnts = new ResultStatisticCnts();
    }
}

