/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.errors;

import java.util.ArrayList;
import org.eclipse.edt.ide.core.internal.errors.ErrorBaseParser;
import org.eclipse.edt.ide.core.internal.errors.NonTerminalNode;
import org.eclipse.edt.ide.core.internal.errors.TerminalNode;

public class ErrorGrammar
extends ErrorBaseParser {
    private static ErrorGrammar instance;
    private short[][] terminalCandidates;

    private ErrorGrammar() {
        this.production_tab = this.production_table();
        this.action_tab = this.action_table();
        this.reduce_tab = this.reduce_table();
    }

    public static ErrorGrammar getInstance() {
        if (instance == null) {
            instance = new ErrorGrammar();
            instance.populateTerminalCandidatesTable();
        }
        return instance;
    }

    public int getTerminalAction(int parseState, TerminalNode terminalNode) {
        return this.get_action(parseState, terminalNode.terminalType);
    }

    public int getTerminalAction(int parseState, int terminalType) {
        return this.get_action(parseState, terminalType);
    }

    public int getGotoState(int parseState, NonTerminalNode nonTerminalNode) {
        return this.get_reduce(parseState, nonTerminalNode.nonTerminalType);
    }

    public int getHandleSize(int ruleNumber) {
        return this.production_tab[ruleNumber][1];
    }

    public int getLHS(int ruleNumber) {
        return this.production_tab[ruleNumber][0];
    }

    public int getStartState() {
        return this.start_state();
    }

    private void populateTerminalCandidatesTable() {
        this.terminalCandidates = new short[_action_table.length][];
        int i = 0;
        while (i < _action_table.length) {
            ArrayList<Short> terminalList = new ArrayList<Short>(_action_table[i].length);
            int j = 0;
            while (j < _action_table[i].length) {
                if (_action_table[i][j] > 1 && _action_table[i][j + 1] != 0) {
                    terminalList.add(new Short(_action_table[i][j]));
                }
                j += 2;
            }
            this.terminalCandidates[i] = new short[terminalList.size()];
            j = 0;
            while (j < terminalList.size()) {
                this.terminalCandidates[i][j] = (Short)terminalList.get(j);
                ++j;
            }
            ++i;
        }
    }

    public short[] getTerminalCandidates(int state) {
        return this.terminalCandidates[state];
    }

    public short[] getNonTerminalCandidates(int state) {
        if (state == 0) {
            return new short[]{72};
        }
        short[] result = new short[_reduce_table[state].length / 2 - 1];
        int i = 0;
        while (i < result.length) {
            result[i] = _reduce_table[state][i * 2];
            ++i;
        }
        return result;
    }

    public boolean isLRZeroReduceState(int state) {
        return this.getLRZeroReduceRule(state) >= 0;
    }

    public int getLRZeroReduceRule(int state) {
        int position = 1;
        int maxPosition = this.action_tab[state].length - 2;
        while (position < maxPosition) {
            short action = this.action_tab[state][position];
            if (action < 0) break;
            position += 2;
        }
        if (position < maxPosition) {
            short reduceAction = this.action_tab[state][position];
            position += 2;
            while (position < maxPosition) {
                short action = this.action_tab[state][position];
                if (action < 0 && action != reduceAction) {
                    return -1;
                }
                position += 2;
            }
            return -reduceAction - 1;
        }
        return -1;
    }
}

