/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.model.ISourceElementRequestor;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.model.index.IDocument;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EVisitor;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.DataItem;
import org.eclipse.edt.mof.egl.Delegate;
import org.eclipse.edt.mof.egl.EGLClass;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Enumeration;
import org.eclipse.edt.mof.egl.ExternalType;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.FunctionPart;
import org.eclipse.edt.mof.egl.Handler;
import org.eclipse.edt.mof.egl.Interface;
import org.eclipse.edt.mof.egl.Library;
import org.eclipse.edt.mof.egl.LogicAndDataPart;
import org.eclipse.edt.mof.egl.Operation;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Program;
import org.eclipse.edt.mof.egl.ProgramParameter;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Service;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.impl.AbstractVisitor;
import org.eclipse.edt.mof.serialization.DeserializationException;
import org.eclipse.edt.mof.serialization.Deserializer;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.xml.XMLSerializationFactory;

public class BinaryElementParser {
    private char[] packageName;
    private ISourceElementRequestor requestor;
    private IProject project;
    private boolean reportReferencesInStatements;

    public BinaryElementParser(ISourceElementRequestor requestor, IProject project) {
        this.requestor = requestor;
        this.project = project;
    }

    public void parseDocument(IDocument file, boolean reportReferencesInStatements) {
        this.reportReferencesInStatements = reportReferencesInStatements;
        try {
            byte[] contents = file.getByteContent();
            if (contents == null) {
                return;
            }
            this.index(contents);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void index(byte[] IRContents) {
        XMLSerializationFactory factory = new XMLSerializationFactory();
        ByteArrayInputStream input = new ByteArrayInputStream(IRContents);
        ProjectEnvironment env = ProjectEnvironmentManager.getInstance().getProjectEnvironment(this.project);
        try {
            Environment.pushEnv((IEnvironment)env.getIREnvironment());
            env.initIREnvironments();
            Deserializer deserializer = factory.createDeserializer((Object)input, (IEnvironment)env.getIREnvironment());
            try {
                EObject obj = deserializer.deserialize();
                if (obj instanceof Part) {
                    Part part = (Part)obj;
                    String fullyQualifiedName = part.getFullyQualifiedName();
                    if (fullyQualifiedName.indexOf(46) >= 0) {
                        fullyQualifiedName = fullyQualifiedName.substring(0, fullyQualifiedName.lastIndexOf(46));
                    }
                    this.packageName = fullyQualifiedName.toCharArray();
                    this.requestor.enterEGLFile();
                    if (this.packageName != null) {
                        this.requestor.acceptPackage(0, 0, this.packageName);
                    }
                    this.handleEnterPart(part);
                }
            }
            catch (DeserializationException ex) {
                ex.printStackTrace();
            }
        }
        finally {
            Environment.popEnv();
        }
    }

    private void handleEnterPart(Part partElement) {
        PartInfoHelper partInfo = new PartInfoHelper();
        ElementLocation location = this.getElementLocation((Element)partElement);
        partInfo.nameStart = location.elementOffSet;
        partInfo.nameEnd = location.elementOffSet + location.elementLen;
        partInfo.name = partElement.getName().toCharArray();
        partInfo.modifier = partElement.getAccessKind() == AccessKind.ACC_PRIVATE ? 2 : 1;
        new PartVisitor(partInfo, partElement);
    }

    private void visitPart(int partType, PartInfoHelper pInfo, Part partElement) {
        String subTypeName = "";
        if (partElement instanceof DataItem) {
            subTypeName = ((DataItem)partElement).getBaseType().toString();
        } else if (partElement instanceof StereotypeType) {
            subTypeName = "eglx.lang.Stereotype";
        } else if (partElement instanceof AnnotationType) {
            subTypeName = "eglx.lang.Annotation";
        } else if (partElement.getSubType() != null) {
            subTypeName = partElement.getSubType().getEClass().getName();
        }
        this.requestor.enterPart(partType, subTypeName.toCharArray(), partElement.hashCode(), 0, pInfo.modifier, pInfo.name, pInfo.nameStart, pInfo.nameEnd, pInfo.interfaceNames, pInfo.parameterNames, pInfo.parameterTypes, pInfo.usagePartTypes, pInfo.usagePartPackages, partElement.getFileName());
    }

    private ElementLocation getElementLocation(Element element) {
        ElementLocation location;
        Annotation annotation = element.getAnnotation("EGL_Location");
        if (annotation != null) {
            int startOffset = 0;
            int length = 0;
            if (annotation.getValue("off") != null) {
                startOffset = (Integer)annotation.getValue("off");
            }
            if (annotation.getValue("len") != null) {
                length = (Integer)annotation.getValue("len");
            }
            location = new ElementLocation(startOffset, length);
        } else {
            location = new ElementLocation(0, 0);
        }
        return location;
    }

    private class ElementLocation {
        int elementOffSet;
        int elementLen;

        public ElementLocation(int offset, int len) {
            this.elementOffSet = offset;
            this.elementLen = len;
        }
    }

    private class PartInfoHelper {
        char[] name;
        int nameStart;
        int nameEnd;
        int modifier;
        char[][] interfaceNames = null;
        char[][] parameterNames = null;
        char[][] parameterTypes = null;
        char[][] usagePartTypes = null;
        char[][] usagePartPackages = null;

        private PartInfoHelper() {
        }
    }

    public class PartVisitor
    extends AbstractVisitor {
        private int partType;
        private PartInfoHelper partInfo;
        private Part part;

        PartVisitor(PartInfoHelper partInfo, Part part) {
            this.disallowRevisit();
            this.partInfo = partInfo;
            this.part = part;
            part.accept((EVisitor)this);
        }

        public boolean visit(Part part) {
            return this.shouldVisit(part);
        }

        private boolean shouldVisit(Part part) {
            return this.part == part;
        }

        public boolean visit(Annotation annotation) {
            return false;
        }

        public void endVisit(Annotation annotation) {
        }

        public boolean visit(AnnotationType annoType) {
            if (!this.shouldVisit((Part)annoType)) {
                return false;
            }
            this.partType = 2;
            BinaryElementParser.this.visitPart(this.partType, this.partInfo, (Part)annoType);
            return true;
        }

        public boolean visit(StereotypeType annoType) {
            if (!this.shouldVisit((Part)annoType)) {
                return false;
            }
            this.partType = 2;
            BinaryElementParser.this.visitPart(this.partType, this.partInfo, (Part)annoType);
            return true;
        }

        public boolean visit(Delegate delegate) {
            String packageName;
            int nameStart;
            if (!this.shouldVisit((Part)delegate)) {
                return false;
            }
            this.partType = 16;
            BinaryElementParser.this.visitPart(this.partType, this.partInfo, (Part)delegate);
            AccessKind accessKind = delegate.getAccessKind();
            boolean isPublic = true;
            if (accessKind != null && accessKind == AccessKind.ACC_PRIVATE) {
                isPublic = false;
            }
            int modifier = isPublic ? 1 : 2;
            ElementLocation location = BinaryElementParser.this.getElementLocation((Element)delegate);
            int declStart = location.elementOffSet;
            int cfr_ignored_0 = location.elementOffSet;
            int cfr_ignored_1 = location.elementLen;
            int nameEnd = nameStart = 0;
            List funPara = delegate.getParameters();
            int funcParaLen = funPara.size();
            char[][] parmNames = new char[funcParaLen][];
            char[][] typeNames = new char[funcParaLen][];
            int[] typeIdentifiers = new int[funcParaLen];
            char[][] useTypes = new char[funcParaLen][];
            char[][] parmPackages = new char[funcParaLen][];
            boolean[] areNullable = new boolean[funcParaLen];
            int i = 0;
            while (i < funcParaLen) {
                FunctionParameter parameter = (FunctionParameter)funPara.get(i);
                parmNames[i] = parameter.getName().toString().toCharArray();
                typeNames[i] = parameter.getType().getTypeSignature().toCharArray();
                areNullable[i] = parameter.isNullable();
                String useType = "";
                ParameterKind paraKind = parameter.getParameterKind();
                useType = paraKind == ParameterKind.PARM_IN ? "in" : (paraKind == ParameterKind.PARM_INOUT ? "inout" : "out");
                useTypes[i] = useType.toCharArray();
                packageName = null;
                if (parameter.getType() != null && parameter.getType().getClassifier() != null) {
                    packageName = parameter.getType().getClassifier().getPackageName();
                }
                parmPackages[i] = (char[])(packageName != null ? packageName.toCharArray() : null);
                typeIdentifiers[i] = 0;
                ++i;
            }
            Type retType = delegate.getReturnType();
            char[] fieldName = "".toCharArray();
            char[] retFieldPkg = null;
            if (retType != null) {
                packageName = retType.getClassifier().getPackageName();
                retFieldPkg = packageName != null ? packageName.toCharArray() : null;
                fieldName = retType.getClassifier().getName().toCharArray();
            }
            BinaryElementParser.this.requestor.enterFunction(declStart, modifier, fieldName, retFieldPkg, delegate.getId().toCharArray(), nameStart, nameEnd, typeNames, parmNames, useTypes, areNullable, parmPackages);
            return true;
        }

        public boolean visit(Enumeration enumeration) {
            if (!this.shouldVisit((Part)enumeration)) {
                return false;
            }
            this.partType = 18;
            BinaryElementParser.this.visitPart(this.partType, this.partInfo, (Part)enumeration);
            return true;
        }

        public boolean visit(ExternalType externalType) {
            if (!this.shouldVisit((Part)externalType)) {
                return false;
            }
            this.partType = 17;
            BinaryElementParser.this.visitPart(this.partType, this.partInfo, (Part)externalType);
            return true;
        }

        public boolean visit(EGLClass eglClass) {
            if (!this.shouldVisit((Part)eglClass)) {
                return false;
            }
            this.partType = 17;
            BinaryElementParser.this.visitPart(this.partType, this.partInfo, (Part)eglClass);
            return true;
        }

        public boolean visit(Statement stmt) {
            return false;
        }

        public boolean visit(Operation operation) {
            return false;
        }

        public void endVisit(Operation operation) {
        }

        public boolean visit(Function function) {
            String packageName;
            this.partType = 10;
            String functionName = function.getName();
            if (functionName.equalsIgnoreCase("<init>")) {
                return false;
            }
            ElementLocation location = BinaryElementParser.this.getElementLocation((Element)function);
            int declStart = location.elementOffSet;
            int cfr_ignored_0 = location.elementOffSet;
            int cfr_ignored_1 = location.elementLen;
            AccessKind accessKind = function.getAccessKind();
            boolean isPublic = true;
            if (accessKind != null && accessKind == AccessKind.ACC_PRIVATE) {
                isPublic = false;
            }
            int modifier = isPublic ? 1 : 2;
            int nameStart = declStart;
            int nameEnd = declStart + functionName.length() - 1;
            List funPara = function.getParameters();
            int funcParaLen = funPara.size();
            char[][] parmNames = new char[funcParaLen][];
            char[][] typeNames = new char[funcParaLen][];
            int[] typeIdentifiers = new int[funcParaLen];
            char[][] useTypes = new char[funcParaLen][];
            char[][] parmPackages = new char[funcParaLen][];
            boolean[] areNullable = new boolean[funcParaLen];
            int i = 0;
            while (i < funcParaLen) {
                FunctionParameter parameter = (FunctionParameter)funPara.get(i);
                parmNames[i] = parameter.getName().toString().toCharArray();
                typeNames[i] = parameter.getType().getTypeSignature().toCharArray();
                areNullable[i] = parameter.isNullable();
                String useType = "";
                ParameterKind paraKind = parameter.getParameterKind();
                useType = paraKind == ParameterKind.PARM_IN ? "in" : (paraKind == ParameterKind.PARM_INOUT ? "inout" : "out");
                useTypes[i] = useType.toCharArray();
                packageName = null;
                if (parameter.getType() != null && parameter.getType().getClassifier() != null) {
                    packageName = parameter.getType().getClassifier().getPackageName();
                }
                parmPackages[i] = (char[])(packageName != null ? packageName.toCharArray() : null);
                typeIdentifiers[i] = 0;
                ++i;
            }
            Field retField = function.getReturnField();
            char[] fieldName = "".toCharArray();
            char[] retFieldPkg = null;
            if (retField != null) {
                packageName = retField.getType().getClassifier().getPackageName();
                retFieldPkg = packageName != null ? packageName.toCharArray() : null;
                fieldName = retField.getName().toCharArray();
            }
            BinaryElementParser.this.requestor.enterFunction(declStart, modifier, fieldName, retFieldPkg, function.getId().toCharArray(), nameStart, nameEnd, typeNames, parmNames, useTypes, areNullable, parmPackages);
            return true;
        }

        public void endVisit(Function function) {
            String functionName = function.getName();
            if (functionName.toString().equalsIgnoreCase("<init>")) {
                return;
            }
            BinaryElementParser.this.requestor.exitFunction(0);
        }

        public boolean visit(FunctionParameter parameter) {
            ElementLocation location = BinaryElementParser.this.getElementLocation((Element)parameter);
            int declStart = location.elementOffSet;
            int declEnd = location.elementOffSet + location.elementLen;
            if (parameter.getType().getClassifier() != null) {
                String fullyQualifiedName = String.valueOf(parameter.getName()) + " " + parameter.getType().getClassifier().getId();
                BinaryElementParser.this.requestor.acceptPartReference(Util.toCompoundChars(fullyQualifiedName), declStart, declEnd);
            }
            return true;
        }

        public boolean visit(FunctionPart functionPart) {
            if (!this.shouldVisit((Part)functionPart)) {
                return false;
            }
            BinaryElementParser.this.visitPart(this.partType, this.partInfo, (Part)functionPart);
            return true;
        }

        public boolean visit(Handler handler) {
            if (!this.shouldVisit((Part)handler)) {
                return false;
            }
            this.partType = 7;
            this.updatePartInfo((LogicAndDataPart)handler);
            BinaryElementParser.this.visitPart(this.partType, this.partInfo, (Part)handler);
            return true;
        }

        public boolean visit(Interface itf) {
            if (!this.shouldVisit((Part)itf)) {
                return false;
            }
            this.partType = 6;
            BinaryElementParser.this.visitPart(this.partType, this.partInfo, (Part)itf);
            return true;
        }

        public boolean visit(Library library) {
            if (!this.shouldVisit((Part)library)) {
                return false;
            }
            this.partType = 11;
            this.updatePartInfo((LogicAndDataPart)library);
            BinaryElementParser.this.visitPart(this.partType, this.partInfo, (Part)library);
            return true;
        }

        public boolean visit(Program program) {
            int paramLength;
            if (!this.shouldVisit((Part)program)) {
                return false;
            }
            this.partType = 1;
            this.updatePartInfo((LogicAndDataPart)program);
            if (program.isCallable().booleanValue() && (paramLength = program.getParameters().size()) > 0) {
                char[][] paramNames = new char[paramLength][];
                char[][] paramTypes = new char[paramLength][];
                List params = program.getParameters();
                int i = 0;
                while (i < paramLength) {
                    paramNames[i] = ((ProgramParameter)params.get(i)).getId().toCharArray();
                    paramTypes[i] = ((ProgramParameter)params.get(i)).getType().toString().toCharArray();
                    ++i;
                }
                this.partInfo.parameterNames = paramNames;
                this.partInfo.parameterTypes = paramTypes;
            }
            BinaryElementParser.this.visitPart(this.partType, this.partInfo, (Part)program);
            return true;
        }

        public boolean visit(Record partElement) {
            if (!this.shouldVisit((Part)partElement)) {
                return false;
            }
            this.partType = 2;
            BinaryElementParser.this.visitPart(this.partType, this.partInfo, (Part)partElement);
            return true;
        }

        public boolean visit(Service service) {
            if (!this.shouldVisit((Part)service)) {
                return false;
            }
            this.partType = 12;
            this.updatePartInfo((LogicAndDataPart)service);
            List implementedInterfaceNames = service.getInterfaces();
            int implementedInterfacesLength = implementedInterfaceNames.size();
            if (implementedInterfacesLength > 0) {
                this.partInfo.interfaceNames = new char[implementedInterfacesLength][];
                int i = 0;
                while (i < implementedInterfacesLength) {
                    this.partInfo.interfaceNames[i] = ((Interface)implementedInterfaceNames.get(i)).getFullyQualifiedName().toCharArray();
                    ++i;
                }
            }
            BinaryElementParser.this.visitPart(this.partType, this.partInfo, (Part)service);
            return true;
        }

        private void updatePartInfo(LogicAndDataPart part) {
            List usedParts = part.getUsedParts();
            if (usedParts != null && usedParts.size() > 0) {
                char[][] usagePartTypes = new char[usedParts.size()][];
                char[][] usagePartPackages = new char[usedParts.size()][];
                int i = 0;
                while (i < usedParts.size()) {
                    usagePartTypes[i] = ((Part)usedParts.get(i)).getName().toCharArray();
                    usagePartPackages[i] = ((Part)usedParts.get(i)).getPackageName().toCharArray();
                    ++i;
                }
                this.partInfo.usagePartTypes = usagePartTypes;
                this.partInfo.usagePartPackages = usagePartPackages;
            }
        }
    }
}

