/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.document;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java_cup.runtime.Scanner;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.DataItem;
import org.eclipse.edt.compiler.core.ast.DataTable;
import org.eclipse.edt.compiler.core.ast.Delegate;
import org.eclipse.edt.compiler.core.ast.Enumeration;
import org.eclipse.edt.compiler.core.ast.ErrorCorrectingParser;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.FormGroup;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.Lexer;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.TopLevelForm;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.ide.core.ast.GetNodeAtOffsetVisitor;
import org.eclipse.edt.ide.core.ast.GetNodeAtOrBeforeOffsetVisitor;
import org.eclipse.edt.ide.core.internal.model.document.EGLDocumentReader;
import org.eclipse.edt.ide.core.internal.model.document.EGLModelChangeReport;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.core.model.document.IEGLModelChangeListener;
import org.eclipse.edt.ide.core.model.document.IEGLModelReconcileListener;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public class EGLDocument
extends Document
implements IEGLDocument {
    protected File fileRootNode;
    private long lastUpdateTime;
    private boolean needReconcile = true;
    private List modelChangeListeners = new ArrayList();
    private List modelReconcileListeners = new ArrayList();

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public EGLDocument() {
    }

    public EGLDocument(String initialContent) {
        super(initialContent);
    }

    @Override
    public void addModelChangeListener(IEGLModelChangeListener listener) {
        if (!this.modelChangeListeners.contains(listener)) {
            this.modelChangeListeners.add(listener);
        }
    }

    @Override
    public void removeModelChangeListener(IEGLModelChangeListener listener) {
        this.modelChangeListeners.remove(listener);
    }

    protected void fireModelChanged() {
        if (this.modelChangeListeners.size() > 0) {
            ArrayList list = new ArrayList(this.modelChangeListeners);
            for (IEGLModelChangeListener listener : list) {
                listener.modelChanged();
            }
        }
    }

    public void addModelReconcileListener(IEGLModelReconcileListener listener) {
        if (!this.modelReconcileListeners.contains(listener)) {
            this.modelReconcileListeners.add(listener);
        }
    }

    public void removeModelReconcileListener(IEGLModelReconcileListener listener) {
        this.modelReconcileListeners.remove(listener);
    }

    protected void fireModelReconciled(EGLModelChangeReport report) {
        if (this.modelReconcileListeners.size() > 0) {
            ArrayList list = new ArrayList(this.modelReconcileListeners);
            for (IEGLModelReconcileListener listener : list) {
                listener.modelReconciled(report);
            }
        }
    }

    @Override
    public EGLModelChangeReport reconcile() {
        EGLModelChangeReport report = null;
        if (this.needReconcile) {
            this.needReconcile = false;
            int whitespacemask = 14;
            ErrorCorrectingParser newParser = new ErrorCorrectingParser((Scanner)new Lexer((Reader)new BufferedReader(new StringReader(this.get()))), whitespacemask);
            this.fileRootNode = (File)newParser.parse().value;
            this.fireModelReconciled(report);
        }
        return report;
    }

    @Override
    public File getNewModelEGLFile() {
        this.reconcile();
        return this.fileRootNode;
    }

    @Override
    public Node getNewModelNodeAtOffset(int offset) {
        return this.getNewModelNodeAtOffset(offset, 0, (Node)this.getNewModelEGLFile());
    }

    @Override
    public Node getNewModelNodeAtOffset(int offset, int length) {
        return this.getNewModelNodeAtOffset(offset, length, (Node)this.getNewModelEGLFile());
    }

    @Override
    public Node getNewModelNodeAtOffset(int offset, Node node) {
        return this.getNewModelNodeAtOffset(offset, 0, node);
    }

    @Override
    public Node getNewModelNodeAtOffset(int offset, int length, Node node) {
        this.reconcile();
        GetNodeAtOffsetVisitor visitor = new GetNodeAtOffsetVisitor(offset, length);
        node.accept((IASTVisitor)visitor);
        return visitor.getNode();
    }

    public Node getNewModelNodeAtOrBeforeOffset(int offset) {
        this.reconcile();
        GetNodeAtOrBeforeOffsetVisitor visitor = new GetNodeAtOrBeforeOffsetVisitor(offset);
        this.getNewModelEGLFile().accept((IASTVisitor)visitor);
        return visitor.getNode();
    }

    public Part getNewModelPartAtOffset(int offset, Node node) {
        this.reconcile();
        PartASTVisitor visitor = new PartASTVisitor(offset);
        node.accept((IASTVisitor)visitor);
        return (Part)visitor.getNode();
    }

    public Part getNewModelPartAtOffset(int offset) {
        this.reconcile();
        PartASTVisitor visitor = new PartASTVisitor(offset);
        this.getNewModelEGLFile().accept((IASTVisitor)visitor);
        return (Part)visitor.getNode();
    }

    public NestedFunction getNewModelNestedFunctionAtOffset(int offset) {
        this.reconcile();
        NestedFunctionASTVisitor visitor = new NestedFunctionASTVisitor(offset);
        this.getNewModelEGLFile().accept((IASTVisitor)visitor);
        return (NestedFunction)visitor.getNode();
    }

    public NestedForm getNewModelNestedFormAtOffset(int offset) {
        this.reconcile();
        NestedFormASTVisitor visitor = new NestedFormASTVisitor(offset);
        this.getNewModelEGLFile().accept((IASTVisitor)visitor);
        return (NestedForm)visitor.getNode();
    }

    public void replace(int pos, int length, String text, long modificationStamp) throws BadLocationException {
        this.needReconcile = true;
        super.replace(pos, length, text, modificationStamp);
        this.lastUpdateTime = System.currentTimeMillis();
        this.fireModelChanged();
    }

    public void set(String text, long modificationStamp) {
        this.needReconcile = true;
        super.set(text, modificationStamp);
        this.lastUpdateTime = System.currentTimeMillis();
        this.fireModelChanged();
    }

    @Override
    public Reader getReader(int startOffset) {
        return new EGLDocumentReader(this, startOffset);
    }

    class NestedFormASTVisitor
    extends AbstractASTVisitor {
        private Node targetNestedForm;
        private int targetOffset;

        public NestedFormASTVisitor(int offset) {
            this.targetOffset = offset;
        }

        public boolean visit(NestedForm nestedForm) {
            if (nestedForm.getOffset() <= this.targetOffset && this.targetOffset < nestedForm.getOffset() + nestedForm.getLength()) {
                this.targetNestedForm = nestedForm;
                return true;
            }
            return false;
        }

        public Node getNode() {
            return this.targetNestedForm;
        }
    }

    class NestedFunctionASTVisitor
    extends AbstractASTVisitor {
        private Node targetNestedFunction;
        private int targetOffset;

        public NestedFunctionASTVisitor(int offset) {
            this.targetOffset = offset;
        }

        public boolean visit(NestedFunction nestedFunction) {
            if (nestedFunction.getOffset() <= this.targetOffset && this.targetOffset < nestedFunction.getOffset() + nestedFunction.getLength()) {
                this.targetNestedFunction = nestedFunction;
                return true;
            }
            return false;
        }

        public Node getNode() {
            return this.targetNestedFunction;
        }
    }

    class PartASTVisitor
    extends AbstractASTVisitor {
        private Part targetPart;
        private int targetOffset;

        public PartASTVisitor(int offset) {
            this.targetOffset = offset;
        }

        public boolean visit(DataItem part) {
            return this.visitInternal((Part)part);
        }

        public boolean visit(DataTable part) {
            return this.visitInternal((Part)part);
        }

        public boolean visit(Delegate part) {
            return this.visitInternal((Part)part);
        }

        public boolean visit(Enumeration part) {
            return this.visitInternal((Part)part);
        }

        public boolean visit(ExternalType part) {
            return this.visitInternal((Part)part);
        }

        public boolean visit(FormGroup part) {
            return this.visitInternal((Part)part);
        }

        public boolean visit(Handler part) {
            return this.visitInternal((Part)part);
        }

        public boolean visit(Interface part) {
            return this.visitInternal((Part)part);
        }

        public boolean visit(Library part) {
            return this.visitInternal((Part)part);
        }

        public boolean visit(Program part) {
            return this.visitInternal((Part)part);
        }

        public boolean visit(Record part) {
            return this.visitInternal((Part)part);
        }

        public boolean visit(Service part) {
            return this.visitInternal((Part)part);
        }

        public boolean visit(TopLevelForm part) {
            return this.visitInternal((Part)part);
        }

        public boolean visit(TopLevelFunction part) {
            return this.visitInternal((Part)part);
        }

        public boolean visitInternal(Part part) {
            if (part.getOffset() <= this.targetOffset && this.targetOffset < part.getOffset() + part.getLength()) {
                this.targetPart = part;
                return true;
            }
            return false;
        }

        public Node getNode() {
            return this.targetPart;
        }
    }
}

