/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.indexing;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.ISourceElementRequestor;
import org.eclipse.edt.ide.core.internal.model.index.IDocument;
import org.eclipse.edt.ide.core.internal.model.indexing.SourceIndexer;
import org.eclipse.edt.ide.core.model.IIndexConstants;

public class SourceIndexerRequestor
implements ISourceElementRequestor,
IIndexConstants {
    SourceIndexer indexer;
    IDocument document;
    char[] packageName;
    char[][] enclosingTypeNames = new char[5][];
    int depth = 0;
    int methodDepth = 0;

    public SourceIndexerRequestor(SourceIndexer indexer, IDocument document) {
        this.indexer = indexer;
        this.document = document;
    }

    @Override
    public void acceptField(int declarationStart, int declarationEnd, int modifiers, char[] type, char[] name, int nameSourceStart, int nameSourceEnd) {
        this.indexer.addFieldDeclaration(type, name);
    }

    public void acceptFieldReference(char[] fieldName, int sourcePosition) {
        this.indexer.addFieldReference(fieldName);
    }

    @Override
    public void acceptImport(int declarationStart, int declarationEnd, char[] name, boolean onDemand) {
        char[][] qualification = CharOperation.splitOn((char)'.', (char[])CharOperation.subarray((char[])name, (int)0, (int)CharOperation.lastIndexOf((char)'.', (char[])name)));
        int i = 0;
        int length = qualification.length;
        while (i < length) {
            this.indexer.addNameReference(qualification[i]);
            ++i;
        }
    }

    @Override
    public void acceptUse(int declarationStart, int declarationEnd, char[] name) {
        char[][] names = CharOperation.splitOn((char)'.', (char[])name);
        this.acceptPartReference(names, declarationStart, declarationEnd);
    }

    @Override
    public void acceptLineSeparatorPositions(int[] positions) {
    }

    @Override
    public void acceptFunctionReference(char[] methodName, int argCount, int sourcePosition) {
        this.indexer.addFunctionReference(methodName, argCount);
    }

    @Override
    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
        this.packageName = name;
    }

    @Override
    public void acceptPartReference(char[][] typeName, int sourceStart, int sourceEnd) {
        int length = typeName.length;
        int i = 0;
        while (i < length - 1) {
            this.acceptUnknownReference(typeName[i], 0);
            ++i;
        }
        this.acceptPartReference(typeName[length - 1], 0);
    }

    @Override
    public void acceptPartReference(char[] simpleTypeName, int sourcePosition) {
        this.indexer.addPartReference(simpleTypeName);
    }

    @Override
    public void acceptUnknownReference(char[][] name, int sourceStart, int sourceEnd) {
        int i = 0;
        while (i < name.length) {
            this.acceptUnknownReference(name[i], 0);
            ++i;
        }
    }

    @Override
    public void acceptUnknownReference(char[] name, int sourcePosition) {
        this.indexer.addNameReference(name);
    }

    public char[][] enclosingTypeNames() {
        if (this.depth == 0) {
            return null;
        }
        char[][] qualification = new char[this.depth][];
        System.arraycopy(this.enclosingTypeNames, 0, qualification, 0, this.depth);
        return qualification;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void enterPart(int partType, char[] subType, int contentCode, int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] interfaceNames, char[][] parameterNames, char[][] parameterTypes, char[][] usagePartTypes, char[][] usagePartPackages, String eglFileName) {
        void var16_33;
        char[][] enclosingTypeNames = this.methodDepth > 0 ? ONE_ZERO_CHAR : this.enclosingTypeNames();
        int n = Short.MAX_VALUE;
        switch (partType) {
            case 2: {
                int n2 = 128;
                break;
            }
            case 4: {
                int n3 = 32;
                break;
            }
            case 5: {
                int n4 = 64;
                break;
            }
            case 8: {
                int n5 = 256;
                break;
            }
            case 0: {
                boolean bl = true;
                break;
            }
            case 6: {
                int n6 = 4;
                break;
            }
            case 1: {
                int n7 = 8;
                break;
            }
            case 3: {
                int n8 = 16;
                break;
            }
            case 9: {
                int n9 = 512;
                break;
            }
            case 11: {
                int n10 = 2048;
                break;
            }
            case 12: {
                int n11 = 4096;
                break;
            }
            case 13: {
                int n12 = 8192;
                break;
            }
            case 14: {
                int n13 = 16384;
                break;
            }
            case 10: {
                int n14 = 1024;
                break;
            }
            case 15: {
                boolean bl = false;
                break;
            }
            default: {
                int n15 = Short.MAX_VALUE;
            }
        }
        this.indexer.addPartDeclaration((char)var16_33, modifiers, this.packageName, name, enclosingTypeNames, interfaceNames);
        this.indexer.addNameReference(subType);
        this.pushPartName(name);
    }

    @Override
    public void enterEGLFile() {
    }

    @Override
    public void enterField(int declarationStart, int modifiers, char[] type, char[] typeDeclaredPackage, char[] name, int nameSourceStart, int nameSourceEnd, boolean hasOccurs, int declEnd) {
        this.indexer.addFieldDeclaration(type, name);
        ++this.methodDepth;
        if (this.methodDepth > 1) {
            this.exitField(declEnd);
        }
    }

    @Override
    public void enterFunction(int declarationStart, int modifiers, char[] returnType, char[] returnTypePackage, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] parameterUseTypes, boolean[] areNullable, char[][] parameterPackages) {
        this.indexer.addFunctionDeclaration(name, parameterTypes, returnType);
        ++this.methodDepth;
    }

    @Override
    public void exitPart(int declarationEnd) {
        this.popPartName();
    }

    @Override
    public void exitEGLFile(int declarationEnd) {
    }

    public void exitConstructor(int declarationEnd) {
        --this.methodDepth;
    }

    @Override
    public void exitField(int declarationEnd) {
        --this.methodDepth;
    }

    @Override
    public void exitUse(int declarationEnd) {
        --this.methodDepth;
    }

    @Override
    public void exitFunction(int declarationEnd) {
        --this.methodDepth;
    }

    public void popPartName() {
        try {
            this.enclosingTypeNames[--this.depth] = null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    public void pushPartName(char[] typeName) {
        if (this.depth == this.enclosingTypeNames.length) {
            char[][] cArrayArray = new char[this.depth * 2][];
            this.enclosingTypeNames = cArrayArray;
            System.arraycopy(this.enclosingTypeNames, 0, cArrayArray, 0, this.depth);
        }
        this.enclosingTypeNames[this.depth++] = typeName;
    }

    @Override
    public void acceptProperty(int declarationStart, int declarationEnd, char[] text) {
        StringTokenizer tokenizer = new StringTokenizer(new String(text), "=\t\f\n\r");
        String key = tokenizer.nextToken().trim();
        String value = null;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("=")) continue;
            value = token.trim();
        }
        if (value != null && !value.equals("yes") && !value.equals("no")) {
            this.acceptUnknownReference(value.toCharArray(), declarationStart);
        }
        if (key != null && key.length() != 0) {
            this.acceptUnknownReference(key.toCharArray(), declarationStart);
        }
    }

    @Override
    public void acceptPropertyLiteralName(int declarationStart, int declarationEnd, char[] name) {
        if (name != null && name.length != 0) {
            this.acceptUnknownReference(name, declarationStart);
        }
    }

    @Override
    public void enterPropertyBlock(int declarationStart, char[] name) {
    }

    @Override
    public void exitPropertyBlock(int declarationEnd) {
    }
}

