/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search.matching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.ConstantFormField;
import org.eclipse.edt.compiler.core.ast.DataItem;
import org.eclipse.edt.compiler.core.ast.DataTable;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Delegate;
import org.eclipse.edt.compiler.core.ast.EGLClass;
import org.eclipse.edt.compiler.core.ast.Enumeration;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ExternalType;
import org.eclipse.edt.compiler.core.ast.FormGroup;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Interface;
import org.eclipse.edt.compiler.core.ast.Library;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedForm;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.PackageDeclaration;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.Program;
import org.eclipse.edt.compiler.core.ast.ProgramParameter;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.Service;
import org.eclipse.edt.compiler.core.ast.ServiceReference;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.core.ast.TopLevelForm;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.core.ast.VariableFormField;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.model.util.HashtableOfLong;
import org.eclipse.edt.ide.core.internal.search.matching.MatchLocator2;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.search.ICompiledFileUnit;

public class MatchingNodeSet {
    MatchLocator2 locator;
    int matchContainer;
    boolean cuHasBeenResolved = false;
    Map matchingNodes = new HashMap(5);
    HashtableOfLong matchingNodesKeys = new HashtableOfLong(5);
    Map potentialMatchingNodes = new HashMap(5);
    HashtableOfLong potentialMatchingNodesKeys = new HashtableOfLong(5);

    public MatchingNodeSet(MatchLocator2 locator) {
        this.locator = locator;
        this.matchContainer = locator.matchContainer();
    }

    public void addPossibleMatch(Node node) {
        long key = ((long)node.getOffset() << 32) + (long)(node.getOffset() + node.getLength());
        Node existing = (Node)this.potentialMatchingNodesKeys.get(key);
        if (existing != null && existing.getClass().equals(node.getClass())) {
            this.potentialMatchingNodes.remove(existing);
        }
        this.potentialMatchingNodes.put(node, new Integer(1));
        this.potentialMatchingNodesKeys.put(key, node);
    }

    public void addTrustedMatch(Node node) {
        long key = ((long)node.getOffset() << 32) + (long)(node.getOffset() + node.getLength());
        Node existing = (Node)this.matchingNodesKeys.get(key);
        if (existing != null && existing.getClass().equals(node.getClass())) {
            this.matchingNodes.remove(existing);
        }
        this.matchingNodes.put(node, new Integer(2));
        this.matchingNodesKeys.put(key, node);
    }

    public void addInaccurateMatch(Node node) {
        long key = ((long)node.getOffset() << 32) + (long)(node.getOffset() + node.getLength());
        Node existing = (Node)this.matchingNodesKeys.get(key);
        if (existing != null && existing.getClass().equals(node.getClass())) {
            this.matchingNodes.remove(existing);
        }
        this.matchingNodes.put(node, new Integer(3));
        this.matchingNodesKeys.put(key, node);
    }

    public int getMatchingLevel(Node node) {
        return this.locator.matchCheck(node);
    }

    public int isMatchingFunctionType(Name node, IPartBinding partBinding) {
        int level = this.getMatchingLevel((Node)node);
        if (level == 1 || level == 2) {
            return this.locator.matchesFunctionPartType(node, partBinding);
        }
        return level;
    }

    public int isMatchingFunctionPart(TopLevelFunction node) {
        int level = this.getMatchingLevel((Node)node);
        if (level == 1 || level == 2) {
            return this.locator.matchesFunctionPart(node);
        }
        return level;
    }

    public int isMatchingNestedFunctionPart(NestedFunction node) {
        int level = this.getMatchingLevel((Node)node);
        if (level == 1 || level == 2) {
            return this.locator.matchesFunctionPartType(node.getName(), null);
        }
        return level;
    }

    public int isMatchingNestedFormPart(NestedForm node) {
        int level = this.getMatchingLevel((Node)node);
        if (level == 1 || level == 2) {
            return this.locator.matchesNestedFormPart(node);
        }
        return level;
    }

    public int isMatchingType(Name node, IPartBinding partBinding) {
        int level = this.getMatchingLevel((Node)node);
        if (level == 1 || level == 2) {
            return this.locator.matchesPartType(node, partBinding);
        }
        return level;
    }

    public int isMatchingPart(Part part) {
        int level = this.getMatchingLevel((Node)part);
        if (level == 1 || level == 2) {
            return this.locator.matchesPart(part);
        }
        return level;
    }

    public int isMatchingAnnotationType(Name node, IAnnotationTypeBinding binding) {
        int level = this.getMatchingLevel((Node)node);
        if (level == 1 || level == 2) {
            return this.locator.matchesAnnotationType(node, binding);
        }
        return level;
    }

    public void checkMatching(Node node) {
        this.locator.matchCheck(node, this);
    }

    public boolean isEmpty() {
        return this.potentialMatchingNodes.size() == 0 && this.matchingNodes.size() == 0;
    }

    private Node[] matchingNodes(int start, int end) {
        return this.nodesInRange(start, end, this.matchingNodes);
    }

    public boolean needsResolve() {
        return this.potentialMatchingNodes.size() > 0;
    }

    private Node[] nodesInRange(int start, int end, Map set) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node node : set.keySet()) {
            if (start > node.getOffset() || node.getOffset() + node.getLength() > end) continue;
            nodes.add(node);
        }
        Object[] result = new Node[nodes.size()];
        nodes.toArray(result);
        Util.Comparer comparer = new Util.Comparer(){

            @Override
            public int compare(Object o1, Object o2) {
                Node node1 = (Node)o1;
                Node node2 = (Node)o2;
                return node1.getOffset() - node2.getOffset();
            }
        };
        Util.sort(result, comparer);
        return result;
    }

    public Integer removePossibleMatch(Node node) {
        long key = ((long)node.getOffset() << 32) + (long)(node.getOffset() + node.getLength());
        this.potentialMatchingNodesKeys.put(key, null);
        return (Integer)this.potentialMatchingNodes.remove(node);
    }

    public Integer removeTrustedMatch(Node node) {
        long key = ((long)node.getOffset() << 32) + (long)(node.getOffset() + node.getLength());
        this.matchingNodesKeys.put(key, null);
        return (Integer)this.matchingNodes.remove(node);
    }

    public void reportMatching(ICompiledFileUnit unit) throws CoreException {
        Part[] parts;
        int i;
        ImportDeclaration[] imports;
        Integer level;
        PackageDeclaration pkg;
        if (this.cuHasBeenResolved) {
            for (Node node : this.potentialMatchingNodes.keySet()) {
                int level2;
                if (node instanceof ImportDeclaration || (level2 = this.locator.matchLevel(node, true)) != 2 && level2 != 3) continue;
                this.matchingNodes.put(node, new Integer(level2));
            }
            this.potentialMatchingNodes = new HashMap();
        }
        if ((pkg = unit.getFile().getPackageDeclaration()) != null && (level = (Integer)this.matchingNodes.remove(pkg)) != null && (this.matchContainer & 1) != 0) {
            this.locator.reportPackageDeclaration(pkg);
        }
        if (!this.cuHasBeenResolved && (imports = unit.getFile().getImportDeclarations().toArray(new ImportDeclaration[unit.getFile().getImportDeclarations().size()])) != null) {
            i = 0;
            while (i < imports.length) {
                Node node;
                ImportDeclaration importRef = imports[i];
                Name importName = importRef.getName();
                Node[] importNodes = this.nodesInRange(importName.getOffset(), importName.getOffset() + importName.getLength(), this.matchingNodes);
                if (importNodes != null && importNodes.length > 0 && (level = (Integer)this.matchingNodes.remove(node = importNodes[0])) != null && (this.matchContainer & 1) != 0) {
                    this.locator.reportImport(importRef, level == 2 ? 0 : 1);
                }
                ++i;
            }
        }
        if ((parts = unit.getFileParts().toArray(new Part[unit.getFileParts().size()])) != null) {
            i = 0;
            while (i < parts.length) {
                Part part = parts[i];
                level = (Integer)this.matchingNodes.remove(part);
                if (level != null && (this.matchContainer & 1) != 0) {
                    this.locator.reportPartDeclaration(part, null, level == 2 ? 0 : 1);
                }
                this.reportMatching(part, null);
                ++i;
            }
        }
    }

    private void reportMatchingField(Node field, IEGLElement parent) throws CoreException {
        Node[] nodes = this.matchingNodes(field.getOffset(), field.getOffset() + field.getLength());
        int i = 0;
        while (i < nodes.length) {
            Node node = nodes[i];
            Integer level = (Integer)this.matchingNodes.get(node);
            if ((this.matchContainer & 4) != 0) {
                this.locator.reportFieldReference(node, field, parent, level == 2 ? 0 : 1);
                this.matchingNodes.remove(node);
            }
            ++i;
        }
    }

    private void reportMatchingUse(Node use, IEGLElement parent, Part part) throws CoreException {
        if (use instanceof UseStatement) {
            List useNames = ((UseStatement)use).getNames();
            int i = 0;
            while (i < useNames.size()) {
                Node name = (Node)useNames.get(i);
                Node[] nodes = this.matchingNodes(name.getOffset(), name.getOffset() + name.getLength());
                int j = 0;
                while (j < nodes.length) {
                    Node node = nodes[j];
                    Integer level = (Integer)this.matchingNodes.get(node);
                    if ((this.matchContainer & 0x10) != 0) {
                        this.locator.reportUseReference(node, part, (Name)name, parent, level == 2 ? 0 : 1);
                        this.matchingNodes.remove(node);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void reportMatching(Part part, IEGLElement parent) throws CoreException {
        IEGLElement enclosingElement;
        if (parent == null) {
            enclosingElement = this.locator.createPartHandle(part.getName().getCanonicalName());
        } else if (parent instanceof IPart) {
            enclosingElement = this.locator.createPartHandle((IPart)parent, part.getName().getCanonicalName());
            if (enclosingElement == null) {
                return;
            }
        } else {
            enclosingElement = parent;
        }
        switch (part.getPartType()) {
            case 0: {
                this.reportMatchingProgram((Program)part, enclosingElement);
                break;
            }
            case 8: {
                this.reportMatchingLibrary((Library)part, enclosingElement);
                break;
            }
            case 4: {
                this.reportMatchingForm((TopLevelForm)part, enclosingElement);
                break;
            }
            case 5: {
                this.reportMatchingFormGroup((FormGroup)part, enclosingElement);
                break;
            }
            case 1: {
                this.reportMatchingRecord((Record)part, enclosingElement);
                break;
            }
            case 6: {
                this.reportMatchingDataTable((DataTable)part, enclosingElement);
                break;
            }
            case 9: {
                this.reportMatchingHandler((Handler)part, enclosingElement);
                break;
            }
            case 10: {
                this.reportMatchingService((Service)part, enclosingElement);
                break;
            }
            case 11: {
                this.reportMatchingInterface((Interface)part, enclosingElement);
                break;
            }
            case 2: {
                this.reportMatchingFunction((TopLevelFunction)part, enclosingElement);
                break;
            }
            case 12: {
                this.reportMatchingDelegate((Delegate)part, enclosingElement);
                break;
            }
            case 13: {
                this.reportMatchingExternalType((ExternalType)part, enclosingElement);
                break;
            }
            case 14: {
                this.reportMatchingEnumeration((Enumeration)part, enclosingElement);
                break;
            }
            case 3: {
                this.reportMatchingDataItem((DataItem)part, enclosingElement);
                break;
            }
            case 15: {
                this.reportMatchingClass((EGLClass)part, enclosingElement);
            }
        }
        Name subtype = part.getSubType();
        if (subtype != null) {
            this.reportMatchingField((Node)subtype, enclosingElement);
        }
        this.reportMatchingSettings(part, enclosingElement);
    }

    private void reportMatchingDataItem(DataItem dataItem, IEGLElement enclosingElement) throws CoreException {
    }

    private void reportMatchingDelegate(Delegate delegate, IEGLElement enclosingElement) throws CoreException {
        Node[] nodes = this.matchingNodes(delegate.getOffset(), delegate.getOffset() + delegate.getLength());
        int i = 0;
        while (i < nodes.length) {
            Node node = nodes[i];
            Integer level = (Integer)this.matchingNodes.get(node);
            if ((this.matchContainer & 4) != 0) {
                this.locator.reportReference(node, delegate, enclosingElement, level == 2 ? 0 : 1);
                this.matchingNodes.remove(node);
            }
            ++i;
        }
        Integer level = (Integer)this.matchingNodes.remove(delegate);
        if (level != null && (this.matchContainer & 2) != 0) {
            this.locator.reportPartDeclaration((Part)delegate, enclosingElement, level == 2 ? 0 : 1);
        }
    }

    private void reportMatchingExternalType(ExternalType externalType, IEGLElement enclosingElement) throws CoreException {
        this.reportMatchingFields((Node)externalType, enclosingElement);
        this.reportMatchingNestedFunctions((Node)externalType, enclosingElement);
        for (Name name : externalType.getExtendedTypes()) {
            Integer level = (Integer)this.matchingNodes.get(name);
            if (level == null || (this.matchContainer & 4) == 0) continue;
            this.locator.reportFieldReference((Node)name, (Node)externalType, enclosingElement, level == 2 ? 0 : 1);
            this.matchingNodes.remove(name);
        }
    }

    private void reportMatchingEnumeration(Enumeration enumeration, IEGLElement enclosingElement) throws CoreException {
    }

    private void reportMatchingProgram(Program program, IEGLElement enclosingElement) throws CoreException {
        this.reportMatchingFields((Node)program, enclosingElement);
        this.reportMatchingUses((Part)program, enclosingElement);
        this.reportMatchingNestedFunctions((Node)program, enclosingElement);
    }

    private void reportMatchingLibrary(Library library, IEGLElement enclosingElement) throws CoreException {
        this.reportMatchingFields((Node)library, enclosingElement);
        this.reportMatchingUses((Part)library, enclosingElement);
        this.reportMatchingNestedFunctions((Node)library, enclosingElement);
    }

    private void reportMatchingNestedFunctions(Node node, final IEGLElement enclosingElement) {
        node.accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(NestedFunction nestedFunction) {
                try {
                    MatchingNodeSet.this.reportMatchingFunction(nestedFunction, enclosingElement);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                return false;
            }
        });
    }

    private void reportMatchingHandler(Handler handler, IEGLElement enclosingElement) throws CoreException {
        this.reportMatchingFields((Node)handler, enclosingElement);
        this.reportMatchingUses((Part)handler, enclosingElement);
        this.reportMatchingNestedFunctions((Node)handler, enclosingElement);
    }

    private void reportMatchingClass(EGLClass eglClass, IEGLElement enclosingElement) throws CoreException {
        this.reportMatchingFields((Node)eglClass, enclosingElement);
        this.reportMatchingUses((Part)eglClass, enclosingElement);
        this.reportMatchingNestedFunctions((Node)eglClass, enclosingElement);
    }

    private void reportMatchingService(Service service, IEGLElement enclosingElement) throws CoreException {
        this.reportMatchingFields((Node)service, enclosingElement);
        this.reportMatchingUses((Part)service, enclosingElement);
        this.reportMatchingNestedFunctions((Node)service, enclosingElement);
        this.reportMatchingImplementedInterfaces(service, enclosingElement);
    }

    private void reportMatchingImplementedInterfaces(Service service, IEGLElement enclosingElement) throws CoreException {
        List definedInterfaceNames = service.getImplementedInterfaces();
        for (Name interfaceName : definedInterfaceNames) {
            int rangeOffset = interfaceName.getOffset();
            int rangeLength = interfaceName.getLength();
            Node[] nodes = this.matchingNodes(rangeOffset, rangeOffset + rangeLength);
            int i = 0;
            while (i < nodes.length) {
                Node node = nodes[i];
                Integer level = (Integer)this.matchingNodes.get(node);
                if ((this.matchContainer & 2) != 0) {
                    this.locator.reportImplementsReference(node, (Part)service, interfaceName, enclosingElement, level == 2 ? 0 : 1);
                    this.matchingNodes.remove(node);
                }
                ++i;
            }
        }
    }

    private void reportMatchingInterface(Interface intrface, IEGLElement enclosingElement) throws CoreException {
        this.reportMatchingNestedFunctions((Node)intrface, enclosingElement);
    }

    private void reportMatchingRecord(Record part, IEGLElement enclosingElement) throws CoreException {
        this.reportMatchingFields((Node)part, enclosingElement);
    }

    private void reportMatchingDataTable(DataTable part, IEGLElement enclosingElement) throws CoreException {
        this.reportMatchingFields((Node)part, enclosingElement);
    }

    private void reportMatchingForm(TopLevelForm form, IEGLElement enclosingElement) throws CoreException {
        this.reportMatchingFields((Node)form, enclosingElement);
        Integer level = (Integer)this.matchingNodes.remove(form);
        if (level != null && (this.matchContainer & 2) != 0) {
            this.locator.reportPartDeclaration((Part)form, enclosingElement, level == 2 ? 0 : 1);
        }
    }

    private void reportMatchingFormGroup(FormGroup formGroup, IEGLElement enclosingElement) throws CoreException {
        this.reportMatchingFields((Node)formGroup, enclosingElement);
        this.reportMatchingUses((Part)formGroup, enclosingElement);
    }

    private void reportMatchingFunction(TopLevelFunction function, IEGLElement enclosingElement) throws CoreException {
        Integer level;
        this.reportMatchingFields((Node)function, enclosingElement);
        Node[] nodes = this.matchingNodes(function.getOffset(), function.getOffset() + function.getLength());
        int i = 0;
        while (i < nodes.length) {
            Node node = nodes[i];
            level = (Integer)this.matchingNodes.get(node);
            if ((this.matchContainer & 4) != 0) {
                this.locator.reportReference(node, function, enclosingElement, level == 2 ? 0 : 1);
                this.matchingNodes.remove(node);
            }
            ++i;
        }
        level = (Integer)this.matchingNodes.remove(function);
        if (level != null && (this.matchContainer & 8) != 0) {
            this.locator.reportFunctionDeclaration(function, enclosingElement, level == 2 ? 0 : 1);
        }
    }

    private void reportMatchingFunction(NestedFunction function, IEGLElement enclosingElement) throws CoreException {
        Integer level;
        this.reportMatchingFields((Node)function, enclosingElement);
        Node[] nodes = this.matchingNodes(function.getOffset(), function.getOffset() + function.getLength());
        int i = 0;
        while (i < nodes.length) {
            Node node = nodes[i];
            level = (Integer)this.matchingNodes.get(node);
            if ((this.matchContainer & 4) != 0) {
                this.locator.reportReference(node, function, enclosingElement, level == 2 ? 0 : 1);
                this.matchingNodes.remove(node);
            }
            ++i;
        }
        level = (Integer)this.matchingNodes.remove(function);
        if (level != null && (this.matchContainer & 8) != 0) {
            this.locator.reportFunctionDeclaration(function, enclosingElement, level == 2 ? 0 : 1);
        }
    }

    private void reportMatchingFields(Node node, final IEGLElement enclosingElement) throws CoreException {
        node.accept((IASTVisitor)new AbstractASTVisitor(){
            Integer level;

            private void reportNamedNode(Node node, IEGLElement parent) {
                try {
                    this.level = (Integer)MatchingNodeSet.this.matchingNodes.remove(node);
                    if (this.level != null && (MatchingNodeSet.this.matchContainer & 2) != 0) {
                        MatchingNodeSet.this.locator.reportField(node, enclosingElement, this.level == 2 ? 0 : 1);
                    }
                    MatchingNodeSet.this.reportMatchingField(node, parent);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }

            public boolean visit(ClassDataDeclaration classDataDeclaration) {
                this.reportNamedNode((Node)classDataDeclaration, enclosingElement);
                return false;
            }

            public boolean visit(ProgramParameter programParameter) {
                this.reportNamedNode((Node)programParameter, enclosingElement);
                return false;
            }

            public boolean visit(FunctionParameter functionParameter) {
                this.reportNamedNode((Node)functionParameter, enclosingElement);
                return false;
            }

            public boolean visit(ServiceReference serviceReference) {
                this.reportNamedNode((Node)serviceReference, enclosingElement);
                return false;
            }

            public boolean visit(StructureItem structureItem) {
                this.reportNamedNode((Node)structureItem, enclosingElement);
                return false;
            }

            public boolean visit(NestedForm nestedForm) {
                this.reportNamedNode((Node)nestedForm, ((IPart)enclosingElement).getPart(nestedForm.getName().getCanonicalName()));
                return false;
            }

            public boolean visit(VariableFormField variableFormField) {
                this.reportNamedNode((Node)variableFormField, enclosingElement);
                return false;
            }

            public boolean visit(ConstantFormField constantFormField) {
                this.reportNamedNode((Node)constantFormField, enclosingElement);
                return false;
            }
        });
    }

    private void reportMatchingUses(final Part part, final IEGLElement enclosingElement) throws CoreException {
        part.accept((IASTVisitor)new AbstractASTVisitor(){

            public boolean visit(UseStatement useStatement) {
                try {
                    MatchingNodeSet.this.reportMatchingUse((Node)useStatement, enclosingElement, part);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                return false;
            }
        });
    }

    private void reportMatchingSettings(final Part part, final IEGLElement enclosingElement) throws CoreException {
        part.accept((IASTVisitor)new DefaultASTVisitor(){

            public boolean visit(DataItem dataItem) {
                return true;
            }

            public boolean visit(DataTable dataTable) {
                return true;
            }

            public boolean visit(Delegate delegate) {
                return true;
            }

            public boolean visit(ExternalType externalType) {
                return true;
            }

            public boolean visit(FormGroup formGroup) {
                return true;
            }

            public boolean visit(Interface interfaceNode) {
                return true;
            }

            public boolean visit(Library library) {
                return true;
            }

            public boolean visit(Program program) {
                return true;
            }

            public boolean visit(Record record) {
                return true;
            }

            public boolean visit(Service service) {
                return true;
            }

            public boolean visit(Handler handler) {
                return true;
            }

            public boolean visit(TopLevelForm topLevelForm) {
                return true;
            }

            public boolean visit(TopLevelFunction topLevelFunction) {
                return true;
            }

            public boolean visit(Enumeration enumeration) {
                return true;
            }

            public boolean visit(SettingsBlock settingsBlock) {
                MatchingNodeSet.this.reportMatchingSettingsBlock(part, enclosingElement, settingsBlock);
                return false;
            }
        });
    }

    private void reportMatchingSettingsBlock(final Part part, final IEGLElement enclosingElement, SettingsBlock settingsBlock) {
        List decls = settingsBlock.getSettings();
        for (Node decl : decls) {
            decl.accept((IASTVisitor)new DefaultASTVisitor(){
                Integer level;

                private void reportNamedNode(Node node, IEGLElement parent) {
                    try {
                        MatchingNodeSet.this.reportMatchingField(node, parent);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }

                public boolean visit(SetValuesExpression setValuesExpression) {
                    Expression expr = setValuesExpression.getExpression();
                    if (expr instanceof AnnotationExpression) {
                        Name name = ((AnnotationExpression)expr).getName();
                        if (name.resolveTypeBinding() != null) {
                            this.reportNamedNode((Node)name, enclosingElement);
                        } else if (name.resolveBinding() != null) {
                            this.reportNamedNode((Node)name, enclosingElement);
                        }
                    }
                    SettingsBlock block = setValuesExpression.getSettingsBlock();
                    MatchingNodeSet.this.reportMatchingSettingsBlock(part, enclosingElement, block);
                    return false;
                }

                public boolean visit(Assignment assignment) {
                    Expression expr = assignment.getRightHandSide();
                    expr.accept((IASTVisitor)new AbstractASTExpressionVisitor(){

                        public boolean visitName(Name name) {
                            if (name.resolveTypeBinding() != null) {
                                this.reportNamedNode((Node)name, enclosingElement);
                            }
                            return false;
                        }

                        public boolean visitExpression(Expression expression) {
                            return true;
                        }
                    });
                    assignment.getLeftHandSide().accept((IASTVisitor)new AbstractASTExpressionVisitor(){

                        public boolean visitName(Name name) {
                            if (name.resolveTypeBinding() != null) {
                                this.reportNamedNode((Node)name, enclosingElement);
                            }
                            return false;
                        }
                    });
                    return false;
                }
            });
        }
    }

    public String toString() {
        int accuracy;
        Object value;
        Node node;
        StringBuffer result = new StringBuffer();
        result.append("Exact matches:");
        Iterator iter = this.matchingNodes.keySet().iterator();
        while (iter.hasNext()) {
            result.append("\n");
            node = (Node)iter.next();
            value = this.matchingNodes.get(node);
            if (value instanceof Integer) {
                result.append('\t');
                accuracy = (Integer)value;
                switch (accuracy) {
                    case 0: {
                        result.append("IMPOSSIBLE_MATCH: ");
                        break;
                    }
                    case 1: {
                        result.append("POSSIBLE_MATCH: ");
                        break;
                    }
                    case 3: {
                        result.append("INACCURATE_MATCH: ");
                        break;
                    }
                    case 2: {
                        result.append("ACCURATE_MATCH: ");
                    }
                }
            }
            result.append(node.toString());
        }
        result.append("\nPotential matches:");
        iter = this.potentialMatchingNodes.keySet().iterator();
        while (iter.hasNext()) {
            result.append("\n");
            node = (Node)iter.next();
            value = this.potentialMatchingNodes.get(node);
            if (value instanceof Integer) {
                result.append("\t");
                accuracy = (Integer)value;
                switch (accuracy) {
                    case 0: {
                        result.append("IMPOSSIBLE_MATCH: ");
                        break;
                    }
                    case 1: {
                        result.append("POSSIBLE_MATCH: ");
                        break;
                    }
                    case 3: {
                        result.append("INACCURATE_MATCH: ");
                        break;
                    }
                    case 2: {
                        result.append("ACCURATE_MATCH: ");
                    }
                }
            }
            result.append(node.toString());
        }
        return result.toString();
    }
}

