/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.ide.core.internal.model.ClassFile;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragment;
import org.eclipse.edt.ide.core.internal.model.EglarPackageFragmentRoot;
import org.eclipse.edt.ide.core.internal.model.indexing.EGLModelSearchResources;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexManager;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexSelector;
import org.eclipse.edt.ide.core.internal.search.EGLSearchScope;
import org.eclipse.edt.ide.core.internal.search.EGLWorkspaceScope;
import org.eclipse.edt.ide.core.internal.search.IndexSearchAdapter;
import org.eclipse.edt.ide.core.internal.search.PathCollector;
import org.eclipse.edt.ide.core.internal.search.PatternSearchJob;
import org.eclipse.edt.ide.core.internal.search.matching.MatchLocator2;
import org.eclipse.edt.ide.core.internal.search.matching.PartDeclarationPattern;
import org.eclipse.edt.ide.core.internal.search.matching.PartReferencePattern;
import org.eclipse.edt.ide.core.internal.search.matching.SearchPattern;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IIndexConstants;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.edt.ide.core.model.IWorkingCopy;
import org.eclipse.edt.ide.core.search.IEGLSearchResultCollector;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.IPartNameRequestor;
import org.eclipse.edt.ide.core.search.ISearchPattern;

public class SearchEngine {
    private IWorkingCopy[] workingCopies = null;
    public static boolean VERBOSE = false;

    public SearchEngine() {
    }

    public SearchEngine(IWorkingCopy[] workingCopies) {
        this.workingCopies = workingCopies;
    }

    /*
     * Unable to fully structure code
     */
    private IWorkingCopy[] filterWorkingCopies(IWorkingCopy[] workingCopies, IEGLElement focus, boolean isPolymorphicSearch) {
        if (focus != null && workingCopies != null) ** GOTO lbl4
        return workingCopies;
lbl-1000:
        // 1 sources

        {
            focus = focus.getParent();
lbl4:
            // 2 sources

            ** while (!(focus instanceof IEGLProject))
        }
lbl5:
        // 1 sources

        length = workingCopies.length;
        result = null;
        index = -1;
        i = 0;
        while (i < length) {
            workingCopy = workingCopies[i];
            projectOrJar = IndexSelector.getProjectOrJar((IEGLElement)workingCopy).getPath();
            if (!IndexSelector.canSeeFocus(focus, isPolymorphicSearch, projectOrJar)) {
                if (result == null) {
                    result = new IWorkingCopy[length - 1];
                    System.arraycopy(workingCopies, 0, result, 0, i);
                    index = i;
                }
            } else if (result != null) {
                result[index++] = workingCopy;
            }
            ++i;
        }
        if (result != null) {
            if (result.length != index) {
                v0 = result;
                result = new IWorkingCopy[index];
                System.arraycopy(v0, 0, result, 0, index);
            }
            return result;
        }
        return workingCopies;
    }

    public static IEGLSearchScope createEGLSearchScope(IResource[] resources) {
        int length = resources.length;
        IEGLElement[] elements = new IEGLElement[length];
        int i = 0;
        while (i < length) {
            elements[i] = EGLCore.create(resources[i]);
            ++i;
        }
        return SearchEngine.createEGLSearchScope(elements);
    }

    public static IEGLSearchScope createEGLSearchScope(IEGLElement[] elements) {
        return SearchEngine.createEGLSearchScope(elements, true);
    }

    public static IEGLSearchScope createEGLSearchScope(IEGLElement[] elements, boolean includeReferencedProjects) {
        EGLSearchScope scope = new EGLSearchScope();
        HashSet visitedProjects = new HashSet(2);
        int i = 0;
        int length = elements.length;
        while (i < length) {
            IEGLElement element = elements[i];
            if (element != null) {
                try {
                    if (element instanceof IEGLProject) {
                        scope.add((IEGLProject)element, includeReferencedProjects, visitedProjects);
                    } else {
                        scope.add(element);
                        if (element instanceof EglarPackageFragmentRoot || element instanceof EglarPackageFragment || element instanceof ClassFile) {
                            scope.putIntoEglarProjectsMap(element.getPath(), element.getEGLProject());
                        }
                    }
                }
                catch (EGLModelException eGLModelException) {}
            }
            ++i;
        }
        return scope;
    }

    public static IEGLSearchScope createEGLSearchScope(Node[] parts) {
        EGLSearchScope scope = new EGLSearchScope();
        int i = 0;
        int length = parts.length;
        while (i < length) {
            Node part = parts[i];
            if (part != null) {
                try {
                    scope.add(part);
                }
                catch (EGLModelException eGLModelException) {}
            }
            ++i;
        }
        return scope;
    }

    public static ISearchPattern createSearchPattern(String stringPattern, int searchFor, int limitTo, boolean isCaseSensitive) {
        int matchMode = stringPattern.indexOf(42) != -1 || stringPattern.indexOf(63) != -1 ? 2 : 0;
        return SearchPattern.createPattern(stringPattern, searchFor, limitTo, matchMode, isCaseSensitive);
    }

    public static IEGLSearchScope createWorkspaceScope() {
        return new EGLWorkspaceScope();
    }

    private IResource getResource(IEGLElement element) {
        IEGLFile cu;
        if (element instanceof IMember && (cu = ((IMember)element).getEGLFile()) != null) {
            if (cu.isWorkingCopy()) {
                return cu.getOriginalElement().getResource();
            }
            return cu.getResource();
        }
        return element.getResource();
    }

    private IWorkingCopy[] getWorkingCopies(IEGLElement element) {
        IEGLFile cu;
        if (element instanceof IMember && (cu = ((IMember)element).getEGLFile()) != null && cu.isWorkingCopy()) {
            int length;
            int n = length = this.workingCopies == null ? 0 : this.workingCopies.length;
            if (length > 0) {
                IWorkingCopy[] newWorkingCopies = new IWorkingCopy[length + 1];
                System.arraycopy(this.workingCopies, 0, newWorkingCopies, 0, length);
                newWorkingCopies[length] = cu;
                return newWorkingCopies;
            }
            return new IWorkingCopy[]{cu};
        }
        return this.workingCopies;
    }

    public void search(IWorkspace workspace, String patternString, int searchFor, int limitTo, IEGLSearchScope scope, IEGLSearchResultCollector resultCollector) throws EGLModelException {
        this.search(workspace, SearchEngine.createSearchPattern(patternString, searchFor, limitTo, true), scope, resultCollector);
    }

    public void search(IWorkspace workspace, ISearchPattern searchPattern, IEGLSearchScope scope, IEGLSearchResultCollector resultCollector) throws EGLModelException {
        this.search(workspace, searchPattern, scope, false, false, resultCollector);
    }

    public void search(IWorkspace workspace, ISearchPattern searchPattern, IEGLSearchScope scope, boolean matchImports, boolean forceQualification, IEGLSearchResultCollector resultCollector) throws EGLModelException {
        if (VERBOSE) {
            System.out.println("Searching for " + searchPattern + " in " + scope);
        }
        resultCollector.aboutToStart();
        try {
            if (searchPattern == null) {
                return;
            }
            IProgressMonitor progressMonitor = resultCollector.getProgressMonitor();
            if (progressMonitor != null) {
                progressMonitor.beginTask(EGLModelSearchResources.EngineSearching, 100);
            }
            PathCollector pathCollector = new PathCollector();
            SearchPattern pattern = (SearchPattern)searchPattern;
            IndexManager indexManager = EGLModelManager.getEGLModelManager().getIndexManager();
            int detailLevel = 6;
            MatchLocator2 matchLocator = new MatchLocator2(pattern, matchImports, forceQualification, detailLevel, resultCollector, scope, (IProgressMonitor)(progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 95)));
            indexManager.performConcurrentJob(new PatternSearchJob(pattern, scope, pattern.focus, false, matchLocator.detailLevel, pathCollector, indexManager), 3, (IProgressMonitor)(progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 5)));
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            matchLocator.locateMatches(pathCollector.getPaths(), workspace, this.filterWorkingCopies(this.workingCopies, pattern.focus, false));
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (progressMonitor != null) {
                progressMonitor.done();
            }
            matchLocator.locatePackageDeclarations(workspace);
        }
        finally {
            resultCollector.done();
        }
    }

    public void searchAllPartNames(IWorkspace workspace, char[] packageName, char[] typeName, int matchMode, boolean isCaseSensitive, int partTypes, IEGLSearchScope scope, final IPartNameRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws EGLModelException {
        IndexManager indexManager = EGLModelManager.getEGLModelManager().getIndexManager();
        PartDeclarationPattern pattern = new PartDeclarationPattern(packageName, null, typeName, (char)partTypes, matchMode, isCaseSensitive);
        IndexSearchAdapter searchRequestor = new IndexSearchAdapter(){

            @Override
            public void acceptPartDeclaration(IPath projectPath, String resourcePath, char[] simpleTypeName, char partType, char[][] enclosingTypeNames, char[] packageName) {
                if (enclosingTypeNames != IIndexConstants.ONE_ZERO_CHAR) {
                    nameRequestor.acceptPart(packageName, simpleTypeName, partType, enclosingTypeNames, resourcePath, projectPath);
                }
            }
        };
        try {
            if (progressMonitor != null) {
                progressMonitor.beginTask(EGLModelSearchResources.EngineSearching, 100);
            }
            indexManager.performConcurrentJob(new PatternSearchJob(pattern, scope, 3, searchRequestor, indexManager), waitingPolicy, (IProgressMonitor)(progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 100)));
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
    }

    public List searchAllFilesReferencing(IWorkspace workspace, char[] qualifier, char[] simpleName, int matchMode, boolean isCaseSensitive, IEGLSearchScope scope, IProgressMonitor progressMonitor) throws EGLModelException {
        PartReferencePattern pattern = new PartReferencePattern(qualifier, simpleName, (char)Short.MAX_VALUE, matchMode, isCaseSensitive);
        final ArrayList resourcePaths = new ArrayList();
        try {
            if (progressMonitor != null) {
                progressMonitor.beginTask(EGLModelSearchResources.EngineSearching, 100);
            }
            IndexSearchAdapter searchRequestor = new IndexSearchAdapter(){

                @Override
                public void acceptPartDeclaration(IPath projectPath, String resourcePath, char[] simpleTypeName, char partType, char[][] enclosingTypeNames, char[] packageName) {
                    resourcePaths.add(resourcePath);
                }
            };
            IndexManager indexManager = EGLModelManager.getEGLModelManager().getIndexManager();
            indexManager.performConcurrentJob(new PatternSearchJob(pattern, scope, pattern.focus, false, 2, searchRequestor, indexManager), 3, (IProgressMonitor)(progressMonitor == null ? null : new SubProgressMonitor(progressMonitor, 5)));
        }
        catch (Throwable throwable) {}
        return resourcePaths;
    }
}

